/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.sql2entity.pmbean;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.engine.database.model.Database;
import org.apache.torque.engine.database.model.TypeMap;
import org.seasar.dbflute.DfBuildProperties;
import org.seasar.dbflute.helper.StringKeyMap;
import org.seasar.dbflute.helper.language.grammar.DfGrammarInfo;
import org.seasar.dbflute.logic.jdbc.handler.DfColumnHandler;
import org.seasar.dbflute.logic.jdbc.handler.DfProcedureHandler;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfColumnMetaInfo;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfProcedureColumnMetaInfo;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfProcedureMetaInfo;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfProcedureNotParamResultMetaInfo;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfTypeArrayInfo;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfTypeStructInfo;
import org.seasar.dbflute.logic.sql2entity.cmentity.DfCustomizeEntityInfo;
import org.seasar.dbflute.logic.sql2entity.cmentity.DfProcedureExecutionMetaExtractor;
import org.seasar.dbflute.logic.sql2entity.pmbean.DfPmbMetaData;
import org.seasar.dbflute.properties.DfBasicProperties;
import org.seasar.dbflute.properties.DfLittleAdjustmentProperties;
import org.seasar.dbflute.properties.DfOutsideSqlProperties;
import org.seasar.dbflute.util.DfCollectionUtil;
import org.seasar.dbflute.util.Srl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfProcedurePmbSetupper {
    private static final Log _log = LogFactory.getLog(DfProcedurePmbSetupper.class);
    protected final DataSource _dataSource;
    protected final Map<String, DfCustomizeEntityInfo> _entityInfoMap;
    protected final Map<String, DfPmbMetaData> _pmbMetaDataMap;
    protected final Database _database;
    protected final DfColumnHandler _columnHandler = new DfColumnHandler();
    protected final DfProcedureHandler _procedureHandler = new DfProcedureHandler();
    protected final Map<String, String> _continuedFailureMessageMap = DfCollectionUtil.newLinkedHashMap();

    public DfProcedurePmbSetupper(DataSource dataSource, Map<String, DfCustomizeEntityInfo> entityInfoMap, Map<String, DfPmbMetaData> pmbMetaDataMap, Database database) {
        this._dataSource = dataSource;
        this._entityInfoMap = entityInfoMap;
        this._pmbMetaDataMap = pmbMetaDataMap;
        this._database = database;
    }

    public void setupProcedure() throws SQLException {
        if (!this.getOutsideSqlProperties().isGenerateProcedureParameterBean()) {
            return;
        }
        _log.info((Object)" ");
        _log.info((Object)"...Setting up procedures for generating parameter-beans");
        List<DfProcedureMetaInfo> procedureList = this.getAvailableProcedureList();
        _log.info((Object)"/= = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =");
        for (DfProcedureMetaInfo procedure : procedureList) {
            Map propertyNameTypeMap = DfCollectionUtil.newLinkedHashMap();
            Map propertyNameOptionMap = DfCollectionUtil.newLinkedHashMap();
            Map propertyNameColumnNameMap = DfCollectionUtil.newLinkedHashMap();
            Map propertyNameColumnInfoMap = DfCollectionUtil.newLinkedHashMap();
            List<DfProcedureColumnMetaInfo> procedureColumnList = procedure.getProcedureColumnList();
            List<DfProcedureNotParamResultMetaInfo> notParamResultList = procedure.getNotParamResultList();
            String pmbName = this.convertProcedureNameToPmbName(procedure.getProcedureName());
            String procDisp = procedure.buildProcedureLoggingName();
            DfProcedureMetaInfo.DfProcedureType procType = procedure.getProcedureType();
            _log.info((Object)("[" + pmbName + "]: " + procDisp + " // " + (Object)((Object)procType)));
            if (procedureColumnList.isEmpty() && notParamResultList.isEmpty()) {
                _log.info((Object)"    *No Parameter");
            }
            boolean refCustomizeEntity = false;
            int index = 0;
            for (DfProcedureColumnMetaInfo column : procedureColumnList) {
                if (!column.isBindParameter()) continue;
                String plainColumnName = column.getColumnName();
                String columnName = Srl.is_NotNull_and_NotTrimmedEmpty((String)plainColumnName) ? this.resolveVendorColumnNameHeadable(plainColumnName) : "arg" + (index + 1);
                String propertyName = this.convertColumnNameToPropertyName(columnName);
                propertyNameColumnInfoMap.put(propertyName, column);
                ProcedurePropertyInfo propertyInfo = this.processProcedureProperty(pmbName, column, propertyName);
                String propertyType = propertyInfo.getPropertyType();
                if (propertyInfo.isRefCustomizeEntity()) {
                    refCustomizeEntity = true;
                }
                propertyNameTypeMap.put(propertyName, propertyType);
                DfProcedureColumnMetaInfo.DfProcedureColumnType procedureColumnType = column.getProcedureColumnType();
                propertyNameOptionMap.put(propertyName, procedureColumnType.toString());
                propertyNameColumnNameMap.put(propertyName, columnName);
                String msg = "    " + propertyType + " " + propertyName + ";";
                msg = msg + " // " + (Object)((Object)column.getProcedureColumnType());
                msg = msg + "(" + column.getJdbcDefType() + ", " + column.getDbTypeName() + ")";
                _log.info((Object)msg);
                ++index;
            }
            for (DfProcedureNotParamResultMetaInfo result : notParamResultList) {
                String propertyType;
                String propertyName = result.getPropertyName();
                if (result.hasResultSetColumnInfo()) {
                    String entityName = this.convertProcedurePmbNameToEntityName(pmbName, propertyName);
                    this._entityInfoMap.put(entityName, new DfCustomizeEntityInfo(entityName, result.getResultSetColumnInfoMap()));
                    propertyType = this.convertProcedureListPropertyType(entityName);
                    refCustomizeEntity = true;
                } else {
                    propertyType = this.getProcedureDefaultResultSetPropertyType();
                }
                propertyNameTypeMap.put(propertyName, propertyType);
                propertyNameOptionMap.put(propertyName, DfProcedureColumnMetaInfo.DfProcedureColumnType.procedureColumnResult.toString());
                propertyNameColumnNameMap.put(propertyName, propertyName);
                String msg = "    " + propertyType + " " + propertyName + ";";
                msg = msg + " // " + (Object)((Object)DfProcedureColumnMetaInfo.DfProcedureColumnType.procedureColumnResult);
                _log.info((Object)msg);
            }
            DfPmbMetaData parameterBeanMetaData = new DfPmbMetaData();
            parameterBeanMetaData.setClassName(pmbName);
            parameterBeanMetaData.setPropertyNameTypeMap(propertyNameTypeMap);
            parameterBeanMetaData.setPropertyNameOptionMap(propertyNameOptionMap);
            parameterBeanMetaData.setProcedureName(procedure.buildProcedureSqlName());
            parameterBeanMetaData.setPropertyNameColumnNameMap(propertyNameColumnNameMap);
            parameterBeanMetaData.setPropertyNameColumnInfoMap(propertyNameColumnInfoMap);
            parameterBeanMetaData.setProcedureCalledBySelect(procedure.isCalledBySelect());
            parameterBeanMetaData.setRefCustomizeEntity(refCustomizeEntity);
            this._pmbMetaDataMap.put(pmbName, parameterBeanMetaData);
        }
        _log.info((Object)"= = = = = = = = = =/");
        _log.info((Object)" ");
    }

    protected List<DfProcedureMetaInfo> getAvailableProcedureList() throws SQLException {
        this._procedureHandler.includeProcedureSynonym(this._dataSource);
        List<DfProcedureMetaInfo> procedureList = this._procedureHandler.getAvailableProcedureList(this._dataSource);
        if (this.getOutsideSqlProperties().isGenerateProcedureCustomizeEntity()) {
            DfProcedureExecutionMetaExtractor executionMetaHandler = new DfProcedureExecutionMetaExtractor();
            executionMetaHandler.extractExecutionMetaData(this._dataSource, procedureList);
            this._continuedFailureMessageMap.putAll(executionMetaHandler.getContinuedFailureMessageMap());
        }
        return procedureList;
    }

    protected ProcedurePropertyInfo processProcedureProperty(String pmbName, DfProcedureColumnMetaInfo column, String propertyName) {
        String propertyType;
        ProcedurePropertyInfo propertyInfo = new ProcedurePropertyInfo();
        propertyInfo.setColumnInfo(column);
        if (this.isResultSetProperty(column)) {
            if (column.hasResultSetColumnInfo()) {
                String entityName = this.convertProcedurePmbNameToEntityName(pmbName, propertyName);
                this._entityInfoMap.put(entityName, new DfCustomizeEntityInfo(entityName, column.getResultSetColumnInfoMap()));
                propertyInfo.setPropertyType(this.convertProcedureListPropertyType(entityName));
                propertyInfo.setRefCustomizeEntity(true);
            } else {
                propertyInfo.setPropertyType(this.getProcedureDefaultResultSetPropertyType());
            }
            return propertyInfo;
        }
        int jdbcDefType = column.getJdbcDefType();
        Integer columnSize = column.getColumnSize();
        Integer decimalDigits = column.getDecimalDigits();
        String specialType = this.doProcessSpecialType(pmbName, column, propertyInfo);
        if (Srl.is_NotNull_and_NotTrimmedEmpty((String)specialType)) {
            propertyType = specialType;
        } else {
            String dbTypeName = column.getDbTypeName();
            propertyType = this.findPlainPropertyType(jdbcDefType, dbTypeName, columnSize, decimalDigits);
        }
        propertyInfo.setPropertyType(propertyType);
        return propertyInfo;
    }

    protected String doProcessSpecialType(String pmbName, DfProcedureColumnMetaInfo column, ProcedurePropertyInfo propertyInfo) {
        String wallOfOracleType;
        if (this.getLittleAdjustmentProperties().isAvailableDatabaseNativeJDBC() && Srl.is_NotNull_and_NotTrimmedEmpty((String)(wallOfOracleType = this.doProcessGreatWallOfOracleType(pmbName, column, propertyInfo)))) {
            return wallOfOracleType;
        }
        String propertyType = column.isOracleNumber() ? TypeMap.getDefaultDecimalJavaNativeType() : null;
        return propertyType;
    }

    protected String doProcessGreatWallOfOracleType(String pmbName, DfProcedureColumnMetaInfo column, ProcedurePropertyInfo propertyInfo) {
        String propertyType;
        if (column.isOracleTreatedAsArray() && column.hasTypeArrayInfo()) {
            DfTypeArrayInfo arrayInfo = column.getTypeArrayInfo();
            propertyType = this.getGenericListClassName(this.doProcessArrayProperty(arrayInfo, propertyInfo));
        } else if (column.isOracleStruct() && column.hasTypeStructInfo()) {
            DfTypeStructInfo structInfo = column.getTypeStructInfo();
            propertyType = this.doProcessStructProperty(structInfo, propertyInfo);
        } else {
            propertyType = null;
        }
        return propertyType;
    }

    protected boolean isResultSetProperty(DfProcedureColumnMetaInfo column) {
        if (column.hasResultSetColumnInfo()) {
            return true;
        }
        return column.isPostgreSQLCursor() || column.isOracleCursor();
    }

    protected String getProcedureDefaultResultSetPropertyType() {
        DfGrammarInfo grammarInfo = this.getBasicProperties().getLanguageDependencyInfo().getGrammarInfo();
        return grammarInfo.getGenericMapListClassName("String", "Object");
    }

    protected String doProcessArrayProperty(DfTypeArrayInfo arrayInfo, ProcedurePropertyInfo propertyInfo) {
        String propertyType;
        if (arrayInfo.hasNestedArray()) {
            DfTypeArrayInfo nestedArrayInfo = arrayInfo.getNestedArrayInfo();
            String nestedType = this.doProcessArrayProperty(nestedArrayInfo, propertyInfo);
            propertyType = this.getGenericListClassName(nestedType);
        } else if (arrayInfo.hasElementStructInfo()) {
            DfTypeStructInfo structInfo = arrayInfo.getElementStructInfo();
            propertyType = this.doProcessStructProperty(structInfo, propertyInfo);
        } else {
            String dbTypeName = arrayInfo.getElementType();
            propertyType = this.findPlainPropertyType(1111, dbTypeName, null, null);
        }
        arrayInfo.setElementJavaNative(propertyType);
        return propertyType;
    }

    protected String findArrayScalarElementPropertyType(DfTypeArrayInfo arrayInfo) {
        String dbTypeName = arrayInfo.getElementType();
        return this.findPlainPropertyType(1111, dbTypeName, null, null);
    }

    protected String doProcessStructProperty(DfTypeStructInfo structInfo, ProcedurePropertyInfo propertyInfo) {
        this.registerEntityInfoIfNeeds(structInfo, propertyInfo);
        String entityType = this.buildStructEntityType(structInfo);
        propertyInfo.setRefCustomizeEntity(true);
        return entityType;
    }

    protected void registerEntityInfoIfNeeds(DfTypeStructInfo structInfo, ProcedurePropertyInfo propertyInfo) {
        String typeName = this.getStructEntityNameResouce(structInfo);
        if (!this._entityInfoMap.containsKey(typeName)) {
            StringKeyMap<DfColumnMetaInfo> attrMap = structInfo.getAttributeInfoMap();
            this._entityInfoMap.put(typeName, new DfCustomizeEntityInfo(typeName, (Map<String, DfColumnMetaInfo>)attrMap, structInfo));
            this.setupStructAttribute(structInfo, propertyInfo);
        }
    }

    protected void setupStructAttribute(DfTypeStructInfo structInfo, ProcedurePropertyInfo propertyInfo) {
        StringKeyMap<DfColumnMetaInfo> attrMap = structInfo.getAttributeInfoMap();
        for (DfColumnMetaInfo attrInfo : attrMap.values()) {
            if (attrInfo.hasTypeArrayInfo()) {
                String elementType;
                DfTypeArrayInfo typeArrayInfo = attrInfo.getTypeArrayInfo();
                if (typeArrayInfo.hasElementStructInfo()) {
                    this.registerEntityInfoIfNeeds(typeArrayInfo.getElementStructInfo(), propertyInfo);
                }
                if (typeArrayInfo.hasElementJavaNative()) {
                    String elementJavaNative = typeArrayInfo.getElementJavaNative();
                    attrInfo.setSql2EntityForcedJavaNative(this.getGenericListClassName(elementJavaNative));
                    continue;
                }
                if (typeArrayInfo.hasNestedArray()) {
                    DfTypeArrayInfo nestedArrayInfo = typeArrayInfo.getNestedArrayInfo();
                    elementType = this.getGenericListClassName(this.doProcessArrayProperty(nestedArrayInfo, propertyInfo));
                } else if (typeArrayInfo.hasElementStructInfo()) {
                    DfTypeStructInfo elementStructInfo = typeArrayInfo.getElementStructInfo();
                    elementType = this.buildStructEntityType(elementStructInfo);
                } else {
                    elementType = this.findArrayScalarElementPropertyType(attrInfo.getTypeArrayInfo());
                }
                typeArrayInfo.setElementJavaNative(elementType);
                attrInfo.setSql2EntityForcedJavaNative(this.getGenericListClassName(elementType));
                continue;
            }
            if (!attrInfo.hasTypeStructInfo()) continue;
            DfTypeStructInfo nestedStructInfo = attrInfo.getTypeStructInfo();
            this.registerEntityInfoIfNeeds(nestedStructInfo, propertyInfo);
            if (nestedStructInfo.hasEntityType()) {
                attrInfo.setSql2EntityForcedJavaNative(nestedStructInfo.getEntityType());
                continue;
            }
            attrInfo.setSql2EntityForcedJavaNative(this.buildStructEntityType(nestedStructInfo));
        }
    }

    protected String buildStructEntityType(DfTypeStructInfo structInfo) {
        String entityName = this._database.convertJavaNameByJdbcNameAsTable(this.getStructEntityNameResouce(structInfo));
        String projectPrefix = this.getBasicProperties().getProjectPrefix();
        String entityType = projectPrefix + entityName;
        structInfo.setEntityType(entityType);
        return entityType;
    }

    protected String getStructEntityNameResouce(DfTypeStructInfo structInfo) {
        return structInfo.getTypePureName();
    }

    protected String findPlainPropertyType(int jdbcDefType, String dbTypeName, Integer columnSize, Integer decimalDigits) {
        if (this._columnHandler.hasMappingJdbcType(jdbcDefType, dbTypeName)) {
            String torqueType = this._columnHandler.getColumnJdbcType(jdbcDefType, dbTypeName);
            return TypeMap.findJavaNativeByJdbcType(torqueType, columnSize, decimalDigits);
        }
        return "Object";
    }

    protected String getGenericListClassName(String element) {
        DfGrammarInfo grammarInfo = this.getBasicProperties().getLanguageDependencyInfo().getGrammarInfo();
        return grammarInfo.getGenericListClassName(element);
    }

    protected String convertProcedureNameToPmbName(String procedureName) {
        procedureName = Srl.replace((String)procedureName, (String)".", (String)"_");
        procedureName = this.resolveVendorProcedureNameHeadache(procedureName);
        return Srl.camelize((String)procedureName) + "Pmb";
    }

    protected String resolveVendorProcedureNameHeadache(String procedureName) {
        if (this.getBasicProperties().isDatabaseSQLServer()) {
            procedureName = Srl.substringLastFront((String)procedureName, (String[])new String[]{";"});
        }
        return procedureName;
    }

    protected String convertProcedurePmbNameToEntityName(String pmbName, String propertyName) {
        String baseName = Srl.substringLastFront((String)pmbName, (String[])new String[]{"Pmb"});
        return baseName + Srl.initCap((String)propertyName);
    }

    protected String convertProcedureListPropertyType(String entityName) {
        String projectPrefix = this.getBasicProperties().getProjectPrefix();
        String propertyType = projectPrefix + entityName;
        DfGrammarInfo grammarInfo = this.getBasicProperties().getLanguageDependencyInfo().getGrammarInfo();
        return grammarInfo.getGenericListClassName(propertyType);
    }

    protected String convertColumnNameToPropertyName(String columnName) {
        columnName = this.resolveVendorColumnNameHeadable(columnName);
        return Srl.initBeansProp((String)Srl.camelize((String)columnName));
    }

    protected String resolveVendorColumnNameHeadable(String columnName) {
        if (this.getBasicProperties().isDatabaseSQLServer()) {
            columnName = Srl.substringFirstRear((String)columnName, (String[])new String[]{"@"});
        }
        return columnName;
    }

    protected DfBasicProperties getBasicProperties() {
        return DfBuildProperties.getInstance().getBasicProperties();
    }

    protected DfLittleAdjustmentProperties getLittleAdjustmentProperties() {
        return DfBuildProperties.getInstance().getLittleAdjustmentProperties();
    }

    protected DfOutsideSqlProperties getOutsideSqlProperties() {
        return DfBuildProperties.getInstance().getOutsideSqlProperties();
    }

    public Map<String, String> getContinuedFailureMessageMap() {
        return this._continuedFailureMessageMap;
    }

    protected static class ProcedurePropertyInfo {
        protected DfProcedureColumnMetaInfo _columnInfo;
        protected String _propertyType;
        protected boolean _refCustomizeEntity;

        protected ProcedurePropertyInfo() {
        }

        public DfProcedureColumnMetaInfo getColumnInfo() {
            return this._columnInfo;
        }

        public void setColumnInfo(DfProcedureColumnMetaInfo columnInfo) {
            this._columnInfo = columnInfo;
        }

        public String getPropertyType() {
            return this._propertyType;
        }

        public void setPropertyType(String propertyType) {
            this._propertyType = propertyType;
        }

        public boolean isRefCustomizeEntity() {
            return this._refCustomizeEntity;
        }

        public void setRefCustomizeEntity(boolean refCustomizeEntity) {
            this._refCustomizeEntity = refCustomizeEntity;
        }
    }
}

