/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.replaceschema.schemainitializer;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.dbflute.helper.jdbc.facade.DfJdbcFacade;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfTableMetaInfo;
import org.seasar.dbflute.logic.replaceschema.schemainitializer.DfSchemaInitializerJdbc;
import org.seasar.dbflute.util.Srl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfSchemaInitializerH2
extends DfSchemaInitializerJdbc {
    private static final Log _log = LogFactory.getLog(DfSchemaInitializerH2.class);

    @Override
    protected void dropSequence(Connection conn, List<DfTableMetaInfo> tableMetaInfoList) {
        String catalog = this._unifiedSchema.existsPureCatalog() ? this._unifiedSchema.getPureCatalog() : null;
        String schema = this._unifiedSchema.getPureSchema();
        ArrayList<String> sequenceNameList = new ArrayList<String>();
        DfJdbcFacade jdbcFacade = new DfJdbcFacade(conn);
        String sequenceColumnName = "sequence_name";
        StringBuilder sb = new StringBuilder();
        sb.append("select ").append("sequence_name").append(" from information_schema.sequences");
        sb.append(" where ");
        if (Srl.is_NotNull_and_NotTrimmedEmpty((String)catalog)) {
            sb.append("sequence_catalog = '").append(catalog).append("'").append(" and ");
        }
        sb.append("sequence_schema = '").append(schema).append("'");
        List<Map<String, String>> resultList = jdbcFacade.selectStringList(sb.toString(), Arrays.asList("sequence_name"));
        for (Map<String, String> recordMap : resultList) {
            sequenceNameList.add(recordMap.get("sequence_name"));
        }
        for (String sequenceName : sequenceNameList) {
            String sequenceSqlName = this._unifiedSchema.buildSqlName(sequenceName);
            String dropSequenceSql = "drop sequence " + sequenceSqlName;
            _log.info((Object)dropSequenceSql);
            jdbcFacade.execute(dropSequenceSql);
        }
    }
}

