/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.jdbc.metadata.sequence;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.engine.database.model.UnifiedSchema;
import org.seasar.dbflute.helper.StringKeyMap;
import org.seasar.dbflute.helper.jdbc.facade.DfJdbcFacade;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfSequenceMetaInfo;
import org.seasar.dbflute.logic.jdbc.metadata.sequence.DfSequenceExtractorBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfSequenceExtractorH2
extends DfSequenceExtractorBase {
    private static final Log _log = LogFactory.getLog(DfSequenceExtractorH2.class);

    public DfSequenceExtractorH2(DataSource dataSource, List<UnifiedSchema> unifiedSchemaList) {
        super(dataSource, unifiedSchemaList);
    }

    @Override
    protected Map<String, DfSequenceMetaInfo> doGetSequenceMap() {
        _log.info((Object)"...Loading sequence informations");
        StringKeyMap resultMap = StringKeyMap.createAsFlexibleOrdered();
        DfJdbcFacade facade = new DfJdbcFacade(this._dataSource);
        String sql = this.buildMetaSelectSql();
        _log.info((Object)sql);
        ArrayList<String> columnList = new ArrayList<String>();
        columnList.add("SEQUENCE_CATALOG");
        columnList.add("SEQUENCE_SCHEMA");
        columnList.add("SEQUENCE_NAME");
        columnList.add("INCREMENT");
        List<Map<String, String>> resultList = facade.selectStringList(sql, columnList);
        StringBuilder logSb = new StringBuilder();
        logSb.append(this.ln()).append("[SEQUENCE]");
        for (Map<String, String> recordMap : resultList) {
            DfSequenceMetaInfo info = new DfSequenceMetaInfo();
            String sequenceCatalog = recordMap.get("SEQUENCE_CATALOG");
            info.setSequenceCatalog(sequenceCatalog);
            String sequenceSchema = recordMap.get("SEQUENCE_SCHEMA");
            info.setSequenceSchema(sequenceSchema);
            String sequenceName = recordMap.get("SEQUENCE_NAME");
            info.setSequenceName(sequenceName);
            String incrementSize = recordMap.get("INCREMENT");
            info.setIncrementSize(incrementSize != null ? Integer.valueOf(incrementSize) : null);
            String key = this.buildSequenceMapKey(sequenceCatalog, sequenceSchema, sequenceName);
            resultMap.put(key, info);
            logSb.append(this.ln()).append(" ").append(key).append(" = ").append(info.toString());
        }
        _log.info((Object)logSb.toString());
        return resultMap;
    }

    protected String buildMetaSelectSql() {
        String schemaCondition;
        if (!this._unifiedSchemaList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (UnifiedSchema unifiedSchema : this._unifiedSchemaList) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append("'").append(unifiedSchema.getPureSchema()).append("'");
            }
            schemaCondition = sb.toString();
        } else {
            schemaCondition = "'PUBLIC'";
        }
        return "select * from INFORMATION_SCHEMA.SEQUENCES where SEQUENCE_SCHEMA in (" + schemaCondition + ")";
    }
}

