/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.bhv.core.execution;

import javax.sql.DataSource;
import org.seasar.dbflute.jdbc.StatementFactory;
import org.seasar.dbflute.outsidesql.OutsideSqlFilter;
import org.seasar.dbflute.s2dao.sqlcommand.TnAbstractDynamicCommand;
import org.seasar.dbflute.util.Srl;

public abstract class AbstractOutsideSqlExecution
extends TnAbstractDynamicCommand {
    protected boolean _removeBlockComment;
    protected boolean _removeLineComment;
    protected boolean _formatSql;
    protected OutsideSqlFilter _outsideSqlFilter;

    public AbstractOutsideSqlExecution(DataSource dataSource, StatementFactory statementFactory) {
        super(dataSource, statementFactory);
    }

    public String filterSql(String sql) {
        if (this._outsideSqlFilter != null) {
            sql = this._outsideSqlFilter.filterExecution(sql, this.getOutsideSqlExecutionFilterType());
        }
        if (this._removeBlockComment) {
            sql = Srl.removeBlockComment(sql);
        }
        if (this._removeLineComment) {
            sql = Srl.removeLineComment(sql);
        }
        if (this._formatSql) {
            sql = Srl.removeEmptyLine(sql);
        }
        return sql;
    }

    protected abstract OutsideSqlFilter.ExecutionFilterType getOutsideSqlExecutionFilterType();

    public boolean isRemoveBlockComment() {
        return this._removeBlockComment;
    }

    public void setRemoveBlockComment(boolean removeBlockComment) {
        this._removeBlockComment = removeBlockComment;
    }

    public boolean isRemoveLineComment() {
        return this._removeLineComment;
    }

    public void setRemoveLineComment(boolean removeLineComment) {
        this._removeLineComment = removeLineComment;
    }

    public boolean isRemoveEmptyLine() {
        return this._formatSql;
    }

    public void setFormatSql(boolean formatSql) {
        this._formatSql = formatSql;
    }

    public OutsideSqlFilter getOutsideSqlFilter() {
        return this._outsideSqlFilter;
    }

    public void setOutsideSqlFilter(OutsideSqlFilter outsideSqlFilter) {
        this._outsideSqlFilter = outsideSqlFilter;
    }
}

