/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.jdbc.schemadiff;

import java.util.List;
import java.util.Map;
import org.seasar.dbflute.logic.jdbc.schemadiff.DfAbstractDiff;
import org.seasar.dbflute.logic.jdbc.schemadiff.DfDiffType;
import org.seasar.dbflute.logic.jdbc.schemadiff.DfNestDiff;
import org.seasar.dbflute.logic.jdbc.schemadiff.DfNextPreviousDiff;
import org.seasar.dbflute.util.DfCollectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DfConstraintDiff
extends DfAbstractDiff
implements DfNestDiff {
    protected final String _constraintName;
    protected final DfDiffType _diffType;
    protected DfNextPreviousDiff _nameDiff;
    protected DfNextPreviousDiff _columnDiff;
    protected List<DfAbstractDiff.NextPreviousHandler> _nextPreviousItemList = DfCollectionUtil.newArrayList();

    protected DfConstraintDiff(String constraintName, DfDiffType diffType) {
        this._nextPreviousItemList.add(new DfAbstractDiff.NextPreviousHandler(){

            @Override
            public String titleName() {
                return "Name";
            }

            @Override
            public String propertyName() {
                return "nameDiff";
            }

            @Override
            public DfNextPreviousDiff provide() {
                return DfConstraintDiff.this._nameDiff;
            }

            @Override
            public void restore(Map<String, Object> diffMap) {
                DfConstraintDiff.this._nameDiff = DfConstraintDiff.this.restoreNextPreviousDiff(diffMap, this.propertyName());
            }
        });
        this._nextPreviousItemList.add(new DfAbstractDiff.NextPreviousHandler(){

            @Override
            public String titleName() {
                return "Column";
            }

            @Override
            public String propertyName() {
                return "columnDiff";
            }

            @Override
            public DfNextPreviousDiff provide() {
                return DfConstraintDiff.this._columnDiff;
            }

            @Override
            public void restore(Map<String, Object> diffMap) {
                DfConstraintDiff.this._columnDiff = DfConstraintDiff.this.restoreNextPreviousDiff(diffMap, this.propertyName());
            }
        });
        this._constraintName = constraintName;
        this._diffType = diffType;
    }

    protected DfConstraintDiff(Map<String, Object> diffMap) {
        this._nextPreviousItemList.add(new /* invalid duplicate definition of identical inner class */);
        this._nextPreviousItemList.add(new /* invalid duplicate definition of identical inner class */);
        this._constraintName = (String)diffMap.get("constraintName");
        this.assertConstraintNameExists(this._constraintName, diffMap);
        this._diffType = DfDiffType.valueOf((String)diffMap.get("diffType"));
        this.acceptDiffMap(diffMap);
    }

    protected void assertConstraintNameExists(String constraintName, Map<String, Object> diffMap) {
        if (constraintName == null) {
            String msg = "The constraintName is required in diff-map:";
            msg = msg + " diffMap=" + diffMap;
            throw new IllegalStateException(msg);
        }
    }

    protected void assertDiffTypeExists(String constraintName, Map<String, Object> diffMap, DfDiffType diffType) {
        if (diffType == null) {
            String msg = "The diffType is required in diff-map:";
            msg = msg + " constraintName=" + constraintName + " diffMap=" + diffMap;
            throw new IllegalStateException(msg);
        }
    }

    @Override
    public Map<String, Object> createDiffMap() {
        Map map = DfCollectionUtil.newLinkedHashMap();
        map.put("constraintName", this._constraintName);
        map.put("diffType", this._diffType.toString());
        List<DfAbstractDiff.NextPreviousHandler> nextPreviousItemList = this._nextPreviousItemList;
        for (DfAbstractDiff.NextPreviousHandler provider : nextPreviousItemList) {
            DfNextPreviousDiff nextPreviousDiff = provider.provide();
            if (nextPreviousDiff == null) continue;
            map.put(provider.propertyName(), nextPreviousDiff.createNextPreviousDiffMap());
        }
        return map;
    }

    @Override
    public void acceptDiffMap(Map<String, Object> diffMap) {
        List<DfAbstractDiff.NextPreviousHandler> nextPreviousItemList = this._nextPreviousItemList;
        for (DfAbstractDiff.NextPreviousHandler provider : nextPreviousItemList) {
            provider.restore(diffMap);
        }
    }

    @Override
    public boolean hasDiff() {
        if (!DfDiffType.CHANGE.equals((Object)this._diffType)) {
            return true;
        }
        List<DfAbstractDiff.NextPreviousHandler> nextPreviousItemList = this._nextPreviousItemList;
        for (DfAbstractDiff.NextPreviousHandler provider : nextPreviousItemList) {
            if (provider.provide() == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getKeyName() {
        return this.getConstraintName();
    }

    public String getConstraintName() {
        return this._constraintName;
    }

    @Override
    public DfDiffType getDiffType() {
        return this._diffType;
    }

    public boolean isAdded() {
        return DfDiffType.ADD.equals((Object)this._diffType);
    }

    public boolean isChanged() {
        return DfDiffType.CHANGE.equals((Object)this._diffType);
    }

    public boolean isDeleted() {
        return DfDiffType.DELETE.equals((Object)this._diffType);
    }

    @Override
    public List<DfAbstractDiff.NextPreviousHandler> getNextPreviousValidList() {
        List<DfAbstractDiff.NextPreviousHandler> previousItemList = this._nextPreviousItemList;
        List validHandlerList = DfCollectionUtil.newArrayList();
        for (DfAbstractDiff.NextPreviousHandler handler : previousItemList) {
            DfNextPreviousDiff nextPreviousDiff = handler.provide();
            if (nextPreviousDiff == null || !nextPreviousDiff.hasDiff()) continue;
            validHandlerList.add(handler);
        }
        return validHandlerList;
    }

    public boolean hasNameDiff() {
        return this._nameDiff != null;
    }

    public DfNextPreviousDiff getNameDiff() {
        return this._nameDiff;
    }

    public void setNameDiff(DfNextPreviousDiff nameDiff) {
        this._nameDiff = nameDiff;
    }

    public boolean hasColumnDiff() {
        return this._columnDiff != null;
    }

    public DfNextPreviousDiff getColumnDiff() {
        return this._columnDiff;
    }

    public void setColumnDiff(DfNextPreviousDiff columnDiff) {
        this._columnDiff = columnDiff;
    }
}

