/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.jdbc.metadata.comment;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.engine.database.model.UnifiedSchema;
import org.seasar.dbflute.exception.DfCommentExtractingFailureException;
import org.seasar.dbflute.helper.StringKeyMap;
import org.seasar.dbflute.logic.jdbc.metadata.DfAbstractMetaDataExtractor;
import org.seasar.dbflute.logic.jdbc.metadata.comment.DfDbCommentExtractor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DfDbCommentExtractorBase
extends DfAbstractMetaDataExtractor
implements DfDbCommentExtractor {
    private static final Log _log = LogFactory.getLog(DfDbCommentExtractorBase.class);
    protected DataSource _dataSource;
    protected UnifiedSchema _unifiedSchema;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, DfDbCommentExtractor.UserTabComments> extractTableComment(Set<String> tableSet) {
        StringKeyMap i$;
        StringKeyMap resultMap = StringKeyMap.createAsFlexible();
        Connection conn = null;
        try {
            try {
                conn = this._dataSource.getConnection();
                List<DfDbCommentExtractor.UserTabComments> userTabCommentsList = this.selectUserTabComments(conn, tableSet);
                for (DfDbCommentExtractor.UserTabComments userTabComments : userTabCommentsList) {
                    resultMap.put(userTabComments.getTableName(), userTabComments);
                }
                i$ = resultMap;
                Object var8_9 = null;
                if (conn == null) return i$;
            }
            catch (SQLException e) {
                String msg = "Failed to extract comment data: unifiedSchema=" + this._unifiedSchema;
                throw new DfCommentExtractingFailureException(msg, e);
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (conn == null) throw throwable;
            try {
                conn.close();
                throw throwable;
            }
            catch (SQLException ignored) {
                _log.info((Object)"connection.close() threw the exception!", (Throwable)ignored);
                throw throwable;
            }
        }
        try {}
        catch (SQLException ignored) {
            _log.info((Object)"connection.close() threw the exception!", (Throwable)ignored);
            return i$;
        }
        conn.close();
        return i$;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, Map<String, DfDbCommentExtractor.UserColComments>> extractColumnComment(Set<String> tableSet) {
        StringKeyMap stringKeyMap;
        StringKeyMap resultMap = StringKeyMap.createAsFlexible();
        Connection conn = null;
        try {
            try {
                conn = this._dataSource.getConnection();
                List<DfDbCommentExtractor.UserColComments> userColCommentsList = this.selectUserColComments(conn, tableSet);
                String previousTableName = null;
                LinkedHashMap<String, DfDbCommentExtractor.UserColComments> elementMap = null;
                for (DfDbCommentExtractor.UserColComments userColComments : userColCommentsList) {
                    String tableName = userColComments.getTableName();
                    if (previousTableName == null || !previousTableName.equals(tableName)) {
                        previousTableName = tableName;
                        elementMap = new LinkedHashMap<String, DfDbCommentExtractor.UserColComments>();
                        resultMap.put(tableName, elementMap);
                    }
                    String columnName = userColComments.getColumnName();
                    elementMap.put(columnName, userColComments);
                }
                stringKeyMap = resultMap;
                Object var12_13 = null;
                if (conn == null) return stringKeyMap;
            }
            catch (SQLException e) {
                String msg = "Failed to extract comment data: schema=" + this._unifiedSchema;
                throw new DfCommentExtractingFailureException(msg, e);
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            if (conn == null) throw throwable;
            try {
                conn.close();
                throw throwable;
            }
            catch (SQLException ignored) {
                _log.info((Object)"connection.close() threw the exception!", (Throwable)ignored);
                throw throwable;
            }
        }
        try {}
        catch (SQLException ignored) {
            _log.info((Object)"connection.close() threw the exception!", (Throwable)ignored);
            return stringKeyMap;
        }
        conn.close();
        return stringKeyMap;
    }

    protected abstract List<DfDbCommentExtractor.UserTabComments> selectUserTabComments(Connection var1, Set<String> var2);

    /*
     * Loose catch block
     */
    protected List<DfDbCommentExtractor.UserTabComments> doSelectUserTabComments(String sql, Connection conn, Set<String> tableSet) {
        SQLException ignored22;
        Object tableName;
        ResultSet rs;
        Statement statement;
        block13: {
            statement = null;
            rs = null;
            statement = conn.createStatement();
            _log.info((Object)sql);
            rs = statement.executeQuery(sql);
            ArrayList<DfDbCommentExtractor.UserTabComments> resultList = new ArrayList<DfDbCommentExtractor.UserTabComments>();
            while (rs.next()) {
                tableName = rs.getString("TABLE_NAME");
                if (!tableSet.contains(tableName)) continue;
                String comments = rs.getString("COMMENTS");
                DfDbCommentExtractor.UserTabComments userTabComments = new DfDbCommentExtractor.UserTabComments();
                userTabComments.setTableName((String)tableName);
                userTabComments.setComments(this.filterTableComments(comments));
                resultList.add(userTabComments);
            }
            tableName = resultList;
            Object var11_12 = null;
            if (rs == null) break block13;
            try {
                rs.close();
            }
            catch (SQLException ignored22) {
                _log.info((Object)"rs.close() threw the exception!", (Throwable)ignored22);
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException ignored22) {
                _log.info((Object)"statement.close() threw the exception!", (Throwable)ignored22);
            }
        }
        return tableName;
        catch (SQLException e) {
            try {
                String msg = "Failed to extract table comment: sql=" + sql;
                throw new DfCommentExtractingFailureException(msg, e);
            }
            catch (Throwable throwable) {
                block15: {
                    SQLException ignored22;
                    Object var11_13 = null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException ignored22) {
                            _log.info((Object)"rs.close() threw the exception!", (Throwable)ignored22);
                        }
                    }
                    if (statement == null) break block15;
                    try {
                        statement.close();
                    }
                    catch (SQLException ignored22) {
                        _log.info((Object)"statement.close() threw the exception!", (Throwable)ignored22);
                    }
                }
                throw throwable;
            }
        }
    }

    protected String filterTableComments(String comments) {
        return comments;
    }

    protected abstract List<DfDbCommentExtractor.UserColComments> selectUserColComments(Connection var1, Set<String> var2);

    /*
     * Loose catch block
     */
    protected List<DfDbCommentExtractor.UserColComments> doSelectUserColComments(String sql, Connection conn, Set<String> tableSet) {
        SQLException ignored22;
        Object tableName;
        ResultSet rs;
        Statement statement;
        block13: {
            statement = null;
            rs = null;
            statement = conn.createStatement();
            _log.info((Object)sql);
            rs = statement.executeQuery(sql);
            ArrayList<DfDbCommentExtractor.UserColComments> resultList = new ArrayList<DfDbCommentExtractor.UserColComments>();
            while (rs.next()) {
                tableName = rs.getString("TABLE_NAME");
                if (!tableSet.contains(tableName)) continue;
                String columnName = rs.getString("COLUMN_NAME");
                String comments = rs.getString("COMMENTS");
                DfDbCommentExtractor.UserColComments userColComments = new DfDbCommentExtractor.UserColComments();
                userColComments.setTableName((String)tableName);
                userColComments.setColumnName(columnName);
                userColComments.setComments(this.filterColumnComments(comments));
                resultList.add(userColComments);
            }
            tableName = resultList;
            Object var12_13 = null;
            if (rs == null) break block13;
            try {
                rs.close();
            }
            catch (SQLException ignored22) {
                _log.info((Object)"rs.close() threw the exception!", (Throwable)ignored22);
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException ignored22) {
                _log.info((Object)"statement.close() threw the exception!", (Throwable)ignored22);
            }
        }
        return tableName;
        catch (SQLException e) {
            try {
                String msg = "Failed to extract column comment: sql=" + sql;
                throw new DfCommentExtractingFailureException(msg, e);
            }
            catch (Throwable throwable) {
                block15: {
                    SQLException ignored22;
                    Object var12_14 = null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException ignored22) {
                            _log.info((Object)"rs.close() threw the exception!", (Throwable)ignored22);
                        }
                    }
                    if (statement == null) break block15;
                    try {
                        statement.close();
                    }
                    catch (SQLException ignored22) {
                        _log.info((Object)"statement.close() threw the exception!", (Throwable)ignored22);
                    }
                }
                throw throwable;
            }
        }
    }

    protected String filterColumnComments(String comments) {
        return comments;
    }

    public void setDataSource(DataSource dataSource) {
        this._dataSource = dataSource;
    }

    public UnifiedSchema getUnifiedSchema() {
        return this._unifiedSchema;
    }

    public void setUnifiedSchema(UnifiedSchema unifiedSchema) {
        this._unifiedSchema = unifiedSchema;
    }
}

