/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.properties;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.engine.database.model.Column;
import org.apache.torque.engine.database.model.Database;
import org.apache.torque.engine.database.model.ForeignKey;
import org.apache.torque.engine.database.model.Table;
import org.seasar.dbflute.helper.StringKeyMap;
import org.seasar.dbflute.logic.clsresource.DfClassificationResourceAnalyzer;
import org.seasar.dbflute.properties.DfAbstractHelperProperties;
import org.seasar.dbflute.properties.assistant.classification.DfClassificationAllInOneSqlExecutor;
import org.seasar.dbflute.properties.assistant.classification.DfClassificationElement;
import org.seasar.dbflute.properties.assistant.classification.DfClassificationIllegalPropertyTypeException;
import org.seasar.dbflute.properties.assistant.classification.DfClassificationLiteralArranger;
import org.seasar.dbflute.properties.assistant.classification.DfClassificationSqlResourceCloser;
import org.seasar.dbflute.properties.assistant.classification.DfClassificationTop;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DfClassificationProperties
extends DfAbstractHelperProperties {
    private static final Log _log = LogFactory.getLog(DfClassificationProperties.class);
    protected final Map<String, DfClassificationElement> _tableClassificationMap = new LinkedHashMap<String, DfClassificationElement>();
    public static final String KEY_classificationDefinitionMap = "classificationDefinitionMap";
    protected Map<String, Map<String, String>> _classificationTopDefinitionMap;
    protected Map<String, List<Map<String, String>>> _classificationDefinitionMap;
    public static final String KEY_classificationDeploymentMap = "classificationDeploymentMap";
    public static final String MARK_allColumnClassification = "$$ALL$$";
    protected Map<String, Map<String, String>> _classificationDeploymentMap;
    protected static final String NAME_CLASSIFICATION_RESOURCE = "classificationResource";
    protected List<DfClassificationTop> _classificationResourceList;

    public DfClassificationProperties(Properties prop) {
        super(prop);
    }

    public boolean hasClassificationTopDefinitionMap() {
        return !this.getClassificationTopDefinitionMap().isEmpty();
    }

    public boolean hasClassificationTopDefinitionMap(String classificationName) {
        return this.getClassificationTopDefinitionMap().containsKey(classificationName);
    }

    public Map<String, Map<String, String>> getClassificationTopDefinitionMap() {
        if (this._classificationTopDefinitionMap != null) {
            return this._classificationTopDefinitionMap;
        }
        this.getClassificationDefinitionMap();
        return this._classificationTopDefinitionMap;
    }

    public boolean hasClassificationDefinitionMap() {
        return !this.getClassificationDefinitionMap().isEmpty();
    }

    public boolean hasClassificationDefinitionMap(String classificationName) {
        return this.getClassificationDefinitionMap().containsKey(classificationName);
    }

    public Map<String, List<Map<String, String>>> getClassificationDefinitionMap() {
        if (this._classificationDefinitionMap != null) {
            return this._classificationDefinitionMap;
        }
        this._classificationTopDefinitionMap = new LinkedHashMap<String, Map<String, String>>();
        this._classificationDefinitionMap = new LinkedHashMap<String, List<Map<String, String>>>();
        String key = "torque.classificationDefinitionMap";
        Map<String, Object> plainClassificationDefinitionMap = this.mapProp("torque.classificationDefinitionMap", DEFAULT_EMPTY_MAP);
        Set<String> classificationNameSet = plainClassificationDefinitionMap.keySet();
        DfClassificationLiteralArranger literalArranger = new DfClassificationLiteralArranger();
        for (String classificationName : classificationNameSet) {
            if (this._classificationDefinitionMap.containsKey(classificationName)) {
                String msg = "Duplicate classification: " + classificationName;
                throw new IllegalStateException(msg);
            }
            if (classificationName.equalsIgnoreCase("$$SQL$$")) {
                String topSql = (String)plainClassificationDefinitionMap.get(classificationName);
                this.setupAllInOneTableClassification(topSql);
                continue;
            }
            Object value = plainClassificationDefinitionMap.get(classificationName);
            if (!(value instanceof List)) {
                String msg = "A value of map for classification definition should be list for classification:";
                msg = msg + " classificationName=" + classificationName;
                msg = msg + " type=" + value.getClass() + " value=" + value;
                throw new DfClassificationIllegalPropertyTypeException(msg);
            }
            List plainList = (List)value;
            ArrayList<Map<String, String>> elementList = new ArrayList<Map<String, String>>();
            for (Object element : plainList) {
                if (!(element instanceof Map)) {
                    String msg = "An element of list for classification should be map for classification element:";
                    msg = msg + " classificationName=" + classificationName;
                    msg = msg + " type=" + element.getClass() + " element=" + element;
                    throw new DfClassificationIllegalPropertyTypeException(msg);
                }
                Map elementMap = (Map)element;
                String table = (String)elementMap.get("table");
                if (table != null) {
                    DfClassificationElement classificationInfo = new DfClassificationElement();
                    classificationInfo.setClassificationName(classificationName);
                    classificationInfo.setTable(table);
                    classificationInfo.acceptClassificationBasicElementMap(elementMap);
                    String where = (String)elementMap.get("where");
                    String orderBy = (String)elementMap.get("orderBy");
                    String sql = this.buildSql(classificationInfo, table, where, orderBy);
                    List<?> exceptCodeList = this.extractExceptCodeList(elementMap);
                    this.setupTableClassification(elementList, sql, classificationInfo, exceptCodeList);
                    if (this.isTableClassificationSuppressAutoDeploy(elementMap)) continue;
                    this._tableClassificationMap.put(classificationName, classificationInfo);
                    continue;
                }
                if (this.isElementMapClassificationMeta(elementMap)) {
                    this.setupClassificationMetaFromLiteralIfNeeds(classificationName, elementMap);
                    continue;
                }
                literalArranger.arrange(classificationName, elementMap, elementList);
            }
            this._classificationDefinitionMap.put(classificationName, elementList);
        }
        this.reflectClassificationResourceToDefinition();
        return this._classificationDefinitionMap;
    }

    protected boolean isElementMapClassificationMeta(Map<?, ?> elementMap) {
        String classificationTopComment = (String)elementMap.get("topComment");
        return classificationTopComment != null;
    }

    protected boolean isTableClassificationSuppressAutoDeploy(Map<?, ?> elementMap) {
        String suppressAutoDeploy = (String)elementMap.get("suppressAutoDeploy");
        return suppressAutoDeploy != null && suppressAutoDeploy.equalsIgnoreCase("true");
    }

    public boolean isTableClassification(String classificationName) {
        return this._tableClassificationMap.containsKey(classificationName);
    }

    public void initializeClassificationDefinition() {
        this.getClassificationDefinitionMap();
    }

    protected void setupAllInOneTableClassification(String sql) {
        DfClassificationAllInOneSqlExecutor executor = new DfClassificationAllInOneSqlExecutor();
        Connection conn = this.getDatabaseProperties().createMainSchemaConnection();
        List<Map<String, String>> resultList = executor.executeAllInOneSql(conn, sql);
        for (Map<String, String> map : resultList) {
            String classificationName = map.get("classificationName");
            String code = map.get("code");
            String name = map.get("name");
            String alias = map.get("alias");
            String comment = map.get("comment");
            List<Map<String, String>> tmpElementList = this._classificationDefinitionMap.get(classificationName);
            if (tmpElementList == null) {
                tmpElementList = new ArrayList<Map<String, String>>();
                this._classificationDefinitionMap.put(classificationName, tmpElementList);
            }
            List<Map<String, String>> elementList = tmpElementList;
            LinkedHashMap elementMap = this.newLinkedHashMap();
            elementMap.put("code", code);
            elementMap.put("name", name);
            elementMap.put("alias", alias);
            if (comment != null) {
                elementMap.put("comment", comment);
            }
            elementList.add(elementMap);
            String topComment = map.get("topComment");
            String dataType = map.get("dataType");
            if (this._classificationTopDefinitionMap.containsKey(classificationName)) continue;
            LinkedHashMap<String, String> topElementMap = new LinkedHashMap<String, String>();
            topElementMap.put("classificationName", classificationName);
            if (topComment != null) {
                topElementMap.put("topComment", topComment);
            }
            if (dataType != null) {
                topElementMap.put("dataType", dataType);
            }
            if (topComment == null) continue;
            this._classificationTopDefinitionMap.put(classificationName, topElementMap);
        }
    }

    protected List<?> extractExceptCodeList(Map<?, ?> elementMap) {
        List exceptCodeList = new ArrayList();
        String exceptCodeObj = (String)elementMap.get("exceptCodeList");
        if (exceptCodeObj != null) {
            if (!(exceptCodeObj instanceof List)) {
                String msg = "'exceptCodeList' should be java.util.List! But: " + exceptCodeObj.getClass();
                msg = msg + " value=" + exceptCodeObj + " " + this._classificationDefinitionMap;
                throw new IllegalStateException(msg);
            }
            exceptCodeList = (List)((Object)exceptCodeObj);
        }
        return exceptCodeList;
    }

    protected String buildSql(DfClassificationElement element, String table, String where, String orderBy) {
        String code = element.getCode();
        String name = element.getName();
        String alias = element.getAlias();
        String comment = element.getComment();
        return this.buildSql(code, name, alias, comment, table, where, orderBy);
    }

    protected String buildSql(String code, String name, String alias, String comment, String table, String where, String orderBy) {
        StringBuffer sb = new StringBuffer();
        sb.append("select ").append(code).append(", ").append(name).append(", ").append(alias);
        if (comment != null && comment.trim().length() != 0) {
            sb.append(", ").append(comment);
        }
        sb.append(" from ").append(table);
        if (where != null && where.trim().length() != 0) {
            sb.append(" where ").append(where);
        }
        if (orderBy != null && orderBy.trim().length() != 0) {
            sb.append(" order by ").append(orderBy);
        }
        return sb.toString();
    }

    protected void setupTableClassification(List<Map<String, String>> elementList, String sql, DfClassificationElement element, List<?> exceptCodeList) {
        String code = element.getCode();
        String name = element.getName();
        String alias = element.getAlias();
        String comment = element.getComment();
        this.doSetupTableClassification(elementList, sql, code, name, alias, comment, exceptCodeList);
    }

    protected void doSetupTableClassification(List<Map<String, String>> elementList, String sql, String code, String name, String alias, String comment, List<?> exceptCodeList) {
        code = this.removeAliasPrefixIfNeeds(code);
        name = this.removeAliasPrefixIfNeeds(name);
        alias = this.removeAliasPrefixIfNeeds(alias);
        comment = this.removeAliasPrefixIfNeeds(comment);
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getDatabaseProperties().createMainSchemaConnection();
            stmt = conn.createStatement();
            _log.debug((Object)"/ - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -");
            _log.debug((Object)("The classification sql: " + sql));
            rs = stmt.executeQuery(sql);
            HashSet<String> codeDuplicateCheckSet = new HashSet<String>();
            while (rs.next()) {
                String tmpCodeValue = rs.getString(code);
                String tmpNameValue = rs.getString(name);
                String tmpAliasValue = rs.getString(alias);
                String tmpCommentValue = null;
                if (comment != null && comment.trim().length() != 0) {
                    tmpCommentValue = rs.getString(comment);
                }
                if (exceptCodeList.contains(tmpCodeValue)) {
                    _log.debug((Object)("    exceptCode: " + tmpCodeValue));
                    continue;
                }
                if (codeDuplicateCheckSet.contains(tmpCodeValue)) {
                    _log.debug((Object)("    duplicate: " + tmpCodeValue));
                    continue;
                }
                LinkedHashMap<String, String> selectedTmpMap = new LinkedHashMap<String, String>();
                selectedTmpMap.put("code", tmpCodeValue);
                selectedTmpMap.put("name", tmpNameValue);
                selectedTmpMap.put("alias", tmpAliasValue);
                if (tmpCommentValue != null) {
                    selectedTmpMap.put("comment", tmpCommentValue);
                }
                elementList.add(selectedTmpMap);
                codeDuplicateCheckSet.add(tmpCodeValue);
            }
            _log.debug((Object)"- - - - - - - - /");
            new DfClassificationSqlResourceCloser().closeSqlResource(conn, stmt, rs);
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException("The sql is " + sql, e);
            }
            catch (Throwable throwable) {
                new DfClassificationSqlResourceCloser().closeSqlResource(conn, stmt, rs);
                throw throwable;
            }
        }
    }

    protected String removeAliasPrefixIfNeeds(String name) {
        if (name != null && name.lastIndexOf(".") >= 0) {
            name = name.substring(name.lastIndexOf(".") + 1);
        }
        return name;
    }

    protected void setupClassificationMetaFromLiteralIfNeeds(String classificationName, Map<?, ?> elementMap) {
        if (this._classificationTopDefinitionMap.containsKey(classificationName)) {
            return;
        }
        DfClassificationTop classificationTop = new DfClassificationTop();
        classificationTop.acceptClassificationTopElementMap(elementMap);
        LinkedHashMap<String, String> topElementMap = new LinkedHashMap<String, String>();
        topElementMap.put("classificationName", classificationName);
        if (classificationTop.getTopComment() != null) {
            topElementMap.put("topComment", classificationTop.getTopComment());
        }
        if (classificationTop.getDataType() != null) {
            topElementMap.put("dataType", classificationTop.getDataType());
        }
        if (classificationTop.getTopComment() != null) {
            this._classificationTopDefinitionMap.put(classificationName, topElementMap);
        }
    }

    public List<String> getClassificationNameList() {
        return new ArrayList<String>(this.getClassificationDefinitionMap().keySet());
    }

    public List<String> getClassificationNameListValidNameOnly() {
        String codeKey = "code";
        String nameKey = "name";
        ArrayList<String> resultList = new ArrayList<String>();
        Set<String> keySet = this.getClassificationDefinitionMap().keySet();
        block0: for (String string : keySet) {
            List<Map<String, String>> list = this.getClassificationDefinitionMap().get(string);
            for (Map<String, String> map : list) {
                String name;
                String code = map.get("code");
                if (code.equals(name = map.get("name"))) continue;
                resultList.add(string);
                continue block0;
            }
        }
        return resultList;
    }

    public List<String> getClassificationNameListValidAliasOnly() {
        String codeKey = "code";
        String nameKey = "name";
        String aliasKey = "alias";
        ArrayList<String> resultList = new ArrayList<String>();
        Set<String> keySet = this.getClassificationDefinitionMap().keySet();
        block0: for (String string : keySet) {
            List<Map<String, String>> list = this.getClassificationDefinitionMap().get(string);
            for (Map<String, String> map : list) {
                String code = map.get("code");
                String name = map.get("name");
                String alias = map.get("alias");
                if (code.equals(alias) || name.equals(alias)) continue;
                resultList.add(string);
                continue block0;
            }
        }
        return resultList;
    }

    public String getClassificationDefinitionMapAsStringRemovedLineSeparatorFilteredQuotation() {
        String property = this.stringProp("torque.classificationDefinitionMap", "map:{}");
        return this.filterDoubleQuotation(this.removeLineSeparator(property));
    }

    public List<Map<String, String>> getClassificationMapList(String classificationName) {
        return this.getClassificationDefinitionMap().get(classificationName);
    }

    public String buildClassificationApplicationComment(Map<String, String> classificationMap) {
        StringBuilder sb = new StringBuilder();
        String alias = classificationMap.get("alias");
        String comment = classificationMap.get("comment");
        if (alias != null && alias.trim().length() > 0) {
            sb.append(alias);
        }
        if (comment != null && comment.trim().length() > 0) {
            if (sb.length() > 0) {
                sb.append(": ");
            }
            sb.append(comment);
        }
        return sb.toString();
    }

    public String buildClassificationCodeAliasVariables(Map<String, String> classificationMap) {
        StringBuilder sb = new StringBuilder();
        String code = classificationMap.get("code");
        String alias = classificationMap.get("alias");
        sb.append("\"").append(code).append("\", ");
        if (alias != null && alias.trim().length() > 0) {
            sb.append("\"").append(alias).append("\"");
        } else {
            sb.append("null");
        }
        return sb.toString();
    }

    public String buildClassificationCodeNameAliasVariables(Map<String, String> classificationMap) {
        StringBuilder sb = new StringBuilder();
        String code = classificationMap.get("code");
        String name = classificationMap.get("name");
        String alias = classificationMap.get("alias");
        sb.append("\"").append(code).append("\", ").append("\"").append(name).append("\", ");
        if (alias != null && alias.trim().length() > 0) {
            sb.append("\"").append(alias).append("\"");
        } else {
            sb.append("null");
        }
        return sb.toString();
    }

    public Map<String, Map<String, String>> getClassificationDeploymentMap() {
        if (this._classificationDeploymentMap != null) {
            return this._classificationDeploymentMap;
        }
        Map<String, Object> map = this.mapProp("torque.classificationDeploymentMap", DEFAULT_EMPTY_MAP);
        this._classificationDeploymentMap = StringKeyMap.createAsFlexibleOrdered();
        Set<String> deploymentMapkeySet = map.keySet();
        for (String tableName : deploymentMapkeySet) {
            Object value = map.get(tableName);
            if (value instanceof Map) {
                Map tmpMap = (Map)value;
                Set tmpMapKeySet = tmpMap.keySet();
                LinkedHashMap<String, String> columnClassificationMap = new LinkedHashMap<String, String>();
                Iterator i$ = tmpMapKeySet.iterator();
                while (i$.hasNext()) {
                    String columnNameObj;
                    String columnName = columnNameObj = (String)i$.next();
                    String classificationName = (String)tmpMap.get(columnName);
                    columnClassificationMap.put(columnName, classificationName);
                }
                this._classificationDeploymentMap.put(tableName, columnClassificationMap);
                continue;
            }
            String msg = "The value should be columnClassificationMap: ";
            throw new IllegalStateException(msg + "type=" + value.getClass() + " value=" + value);
        }
        this.reflectClassificationResourceToDeployment();
        return this._classificationDeploymentMap;
    }

    public void initializeClassificationDeployment(Database database) {
        Map<String, Map<String, String>> deploymentMap = this.getClassificationDeploymentMap();
        Map<String, String> allColumnClassificationMap = this.getAllColumnClassificationMap();
        if (allColumnClassificationMap != null) {
            List<Table> tableList = database.getTableList();
            for (Table table : tableList) {
                Map<String, String> columnClsMap = this.getColumnClsMap(deploymentMap, table.getName());
                Set<String> columnNameKeySet = allColumnClassificationMap.keySet();
                for (String columnName : columnNameKeySet) {
                    String classificationName = allColumnClassificationMap.get(columnName);
                    columnClsMap.put(columnName, classificationName);
                }
            }
        }
        this.initializeClassificationDefinition();
        Set<Map.Entry<String, DfClassificationElement>> tableClassificationEntrySet = this._tableClassificationMap.entrySet();
        for (Map.Entry entry : tableClassificationEntrySet) {
            Column column;
            DfClassificationElement element = (DfClassificationElement)entry.getValue();
            Map<String, String> columnClsMap = this.getColumnClsMap(deploymentMap, element.getTable());
            String classificationName = element.getClassificationName();
            this.registerColumnClsIfNeeds(columnClsMap, element.getCode(), classificationName);
            Table table = database.getTable(element.getTable());
            if (table == null || table.hasTwoOrMorePrimaryKeys() || (column = table.getColumn(element.getCode())) == null || !column.isPrimaryKey()) continue;
            List<ForeignKey> referrers = column.getReferrers();
            for (ForeignKey referrer : referrers) {
                if (!referrer.isSimpleKeyFK()) continue;
                Table referrerTable = referrer.getTable();
                Map<String, String> referrerClsMap = this.getColumnClsMap(deploymentMap, referrerTable.getName());
                Column localColumnAsOne = referrer.getLocalColumnAsOne();
                this.registerColumnClsIfNeeds(referrerClsMap, localColumnAsOne.getName(), classificationName);
            }
        }
        this._classificationDeploymentMap = deploymentMap;
    }

    protected Map<String, String> getColumnClsMap(Map<String, Map<String, String>> deploymentMap, String tableName) {
        Map<String, String> columnClassificationMap = deploymentMap.get(tableName);
        if (columnClassificationMap == null) {
            columnClassificationMap = new LinkedHashMap<String, String>();
            deploymentMap.put(tableName, columnClassificationMap);
        }
        return columnClassificationMap;
    }

    protected void registerColumnClsIfNeeds(Map<String, String> columnClsMap, String columnName, String classificationName) {
        String value = columnClsMap.get(columnName);
        if (value != null) {
            return;
        }
        columnClsMap.put(columnName, classificationName);
    }

    public String getClassificationDeploymentMapAsStringRemovedLineSeparatorFilteredQuotation() {
        String property = this.stringProp("torque.classificationDeploymentMap", "map:{}");
        return this.filterDoubleQuotation(this.removeLineSeparator(property));
    }

    public boolean hasClassification(String tableName, String columnName) {
        Map<String, Map<String, String>> deploymentMap = this.getClassificationDeploymentMap();
        Map<String, String> columnClassificationMap = deploymentMap.get(tableName);
        if (columnClassificationMap == null) {
            return false;
        }
        String classificationName = columnClassificationMap.get(columnName);
        if (classificationName == null) {
            Set<String> columnClassificationMapKeySet = columnClassificationMap.keySet();
            for (String columnNameHint : columnClassificationMapKeySet) {
                if (!this.isHitByTheHint(columnName, columnNameHint)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public String getClassificationName(String tableName, String columnName) {
        Map<String, Map<String, String>> deploymentMap = this.getClassificationDeploymentMap();
        if (!deploymentMap.containsKey(tableName)) {
            return null;
        }
        Map<String, String> columnClassificationMap = deploymentMap.get(tableName);
        String classificationName = this.getByFlexibleKey(columnClassificationMap, columnName);
        if (classificationName == null) {
            Set<String> columnClassificationMapKeySet = columnClassificationMap.keySet();
            for (String columnNameHint : columnClassificationMapKeySet) {
                if (!this.isHitByTheHint(columnName, columnNameHint)) continue;
                return columnClassificationMap.get(columnNameHint);
            }
            return null;
        }
        return classificationName;
    }

    public boolean hasClassificationName(String tableName, String columnName) {
        String classificationName = this.getClassificationName(tableName, columnName);
        if (classificationName == null) {
            return false;
        }
        return this.getClassificationNameListValidNameOnly().contains(classificationName);
    }

    public boolean hasClassificationAlias(String tableName, String columnName) {
        String classificationName = this.getClassificationName(tableName, columnName);
        if (classificationName == null) {
            return false;
        }
        return this.getClassificationNameListValidAliasOnly().contains(classificationName);
    }

    public Map<String, String> getAllColumnClassificationMap() {
        return this.getClassificationDeploymentMap().get(MARK_allColumnClassification);
    }

    public boolean isAllClassificationColumn(String columnName) {
        return this.getAllClassificationName(columnName) != null;
    }

    public String getAllClassificationName(String columnName) {
        Map<String, String> allColumnClassificationMap = this.getAllColumnClassificationMap();
        if (allColumnClassificationMap == null) {
            return null;
        }
        String classificationName = this.getByFlexibleKey(allColumnClassificationMap, columnName);
        if (classificationName != null) {
            return classificationName;
        }
        Set<String> columnNameHintSet = allColumnClassificationMap.keySet();
        for (String columnNameHint : columnNameHintSet) {
            if (!this.isHitByTheHint(columnName, columnNameHint)) continue;
            return allColumnClassificationMap.get(columnNameHint);
        }
        return null;
    }

    protected void setupAllColumnClassificationEmptyMapIfNeeds() {
        if (this.getAllColumnClassificationMap() != null) {
            return;
        }
        Map<String, Map<String, String>> classificationDeploymentMap = this.getClassificationDeploymentMap();
        classificationDeploymentMap.put(MARK_allColumnClassification, new LinkedHashMap());
    }

    protected List<DfClassificationTop> getClassificationResourceList() {
        if (this._classificationResourceList != null) {
            return this._classificationResourceList;
        }
        this._classificationResourceList = this.extractClassificationResource();
        return this._classificationResourceList;
    }

    protected List<DfClassificationTop> extractClassificationResource() {
        DfClassificationResourceAnalyzer analyzer = new DfClassificationResourceAnalyzer();
        String dirBaseName = "./dfprop";
        String resource = NAME_CLASSIFICATION_RESOURCE;
        String extension = "dfprop";
        if (this.isEnvironmentDefault()) {
            return analyzer.analyze("./dfprop", NAME_CLASSIFICATION_RESOURCE, "dfprop");
        }
        String dirEnvName = "./dfprop/" + this.getEnvironmentType();
        List<DfClassificationTop> ls = analyzer.analyze(dirEnvName, NAME_CLASSIFICATION_RESOURCE, "dfprop");
        if (!ls.isEmpty()) {
            return ls;
        }
        return analyzer.analyze("./dfprop", NAME_CLASSIFICATION_RESOURCE, "dfprop");
    }

    protected void reflectClassificationResourceToDefinition() {
        List<DfClassificationTop> classificationTopList = this.getClassificationResourceList();
        for (DfClassificationTop classificationTop : classificationTopList) {
            String classificationName = classificationTop.getClassificationName();
            if (this._classificationDefinitionMap.containsKey(classificationName)) continue;
            LinkedHashMap<String, String> topElementMap = new LinkedHashMap<String, String>();
            topElementMap.put("topComment", classificationTop.getTopComment());
            this._classificationTopDefinitionMap.put(classificationName, topElementMap);
            ArrayList elementList = new ArrayList();
            List<DfClassificationElement> classificationElementList = classificationTop.getClassificationElementList();
            for (DfClassificationElement classificationElement : classificationElementList) {
                String comment;
                LinkedHashMap<String, String> elementMap = new LinkedHashMap<String, String>();
                elementMap.put("code", classificationElement.getCode());
                elementMap.put("name", classificationElement.getName());
                String alias = classificationElement.getAlias();
                if (alias != null) {
                    elementMap.put("alias", alias);
                }
                if ((comment = classificationElement.getComment()) != null) {
                    elementMap.put("comment", comment);
                }
                elementList.add(elementMap);
            }
            this._classificationDefinitionMap.put(classificationName, elementList);
        }
    }

    protected void reflectClassificationResourceToDeployment() {
        List<DfClassificationTop> classificationTopList = this.getClassificationResourceList();
        for (DfClassificationTop classificationTop : classificationTopList) {
            String classificationName = classificationTop.getClassificationName();
            String relatedColumnName = classificationTop.getRelatedColumnName();
            if (relatedColumnName == null) continue;
            this.setupAllColumnClassificationEmptyMapIfNeeds();
            Map<String, String> allColumnClassificationMap = this.getAllColumnClassificationMap();
            if (allColumnClassificationMap.containsKey(relatedColumnName)) continue;
            allColumnClassificationMap.put(relatedColumnName, classificationName);
        }
    }
}

