/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.friends.velocity;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.seasar.dbflute.exception.DfTemplateParsingException;
import org.seasar.dbflute.friends.velocity.DfGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfOriginalGenerator
extends DfGenerator {
    private static DfOriginalGenerator instance = new DfOriginalGenerator();
    public static final String OUTPUT_PATH = "output.path";
    public static final String TEMPLATE_PATH = "template.path";
    private Properties props = new Properties();
    private Context controlContext;
    private Hashtable<String, Writer> writers = new Hashtable();
    protected String outputEncoding;
    protected String inputEncoding;
    protected List<String> parseFileNameList = new ArrayList<String>();
    protected List<String> skipFileNameList = new ArrayList<String>();

    private DfOriginalGenerator() {
        this.setDefaultProps();
    }

    public static DfOriginalGenerator getInstance() {
        return instance;
    }

    public DfOriginalGenerator(Properties props) {
        this.props = (Properties)props.clone();
    }

    protected void setDefaultProps() {
        this.props.put("path.output", "output");
        this.props.put("context.objects.strings", "org.apache.velocity.util.StringUtils");
        this.props.put("context.objects.files", "org.apache.velocity.texen.util.FileUtil");
        this.props.put("context.objects.properties", "org.apache.velocity.texen.util.PropertiesUtil");
    }

    public String parse(String inputTemplate, String outputFile) throws Exception {
        return this.parse(inputTemplate, outputFile, null, null);
    }

    @Override
    public String parse(String inputTemplate, String outputFile, String objectID, Object object) throws Exception {
        return this.parse(inputTemplate, null, outputFile, null, objectID, object);
    }

    public String parse(String inputTemplate, String specifiedInputEncoding, String outputFile, String specifiedOutputEncoding, String objectID, Object object) throws Exception {
        if (objectID != null && object != null) {
            this.controlContext.put(objectID, object);
        }
        if (specifiedInputEncoding == null || specifiedInputEncoding.trim().length() == 0) {
            specifiedInputEncoding = this.inputEncoding;
        }
        if (specifiedOutputEncoding == null || specifiedOutputEncoding.trim().length() == 0) {
            specifiedOutputEncoding = this.outputEncoding;
        }
        try {
            VelocityContext vc;
            Template template = this.getTemplate(inputTemplate, specifiedInputEncoding);
            this.parseFileNameList.add(outputFile);
            if (outputFile == null || outputFile.equals("")) {
                StringWriter sw = new StringWriter();
                template.merge(this.controlContext, (Writer)sw);
                return sw.toString();
            }
            File oldFile = new File(this.getOutputPath() + "/" + outputFile);
            if (oldFile.exists()) {
                StringWriter sw = new StringWriter();
                vc = new VelocityContext(this.controlContext);
                template.merge((Context)vc, (Writer)sw);
                String newContent = sw.toString();
                String oldContent = new String(this.getBytes(oldFile), specifiedOutputEncoding);
                if (newContent.equals(oldContent)) {
                    this.skipFileNameList.add(oldFile.getName());
                    return "";
                }
            }
            Writer writer = null;
            if (this.writers.get(outputFile) == null) {
                writer = this.getWriter(this.getOutputPath() + File.separator + outputFile, specifiedOutputEncoding);
                this.writers.put(outputFile, writer);
            } else {
                writer = this.writers.get(outputFile);
            }
            vc = new VelocityContext(this.controlContext);
            template.merge((Context)vc, writer);
        }
        catch (Throwable e) {
            this.throwTemplateParsingException(inputTemplate, specifiedInputEncoding, e);
        }
        return "";
    }

    protected void throwTemplateParsingException(String inputTemplate, String specifiedInputEncoding, Throwable e) {
        this.rethrowIfNestedException(inputTemplate, specifiedInputEncoding, e);
        String msg = "Look! Read the message below." + this.ln();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.ln();
        msg = msg + "Failed to parse the input template!" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Input Template]" + this.ln() + inputTemplate + " (" + specifiedInputEncoding + ")" + this.ln();
        msg = msg + "* * * * * * * * * */";
        throw new DfTemplateParsingException(msg, e);
    }

    protected void rethrowIfNestedException(String inputTemplate, String specifiedInputEncoding, Throwable e) {
        Throwable wrapped;
        if (e instanceof DfTemplateParsingException) {
            throw (DfTemplateParsingException)e;
        }
        if (e.getCause() instanceof DfTemplateParsingException) {
            throw (DfTemplateParsingException)e.getCause();
        }
        if (e instanceof MethodInvocationException && (wrapped = ((MethodInvocationException)e).getWrappedThrowable()) instanceof DfTemplateParsingException) {
            throw (DfTemplateParsingException)wrapped;
        }
    }

    @Override
    public String parse(String controlTemplate, Context controlContext) throws Exception {
        this.controlContext = controlContext;
        this.fillContextDefaults(this.controlContext);
        this.fillContextProperties(this.controlContext);
        Template template = this.getTemplate(controlTemplate, this.inputEncoding);
        StringWriter sw = new StringWriter();
        template.merge(controlContext, (Writer)sw);
        return sw.toString();
    }

    protected Context getContext(Hashtable<?, ?> objs) {
        this.fillContextHash(this.controlContext, objs);
        return this.controlContext;
    }

    protected void fillContextHash(Context context, Hashtable<?, ?> objs) {
        Enumeration<?> enu = objs.keys();
        while (enu.hasMoreElements()) {
            String key = enu.nextElement().toString();
            context.put(key, objs.get(key));
        }
    }

    protected void fillContextDefaults(Context context) {
        context.put("generator", (Object)instance);
        context.put("outputDirectory", (Object)this.getOutputPath());
    }

    protected void fillContextProperties(Context context) {
        Enumeration<?> enu = this.props.propertyNames();
        while (enu.hasMoreElements()) {
            String nm = (String)enu.nextElement();
            if (!nm.startsWith("context.objects.")) continue;
            String contextObj = this.props.getProperty(nm);
            int colon = nm.lastIndexOf(46);
            String contextName = nm.substring(colon + 1);
            try {
                Class<?> cls = Class.forName(contextObj);
                Object o = cls.newInstance();
                context.put(contextName, o);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void shutdown() {
        for (Writer writer : this.writers.values()) {
            try {
                writer.flush();
                writer.close();
            }
            catch (Exception exception) {}
        }
        this.writers.clear();
    }

    protected String ln() {
        return "\n";
    }

    protected byte[] getBytes(File file) throws IOException {
        return this.getBytes(this.create(file));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final byte[] getBytes(InputStream is) throws IOException {
        byte[] bytes = null;
        byte[] buf = new byte[8192];
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int n = 0;
            while ((n = is.read(buf, 0, buf.length)) != -1) {
                baos.write(buf, 0, n);
            }
            bytes = baos.toByteArray();
            Object var7_7 = null;
            if (is == null) return bytes;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (is == null) throw throwable;
            DfOriginalGenerator.close(is);
            throw throwable;
        }
        DfOriginalGenerator.close(is);
        return bytes;
    }

    public static void close(InputStream is) throws IOException {
        if (is == null) {
            return;
        }
        is.close();
    }

    protected FileInputStream create(File file) throws IOException {
        return new FileInputStream(file);
    }

    @Override
    public void setTemplatePath(String templatePath) {
        this.props.put(TEMPLATE_PATH, templatePath);
    }

    public String getTemplatePath() {
        return this.props.getProperty(TEMPLATE_PATH);
    }

    @Override
    public void setOutputPath(String outputPath) {
        this.props.put(OUTPUT_PATH, outputPath);
    }

    @Override
    public String getOutputPath() {
        return this.props.getProperty(OUTPUT_PATH);
    }

    @Override
    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    @Override
    public void setInputEncoding(String inputEncoding) {
        this.inputEncoding = inputEncoding;
    }

    public Writer getWriter(String path, String encoding) throws Exception {
        Writer writer = encoding == null || encoding.length() == 0 || encoding.equals("8859-1") || encoding.equals("8859_1") ? new FileWriter(path) : new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(path), encoding));
        return writer;
    }

    public Template getTemplate(String templateName, String encoding) throws Exception {
        Template template = encoding == null || encoding.length() == 0 || encoding.equals("8859-1") || encoding.equals("8859_1") ? Velocity.getTemplate((String)templateName) : Velocity.getTemplate((String)templateName, (String)encoding);
        return template;
    }

    @Override
    public List<String> getParseFileNameList() {
        return this.parseFileNameList;
    }

    public void setParseFileNameList(List<String> parseFileNameList) {
        this.parseFileNameList = parseFileNameList;
    }

    @Override
    public List<String> getSkipFileNameList() {
        return this.skipFileNameList;
    }

    public void setSkipFileNameList(List<String> skipFileNameList) {
        this.skipFileNameList = skipFileNameList;
    }

    @Override
    public String toString() {
        return "outputEncoding=" + this.outputEncoding + ", inputEncoding=" + this.inputEncoding + " skipFileNameList=" + this.skipFileNameList;
    }
}

