/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.metadata.impl;

import java.util.ArrayList;
import java.util.List;
import org.seasar.dbflute.helper.StringKeyMap;
import org.seasar.dbflute.s2dao.metadata.TnBeanAnnotationReader;
import org.seasar.dbflute.s2dao.metadata.TnDtoMetaData;
import org.seasar.dbflute.s2dao.metadata.TnPropertyType;
import org.seasar.dbflute.s2dao.metadata.TnPropertyTypeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TnDtoMetaDataImpl
implements TnDtoMetaData {
    protected final Class<?> _beanClass;
    protected final StringKeyMap<TnPropertyType> _propertyTypeMap = StringKeyMap.createAsCaseInsensitive();
    protected final List<TnPropertyType> _propertyTypeList = new ArrayList<TnPropertyType>();
    protected TnBeanAnnotationReader _beanAnnotationReader;
    protected TnPropertyTypeFactory _propertyTypeFactory;

    public TnDtoMetaDataImpl(Class<?> beanClass) {
        this._beanClass = beanClass;
    }

    public void initialize() {
        this.setupPropertyType();
    }

    protected void setupPropertyType() {
        TnPropertyType[] propertyTypes = this._propertyTypeFactory.createDtoPropertyTypes();
        for (int i = 0; i < propertyTypes.length; ++i) {
            TnPropertyType pt = propertyTypes[i];
            this.addPropertyType(pt);
        }
    }

    protected void addPropertyType(TnPropertyType propertyType) {
        this._propertyTypeMap.put(propertyType.getPropertyName(), propertyType);
        this._propertyTypeList.add(propertyType);
    }

    @Override
    public Class<?> getBeanClass() {
        return this._beanClass;
    }

    @Override
    public List<TnPropertyType> getPropertyTypeList() {
        return this._propertyTypeList;
    }

    @Override
    public TnPropertyType getPropertyType(String propertyName) {
        TnPropertyType propertyType = this._propertyTypeMap.get(propertyName);
        if (propertyType == null) {
            String msg = "The propertyName was not found in the map:";
            msg = msg + " propertyName=" + propertyName + " propertyTypeMap=" + this._propertyTypeMap;
            throw new IllegalStateException(msg);
        }
        return propertyType;
    }

    @Override
    public boolean hasPropertyType(String propertyName) {
        return this._propertyTypeMap.get(propertyName) != null;
    }

    public void setBeanAnnotationReader(TnBeanAnnotationReader beanAnnotationReader) {
        this._beanAnnotationReader = beanAnnotationReader;
    }

    public void setPropertyTypeFactory(TnPropertyTypeFactory propertyTypeFactory) {
        this._propertyTypeFactory = propertyTypeFactory;
    }
}

