/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.ejb;

import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import javax.ejb.deployment.DeploymentDescriptor;
import weblogic.ejb.utils.DDCreator;

public final class DDCreatorHelper {
    private File descriptorDirectory;
    private File generatedFilesDirectory;
    String[] descriptors;

    public static void main(String[] args) throws Exception {
        DDCreatorHelper helper = new DDCreatorHelper(args);
        helper.process();
    }

    private DDCreatorHelper(String[] args) {
        int index = 0;
        this.descriptorDirectory = new File(args[index++]);
        this.generatedFilesDirectory = new File(args[index++]);
        this.descriptors = new String[args.length - index];
        int i = 0;
        while (index < args.length) {
            this.descriptors[i] = args[index++];
            ++i;
        }
    }

    private void process() throws Exception {
        for (int i = 0; i < this.descriptors.length; ++i) {
            String descriptorName = this.descriptors[i];
            File descriptorFile = new File(this.descriptorDirectory, descriptorName);
            int extIndex = descriptorName.lastIndexOf(".");
            String serName = null;
            serName = extIndex != -1 ? descriptorName.substring(0, extIndex) + ".ser" : descriptorName + ".ser";
            File serFile = new File(this.generatedFilesDirectory, serName);
            if (serFile.exists() && serFile.lastModified() >= descriptorFile.lastModified() && !this.regenerateSerializedFile(serFile)) continue;
            String[] args = new String[]{"-noexit", "-d", serFile.getParent(), "-outputfile", serFile.getName(), descriptorFile.getPath()};
            try {
                DDCreator.main((String[])args);
                continue;
            }
            catch (Exception e) {
                String[] newArgs = new String[]{"-d", this.generatedFilesDirectory.getPath(), "-outputfile", serFile.getName(), descriptorFile.getPath()};
                DDCreator.main((String[])newArgs);
            }
        }
    }

    private boolean regenerateSerializedFile(File serFile) {
        try {
            FileInputStream fis = new FileInputStream(serFile);
            ObjectInputStream ois = new ObjectInputStream(fis);
            DeploymentDescriptor dd = (DeploymentDescriptor)ois.readObject();
            fis.close();
            return false;
        }
        catch (Exception e) {
            return true;
        }
    }
}

