/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.jdbc.metadata.info;

import java.util.Map;
import org.seasar.dbflute.logic.jdbc.metadata.comment.DfDbCommentExtractor;
import org.seasar.dbflute.util.DfSystemUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfTableMetaInfo {
    protected String _tableName;
    protected String _tableType;
    protected String _tableSchema;
    protected String _tableComment;
    protected boolean _existSameNameTable;
    protected boolean _outOfGenerateTarget;

    public boolean isTableTypeTable() {
        return this._tableType != null ? this._tableType.equalsIgnoreCase("TABLE") : false;
    }

    public boolean isTableTypeView() {
        return this._tableType != null ? this._tableType.equalsIgnoreCase("VIEW") : false;
    }

    public boolean isTableTypeAlias() {
        return this._tableType != null ? this._tableType.equalsIgnoreCase("ALIAS") : false;
    }

    public boolean isTableTypeSynonym() {
        return this._tableType != null ? this._tableType.equalsIgnoreCase("SYNONYM") : false;
    }

    public boolean canHandleSynonym() {
        return this.isTableTypeSynonym() || this.isTableTypeAlias();
    }

    public boolean hasTableComment() {
        return this._tableComment != null && this._tableComment.trim().length() > 0;
    }

    public String selectMetaExtractingSchemaName(String schemaName) {
        if (this.isExistSameNameTable()) {
            return this._tableSchema;
        }
        return schemaName;
    }

    public String buildTableNameWithSchema() {
        if (this._tableSchema != null && this._tableSchema.trim().length() != 0) {
            return this._tableSchema + "." + this._tableName;
        }
        return this._tableName;
    }

    public void acceptTableComment(Map<String, DfDbCommentExtractor.UserTabComments> tableCommentMap) {
        if (tableCommentMap == null) {
            return;
        }
        DfDbCommentExtractor.UserTabComments userTabComments = tableCommentMap.get(this._tableName);
        if (userTabComments != null && userTabComments.hasComments()) {
            this._tableComment = userTabComments.getComments();
        }
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof DfTableMetaInfo) {
            return this.getTableName().equals(((DfTableMetaInfo)obj).getTableName());
        }
        return false;
    }

    public int hashCode() {
        return this.getTableName().hashCode();
    }

    public String toString() {
        String comment = "";
        if (this._tableComment != null) {
            String ln = DfSystemUtil.getLineSeparator();
            int indexOf = this._tableComment.indexOf(ln);
            comment = indexOf > 0 ? this._tableComment.substring(0, indexOf) + "..." : this._tableComment;
        }
        if (this._tableSchema != null && this._tableSchema.trim().length() != 0) {
            return this._tableSchema + "." + this._tableName + "(" + this._tableType + ")" + (comment != null && comment.trim().length() > 0 ? " // " + comment : "");
        }
        return this._tableName + "(" + this._tableType + ")" + (comment != null && comment.trim().length() > 0 ? " // " + comment : "");
    }

    public String getTableName() {
        return this._tableName;
    }

    public void setTableName(String tableName) {
        this._tableName = tableName;
    }

    public String getTableType() {
        return this._tableType;
    }

    public void setTableType(String tableType) {
        this._tableType = tableType;
    }

    public String getTableSchema() {
        return this._tableSchema;
    }

    public void setTableSchema(String tableSchema) {
        this._tableSchema = tableSchema;
    }

    public String getTableComment() {
        return this._tableComment;
    }

    public void setTableComment(String tableComment) {
        this._tableComment = tableComment;
    }

    public boolean isExistSameNameTable() {
        return this._existSameNameTable;
    }

    public void setExistSameNameTable(boolean existSameNameTable) {
        this._existSameNameTable = existSameNameTable;
    }

    public boolean isOutOfGenerateTarget() {
        return this._outOfGenerateTarget;
    }

    public void setOutOfGenerateTarget(boolean outOfGenerateTarget) {
        this._outOfGenerateTarget = outOfGenerateTarget;
    }
}

