/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.factory;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.seasar.dbflute.logic.schemainitializer.DfSchemaInitializer;
import org.seasar.dbflute.logic.schemainitializer.DfSchemaInitializerDB2;
import org.seasar.dbflute.logic.schemainitializer.DfSchemaInitializerH2;
import org.seasar.dbflute.logic.schemainitializer.DfSchemaInitializerJdbc;
import org.seasar.dbflute.logic.schemainitializer.DfSchemaInitializerMySQL;
import org.seasar.dbflute.logic.schemainitializer.DfSchemaInitializerOracle;
import org.seasar.dbflute.logic.schemainitializer.DfSchemaInitializerPostgreSQL;
import org.seasar.dbflute.logic.schemainitializer.DfSchemaInitializerSqlServer;
import org.seasar.dbflute.properties.DfBasicProperties;
import org.seasar.dbflute.properties.DfDatabaseProperties;
import org.seasar.dbflute.properties.DfReplaceSchemaProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfSchemaInitializerFactory {
    protected DataSource _dataSource;
    protected DfBasicProperties _basicProperties;
    protected DfDatabaseProperties _databaseProperties;
    protected DfReplaceSchemaProperties _replaceSchemaProperties;
    protected InitializeType _initializeType;
    protected Map<String, Object> _additionalDropMap;

    public DfSchemaInitializerFactory(DataSource dataSource, DfBasicProperties basicProperties, DfDatabaseProperties databaseProperties, DfReplaceSchemaProperties replaceSchemaProperties, InitializeType initializeType) {
        this._dataSource = dataSource;
        this._basicProperties = basicProperties;
        this._databaseProperties = databaseProperties;
        this._replaceSchemaProperties = replaceSchemaProperties;
        this._initializeType = initializeType;
    }

    public DfSchemaInitializer createSchemaInitializer() {
        DfSchemaInitializer initializer = this._basicProperties.isDatabaseMySQL() ? this.createSchemaInitializerMySQL() : (this._basicProperties.isDatabasePostgreSQL() ? this.createSchemaInitializerPostgreSQL() : (this._basicProperties.isDatabaseOracle() ? this.createSchemaInitializerOracle() : (this._basicProperties.isDatabaseDB2() ? this.createSchemaInitializerDB2() : (this._basicProperties.isDatabaseSqlServer() ? this.createSchemaInitializerSqlServer() : (this._basicProperties.isDatabaseH2() ? this.createSchemaInitializerH2() : this.createSchemaInitializerJdbc())))));
        return initializer;
    }

    protected DfSchemaInitializer createSchemaInitializerJdbc() {
        DfSchemaInitializerJdbc initializer = new DfSchemaInitializerJdbc();
        this.setupSchemaInitializerJdbcProperties(initializer);
        return initializer;
    }

    protected DfSchemaInitializer createSchemaInitializerPostgreSQL() {
        DfSchemaInitializerPostgreSQL initializer = new DfSchemaInitializerPostgreSQL();
        this.setupSchemaInitializerJdbcProperties(initializer);
        return initializer;
    }

    protected DfSchemaInitializer createSchemaInitializerOracle() {
        DfSchemaInitializerOracle initializer = new DfSchemaInitializerOracle();
        this.setupSchemaInitializerJdbcProperties(initializer);
        return initializer;
    }

    protected DfSchemaInitializer createSchemaInitializerDB2() {
        DfSchemaInitializerDB2 initializer = new DfSchemaInitializerDB2();
        this.setupSchemaInitializerJdbcProperties(initializer);
        return initializer;
    }

    protected DfSchemaInitializer createSchemaInitializerMySQL() {
        DfSchemaInitializerMySQL initializer = new DfSchemaInitializerMySQL();
        this.setupSchemaInitializerJdbcProperties(initializer);
        return initializer;
    }

    protected DfSchemaInitializer createSchemaInitializerSqlServer() {
        DfSchemaInitializerSqlServer initializer = new DfSchemaInitializerSqlServer();
        this.setupSchemaInitializerJdbcProperties(initializer);
        return initializer;
    }

    protected DfSchemaInitializer createSchemaInitializerH2() {
        DfSchemaInitializerH2 initializer = new DfSchemaInitializerH2();
        this.setupSchemaInitializerJdbcProperties(initializer);
        return initializer;
    }

    protected void setupSchemaInitializerJdbcProperties(DfSchemaInitializerJdbc initializer) {
        this.setupDetailExecutionHandling(initializer);
        if (this._initializeType.equals((Object)InitializeType.MAIN)) {
            initializer.setDataSource(this._dataSource);
            initializer.setSchema(this._databaseProperties.getDatabaseSchema());
            initializer.setDropGenerateTableOnly(this._replaceSchemaProperties.isDropGenerateTableOnly());
            initializer.setDropGenerateProcedureOnly(this._replaceSchemaProperties.isDropGenerateProcedureOnly());
            return;
        }
        if (this._initializeType.equals((Object)InitializeType.ADDTIONAL)) {
            if (this._additionalDropMap == null) {
                String msg = "The additional drop map should exist if the initialize type is additional!";
                throw new IllegalStateException(msg);
            }
            initializer.setDataSource(this.getAdditionalDataSource());
            String schemaName = this.getAdditionalDropSchema(this._additionalDropMap);
            initializer.setSchema(schemaName);
            initializer.setTableNameWithSchema(true);
            initializer.setDropObjectTypeList(this.getAdditionalDropObjectTypeList(this._additionalDropMap));
            initializer.setDropTableTargetList(this.getAdditionalDropTableTargetList(this._additionalDropMap));
            initializer.setDropTableExceptList(this.getAdditionalDropTableExceptList(this._additionalDropMap));
            initializer.setDropGenerateTableOnly(false);
            return;
        }
        String msg = "Unknown initialize type: " + (Object)((Object)this._initializeType);
        throw new IllegalStateException(msg);
    }

    protected DataSource getAdditionalDataSource() {
        return new DataSource(){

            public void setLoginTimeout(int i) throws SQLException {
            }

            public void setLogWriter(PrintWriter printwriter) throws SQLException {
            }

            public int getLoginTimeout() throws SQLException {
                return 0;
            }

            public PrintWriter getLogWriter() throws SQLException {
                return null;
            }

            public Connection getConnection(String s, String s1) throws SQLException {
                return null;
            }

            public Connection getConnection() throws SQLException {
                return DfSchemaInitializerFactory.this._replaceSchemaProperties.createAdditionalDropConnection(DfSchemaInitializerFactory.this._additionalDropMap);
            }
        };
    }

    protected void setupDetailExecutionHandling(DfSchemaInitializerJdbc initializer) {
        initializer.setSuppressTruncateTable(this._replaceSchemaProperties.isSuppressTruncateTable());
        initializer.setSuppressDropForeignKey(this._replaceSchemaProperties.isSuppressDropForeignKey());
        initializer.setSuppressDropTable(this._replaceSchemaProperties.isSuppressDropTable());
        initializer.setSuppressDropSequence(this._replaceSchemaProperties.isSuppressDropSequence());
        initializer.setSuppressDropProcedure(this._replaceSchemaProperties.isSuppressDropProcedure());
        initializer.setSuppressDropDBLink(this._replaceSchemaProperties.isSuppressDropDBLink());
    }

    protected String getAdditionalDropSchema(Map<String, Object> map) {
        return this._replaceSchemaProperties.getAdditionalDropSchema(map);
    }

    protected List<String> getAdditionalDropObjectTypeList(Map<String, Object> map) {
        return this._replaceSchemaProperties.getAdditionalDropObjectTypeList(map);
    }

    protected List<String> getAdditionalDropTableTargetList(Map<String, Object> map) {
        return this._replaceSchemaProperties.getAdditionalDropTableTargetList(map);
    }

    protected List<String> getAdditionalDropTableExceptList(Map<String, Object> map) {
        return this._replaceSchemaProperties.getAdditionalDropTableExceptList(map);
    }

    protected boolean isAdditionalDropAllTable(Map<String, Object> map) {
        return this._replaceSchemaProperties.isAdditionalDropAllTable(map);
    }

    public Map<String, Object> getAdditionalDropMap() {
        return this._additionalDropMap;
    }

    public void setAdditionalDropMap(Map<String, Object> additionalDropMap) {
        this._additionalDropMap = additionalDropMap;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum InitializeType {
        MAIN,
        ADDTIONAL;

    }
}

