/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.helper.jdbc.sqlfile;

import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.dbflute.helper.jdbc.sqlfile.DfSqlFileRunner;
import org.seasar.dbflute.helper.jdbc.sqlfile.DfSqlFileRunnerResult;
import org.seasar.dbflute.helper.token.line.LineTokenizingOption;
import org.seasar.dbflute.helper.token.line.impl.LineTokenImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfSqlFileFireMan {
    private static Log _log = LogFactory.getLog(DfSqlFileFireMan.class);
    private String _executorName;

    public FireResult execute(DfSqlFileRunner runner, List<File> fileList) {
        FireResult fireResult = new FireResult();
        int goodSqlCount = 0;
        int totalSqlCount = 0;
        for (File file : fileList) {
            if (!file.exists()) {
                String msg = "The file was not found: " + file;
                throw new IllegalStateException(msg);
            }
            if (_log.isInfoEnabled()) {
                _log.info((Object)("{SQL File}: " + file));
            }
            runner.prepare(file);
            DfSqlFileRunnerResult runnerResult = runner.runTransaction();
            fireResult.addRunnerResult(runnerResult);
            goodSqlCount += runnerResult.getGoodSqlCount();
            totalSqlCount += runnerResult.getTotalSqlCount();
        }
        String title = this._executorName != null ? this._executorName : "Fired SQL";
        StringBuilder resultSb = new StringBuilder();
        resultSb.append("{").append(title).append("}: success=").append(goodSqlCount).append(" failure=").append(totalSqlCount - goodSqlCount).append(" (in ").append(fileList.size()).append(" files)");
        _log.info((Object)resultSb.toString());
        fireResult.setResultMessage(resultSb.toString());
        fireResult.setExistsError(totalSqlCount > goodSqlCount);
        StringBuilder detailSb = new StringBuilder();
        List<DfSqlFileRunnerResult> runnerResultList = fireResult.getRunnerResultList();
        for (DfSqlFileRunnerResult currentResult : runnerResultList) {
            List<DfSqlFileRunnerResult.ErrorContinuedSql> errorContinuedSqlList = currentResult.getErrorContinuedSqlList();
            String fileName = currentResult.getSrcFile().getName();
            if (detailSb.length() > 0) {
                detailSb.append(this.ln());
            }
            detailSb.append(errorContinuedSqlList.isEmpty() ? "o " : "x ").append(fileName);
            for (DfSqlFileRunnerResult.ErrorContinuedSql errorContinuedSql : errorContinuedSqlList) {
                String sql = errorContinuedSql.getSql();
                detailSb.append(this.ln()).append(sql);
                SQLException sqlEx = errorContinuedSql.getSqlEx();
                String message = sqlEx.getMessage();
                if (sqlEx == null || message == null) continue;
                message = message.trim();
                LineTokenImpl lineToken = new LineTokenImpl();
                LineTokenizingOption lineTokenizingOption = new LineTokenizingOption();
                lineTokenizingOption.setDelimiter(this.ln());
                List tokenizedList = lineToken.tokenize(message, lineTokenizingOption);
                int elementIndex = 0;
                for (String element : tokenizedList) {
                    if (elementIndex == 0) {
                        detailSb.append(this.ln()).append(" >> ").append(element);
                    } else {
                        detailSb.append(this.ln()).append("    ").append(element);
                    }
                    ++elementIndex;
                }
                detailSb.append(this.ln());
                detailSb.append("    (SQLState=").append(sqlEx.getSQLState()).append(" ErrorCode=").append(sqlEx.getErrorCode()).append(")");
            }
        }
        fireResult.setDetailMessage(detailSb.toString());
        return fireResult;
    }

    protected String ln() {
        return "\n";
    }

    public String getExecutorName() {
        return this._executorName;
    }

    public void setExecutorName(String executorName) {
        this._executorName = executorName;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FireResult {
        protected String resultMessage;
        protected String detailMessage;
        protected boolean existsError;
        protected List<DfSqlFileRunnerResult> runnerResultList = new ArrayList<DfSqlFileRunnerResult>();

        public String getResultMessage() {
            return this.resultMessage;
        }

        public void setResultMessage(String resultMessage) {
            this.resultMessage = resultMessage;
        }

        public String getDetailMessage() {
            return this.detailMessage;
        }

        public void setDetailMessage(String detailMessage) {
            this.detailMessage = detailMessage;
        }

        public boolean isExistsError() {
            return this.existsError;
        }

        public void setExistsError(boolean existsError) {
            this.existsError = existsError;
        }

        public List<DfSqlFileRunnerResult> getRunnerResultList() {
            return this.runnerResultList;
        }

        public void addRunnerResult(DfSqlFileRunnerResult runnerResult) {
            this.runnerResultList.add(runnerResult);
        }
    }
}

