/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.config;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.seasar.dbflute.DBDef;
import org.seasar.dbflute.helper.mapstring.impl.MapListStringImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfDatabaseNameMapping {
    private static final DfDatabaseNameMapping _instance = new DfDatabaseNameMapping();
    protected final String _databaseNameMappingString;
    protected final Map<String, Map<String, String>> _databaseNameMappingMap;

    private DfDatabaseNameMapping() {
        String tmp = "map:{";
        tmp = tmp + "     ; mysql      = map:{generateName = MySql      ; defName = mysql}";
        tmp = tmp + "     ; postgresql = map:{generateName = PostgreSql ; defName = postgresql}";
        tmp = tmp + "     ; oracle     = map:{generateName = Oracle     ; defName = oracle}";
        tmp = tmp + "     ; db2        = map:{generateName = Db2        ; defName = db2}";
        tmp = tmp + "     ; mssql      = map:{generateName = SqlServer  ; defName = sqlserver}";
        tmp = tmp + "     ; h2         = map:{generateName = H2         ; defName = h2}";
        tmp = tmp + "     ; derby      = map:{generateName = Derby      ; defName = derby}";
        tmp = tmp + "     ; firebird   = map:{generateName = Firebird   ; defName = firebird}";
        tmp = tmp + "     ; interbase  = map:{generateName = Interbase  ; defName = unknown}";
        tmp = tmp + "     ; msaccess   = map:{generateName = Default    ; defName = msaccess}";
        tmp = tmp + "     ; default    = map:{generateName = Default    ; defName = unknown}";
        this._databaseNameMappingString = tmp = tmp + "}";
        this._databaseNameMappingMap = this.analyze();
    }

    public static DfDatabaseNameMapping getInstance() {
        return _instance;
    }

    protected Map<String, Map<String, String>> analyze() {
        MapListStringImpl mapListString = new MapListStringImpl();
        mapListString.setDelimiter(";");
        Map map = mapListString.generateMap(this._databaseNameMappingString);
        LinkedHashMap<String, Map<String, String>> realMap = new LinkedHashMap<String, Map<String, String>>();
        Set entrySet = map.entrySet();
        for (Map.Entry entry : entrySet) {
            String key = (String)entry.getKey();
            Map elementMap = (Map)entry.getValue();
            LinkedHashMap<String, String> elementRealMap = new LinkedHashMap<String, String>();
            Set elementEntrySet = elementMap.entrySet();
            Iterator i$ = elementEntrySet.iterator();
            while (i$.hasNext()) {
                Map.Entry object;
                Map.Entry elementEntry = object = i$.next();
                Object elementKey = elementEntry.getKey();
                Object elementValue = elementEntry.getValue();
                elementRealMap.put((String)elementKey, (String)elementValue);
            }
            realMap.put(key, elementRealMap);
        }
        return realMap;
    }

    public Map<String, String> findMapping(String databaseType) {
        Map<String, String> map = this._databaseNameMappingMap.get(databaseType);
        if (map == null) {
            map = this._databaseNameMappingMap.get("default");
        }
        return map;
    }

    public String findGenerateName(String databaseType) {
        Map<String, String> mapping = this.findMapping(databaseType);
        String generateName = mapping.get("generateName");
        if (generateName == null || generateName.trim().length() == 0) {
            String msg = "The database should have its generateName: " + mapping;
            throw new IllegalStateException(msg);
        }
        return generateName;
    }

    public DBDef findDBDef(String databaseType) {
        Map<String, String> mapping = this.findMapping(databaseType);
        String defName = mapping.get("defName");
        if (defName == null || defName.trim().length() == 0) {
            String msg = "The database should have its defName: " + mapping;
            throw new IllegalStateException(msg);
        }
        DBDef dbdef = DBDef.codeOf((String)defName);
        return dbdef != null ? dbdef : DBDef.Unknown;
    }
}

