/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command;

import java.sql.SQLException;
import org.h2.command.Command;
import org.h2.command.Parser;
import org.h2.expression.ParameterInterface;
import org.h2.result.ResultInterface;
import org.h2.util.ObjectArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandList
extends Command {
    private final Command command;
    private final String remaining;

    public CommandList(Parser parser, String string, Command command, String string2) {
        super(parser, string);
        this.command = command;
        this.remaining = string2;
    }

    @Override
    public ObjectArray<? extends ParameterInterface> getParameters() {
        return this.command.getParameters();
    }

    private void executeRemaining() throws SQLException {
        Command command = this.session.prepareLocal(this.remaining);
        if (command.isQuery()) {
            command.query(0);
        } else {
            command.update();
        }
    }

    @Override
    public int update() throws SQLException {
        int n = this.command.executeUpdate();
        this.executeRemaining();
        return n;
    }

    @Override
    public ResultInterface query(int n) throws SQLException {
        ResultInterface resultInterface = this.command.query(n);
        this.executeRemaining();
        return resultInterface;
    }

    @Override
    public boolean isQuery() {
        return this.command.isQuery();
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ResultInterface queryMeta() throws SQLException {
        return this.command.queryMeta();
    }
}

