/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.generate.packagepath;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.engine.database.model.Database;
import org.seasar.dbflute.properties.DfBasicProperties;
import org.seasar.dbflute.util.DfStringUtil;

public class DfPackagePathHandler {
    private static final Log _log = LogFactory.getLog(Database.class);
    protected DfBasicProperties _basicProperties;
    protected boolean _fileSeparatorSlash;

    public DfPackagePathHandler(DfBasicProperties basicProperties) {
        this._basicProperties = basicProperties;
    }

    public String getPackageAsPath(String pckge) {
        String flatDirectoryPackage;
        String omitDirectoryPackage = this._basicProperties.getOmitDirectoryPackage();
        if (omitDirectoryPackage != null && omitDirectoryPackage.trim().length() > 0) {
            pckge = this.removeOmitPackage(pckge, omitDirectoryPackage);
        }
        if ((flatDirectoryPackage = this._basicProperties.getFlatDirectoryPackage()) == null || flatDirectoryPackage.trim().length() == 0) {
            return this.resolvePackageAsPath(pckge);
        }
        if (!pckge.contains(flatDirectoryPackage)) {
            return this.resolvePackageAsPath(pckge);
        }
        String flatMark = "$$df:flatMark$$";
        pckge = DfStringUtil.replace((String)pckge, (String)flatDirectoryPackage, (String)"$$df:flatMark$$");
        pckge = this.resolvePackageAsPath(pckge);
        pckge = DfStringUtil.replace((String)pckge, (String)"$$df:flatMark$$", (String)flatDirectoryPackage);
        return pckge;
    }

    protected String removeOmitPackage(String pckge, String omitName) {
        if (pckge.startsWith(omitName)) {
            return this.replaceString(pckge, omitName + ".", "");
        }
        if (pckge.endsWith(omitName)) {
            return this.replaceString(pckge, "." + omitName, "");
        }
        return this.replaceString(pckge, "." + omitName + ".", ".");
    }

    protected String resolvePackageAsPath(String pckge) {
        if (this._fileSeparatorSlash) {
            return pckge.replace('.', '/') + "/";
        }
        return pckge.replace('.', File.separator.charAt(0)) + File.separator;
    }

    public void info(String msg) {
        _log.info((Object)msg);
    }

    public void debug(String msg) {
        _log.debug((Object)msg);
    }

    public String replaceString(String text, String fromText, String toText) {
        return DfStringUtil.replace((String)text, (String)fromText, (String)toText);
    }

    public boolean isFileSeparatorSlash() {
        return this._fileSeparatorSlash;
    }

    public void setFileSeparatorSlash(boolean fileSeparatorSlash) {
        this._fileSeparatorSlash = fileSeparatorSlash;
    }
}

