/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.doc.schemahtml;

import org.apache.torque.engine.database.model.ForeignKey;
import org.seasar.dbflute.properties.DfDocumentProperties;
import org.seasar.dbflute.util.Srl;

public class DfSchemaHtmlBuilder {
    protected DfDocumentProperties _documentProperties;

    public DfSchemaHtmlBuilder(DfDocumentProperties documentProperties) {
        this._documentProperties = documentProperties;
    }

    public String buildRelatedTableLink(ForeignKey fk, String name, String delimiter) {
        String contentName;
        StringBuilder sb = new StringBuilder();
        sb.append(delimiter);
        String baseTitle = fk.getName();
        String comment = fk.getComment();
        if (fk.isAdditionalForeignKey()) {
            String addtionalBaseTitle = baseTitle;
            String fixedCondition = fk.getFixedCondition();
            StringBuilder titleSb = new StringBuilder();
            titleSb.append(addtionalBaseTitle);
            boolean comma = false;
            if (fk.hasFixedCondition()) {
                titleSb.append(comma ? ", " : ": ");
                titleSb.append("fixedCondition=\"").append(fixedCondition).append("\"");
                comma = true;
            }
            if (Srl.is_NotNull_and_NotTrimmedEmpty((String)comment)) {
                titleSb.append(comma ? ", " : ": ");
                titleSb.append("comment=").append(comment);
                comma = true;
            }
            String title = this.resolveTitle(titleSb.toString());
            sb.append("<a href=\"#" + name + "\" class=\"additionalfk\" title=\"" + title + "\">");
            contentName = name + (fk.hasFixedSuffix() ? "(" + fk.getFixedSuffix() + ")" : "");
        } else {
            StringBuilder titleSb = new StringBuilder();
            titleSb.append(baseTitle);
            if (Srl.is_NotNull_and_NotTrimmedEmpty((String)comment)) {
                titleSb.append(": comment=").append(comment);
            }
            String title = this.resolveTitle(titleSb.toString());
            sb.append("<a href=\"#" + name + "\" title=\"" + title + "\">");
            contentName = name;
        }
        sb.append(contentName).append("</a>");
        return sb.toString();
    }

    protected String resolveTitle(String title) {
        return this._documentProperties.resolveAttributeForSchemaHtml(title);
    }
}

