/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.helper.jdbc.sqlfile;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tools.ant.BuildException;
import org.seasar.dbflute.DfBuildProperties;
import org.seasar.dbflute.exception.SQLFailureException;
import org.seasar.dbflute.exception.factory.ExceptionMessageBuilder;
import org.seasar.dbflute.helper.jdbc.DfRunnerInformation;
import org.seasar.dbflute.helper.jdbc.sqlfile.DfSqlFileRunner;
import org.seasar.dbflute.helper.jdbc.sqlfile.DfSqlFileRunnerResult;
import org.seasar.dbflute.util.Srl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DfSqlFileRunnerBase
implements DfSqlFileRunner {
    private static Log _log = LogFactory.getLog(DfSqlFileRunnerBase.class);
    protected final DfRunnerInformation _runInfo;
    protected DataSource _dataSource;
    protected File _sqlFile;
    protected DfSqlFileRunnerResult _result = new DfSqlFileRunnerResult();
    protected int _goodSqlCount = 0;
    protected int _totalSqlCount = 0;
    protected Connection _currentConnection;
    protected Statement _currentStatement;

    public DfSqlFileRunnerBase(DfRunnerInformation runInfo, DataSource dataSource) {
        this._runInfo = runInfo;
        this._dataSource = dataSource;
    }

    @Override
    public void prepare(File sqlFile) {
        this._sqlFile = sqlFile;
        this._result = new DfSqlFileRunnerResult();
        this._result.setSrcFile(sqlFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public DfSqlFileRunnerResult runTransaction() {
        block34: {
            Object v0;
            String currentSql;
            block31: {
                this._goodSqlCount = 0;
                this._totalSqlCount = 0;
                if (this._sqlFile == null) {
                    String msg = "The attribute '_srcFile' should not be null.";
                    throw new IllegalStateException(msg);
                }
                currentSql = null;
                InputStreamReader reader = null;
                reader = this.newInputStreamReader();
                List<String> sqlList = this.extractSqlList(reader);
                this.setupConnection();
                this.setupStatement();
                Iterator<String> i$ = sqlList.iterator();
                while (i$.hasNext()) {
                    String sql;
                    currentSql = sql = i$.next();
                    if (!this.isTargetSql(sql)) continue;
                    ++this._totalSqlCount;
                    String realSql = this.filterSql(sql);
                    this.traceSql(realSql);
                    this.execSQL(realSql);
                }
                if (this._currentConnection == null) break block31;
                Boolean autoCommit = null;
                try {
                    autoCommit = this._currentConnection.getAutoCommit();
                }
                catch (SQLException continued) {
                    _log.warn((Object)("Connection#getAutoCommit() said: " + continued.getMessage()));
                }
                if (autoCommit == null || autoCommit.booleanValue()) break block31;
                if (this._runInfo.isRollbackOnly()) {
                    this._currentConnection.rollback();
                    break block31;
                }
                this._currentConnection.commit();
            }
            Object var8_10 = null;
            try {
                if (this._currentConnection != null) {
                    this._currentConnection.rollback();
                }
            }
            catch (SQLException ignored) {
                // empty catch block
            }
            try {
                try {
                    if (this._currentStatement != null) {
                        this._currentStatement.close();
                    }
                    v0 = null;
                }
                catch (SQLException ignored) {
                    v0 = null;
                }
            }
            catch (Throwable throwable) {
                v0 = null;
            }
            Object var11_19 = v0;
            this._currentStatement = null;
            {
                break block34;
                catch (SQLException e) {
                    Object v1;
                    this.throwSQLFailureException(currentSql, e);
                    Object var8_11 = null;
                    try {
                        if (this._currentConnection != null) {
                            this._currentConnection.rollback();
                        }
                    }
                    catch (SQLException ignored) {
                        // empty catch block
                    }
                    try {
                        try {
                            if (this._currentStatement != null) {
                                this._currentStatement.close();
                            }
                            v1 = null;
                        }
                        catch (SQLException ignored) {
                            v1 = null;
                        }
                    }
                    catch (Throwable throwable) {
                        v1 = null;
                    }
                    Object var11_20 = v1;
                    this._currentStatement = null;
                }
            }
            catch (Throwable throwable) {
                Object v2;
                Object var8_12 = null;
                try {
                    if (this._currentConnection != null) {
                        this._currentConnection.rollback();
                    }
                }
                catch (SQLException ignored) {
                    // empty catch block
                }
                try {
                    try {
                        if (this._currentStatement != null) {
                            this._currentStatement.close();
                        }
                        v2 = null;
                    }
                    catch (SQLException ignored) {
                        v2 = null;
                    }
                }
                catch (Throwable throwable2) {
                    v2 = null;
                }
                Object var11_21 = v2;
                this._currentStatement = null;
                throw throwable;
            }
        }
        this.traceResult(this._goodSqlCount, this._totalSqlCount);
        this._result.setGoodSqlCount(this._goodSqlCount);
        this._result.setTotalSqlCount(this._totalSqlCount);
        return this._result;
    }

    protected boolean isTargetSql(String sql) {
        return true;
    }

    protected void traceSql(String sql) {
        if (sql.contains(this.ln())) {
            sql = this.ln() + sql;
        }
        _log.info((Object)sql);
    }

    protected void traceResult(int goodSqlCount, int totalSqlCount) {
        _log.info((Object)("  --> success=" + goodSqlCount + " failure=" + (totalSqlCount - goodSqlCount)));
    }

    protected String filterSql(String sql) {
        return sql;
    }

    protected InputStreamReader newInputStreamReader() {
        try {
            String encoding = this._runInfo.isEncodingNull() ? "UTF-8" : this._runInfo.getEncoding();
            return new InputStreamReader((InputStream)new FileInputStream(this._sqlFile), encoding);
        }
        catch (FileNotFoundException e) {
            throw new BuildException("The file does not exist: " + this._sqlFile, (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            throw new BuildException("The encoding is unsupported: " + this._runInfo.getEncoding(), (Throwable)e);
        }
    }

    protected void setupConnection() {
        if (this._dataSource == null) {
            return;
        }
        try {
            this._currentConnection = this._dataSource.getConnection();
            boolean autoCommit = this._currentConnection.getAutoCommit();
            if (autoCommit != this._runInfo.isAutoCommit()) {
                this._currentConnection.setAutoCommit(this._runInfo.isAutoCommit());
            }
        }
        catch (SQLException e) {
            String msg = "DataSource#getConnection() threw the exception:";
            msg = msg + " dataSource=" + this._dataSource;
            throw new SQLFailureException(msg, e);
        }
    }

    protected void checkConnection() {
        if (this._currentConnection == null) {
            String msg = "The connection should not be null at this timing!";
            throw new IllegalStateException(msg);
        }
    }

    protected void setupStatement() {
        if (this._currentConnection == null) {
            return;
        }
        try {
            this._currentStatement = this._currentConnection.createStatement();
        }
        catch (SQLException e) {
            String msg = "Connection#createStatement() threw the exception:";
            msg = msg + " connection=" + this._currentConnection;
            throw new SQLFailureException(msg, e);
        }
    }

    protected void checkStatement(String sql) {
        if (this._currentStatement == null) {
            String msg = "The statement should not be null at this timing:";
            msg = msg + " sql=" + sql;
            throw new IllegalStateException(msg);
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected List<String> extractSqlList(Reader reader) {
        BufferedReader in;
        ArrayList<String> sqlList;
        block20: {
            sqlList = new ArrayList<String>();
            in = new BufferedReader(reader);
            DelimiterChanger delimiterChanger = this.newDelimterChanger();
            String sql = "";
            String line = "";
            boolean inGroup = false;
            boolean alwaysNeedsLineSeparator = false;
            boolean isAlreadyProcessUTF8Bom = false;
            while ((line = in.readLine()) != null) {
                if (!isAlreadyProcessUTF8Bom) {
                    line = this.removeUTF8BomIfNeeds(line);
                    isAlreadyProcessUTF8Bom = true;
                }
                if (!inGroup && this.isSqlTrimAndRemoveLineSeparator()) {
                    line = line.trim();
                }
                if (!alwaysNeedsLineSeparator && this.isSqlTrimAndRemoveLineSeparator() && this.isHandlingCommentOnLineSeparator() && this.isDbCommentLine(line)) {
                    alwaysNeedsLineSeparator = true;
                }
                if (line.trim().startsWith("--")) {
                    if (line.trim().contains("#df:begin#")) {
                        inGroup = true;
                        sql = "";
                        continue;
                    }
                    if (line.trim().contains("#df:end#")) {
                        inGroup = false;
                        sql = this.removeTerminater4ToolIfNeeds(sql);
                        this.addSqlToList(sqlList, sql);
                        alwaysNeedsLineSeparator = false;
                        sql = "";
                        continue;
                    }
                    line = this.replaceCommentQuestionMarkIfNeeds(line);
                    if (inGroup) {
                        sql = sql + line + this.ln();
                        continue;
                    }
                    sql = sql + line + this.ln();
                } else {
                    if (inGroup) {
                        sql = sql + line + this.ln();
                        continue;
                    }
                    String lineConnect = this.isSqlTrimAndRemoveLineSeparator() ? (alwaysNeedsLineSeparator ? this.ln() : " ") : "";
                    if (line.indexOf("--") >= 0) {
                        line = this.replaceCommentQuestionMarkIfNeeds(line);
                        sql = sql + lineConnect + line + this.ln();
                    } else {
                        String lineTerminator = this.isSqlTrimAndRemoveLineSeparator() ? "" : this.ln();
                        sql = sql + lineConnect + line + lineTerminator;
                    }
                }
                if (!sql.trim().endsWith(this._runInfo.getDelimiter())) continue;
                sql = sql.trim();
                sql = sql.substring(0, sql.length() - this._runInfo.getDelimiter().length());
                if ("".equals(sql = sql.trim())) continue;
                if (!delimiterChanger.isDelimiterChanger(sql)) {
                    this.addSqlToList(sqlList, sql);
                    alwaysNeedsLineSeparator = false;
                    sql = "";
                    continue;
                }
                this._runInfo.setDelimiter(delimiterChanger.getNewDelimiter(sql, this._runInfo.getDelimiter()));
                alwaysNeedsLineSeparator = false;
                sql = "";
            }
            if ((sql = sql.trim()).length() <= 0) break block20;
            this.addSqlToList(sqlList, sql);
        }
        Object var13_14 = null;
        if (in == null) return sqlList;
        try {
            in.close();
            return sqlList;
        }
        catch (IOException ignore) {
            ignore.printStackTrace();
        }
        return sqlList;
        {
            catch (IOException e) {
                String msg = "The method 'extractSqlList()' threw the IOException!";
                throw new IllegalStateException(msg, e);
            }
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException ignore) {
                ignore.printStackTrace();
            }
            throw throwable;
        }
    }

    protected void addSqlToList(List<String> sqlList, String sql) {
        if (this.isSqlLineCommentOnly(sql)) {
            return;
        }
        sqlList.add(this.removeCR(sql));
    }

    protected boolean isSqlLineCommentOnly(String sql) {
        String[] lines;
        sql = sql.trim();
        for (String line : lines = sql.split("\n")) {
            if ((line = line.trim()).length() == 0 || line.startsWith("--")) continue;
            return false;
        }
        _log.info((Object)("The SQL is line comment only so skip it:" + this.ln() + sql));
        return true;
    }

    protected boolean isDbCommentLine(String line) {
        return (line = line.trim().toLowerCase()).startsWith("comment on ") && line.contains("is") && line.contains("'");
    }

    protected String removeTerminater4ToolIfNeeds(String sql) {
        String terminater = this.getTerminater4Tool();
        if (terminater == null || terminater.trim().length() == 0) {
            return sql;
        }
        if ((sql = sql.trim()).endsWith(terminater)) {
            String rear = sql.length() > 30 ? ": ..." + sql.substring(sql.length() - 30) : ".";
            _log.info((Object)("...Removing terminater '" + terminater + "' for tools" + rear));
            sql = sql.substring(0, sql.length() - terminater.length());
        }
        return sql;
    }

    protected String getTerminater4Tool() {
        return null;
    }

    public DelimiterChanger newDelimterChanger() {
        String databaseName = DfBuildProperties.getInstance().getBasicProperties().getDatabaseType();
        String className = DelimiterChanger.class.getName() + "_" + databaseName;
        DelimiterChanger changer = null;
        try {
            changer = (DelimiterChanger)Class.forName(className).newInstance();
        }
        catch (Exception ignore) {
            changer = new DelimiterChanger_null();
        }
        return changer;
    }

    protected String removeUTF8BomIfNeeds(String str) {
        if (this._runInfo.isEncodingNull()) {
            return str;
        }
        if ("UTF-8".equalsIgnoreCase(this._runInfo.getEncoding()) && str.length() > 0 && str.charAt(0) == '\ufeff') {
            String front = str.length() > 5 ? ": " + str.substring(0, 5) + "..." : ".";
            _log.info((Object)("...Removing UTF-8 bom" + front));
            str = str.substring(1);
        }
        return str;
    }

    protected String removeCR(String str) {
        return str.replaceAll("\r", "");
    }

    protected String replaceCommentQuestionMarkIfNeeds(String line) {
        int lineCommentIndex = line.indexOf("--");
        if (lineCommentIndex < 0) {
            return line;
        }
        String sqlClause = lineCommentIndex == 0 ? "" : line.substring(0, lineCommentIndex);
        String lineComment = line.substring(lineCommentIndex);
        if (lineComment.indexOf("?") >= 0) {
            lineComment = Srl.replace((String)line, (String)"?", (String)"Q");
        }
        return sqlClause + lineComment;
    }

    protected void throwSQLFailureException(String sql, SQLException e) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Failed to execute the SQL!");
        br.addItem("SQL File");
        br.addElement((Object)this._sqlFile);
        br.addItem("Executed SQL");
        br.addElement((Object)sql);
        br.addItem("SQLState");
        br.addElement((Object)e.getSQLState());
        br.addItem("ErrorCode");
        br.addElement((Object)e.getErrorCode());
        br.addItem("SQLException");
        br.addElement((Object)e.getClass().getName());
        br.addElement((Object)this.extractMessage(e));
        SQLException nextEx = e.getNextException();
        if (nextEx != null) {
            br.addItem("NextException");
            br.addElement((Object)nextEx.getClass().getName());
            br.addElement((Object)this.extractMessage(nextEx));
            SQLException nextNextEx = nextEx.getNextException();
            if (nextNextEx != null) {
                br.addItem("NextNextException");
                br.addElement((Object)nextNextEx.getClass().getName());
                br.addElement((Object)this.extractMessage(nextNextEx));
            }
        }
        String msg = br.buildExceptionMessage();
        throw new SQLFailureException(msg, e);
    }

    protected String extractMessage(SQLException e) {
        String message = e.getMessage();
        return message != null ? message.trim() : message;
    }

    protected abstract void execSQL(String var1);

    protected boolean isSqlTrimAndRemoveLineSeparator() {
        return false;
    }

    protected boolean isHandlingCommentOnLineSeparator() {
        return false;
    }

    protected String ln() {
        return "\n";
    }

    public DfSqlFileRunnerResult getResult() {
        return this._result;
    }

    protected static class DelimiterChanger_null
    implements DelimiterChanger {
        protected DelimiterChanger_null() {
        }

        public boolean isDelimiterChanger(String sql) {
            return false;
        }

        public String getNewDelimiter(String sql, String preDelimiter) {
            return preDelimiter;
        }
    }

    protected static class DelimiterChanger_mysql
    implements DelimiterChanger {
        public static final String CHANGE_COMMAND = "delimiter ";
        public static final int CHANGE_COMMAND_LENGTH = "delimiter ".length();

        protected DelimiterChanger_mysql() {
        }

        public boolean isDelimiterChanger(String sql) {
            return (sql = sql.trim()).length() > CHANGE_COMMAND_LENGTH && sql.substring(0, CHANGE_COMMAND_LENGTH).equalsIgnoreCase(CHANGE_COMMAND);
        }

        public String getNewDelimiter(String sql, String preDelimiter) {
            String tmp = sql.substring(CHANGE_COMMAND.length());
            if (tmp.indexOf(" ") >= 0) {
                tmp = tmp.substring(0, tmp.indexOf(" "));
            }
            return tmp;
        }
    }

    protected static class DelimiterChanger_firebird
    implements DelimiterChanger {
        public static final String CHANGE_COMMAND = "set term ";
        public static final int CHANGE_COMMAND_LENGTH = "set term ".length();

        protected DelimiterChanger_firebird() {
        }

        public boolean isDelimiterChanger(String sql) {
            return (sql = sql.trim()).length() > CHANGE_COMMAND_LENGTH && sql.substring(0, CHANGE_COMMAND_LENGTH).equalsIgnoreCase(CHANGE_COMMAND);
        }

        public String getNewDelimiter(String sql, String preDelimiter) {
            String tmp = sql.substring(CHANGE_COMMAND.length());
            if (tmp.indexOf(" ") >= 0) {
                tmp = tmp.substring(0, tmp.indexOf(" "));
            }
            return tmp;
        }
    }

    protected static interface DelimiterChanger {
        public boolean isDelimiterChanger(String var1);

        public String getNewDelimiter(String var1, String var2);
    }
}

