/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.task;

import java.io.File;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.dbflute.DfBuildProperties;
import org.seasar.dbflute.logic.sql2entity.bqp.DfBehaviorQueryPathSetupper;
import org.seasar.dbflute.properties.DfLittleAdjustmentProperties;
import org.seasar.dbflute.task.bs.DfAbstractDbMetaTexenTask;

public class TorqueDataModelTask
extends DfAbstractDbMetaTexenTask {
    private static final Log _log = LogFactory.getLog(TorqueDataModelTask.class);

    protected void doExecute() {
        this.setupControlTemplate();
        super.doExecute();
        this.setupBehaviorQueryPath();
        this.showSkippedFileInformation();
        this.refreshResources();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void setupControlTemplate() {
        DfLittleAdjustmentProperties littleProp = DfBuildProperties.getInstance().getLittleAdjustmentProperties();
        if (littleProp.isAlternateGenerateControlValid()) {
            this.setupControlAlternate(littleProp);
            return;
        }
        if (!this.getBasicProperties().isTargetLanguageMain()) {
            this.setupControlSubLanguage();
            return;
        }
        if (this.getBasicProperties().isTargetLanguageJava()) {
            if (this.getBasicProperties().isApplicationBehaviorProject()) {
                this.setupControlApplicationBehaviorJava(littleProp);
                return;
            }
            _log.info((Object)"");
            _log.info((Object)"* * * * * * * * *");
            _log.info((Object)"* Process Java  *");
            _log.info((Object)"* * * * * * * * *");
            String control = "om/ControlGenerateJava.vm";
            _log.info((Object)"...Using Java control: om/ControlGenerateJava.vm");
            this.setControlTemplate("om/ControlGenerateJava.vm");
            return;
        }
        if (!this.getBasicProperties().isTargetLanguageCSharp()) {
            String msg = "Unknown main language: " + this.getBasicProperties().getTargetLanguage();
            throw new IllegalStateException(msg);
        }
        if (this.getBasicProperties().isApplicationBehaviorProject()) {
            this.setupControlApplicationBehaviorCSharp(littleProp);
            return;
        }
        _log.info((Object)"");
        _log.info((Object)"* * * * * * * * * *");
        _log.info((Object)"* Process CSharp  *");
        _log.info((Object)"* * * * * * * * * *");
        String control = "om/ControlGenerateCSharp.vm";
        _log.info((Object)"...Using CSharp control: om/ControlGenerateCSharp.vm");
        this.setControlTemplate("om/ControlGenerateCSharp.vm");
    }

    protected void setupControlAlternate(DfLittleAdjustmentProperties littleProp) {
        _log.info((Object)"");
        _log.info((Object)"* * * * * * * * * * * * * * *");
        _log.info((Object)"* Process Alternate Control *");
        _log.info((Object)"* * * * * * * * * * * * * * *");
        String control = littleProp.getAlternateGenerateControl();
        _log.info((Object)("...Using alternate control: " + control));
        this.setControlTemplate(control);
    }

    protected void setupControlApplicationBehaviorJava(DfLittleAdjustmentProperties littleProp) {
        _log.info((Object)"");
        _log.info((Object)"* * * * * * * * * * * * * * * * * * * * * * * *");
        _log.info((Object)"* Process Application Behavior Control (Java) *");
        _log.info((Object)"* * * * * * * * * * * * * * * * * * * * * * * *");
        String control = "om/java/plugin/bhvap/ControlBhvApJava.vm";
        _log.info((Object)"...Using application behavior (Java) control: om/java/plugin/bhvap/ControlBhvApJava.vm");
        this.setControlTemplate("om/java/plugin/bhvap/ControlBhvApJava.vm");
    }

    protected void setupControlApplicationBehaviorCSharp(DfLittleAdjustmentProperties littleProp) {
        _log.info((Object)"");
        _log.info((Object)"* * * * * * * * * * * * * * * * * * * * * * * * *");
        _log.info((Object)"* Process Application Behavior Control (CSharp) *");
        _log.info((Object)"* * * * * * * * * * * * * * * * * * * * * * * * *");
        String control = "om/csharp/plugin/bhvap/ControlBhvApCSharp.vm";
        _log.info((Object)"...Using application behavior (CSharp) control: om/csharp/plugin/bhvap/ControlBhvApCSharp.vm");
        this.setControlTemplate("om/csharp/plugin/bhvap/ControlBhvApCSharp.vm");
    }

    protected void setupControlSubLanguage() {
        String language = this.getBasicProperties().getTargetLanguage();
        _log.info((Object)"");
        _log.info((Object)"* * * * * * * * * *");
        _log.info((Object)("* Process " + language + "    *"));
        _log.info((Object)"* * * * * * * * * *");
        String control = "om/" + language + "/Control-" + language + ".vm";
        _log.info((Object)("...Using " + language + " control: " + control));
        this.setControlTemplate(control);
    }

    protected boolean isUseDataSource() {
        return true;
    }

    protected void setupBehaviorQueryPath() {
        List<File> sqlFileList = this.collectSqlFileList();
        DfBehaviorQueryPathSetupper setupper = new DfBehaviorQueryPathSetupper(this.getProperties());
        setupper.setupBehaviorQueryPath(sqlFileList);
    }
}

