/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.engine.database.model;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.engine.EngineException;
import org.apache.torque.engine.database.model.Column;
import org.apache.torque.engine.database.model.Database;
import org.apache.torque.engine.database.model.ForeignKey;
import org.apache.torque.engine.database.model.IdMethodParameter;
import org.apache.torque.engine.database.model.Index;
import org.apache.torque.engine.database.model.Inheritance;
import org.apache.torque.engine.database.model.NameFactory;
import org.apache.torque.engine.database.model.UnifiedSchema;
import org.apache.torque.engine.database.model.Unique;
import org.seasar.dbflute.DBDef;
import org.seasar.dbflute.DfBuildProperties;
import org.seasar.dbflute.helper.StringKeyMap;
import org.seasar.dbflute.helper.StringSet;
import org.seasar.dbflute.logic.doc.schemahtml.DfSchemaHtmlBuilder;
import org.seasar.dbflute.logic.generate.column.DfColumnListToStringUtil;
import org.seasar.dbflute.properties.DfBasicProperties;
import org.seasar.dbflute.properties.DfBehaviorFilterProperties;
import org.seasar.dbflute.properties.DfBuriProperties;
import org.seasar.dbflute.properties.DfCommonColumnProperties;
import org.seasar.dbflute.properties.DfDatabaseProperties;
import org.seasar.dbflute.properties.DfDocumentProperties;
import org.seasar.dbflute.properties.DfLittleAdjustmentProperties;
import org.seasar.dbflute.properties.DfSequenceIdentityProperties;
import org.seasar.dbflute.properties.assistant.DfAdditionalSchemaInfo;
import org.seasar.dbflute.util.DfCollectionUtil;
import org.seasar.dbflute.util.Srl;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Table {
    private static final Log _log = LogFactory.getLog(Table.class);
    private Database _tableParent;
    private String _name;
    private String _type;
    private UnifiedSchema _unifiedSchema;
    private String _plainComment;
    private String _description;
    private boolean _existSameNameTable;
    private List<Column> _columnList;
    private StringKeyMap<Column> _columnMap = StringKeyMap.createAsFlexible();
    private List<ForeignKey> _foreignKeys;
    private List<String> _foreignTableNames;
    private boolean _containsForeignPK;
    private boolean _isForReferenceOnly;
    private List<ForeignKey> _referrerList;
    private List<Unique> _unices;
    private List<Index> _indices;
    private String _javaName;
    private boolean _sql2entityCustomize;
    private boolean _sql2entityCustomizeHasNested;
    private boolean _sql2entityTypeSafeCursor;
    private List<IdMethodParameter> _idMethodParameters;
    private Column _inheritanceColumn;
    protected Map<String, Integer> _relationIndexMap = new LinkedHashMap<String, Integer>();
    protected List<ForeignKey> _singleKeyReferrers = null;
    protected List<ForeignKey> _singleKeyStringOrIntegerReferrers = null;
    protected boolean _needsJavaNameConvert = true;
    protected boolean _alreadyCheckedExistingSameNameTable;
    protected List<Column> _behaviorFilterBeforeInsertColumnList;
    protected List<Column> _behaviorFilterBeforeUpdateColumnList;

    public Table() {
        this(null);
    }

    public Table(String name) {
        this._name = name;
        this._columnList = new ArrayList<Column>();
        this._foreignKeys = new ArrayList<ForeignKey>(5);
        this._referrerList = new ArrayList<ForeignKey>(5);
        this._indices = new ArrayList<Index>(5);
        this._unices = new ArrayList<Unique>(5);
    }

    public void loadFromXML(Attributes attrib) {
        this._name = attrib.getValue("name");
        this._type = attrib.getValue("type");
        String plainSchema = attrib.getValue("schema");
        this._unifiedSchema = UnifiedSchema.createAsDynamicSchema(plainSchema);
        this._plainComment = attrib.getValue("comment");
        this._javaName = attrib.getValue("javaName");
        this._description = attrib.getValue("description");
    }

    public void setDatabase(Database parent) {
        this._tableParent = parent;
    }

    public Database getDatabase() {
        return this._tableParent;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getAnnotationTableName() {
        return this.getTableSqlName();
    }

    public String getTableSqlName() {
        String tableName = this.quoteTableNameIfNeeds(this._name);
        return this.filterSchemaSqlPrefix(tableName);
    }

    public String getTableSqlNameDirectUse() {
        String tableName = this.quoteTableNameIfNeedsDirectUse(this._name);
        return this.filterSchemaSqlPrefix(tableName);
    }

    protected String filterSchemaSqlPrefix(String tableName) {
        if (this.hasSchema()) {
            return this._unifiedSchema.buildSqlName(tableName);
        }
        return tableName;
    }

    protected String quoteTableNameIfNeeds(String tableName) {
        DfLittleAdjustmentProperties prop = this.getProperties().getLittleAdjustmentProperties();
        return prop.quoteTableNameIfNeeds(tableName);
    }

    protected String quoteTableNameIfNeedsDirectUse(String tableName) {
        DfLittleAdjustmentProperties prop = this.getProperties().getLittleAdjustmentProperties();
        return prop.quoteTableNameIfNeeds(tableName, true);
    }

    public boolean hasAlias() {
        String alias = this.getAlias();
        return alias != null && alias.trim().length() > 0;
    }

    public String getAlias() {
        String alias;
        DfDocumentProperties prop = this.getProperties().getDocumentProperties();
        String comment = this._plainComment;
        if (comment != null && (alias = prop.extractAliasFromDbComment(comment)) != null) {
            return alias;
        }
        return "";
    }

    public String getAliasExpression() {
        String alias = this.getAlias();
        if (alias == null || alias.trim().length() == 0) {
            return "";
        }
        return "(" + alias + ")";
    }

    public String getType() {
        return this._type;
    }

    public void setType(String type) {
        this._type = type;
    }

    public boolean isTypeTable() {
        return this._type != null && this._type.equalsIgnoreCase("table");
    }

    public UnifiedSchema getUnifiedSchema() {
        return this._unifiedSchema != null ? this._unifiedSchema : null;
    }

    public void setUnifiedSchema(UnifiedSchema unifiedSchema) {
        this._unifiedSchema = unifiedSchema;
    }

    public String getDocumentSchema() {
        if (this._unifiedSchema == null) {
            return "";
        }
        if (this.getDatabase().hasCatalogAdditionalSchema()) {
            return this._unifiedSchema.getCatalogSchema();
        }
        return this._unifiedSchema.getPureSchema();
    }

    protected String getPureCatalog() {
        return this._unifiedSchema != null ? this._unifiedSchema.getPureSchema() : null;
    }

    protected String getPureSchema() {
        return this._unifiedSchema != null ? this._unifiedSchema.getPureSchema() : null;
    }

    public boolean hasSchema() {
        return this._unifiedSchema != null ? this._unifiedSchema.hasSchema() : false;
    }

    public boolean isMainSchema() {
        return this.hasSchema() && this.getUnifiedSchema().isMainSchema();
    }

    public boolean isAdditionalSchema() {
        return this.hasSchema() && this.getUnifiedSchema().isAdditionalSchema();
    }

    public boolean isCatalogAdditionalSchema() {
        return this.hasSchema() && this.getUnifiedSchema().isCatalogAdditionalSchema();
    }

    public String getPlainComment() {
        return this._plainComment;
    }

    public boolean hasComment() {
        String comment = this.getComment();
        return comment != null && comment.trim().length() > 0;
    }

    public String getComment() {
        DfDocumentProperties prop = this.getProperties().getDocumentProperties();
        String comment = prop.extractCommentFromDbComment(this._plainComment);
        return comment != null ? comment : "";
    }

    public String getCommentForSchemaHtml() {
        DfDocumentProperties prop = this.getProperties().getDocumentProperties();
        String comment = prop.resolveTextForSchemaHtml(this.getComment());
        return comment != null ? comment : "";
    }

    public boolean isCommentForJavaDocValid() {
        DfDocumentProperties prop = this.getProperties().getDocumentProperties();
        return this.hasComment() && prop.isEntityJavaDocDbCommentValid();
    }

    public String getCommentForJavaDoc() {
        DfDocumentProperties prop = this.getProperties().getDocumentProperties();
        String comment = prop.resolveTextForJavaDoc(this.getComment(), "");
        return comment != null ? comment : "";
    }

    public boolean isCommentForDBMetaValid() {
        DfDocumentProperties prop = this.getProperties().getDocumentProperties();
        return this.hasComment() && prop.isEntityDBMetaDbCommentValid();
    }

    public String getCommentForDBMeta() {
        DfDocumentProperties prop = this.getProperties().getDocumentProperties();
        String comment = prop.resolveTextForDBMeta(this.getComment());
        return comment != null ? comment : "";
    }

    public String getBasicInfoDispString() {
        String type = this.getType();
        return this.getAliasExpression() + this.getName() + (type != null ? " as " + type : "");
    }

    public String getTitleForSchemaHtml() {
        StringBuilder sb = new StringBuilder();
        sb.append("type=").append(this._type);
        if (this.isAdditionalSchema()) {
            sb.append(", schema=").append(this.getDocumentSchema());
        }
        sb.append(", primaryKey={").append(this.getPrimaryKeyNameCommaString()).append("}");
        sb.append(", nameLength=").append(this.getName().length());
        sb.append(", columnCount=").append(this.getColumns().length);
        DfDocumentProperties prop = this.getProperties().getDocumentProperties();
        return " title=\"" + prop.resolveAttributeForSchemaHtml(sb.toString()) + "\"";
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String newDescription) {
        this._description = newDescription;
    }

    public Column getChildrenColumn() {
        return this._inheritanceColumn;
    }

    public List<String> getChildrenNames() {
        if (this._inheritanceColumn == null || !this._inheritanceColumn.isEnumeratedClasses()) {
            return null;
        }
        List<Inheritance> children = this._inheritanceColumn.getChildren();
        ArrayList<String> names = new ArrayList<String>(children.size());
        for (int i = 0; i < children.size(); ++i) {
            names.add(children.get(i).getClassName());
        }
        return names;
    }

    public Column addColumn(Attributes attrib) {
        Column col = new Column();
        col.setTable(this);
        col.loadFromXML(attrib);
        this.addColumn(col);
        return col;
    }

    public void addColumn(Column col) {
        col.setTable(this);
        if (col.isInheritance()) {
            this._inheritanceColumn = col;
        }
        this._columnList.add(col);
        this._columnMap.put(col.getName(), (Object)col);
        String synonym = col.getSynonym();
        if (synonym != null) {
            this._columnMap.put(synonym, (Object)col);
        }
        col.setPosition(this._columnList.size());
    }

    public List<Column> getColumnList() {
        return this._columnList;
    }

    public Column[] getColumns() {
        return this._columnList.toArray(new Column[0]);
    }

    public String getColumnNameCommaString() {
        StringBuilder sb = new StringBuilder();
        List<Column> ls = this._columnList;
        int size = ls.size();
        for (int i = 0; i < size; ++i) {
            Column col = ls.get(i);
            sb.append(", ").append(col.getName());
        }
        sb.delete(0, ", ".length());
        return sb.toString();
    }

    public String getPropertyNameCommaString() {
        StringBuilder sb = new StringBuilder();
        List<Column> ls = this._columnList;
        int size = ls.size();
        for (int i = 0; i < size; ++i) {
            Column col = ls.get(i);
            sb.append(", ").append(col.getJavaBeansRulePropertyName());
        }
        sb.delete(0, ", ".length());
        return sb.toString();
    }

    public Column getColumn(String name) {
        return (Column)this._columnMap.get((Object)name);
    }

    public boolean containsColumn(List<String> columnNameList) {
        if (columnNameList.isEmpty()) {
            return false;
        }
        for (String columnName : columnNameList) {
            if (this.getColumn(columnName) != null) continue;
            return false;
        }
        return true;
    }

    public boolean hasUtilDateColumn() {
        for (Column column : this._columnList) {
            if (!column.isJavaNativeUtilDate()) continue;
            return true;
        }
        return false;
    }

    public boolean hasByteArrayColumn() {
        for (Column column : this._columnList) {
            if (!column.isJavaNativeByteArray()) continue;
            return true;
        }
        return false;
    }

    public boolean hasByteArrayColumnInEqualsHashcode() {
        for (Column column : this.getEqualsHashcodeColumnList()) {
            if (!column.isJavaNativeByteArray()) continue;
            return true;
        }
        return false;
    }

    public String getPrimaryKeyConstraintName() {
        List<Column> columnList = this.getColumnList();
        for (Column column : columnList) {
            if (!column.isPrimaryKey()) continue;
            return column.getPrimaryKeyName();
        }
        return null;
    }

    public List<Column> getPrimaryKey() {
        ArrayList<Column> pk = new ArrayList<Column>(this._columnList.size());
        for (Column column : this._columnList) {
            if (!column.isPrimaryKey()) continue;
            pk.add(column);
        }
        return pk;
    }

    public Column getPrimaryKeyAsOne() {
        if (this.getPrimaryKey().size() != 1) {
            String msg = "This method is for only-one primary-key:";
            msg = msg + " getPrimaryKey().size()=" + this.getPrimaryKey().size();
            msg = msg + " table=" + this.getName();
            throw new IllegalStateException(msg);
        }
        return this.getPrimaryKey().get(0);
    }

    public String getPrimaryKeyNameAsOne() {
        return this.getPrimaryKeyAsOne().getName();
    }

    public String getPrimaryKeyJavaNameAsOne() {
        return this.getPrimaryKeyAsOne().getJavaName();
    }

    public String getPrimaryKeyJavaNativeAsOne() {
        return this.getPrimaryKeyAsOne().getJavaNative();
    }

    public String getPrimaryKeyColumnDbNameOnlyFirstOne() {
        if (this.hasPrimaryKey()) {
            return this.getPrimaryKey().get(0).getName();
        }
        return "";
    }

    public List<Column> getEqualsHashcodeColumnList() {
        if (this.hasPrimaryKey()) {
            return this.getPrimaryKey();
        }
        return this.getColumnList();
    }

    public String getPrimaryKeyArgsString() {
        return DfColumnListToStringUtil.getColumnArgsString(this.getPrimaryKey());
    }

    public String getPrimaryKeyArgsJavaDocString() {
        String ln = this.getBasicProperties().getSourceCodeLineSeparator();
        return DfColumnListToStringUtil.getColumnArgsJavaDocString(this.getPrimaryKey(), ln);
    }

    public String getPrimaryKeyArgsAssertString() {
        return DfColumnListToStringUtil.getColumnArgsAssertString(this.getPrimaryKey());
    }

    public String getPrimaryKeyArgsAssertStringCSharp() {
        return DfColumnListToStringUtil.getColumnArgsAssertStringCSharp(this.getPrimaryKey());
    }

    public String getPrimaryKeyArgsSetupString() {
        return DfColumnListToStringUtil.getColumnArgsSetupString(null, this.getPrimaryKey());
    }

    public String getPrimaryKeyArgsSetupString(String beanName) {
        return DfColumnListToStringUtil.getColumnArgsSetupString(beanName, this.getPrimaryKey());
    }

    public String getPrimaryKeyArgsSetupStringCSharp() {
        return DfColumnListToStringUtil.getColumnArgsSetupStringCSharp(null, this.getPrimaryKey());
    }

    public String getPrimaryKeyArgsSetupStringCSharp(String beanName) {
        return DfColumnListToStringUtil.getColumnArgsSetupStringCSharp(beanName, this.getPrimaryKey());
    }

    public String getPrimaryKeyArgsConditionSetupString() {
        return DfColumnListToStringUtil.getColumnArgsConditionSetupString(this.getPrimaryKey());
    }

    public String getPrimaryKeyArgsConditionSetupStringCSharp() {
        return DfColumnListToStringUtil.getColumnArgsConditionSetupStringCSharp(this.getPrimaryKey());
    }

    public String getPrimaryKeyArgsCallingString() {
        return this.getPrimaryKeyUncapitalisedJavaNameCommaString();
    }

    public String getPrimaryKeyWhereStringWithSqlComment() {
        StringBuilder sb = new StringBuilder();
        List<Column> pk = this.getPrimaryKey();
        for (Column column : pk) {
            sb.append(" and ");
            sb.append(this.getName()).append(".").append(column.getName()).append(" = /*");
            sb.append(column.getUncapitalisedJavaName()).append("*/null");
        }
        sb.delete(0, " and ".length());
        return sb.toString();
    }

    public String getPrimaryKeyOrderByAscString() {
        return DfColumnListToStringUtil.getColumnOrderByString(this.getPrimaryKey(), "asc");
    }

    public String getPrimaryKeyOrderByDescString() {
        return DfColumnListToStringUtil.getColumnOrderByString(this.getPrimaryKey(), "desc");
    }

    public String getPrimaryKeyDispValueString() {
        return DfColumnListToStringUtil.getColumnDispValueString(this.getPrimaryKey(), "get");
    }

    public String getPrimaryKeyDispValueStringByGetterInitCap() {
        return DfColumnListToStringUtil.getColumnDispValueString(this.getPrimaryKey(), "Get");
    }

    public String getPrimaryKeyNameCommaString() {
        return DfColumnListToStringUtil.getColumnNameCommaString(this.getPrimaryKey());
    }

    public String getPrimaryKeyUncapitalisedJavaNameCommaString() {
        return DfColumnListToStringUtil.getColumnUncapitalisedJavaNameCommaString(this.getPrimaryKey());
    }

    public String getPrimaryKeyJavaNameCommaString() {
        return DfColumnListToStringUtil.getColumnJavaNameCommaString(this.getPrimaryKey());
    }

    public String getPrimaryKeyGetterCommaString() {
        return DfColumnListToStringUtil.getColumnGetterCommaString(this.getPrimaryKey());
    }

    public boolean hasPrimaryKey() {
        return this.getPrimaryKey().size() > 0;
    }

    public boolean hasSinglePrimaryKey() {
        return this.getPrimaryKey().size() == 1;
    }

    public boolean hasCompoundPrimaryKey() {
        return this.getPrimaryKey().size() > 1;
    }

    public String printPrimaryKey() {
        return this.printList(this._columnList);
    }

    public boolean isWritable() {
        return this.hasPrimaryKey();
    }

    public String getAttachedPKArgsSetupString(String attachedPKVariableName) {
        List<Column> pkList = this.getPrimaryKey();
        String result = "";
        for (Column pk : pkList) {
            String javaName = pk.getJavaName();
            String pkGetString = attachedPKVariableName + ".get" + javaName + "()";
            String setterString = "set" + javaName + "(" + pkGetString + ");";
            if ("".equals(result)) {
                result = setterString;
                continue;
            }
            result = result + setterString;
        }
        return result;
    }

    public ForeignKey[] getForeignKeys() {
        int size = this._foreignKeys.size();
        ForeignKey[] tbls = new ForeignKey[size];
        for (int i = 0; i < size; ++i) {
            tbls[i] = this._foreignKeys.get(i);
        }
        return tbls;
    }

    public ForeignKey getForeignKey(String columnName) {
        ForeignKey firstFK = null;
        for (ForeignKey key : this._foreignKeys) {
            List<String> localColumns = key.getLocalColumns();
            if (!Srl.containsElementIgnoreCase(localColumns, (String)columnName) || firstFK != null) continue;
            firstFK = key;
        }
        return firstFK;
    }

    public List<ForeignKey> getForeignKeyList(String columnName) {
        ArrayList<ForeignKey> fkList = new ArrayList<ForeignKey>();
        for (ForeignKey key : this._foreignKeys) {
            List<String> localColumns = key.getLocalColumns();
            if (!Srl.containsElementIgnoreCase(localColumns, (String)columnName)) continue;
            fkList.add(key);
        }
        return fkList;
    }

    public ForeignKey addForeignKey(Attributes attrib) {
        ForeignKey fk = new ForeignKey();
        fk.loadFromXML(attrib);
        this.addForeignKey(fk);
        return fk;
    }

    public String getForeignTableNameCommaString() {
        StringBuilder sb = new StringBuilder();
        HashSet<String> tableSet = new HashSet<String>();
        List<ForeignKey> foreignKeyList = this._foreignKeys;
        for (int i = 0; i < foreignKeyList.size(); ++i) {
            ForeignKey fk = foreignKeyList.get(i);
            String name = fk.getForeignTableName();
            if (tableSet.contains(name)) continue;
            tableSet.add(name);
            sb.append(", ").append(name).append(fk.hasFixedSuffix() ? "(" + fk.getFixedSuffix() + ")" : "");
        }
        List<ForeignKey> referrerList = this._referrerList;
        for (int i = 0; i < referrerList.size(); ++i) {
            String name;
            ForeignKey fk = referrerList.get(i);
            if (!fk.isOneToOne() || tableSet.contains(name = fk.getTable().getName())) continue;
            tableSet.add(name);
            sb.append(", ").append(name).append("(AsOne)");
        }
        sb.delete(0, ", ".length());
        return sb.toString();
    }

    public String getForeignTableNameCommaStringWithHtmlHref() {
        StringBuilder sb = new StringBuilder();
        DfDocumentProperties prop = this.getProperties().getDocumentProperties();
        DfSchemaHtmlBuilder schemaHtmlBuilder = new DfSchemaHtmlBuilder(prop);
        String delimiter = ", ";
        List<ForeignKey> foreignKeyList = this._foreignKeys;
        int size = foreignKeyList.size();
        if (size == 0) {
            return "&nbsp;";
        }
        for (int i = 0; i < size; ++i) {
            ForeignKey fk = foreignKeyList.get(i);
            String foreignTableName = fk.getForeignTableName();
            sb.append(schemaHtmlBuilder.buildRelatedTableLink(fk, foreignTableName, ", "));
        }
        sb.delete(0, ", ".length());
        return sb.toString();
    }

    public String getForeignPropertyNameCommaString() {
        StringBuilder sb = new StringBuilder();
        List<ForeignKey> ls = this._foreignKeys;
        int size = ls.size();
        for (int i = 0; i < size; ++i) {
            ForeignKey fk = ls.get(i);
            sb.append(", ").append(fk.getForeignPropertyName());
        }
        List<ForeignKey> referrerList = this._referrerList;
        for (ForeignKey fk : referrerList) {
            if (!fk.isOneToOne()) continue;
            sb.append(", ").append(fk.getReferrerPropertyNameAsOne());
        }
        sb.delete(0, ", ".length());
        return sb.toString();
    }

    public List<String> getForeignTableNames() {
        if (this._foreignTableNames == null) {
            this._foreignTableNames = new ArrayList<String>(1);
        }
        return this._foreignTableNames;
    }

    public void addForeignKey(ForeignKey fk) {
        fk.setTable(this);
        this._foreignKeys.add(fk);
        if (this._foreignTableNames == null) {
            this._foreignTableNames = new ArrayList<String>(5);
        }
        if (this._foreignTableNames.contains(fk.getForeignTableName())) {
            this._foreignTableNames.add(fk.getForeignTableName());
        }
    }

    public boolean existsForeignKey(String foreignTableName, List<String> localColumnNameList, List<String> foreignColumnNameList, String fixedSuffix) {
        ForeignKey[] fks;
        StringSet localColumnNameSet = StringSet.createAsFlexibleOrdered();
        localColumnNameSet.addAll(localColumnNameList);
        StringSet foreignColumnNameSet = StringSet.createAsFlexibleOrdered();
        foreignColumnNameSet.addAll(foreignColumnNameList);
        for (ForeignKey key : fks = this.getForeignKeys()) {
            if (!Srl.equalsFlexible((String)foreignTableName, (String[])new String[]{key.getForeignTableName()})) continue;
            if (!Srl.equalsFlexible((String)fixedSuffix, (String[])new String[]{key.getFixedSuffix()})) continue;
            StringSet currentLocalColumnNameSet = StringSet.createAsFlexibleOrdered();
            currentLocalColumnNameSet.addAll(key.getLocalColumns());
            if (!localColumnNameSet.equalsUnderCharOption(currentLocalColumnNameSet)) continue;
            StringSet currentForeignColumnNameSet = StringSet.createAsFlexibleOrdered();
            currentForeignColumnNameSet.addAll(key.getForeignColumns());
            if (!foreignColumnNameSet.equalsUnderCharOption(currentForeignColumnNameSet)) continue;
            return true;
        }
        return false;
    }

    public boolean hasForeignKey() {
        return this.getForeignKeys().length != 0;
    }

    public boolean hasRelation() {
        return this.hasForeignKey() || this.hasReferrer();
    }

    public boolean isForReferenceOnly() {
        return this._isForReferenceOnly;
    }

    public void setForReferenceOnly(boolean v) {
        this._isForReferenceOnly = v;
    }

    public int resolveForeignIndex(ForeignKey foreignKey) {
        return this.doResolveRelationIndex(foreignKey, false, false);
    }

    public int resolveReferrerIndexAsOne(ForeignKey foreignKey) {
        return this.doResolveRelationIndex(foreignKey, true, true);
    }

    public int resolveRefererIndexAsOne(ForeignKey foreignKey) {
        return this.resolveReferrerIndexAsOne(foreignKey);
    }

    public int resolveReferrerIndex(ForeignKey foreignKey) {
        return this.doResolveRelationIndex(foreignKey, true, false);
    }

    public int resolveRefererIndex(ForeignKey foreignKey) {
        return this.resolveReferrerIndex(foreignKey);
    }

    protected int doResolveRelationIndex(ForeignKey foreignKey, boolean referer, boolean oneToOne) {
        try {
            String relationIndexKey = this.buildRefererIndexKey(foreignKey, referer, oneToOne);
            Integer realIndex = this._relationIndexMap.get(relationIndexKey);
            if (realIndex != null) {
                return realIndex;
            }
            int minimumRelationIndex = this.extractMinimumRelationIndex(this._relationIndexMap);
            this._relationIndexMap.put(relationIndexKey, minimumRelationIndex);
            return minimumRelationIndex;
        }
        catch (RuntimeException e) {
            _log.warn((Object)("doResolveRelationIndex() threw the exception: " + foreignKey), (Throwable)e);
            throw e;
        }
    }

    protected String buildRefererIndexKey(ForeignKey foreignKey, boolean referer, boolean oneToOne) {
        if (!referer) {
            return foreignKey.getForeignJavaBeansRulePropertyName();
        }
        if (oneToOne) {
            return foreignKey.getReferrerJavaBeansRulePropertyNameAsOne();
        }
        return foreignKey.getReferrerJavaBeansRulePropertyName();
    }

    protected int extractMinimumRelationIndex(Map<String, Integer> relationIndexMap) {
        Set<String> keySet = relationIndexMap.keySet();
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        for (String key : keySet) {
            Integer index = relationIndexMap.get(key);
            indexList.add(index);
        }
        if (indexList.isEmpty()) {
            return 0;
        }
        Integer minimumIndex = -1;
        for (Integer currentIndex : indexList) {
            if (minimumIndex + 1 < currentIndex) {
                return minimumIndex + 1;
            }
            minimumIndex = currentIndex;
        }
        return indexList.size();
    }

    public boolean hasForeignKeyOrReferrer() {
        return this.hasForeignKey() || this.hasReferrer();
    }

    public boolean hasForeignKeyOrReferrerAsOne() {
        return this.hasForeignKey() || this.hasReferrerAsOne();
    }

    public boolean hasTwoOrMoreKeyReferrer() {
        return this.xhasTwoOrMoreKeyReferrer(this.getPrimaryKey()) || this.xhasTwoOrMoreKeyReferrer(this.getUniqueColumnList());
    }

    protected boolean xhasTwoOrMoreKeyReferrer(List<Column> columnList) {
        for (Column col : columnList) {
            for (ForeignKey referrer : col.getReferrers()) {
                if (referrer.isSimpleKeyFK()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean addReferrer(ForeignKey fk) {
        if (!fk.canBeReferrer()) {
            return false;
        }
        if (this._referrerList == null) {
            this._referrerList = DfCollectionUtil.newArrayList();
        }
        this._referrerList.add(fk);
        return true;
    }

    public List<ForeignKey> getReferrerList() {
        return this._referrerList;
    }

    public List<ForeignKey> getReferrerAsManyList() {
        return this.getReferrerAsWhatList(false);
    }

    public List<ForeignKey> getReferrerAsOneList() {
        return this.getReferrerAsWhatList(true);
    }

    protected List<ForeignKey> getReferrerAsWhatList(boolean oneToOne) {
        List<ForeignKey> referrerList = this.getReferrerList();
        if (referrerList == null || referrerList.isEmpty()) {
            return referrerList;
        }
        List referrerListAsWhat = DfCollectionUtil.newArrayList();
        for (ForeignKey key : referrerList) {
            if (oneToOne) {
                if (!key.isOneToOne()) continue;
                referrerListAsWhat.add(key);
                continue;
            }
            if (key.isOneToOne()) continue;
            referrerListAsWhat.add(key);
        }
        return referrerListAsWhat;
    }

    public List<ForeignKey> getRefererList() {
        return this.getReferrerList();
    }

    public List<ForeignKey> getReferrers() {
        return this.getReferrerList();
    }

    public boolean hasReferrer() {
        return this.getReferrerList() != null && !this.getReferrerList().isEmpty();
    }

    public boolean hasReferrerAsMany() {
        List<ForeignKey> manyList = this.getReferrerAsManyList();
        return manyList != null && !manyList.isEmpty();
    }

    protected boolean hasReferrerAsOne() {
        List<ForeignKey> oneList = this.getReferrerAsOneList();
        return oneList != null && !oneList.isEmpty();
    }

    public boolean hasSingleKeyReferrer() {
        return !this.getSingleKeyReferrers().isEmpty();
    }

    public List<ForeignKey> getSingleKeyReferrers() {
        if (this._singleKeyReferrers != null) {
            return this._singleKeyReferrers;
        }
        this._singleKeyReferrers = new ArrayList<ForeignKey>(5);
        if (!this.hasReferrer()) {
            return this._singleKeyReferrers;
        }
        List<ForeignKey> referrerList = this.getReferrers();
        for (ForeignKey referrer : referrerList) {
            if (!referrer.isSimpleKeyFK()) continue;
            this._singleKeyReferrers.add(referrer);
        }
        return this._singleKeyReferrers;
    }

    public boolean hasSingleKeyStringOrIntegerReferrer() {
        return !this.getSingleKeyStringOrIntegerReferrers().isEmpty();
    }

    public List<ForeignKey> getSingleKeyStringOrIntegerReferrers() {
        if (this._singleKeyStringOrIntegerReferrers != null) {
            return this._singleKeyStringOrIntegerReferrers;
        }
        this._singleKeyStringOrIntegerReferrers = new ArrayList<ForeignKey>(5);
        if (!this.hasReferrer()) {
            return this._singleKeyStringOrIntegerReferrers;
        }
        List<ForeignKey> referrerList = this.getReferrers();
        for (ForeignKey referrer : referrerList) {
            Column localColumn;
            if (!referrer.isSimpleKeyFK() || !(localColumn = referrer.getLocalColumnAsOne()).isJavaNativeStringObject() && !localColumn.isJavaNativeNumberObject()) continue;
            this._singleKeyStringOrIntegerReferrers.add(referrer);
        }
        return this._singleKeyStringOrIntegerReferrers;
    }

    public String getReferrerTableNameCommaString() {
        String name;
        ForeignKey fk;
        int i;
        StringBuilder sb = new StringBuilder();
        HashSet<String> tableSet = new HashSet<String>();
        List<ForeignKey> ls = this.getReferrerList();
        int size = ls.size();
        for (i = 0; i < size; ++i) {
            fk = ls.get(i);
            if (fk.isOneToOne() || tableSet.contains(name = fk.getTable().getName())) continue;
            tableSet.add(name);
            sb.append(", ").append(name);
        }
        for (i = 0; i < size; ++i) {
            fk = ls.get(i);
            if (!fk.isOneToOne() || tableSet.contains(name = fk.getTable().getName())) continue;
            tableSet.add(name);
            sb.append(", ").append(name);
        }
        sb.delete(0, ", ".length());
        return sb.toString();
    }

    public String getReferrerTableNameCommaStringWithHtmlHref() {
        StringBuilder sb = new StringBuilder();
        DfDocumentProperties prop = this.getProperties().getDocumentProperties();
        DfSchemaHtmlBuilder schemaHtmlBuilder = new DfSchemaHtmlBuilder(prop);
        String delimiter = ", ";
        List<ForeignKey> referrerList = this.getReferrerList();
        int size = referrerList.size();
        if (size == 0) {
            return "&nbsp;";
        }
        for (int i = 0; i < size; ++i) {
            ForeignKey fk = referrerList.get(i);
            String referrerTableName = fk.getTable().getName();
            sb.append(schemaHtmlBuilder.buildRelatedTableLink(fk, referrerTableName, ", "));
        }
        sb.delete(0, ", ".length());
        return sb.toString();
    }

    public String getReferrerPropertyNameCommaString() {
        StringBuilder sb = new StringBuilder();
        List<ForeignKey> ls = this.getReferrerList();
        int size = ls.size();
        for (int i = 0; i < size; ++i) {
            ForeignKey fk = ls.get(i);
            if (fk.isOneToOne()) continue;
            sb.append(", ").append(fk.getReferrerPropertyName());
        }
        sb.delete(0, ", ".length());
        return sb.toString();
    }

    public void setContainsForeignPK(boolean b) {
        this._containsForeignPK = b;
    }

    public boolean getContainsForeignPK() {
        return this._containsForeignPK;
    }

    public Unique[] getUnices() {
        int size = this._unices.size();
        Unique[] tbls = new Unique[size];
        for (int i = 0; i < size; ++i) {
            tbls[i] = this._unices.get(i);
        }
        return tbls;
    }

    public List<Unique> getUniqueList() {
        return this._unices;
    }

    public List<Unique> getOnlyOneColumnUniqueList() {
        List<Unique> uniqueList = this.getUniqueList();
        List resultList = DfCollectionUtil.newArrayList();
        for (Unique unique : uniqueList) {
            if (!unique.isOnlyOneColumn()) continue;
            resultList.add(unique);
        }
        return resultList;
    }

    public List<Unique> getTwoOrMoreColumnUniqueList() {
        List<Unique> uniqueList = this.getUniqueList();
        List resultList = DfCollectionUtil.newArrayList();
        for (Unique unique : uniqueList) {
            if (!unique.isTwoOrMoreColumn()) continue;
            resultList.add(unique);
        }
        return resultList;
    }

    public void addUnique(Unique unique) {
        unique.setTable(this);
        this._unices.add(unique);
    }

    public Unique addUnique(Attributes attrib) {
        Unique unique = new Unique();
        unique.loadFromXML(attrib);
        this.addUnique(unique);
        return unique;
    }

    public List<Column> getUniqueColumnList() {
        StringKeyMap keyMap = StringKeyMap.createAsCaseInsensitiveOrdered();
        for (Column column : this._columnList) {
            keyMap.put(column.getName(), (Object)column);
        }
        return new ArrayList<Column>(keyMap.values());
    }

    public Index[] getIndices() {
        int size = this._indices.size();
        Index[] tbls = new Index[size];
        for (int i = 0; i < size; ++i) {
            tbls[i] = this._indices.get(i);
        }
        return tbls;
    }

    public List<Index> getIndexList() {
        return this._indices;
    }

    public List<Index> getOnlyOneColumnIndexList() {
        List<Index> indexList = this.getIndexList();
        List resultList = DfCollectionUtil.newArrayList();
        for (Index index : indexList) {
            if (!index.isOnlyOneColumn()) continue;
            resultList.add(index);
        }
        return resultList;
    }

    public List<Index> getTwoOrMoreColumnIndexList() {
        List<Index> indexList = this.getIndexList();
        List resultList = DfCollectionUtil.newArrayList();
        for (Index index : indexList) {
            if (!index.isTwoOrMoreColumn()) continue;
            resultList.add(index);
        }
        return resultList;
    }

    public void addIndex(Index index) {
        index.setTable(this);
        this._indices.add(index);
    }

    public Index addIndex(Attributes attrib) {
        Index index = new Index();
        index.loadFromXML(attrib);
        this.addIndex(index);
        return index;
    }

    public void suppressJavaNameConvert() {
        this._needsJavaNameConvert = false;
    }

    public boolean needsJavaNameConvert() {
        return this._needsJavaNameConvert;
    }

    public String getJavaName() {
        if (this._javaName != null) {
            return this._javaName;
        }
        this._javaName = this.needsJavaNameConvert() ? this.getDatabase().convertJavaNameByJdbcNameAsTable(this.getName()) : this.getName();
        this._javaName = this.filterBuriJavaNameIfNeeds(this._javaName);
        this._javaName = this.filterJavaNameNonCompilableConnector(this._javaName);
        return this._javaName;
    }

    protected String filterBuriJavaNameIfNeeds(String javaName) {
        String arranged;
        DfBuriProperties buriProperties = this.getProperties().getBuriProperties();
        if (buriProperties.isUseBuri() && this.isBuriInternal() && (arranged = buriProperties.arrangeBuriTableJavaName(this._javaName)) != null) {
            return arranged;
        }
        return javaName;
    }

    protected String filterJavaNameNonCompilableConnector(String javaName) {
        DfLittleAdjustmentProperties prop = this.getProperties().getLittleAdjustmentProperties();
        return prop.filterJavaNameNonCompilableConnector(javaName, new DfLittleAdjustmentProperties.NonCompilableChecker(){

            public String name() {
                return Table.this.getName();
            }

            public String disp() {
                return Table.this.getBasicInfoDispString();
            }
        });
    }

    public void setJavaName(String javaName) {
        this._javaName = javaName;
    }

    public String getUncapitalisedJavaName() {
        return Srl.initUncap((String)this.getJavaName());
    }

    public String getJavaBeansRulePropertyName() {
        return Srl.initBeansProp((String)this.getJavaName());
    }

    public String getBaseEntityClassName() {
        String projectPrefix = this.getDatabase().getProjectPrefix();
        String basePrefix = this.getDatabase().getBasePrefix();
        String baseSuffixForEntity = this.getDatabase().getBaseSuffixForEntity();
        return projectPrefix + basePrefix + this.getSchemaClassPrefix() + this.getJavaName() + baseSuffixForEntity;
    }

    public String getBaseDaoClassName() {
        return this.getBaseEntityClassName() + "Dao";
    }

    public String getBaseBehaviorClassName() {
        return this.getBaseEntityClassName() + "Bhv";
    }

    public String getBaseBehaviorApClassName() {
        String suffix = this.getBasicProperties().getApplicationBehaviorAdditionalSuffix();
        return this.getBaseBehaviorClassName() + suffix;
    }

    public String getBaseConditionBeanClassName() {
        return this.getBaseEntityClassName() + "CB";
    }

    public String getAbstractBaseConditionQueryClassName() {
        String projectPrefix = this.getDatabase().getProjectPrefix();
        String basePrefix = this.getDatabase().getBasePrefix();
        return projectPrefix + "Abstract" + basePrefix + this.getSchemaClassPrefix() + this.getJavaName() + "CQ";
    }

    public String getBaseConditionQueryClassName() {
        return this.getBaseEntityClassName() + "CQ";
    }

    public String getExtendedEntityClassName() {
        String projectPrefix = this.getDatabase().getProjectPrefix();
        return this.buildExtendedEntityClassName(projectPrefix);
    }

    protected String buildExtendedEntityClassName(String projectPrefix) {
        return projectPrefix + this.getSchemaClassPrefix() + this.getJavaName();
    }

    public String getRelationTraceClassName() {
        return this.getSchemaClassPrefix() + this.getJavaName();
    }

    public String getDBMetaClassName() {
        return this.getExtendedEntityClassName() + "Dbm";
    }

    public String getDBMetaFullClassName() {
        return this.getDatabase().getBaseEntityPackage() + ".dbmeta." + this.getDBMetaClassName();
    }

    public String getExtendedDaoClassName() {
        return this.getExtendedEntityClassName() + "Dao";
    }

    public String getExtendedDaoFullClassName() {
        String extendedDaoPackage = this.getDatabase().getExtendedDaoPackage();
        return extendedDaoPackage + "." + this.getExtendedDaoClassName();
    }

    public String getExtendedBehaviorClassName() {
        return this.getExtendedEntityClassName() + "Bhv";
    }

    public String getExtendedBehaviorApClassName() {
        String suffix = this.getBasicProperties().getApplicationBehaviorAdditionalSuffix();
        return this.getExtendedBehaviorClassName() + suffix;
    }

    public String getExtendedBehaviorLibClassName() {
        String projectPrefix = this.getBasicProperties().getLibraryProjectPrefix();
        return this.buildExtendedEntityClassName(projectPrefix) + "Bhv";
    }

    public String getExtendedBehaviorFullClassName() {
        String extendedBehaviorPackage = this.getDatabase().getExtendedBehaviorPackage();
        return extendedBehaviorPackage + "." + this.getExtendedBehaviorClassName();
    }

    public String getExtendedBehaviorApFullClassName() {
        String extendedBehaviorPackage = this.getDatabase().getExtendedBehaviorPackage();
        return extendedBehaviorPackage + "." + this.getExtendedBehaviorApClassName();
    }

    public String getExtendedConditionBeanClassName() {
        return this.getExtendedEntityClassName() + "CB";
    }

    public String getExtendedConditionQueryClassName() {
        return this.getExtendedEntityClassName() + "CQ";
    }

    public String getExtendedConditionInlineQueryClassName() {
        return this.getExtendedEntityClassName() + "CIQ";
    }

    public String getNestSelectSetupperClassName() {
        return this.getExtendedEntityClassName() + "Nss";
    }

    public String getNestSelectSetupperTerminalClassName() {
        return this.getExtendedEntityClassName() + "Nsst";
    }

    protected String getSchemaClassPrefix() {
        if (this.hasSchema() && this.isExistSameNameTable()) {
            String prefix;
            if (this.isCatalogAdditionalSchema()) {
                String pureCatalog = this.getPureCatalog();
                pureCatalog = pureCatalog != null ? Srl.initCapTrimmed((String)pureCatalog.trim().toLowerCase()) : "";
                String pureSchema = this.getPureSchema();
                pureSchema = pureSchema != null ? Srl.initCapTrimmed((String)pureSchema.trim().toLowerCase()) : "";
                prefix = pureCatalog + pureSchema;
            } else {
                String pureSchema = this.getPureSchema();
                prefix = pureSchema = pureSchema != null ? Srl.initCapTrimmed((String)pureSchema.trim().toLowerCase()) : "";
            }
            return prefix;
        }
        return "";
    }

    protected boolean isExistSameNameTable() {
        if (this._alreadyCheckedExistingSameNameTable) {
            return this._existSameNameTable;
        }
        this._alreadyCheckedExistingSameNameTable = true;
        List<Table> tableList = this.getDatabase().getTableList();
        int count = 0;
        for (Table table : tableList) {
            String name = table.getName();
            if (!this._name.equalsIgnoreCase(name) || ++count <= 1) continue;
            this._existSameNameTable = true;
            return this._existSameNameTable;
        }
        this._existSameNameTable = false;
        return this._existSameNameTable;
    }

    public String getDaoComponentName() {
        return this.getDatabase().filterComponentNameWithProjectPrefix(this.getUncapitalisedJavaName()) + "Dao";
    }

    public String getBehaviorComponentName() {
        String uncapName = this.getUncapitalisedJavaName();
        String componentName = this.getDatabase().filterComponentNameWithProjectPrefix(uncapName) + "Bhv";
        return Srl.replace((String)componentName, (String)"$", (String)"");
    }

    public String getBehaviorApComponentName() {
        String suffix = this.getBasicProperties().getApplicationBehaviorAdditionalSuffix();
        return this.getBehaviorComponentName() + suffix;
    }

    public boolean isSql2EntityCustomize() {
        return this._sql2entityCustomize;
    }

    public void setSql2EntityCustomize(boolean sql2entityCustomize) {
        this._sql2entityCustomize = sql2entityCustomize;
    }

    public boolean isSql2EntityCustomizeHasNested() {
        return this._sql2entityCustomizeHasNested;
    }

    public void setSql2EntityCustomizeHasNested(boolean sql2entityCustomizeHasNested) {
        this._sql2entityCustomizeHasNested = sql2entityCustomizeHasNested;
    }

    public boolean isSql2EntityTypeSafeCursor() {
        return this._sql2entityTypeSafeCursor;
    }

    public void setSql2EntityTypeSafeCursor(boolean sql2entityTypeSafeCursor) {
        this._sql2entityTypeSafeCursor = sql2entityTypeSafeCursor;
    }

    public boolean isLoadableCustomizeEntity() {
        Table domain = this.getLoadableCustomizeDomain();
        return domain != null && domain.hasReferrerAsMany();
    }

    public Table getLoadableCustomizeDomain() {
        if (!this.isSql2EntityCustomize() || !this.hasPrimaryKey()) {
            return null;
        }
        List<Column> primaryKeyList = this.getPrimaryKey();
        for (Column pk : primaryKeyList) {
            Column relatedColumn = pk.getSql2EntityRelatedColumn();
            if (relatedColumn == null || relatedColumn.isPrimaryKey()) continue;
            return null;
        }
        return primaryKeyList.get(0).getSql2EntityRelatedTable();
    }

    public List<String> getLoadableCustomizePrimaryKeySettingExpressionList() {
        Table domain = this.getLoadableCustomizeDomain();
        if (domain == null) {
            return DfCollectionUtil.emptyList();
        }
        List<Column> primaryKeyList = this.getPrimaryKey();
        List settingList = DfCollectionUtil.newArrayList();
        boolean notFoundExists = false;
        for (Column pk : primaryKeyList) {
            if (pk.hasSql2EntityRelatedColumn()) continue;
            notFoundExists = true;
            break;
        }
        boolean hasRelatedColumn = !notFoundExists;
        int index = 0;
        for (Column pk : primaryKeyList) {
            Column relatedColumn = hasRelatedColumn ? pk.getSql2EntityRelatedColumn() : domain.getPrimaryKey().get(index);
            if (this.getBasicProperties().isTargetLanguageJava()) {
                String fromPropName = pk.getJavaBeansRulePropertyNameInitCap();
                String toPropName = relatedColumn.getJavaBeansRulePropertyNameInitCap();
                settingList.add("set" + toPropName + "(get" + fromPropName + "())");
            } else if (this.getBasicProperties().isTargetLanguageCSharp()) {
                settingList.add(relatedColumn.getJavaName() + " = this." + pk.getJavaName());
            } else {
                String msg = "Unsupported language for this method: " + this.getBasicProperties().getTargetLanguage();
                throw new UnsupportedOperationException(msg);
            }
            ++index;
        }
        return settingList;
    }

    private String printList(List<Column> list) {
        StringBuilder result = new StringBuilder();
        boolean comma = false;
        for (Column col : list) {
            if (!col.isPrimaryKey()) continue;
            if (comma) {
                result.append(',');
            } else {
                comma = true;
            }
            result.append(col.getName());
        }
        return result.toString();
    }

    protected DfBuildProperties getProperties() {
        return DfBuildProperties.getInstance();
    }

    protected DfBasicProperties getBasicProperties() {
        return this.getProperties().getBasicProperties();
    }

    protected DfDatabaseProperties getDatabaseProperties() {
        return this.getProperties().getDatabaseProperties();
    }

    protected DfSequenceIdentityProperties getSequenceIdentityProperties() {
        return this.getProperties().getSequenceIdentityProperties();
    }

    public boolean hasClassification() {
        Column[] columns;
        for (Column column : columns = this.getColumns()) {
            if (!column.hasClassification()) continue;
            return true;
        }
        return false;
    }

    public boolean hasTableClassification() {
        Column[] columns;
        for (Column column : columns = this.getColumns()) {
            if (!column.isTableClassification()) continue;
            return true;
        }
        return false;
    }

    public boolean hasImplicitClassification() {
        Column[] columns;
        for (Column column : columns = this.getColumns()) {
            if (column.isTableClassification()) continue;
            return true;
        }
        return false;
    }

    public boolean hasPrimaryKeyForcedClassificationSetting() {
        List<Column> columns = this.getPrimaryKey();
        for (Column column : columns) {
            if (!column.isForceClassificationSetting()) continue;
            return true;
        }
        return false;
    }

    public boolean isUseSequence() {
        String sequenceName = this.getSequenceIdentityProperties().getSequenceName(this.getName());
        if (sequenceName == null || sequenceName.trim().length() == 0) {
            return this.hasPostgreSQLSerialSequenceName();
        }
        return true;
    }

    public String getDefinedSequenceName() {
        if (!this.isUseSequence()) {
            return "";
        }
        String sequenceName = this.getSequenceIdentityProperties().getSequenceName(this.getName());
        if (Srl.is_Null_or_TrimmedEmpty((String)sequenceName)) {
            String serialSequenceName = this.extractPostgreSQLSerialSequenceName();
            if (Srl.is_NotNull_and_NotTrimmedEmpty((String)serialSequenceName)) {
                return serialSequenceName;
            }
            return "";
        }
        return sequenceName;
    }

    public String getSequenceSqlName() {
        if (!this.isUseSequence()) {
            return "";
        }
        String sequenceName = this.getSequenceIdentityProperties().getSequenceName(this.getName());
        if (Srl.is_Null_or_TrimmedEmpty((String)sequenceName)) {
            String serialSequenceName = this.extractPostgreSQLSerialSequenceName();
            if (Srl.is_Null_or_TrimmedEmpty((String)serialSequenceName)) {
                String msg = "The sequence for serial type should exist when isUseSequence() is true!";
                throw new IllegalStateException(msg);
            }
            return serialSequenceName;
        }
        return sequenceName;
    }

    public String getSequenceNextValSql() {
        if (!this.isUseSequence()) {
            return "";
        }
        DBDef dbdef = this.getBasicProperties().getCurrentDBDef();
        String sequenceName = this.getSequenceSqlName();
        String sql = dbdef.dbway().buildSequenceNextValSql(sequenceName);
        return sql != null ? sql : "";
    }

    public BigDecimal getSequenceMinimumValue() {
        String sequenceName;
        DataSource ds;
        if (!this.isUseSequence()) {
            return null;
        }
        DfSequenceIdentityProperties prop = this.getSequenceIdentityProperties();
        BigDecimal value = prop.getSequenceMinimumValueByTableName(ds = this.getDatabase().getDataSource(), this.getUnifiedSchema(), this.getName());
        if (value == null && (sequenceName = this.extractPostgreSQLSerialSequenceName()) != null && sequenceName.trim().length() > 0) {
            value = prop.getSequenceMinimumValueBySequenceName(ds, this.getUnifiedSchema(), sequenceName);
        }
        return value;
    }

    public String getSequenceMinimumValueExpression() {
        BigDecimal value = this.getSequenceMinimumValue();
        return value != null ? value.toString() : "null";
    }

    public BigDecimal getSequenceMaximumValue() {
        String sequenceName;
        DataSource ds;
        if (!this.isUseSequence()) {
            return null;
        }
        DfSequenceIdentityProperties prop = this.getSequenceIdentityProperties();
        BigDecimal value = prop.getSequenceMaximumValueByTableName(ds = this.getDatabase().getDataSource(), this.getUnifiedSchema(), this.getName());
        if (value == null && (sequenceName = this.extractPostgreSQLSerialSequenceName()) != null && sequenceName.trim().length() > 0) {
            value = prop.getSequenceMaximumValueBySequenceName(ds, this.getUnifiedSchema(), sequenceName);
        }
        return value;
    }

    public String getSequenceMaximumValueExpression() {
        BigDecimal value = this.getSequenceMaximumValue();
        return value != null ? value.toString() : "null";
    }

    public Integer getSequenceIncrementSize() {
        String sequenceName;
        DataSource ds;
        if (!this.isUseSequence()) {
            return null;
        }
        DfSequenceIdentityProperties prop = this.getSequenceIdentityProperties();
        Integer size = prop.getSequenceIncrementSizeByTableName(ds = this.getDatabase().getDataSource(), this.getUnifiedSchema(), this.getName());
        if (size == null && (sequenceName = this.extractPostgreSQLSerialSequenceName()) != null && sequenceName.trim().length() > 0) {
            size = prop.getSequenceIncrementSizeBySequenceName(ds, this.getUnifiedSchema(), sequenceName);
        }
        return size;
    }

    public String getSequenceIncrementSizeExpression() {
        Integer value = this.getSequenceIncrementSize();
        return value != null ? value.toString() : "null";
    }

    public Integer getSequenceCacheSize() {
        if (!this.isUseSequence()) {
            return null;
        }
        DfSequenceIdentityProperties prop = this.getSequenceIdentityProperties();
        DataSource ds = this.getDatabase().getDataSource();
        return prop.getSequenceCacheSize(ds, this.getUnifiedSchema(), this.getName());
    }

    public String getSequenceCacheSizeExpression() {
        Integer value = this.getSequenceCacheSize();
        return value != null ? value.toString() : "null";
    }

    public String getSequenceReturnType() {
        DfSequenceIdentityProperties sequenceIdentityProperties = this.getProperties().getSequenceIdentityProperties();
        String sequenceReturnType = sequenceIdentityProperties.getSequenceReturnType();
        if (this.hasCompoundPrimaryKey()) {
            return sequenceReturnType;
        }
        Column primaryKeyAsOne = this.getPrimaryKeyAsOne();
        if (primaryKeyAsOne.isJavaNativeNumberObject()) {
            return primaryKeyAsOne.getJavaNative();
        }
        return sequenceReturnType;
    }

    protected boolean hasPostgreSQLSerialSequenceName() {
        String postgreSQLSerialSequenceName = this.extractPostgreSQLSerialSequenceName();
        return postgreSQLSerialSequenceName != null;
    }

    protected String extractPostgreSQLSerialSequenceName() {
        DfBasicProperties basicProperties = this.getBasicProperties();
        if (!basicProperties.isDatabasePostgreSQL() || !this.hasAutoIncrementColumn()) {
            return null;
        }
        Column autoIncrementColumn = this.getAutoIncrementColumn();
        if (autoIncrementColumn == null) {
            return null;
        }
        String defaultValue = autoIncrementColumn.getDefaultValue();
        if (defaultValue == null) {
            return null;
        }
        String prefix = "nextval('";
        if (!defaultValue.startsWith("nextval('")) {
            return null;
        }
        String excludedPrefixString = defaultValue.substring("nextval('".length());
        int endIndex = excludedPrefixString.indexOf("'");
        if (endIndex < 0) {
            return null;
        }
        return excludedPrefixString.substring(0, endIndex);
    }

    public boolean isAvailableSequenceAssignedIdAnnotation() {
        return this.isBuriTarget();
    }

    public String getAssignedPropertyName() {
        Column primaryKeyAsOne = this.getPrimaryKeyAsOne();
        return this.getPropertyNameResolvedLanguage(primaryKeyAsOne);
    }

    protected String getPropertyNameResolvedLanguage(Column col) {
        if (this.getBasicProperties().isTargetLanguageJava()) {
            return col.getJavaBeansRulePropertyName();
        }
        if (this.getBasicProperties().isTargetLanguageCSharp()) {
            return col.getJavaName();
        }
        return col.getUncapitalisedJavaName();
    }

    public boolean isUseIdentity() {
        DfBasicProperties basicProperties = this.getBasicProperties();
        if (basicProperties.isDatabasePostgreSQL()) {
            return false;
        }
        if (this.hasAutoIncrementColumn()) {
            return true;
        }
        DfSequenceIdentityProperties prop = this.getSequenceIdentityProperties();
        return prop.getIdentityColumnName(this.getName()) != null;
    }

    public String getIdentityColumnName() {
        Column column = this.getIdentityColumn();
        return column != null ? column.getName() : "";
    }

    public String getIdentityPropertyName() {
        Column column = this.getIdentityColumn();
        return column != null ? this.getPropertyNameResolvedLanguage(column) : "";
    }

    protected Column getIdentityColumn() {
        if (!this.isUseIdentity()) {
            return null;
        }
        Column autoIncrementColumn = this.getAutoIncrementColumn();
        if (autoIncrementColumn != null) {
            return autoIncrementColumn;
        }
        DfSequenceIdentityProperties prop = this.getSequenceIdentityProperties();
        String columnName = prop.getIdentityColumnName(this.getName());
        Column column = this.getColumn(columnName);
        if (column == null) {
            String msg = "The columnName does not exist in the table: ";
            msg = msg + " tableName=" + this.getName() + " columnName=" + columnName;
            msg = msg + " columnList=" + this.getColumnNameCommaString();
            throw new IllegalStateException(msg);
        }
        return column;
    }

    protected boolean hasAutoIncrementColumn() {
        Column[] columnArray;
        for (Column column : columnArray = this.getColumns()) {
            if (!column.isAutoIncrement()) continue;
            return true;
        }
        return false;
    }

    protected Column getAutoIncrementColumn() {
        Column[] columnArray;
        for (Column column : columnArray = this.getColumns()) {
            if (!column.isAutoIncrement()) continue;
            return column;
        }
        return null;
    }

    public boolean hasOptimisticLock() {
        return this.isUseUpdateDate() || this.isUseVersionNo();
    }

    public boolean isUseUpdateDate() {
        String updateDateColumnName = this.getProperties().getOptimisticLockProperties().getUpdateDateFieldName();
        if ("".equals(updateDateColumnName)) {
            return false;
        }
        Column column = this.getColumn(updateDateColumnName);
        return column != null;
    }

    protected Column getUpdateDateColumn() {
        if (!this.isUseUpdateDate()) {
            return null;
        }
        String fieldName = this.getProperties().getOptimisticLockProperties().getUpdateDateFieldName();
        if (fieldName != null && fieldName.trim().length() != 0) {
            Column column = this.getColumn(fieldName);
            return column;
        }
        return null;
    }

    public String getUpdateDateColumnName() {
        Column column = this.getUpdateDateColumn();
        if (column == null) {
            return "";
        }
        return column.getName();
    }

    public String getUpdateDateJavaName() {
        Column column = this.getUpdateDateColumn();
        if (column == null) {
            return "";
        }
        return column.getJavaName();
    }

    public String getUpdateDateUncapitalisedJavaName() {
        return Srl.initUncap((String)this.getUpdateDateJavaName());
    }

    public String getUpdateDatePropertyName() {
        Column column = this.getUpdateDateColumn();
        if (column == null) {
            return "";
        }
        return this.getPropertyNameResolvedLanguage(column);
    }

    public String getUpdateDateJavaNative() {
        if (!this.isUseUpdateDate()) {
            return "";
        }
        Column column = this.getColumn(this.getProperties().getOptimisticLockProperties().getUpdateDateFieldName());
        return column.getJavaNative();
    }

    public boolean isUseVersionNo() {
        String versionNoColumnName = this.getProperties().getOptimisticLockProperties().getVersionNoFieldName();
        Column column = this.getColumn(versionNoColumnName);
        return column != null;
    }

    public Column getVersionNoColumn() {
        if (!this.isUseVersionNo()) {
            return null;
        }
        String versionNoColumnName = this.getProperties().getOptimisticLockProperties().getVersionNoFieldName();
        return this.getColumn(versionNoColumnName);
    }

    public String getVersionNoColumnName() {
        Column column = this.getVersionNoColumn();
        if (column == null) {
            return "";
        }
        return column.getName();
    }

    public String getVersionNoJavaName() {
        Column column = this.getVersionNoColumn();
        if (column == null) {
            return "";
        }
        return column.getJavaName();
    }

    public String getVersionNoPropertyName() {
        Column column = this.getVersionNoColumn();
        if (column == null) {
            return "";
        }
        return this.getPropertyNameResolvedLanguage(column);
    }

    public String getVersionNoUncapitalisedJavaName() {
        return this.buildVersionNoUncapitalisedJavaName(this.getVersionNoJavaName());
    }

    protected String buildVersionNoUncapitalisedJavaName(String versionNoJavaName) {
        return Srl.initUncap((String)versionNoJavaName);
    }

    public boolean hasAllCommonColumn() {
        try {
            return this.doHasAllCommonColumn();
        }
        catch (RuntimeException e) {
            _log.debug((Object)"Failed to execute 'Table.hasAllCommonColumn()'!", (Throwable)e);
            throw e;
        }
    }

    protected boolean doHasAllCommonColumn() {
        DfDatabaseProperties prop;
        DfAdditionalSchemaInfo schemaInfo;
        if (!this.isWritable()) {
            return false;
        }
        if (this.isAdditionalSchema() && (schemaInfo = (prop = this.getDatabaseProperties()).getAdditionalSchemaInfo(this._unifiedSchema)).isSuppressCommonColumn()) {
            return false;
        }
        List<String> commonColumnNameList = this.getDatabase().getCommonColumnNameList();
        if (commonColumnNameList.isEmpty()) {
            return false;
        }
        for (String commonColumnName : commonColumnNameList) {
            if (this.getProperties().getCommonColumnProperties().isCommonColumnConversion(commonColumnName)) {
                try {
                    this.findTargetColumnJavaNameByCommonColumnName(commonColumnName);
                    continue;
                }
                catch (IllegalStateException e) {
                    return false;
                }
            }
            if (this._columnMap.containsKey((Object)commonColumnName)) continue;
            return false;
        }
        return true;
    }

    public List<Column> getCommonColumnList() {
        if (!this.isWritable()) {
            return new ArrayList<Column>();
        }
        ArrayList<Column> ls = new ArrayList<Column>();
        if (!this.hasAllCommonColumn()) {
            return ls;
        }
        List<String> commonColumnNameList = this.getDatabase().getCommonColumnNameList();
        for (String commonColumnName : commonColumnNameList) {
            ls.add(this.getColumn(this.findTargetColumnNameByCommonColumnName(commonColumnName)));
        }
        return ls;
    }

    public String findTargetColumnJavaNameByCommonColumnName(String commonColumnName) {
        DfCommonColumnProperties prop = this.getProperties().getCommonColumnProperties();
        if (prop.isCommonColumnConversion(commonColumnName)) {
            String filteredCommonColumn = this.convertCommonColumnName(commonColumnName, prop);
            Column column = this.getCommonColumnConversion(commonColumnName, filteredCommonColumn);
            return column.getJavaName();
        }
        Column column = this.getCommonColumnNormal(commonColumnName);
        return column.getJavaName();
    }

    public String findTargetColumnNameByCommonColumnName(String commonColumnName) {
        DfCommonColumnProperties prop = this.getProperties().getCommonColumnProperties();
        if (prop.isCommonColumnConversion(commonColumnName)) {
            String filteredCommonColumn = this.convertCommonColumnName(commonColumnName, prop);
            Column column = this.getCommonColumnConversion(commonColumnName, filteredCommonColumn);
            return column.getName();
        }
        Column column = this.getCommonColumnNormal(commonColumnName);
        return column.getName();
    }

    protected Column getCommonColumnNormal(String commonColumnName) {
        Column column = this.getColumn(commonColumnName);
        if (column == null) {
            String msg = "Not found column by '" + commonColumnName + "'.";
            throw new IllegalStateException(msg);
        }
        return column;
    }

    protected Column getCommonColumnConversion(String commonColumnName, String filteredCommonColumn) {
        Column column = this.getColumn(filteredCommonColumn);
        if (column == null) {
            String msg = "Not found column by '" + filteredCommonColumn + "': ";
            msg = msg + "original=" + commonColumnName;
            throw new IllegalStateException(msg);
        }
        return column;
    }

    protected String convertCommonColumnName(String commonColumnName, DfCommonColumnProperties prop) {
        String filteredCommonColumn = prop.filterCommonColumn(commonColumnName);
        filteredCommonColumn = Srl.replace((String)filteredCommonColumn, (String)"TABLE_NAME", (String)this.getName());
        filteredCommonColumn = Srl.replace((String)filteredCommonColumn, (String)"table_name", (String)this.getName());
        filteredCommonColumn = Srl.replace((String)filteredCommonColumn, (String)"TableName", (String)this.getJavaName());
        filteredCommonColumn = Srl.replace((String)filteredCommonColumn, (String)"tablename", (String)this.getJavaName());
        return filteredCommonColumn;
    }

    public boolean isAvailableNonPrimaryKeyWritable() {
        if (this.hasPrimaryKey()) {
            return false;
        }
        return this.getProperties().getLittleAdjustmentProperties().isAvailableNonPrimaryKeyWritable();
    }

    protected boolean isAvailableAddingSchemaToTableSqlName() {
        return this.getProperties().getLittleAdjustmentProperties().isAvailableAddingSchemaToTableSqlName();
    }

    protected boolean isAvailableAddingCatalogToTableSqlName() {
        return this.getProperties().getLittleAdjustmentProperties().isAvailableAddingCatalogToTableSqlName();
    }

    public boolean hasEntityConvertEmptyStringToNull() {
        List<Column> columnList = this.getColumnList();
        for (Column column : columnList) {
            if (!column.isEntityConvertEmptyStringToNull()) continue;
            return true;
        }
        return false;
    }

    public boolean isFlexDtoBindable() {
        return this.getProperties().getFlexDtoProperties().isBindable(this.getName());
    }

    public boolean isBuriTarget() {
        if (!this.hasSinglePrimaryKey()) {
            return false;
        }
        DfBuriProperties buriProperties = this.getProperties().getBuriProperties();
        return buriProperties.isUseBuri() && buriProperties.isTargetTable(this.getName()) && this.hasTableProcess();
    }

    protected boolean hasTableProcess() {
        return !this.getTableProcessForMethodNameList().isEmpty();
    }

    public boolean isBuriInternal() {
        DfBuriProperties buriProperties = this.getProperties().getBuriProperties();
        return buriProperties.isUseBuri() && buriProperties.isBuriInternalTable(this.getJavaName());
    }

    public List<String> getTableProcessForMethodNameList() {
        DfBuriProperties buriProperties = this.getProperties().getBuriProperties();
        return buriProperties.getTableProcessForMethodNameList(this.getName());
    }

    public boolean isBuriAllRoundStateHistory() {
        DfBuriProperties buriProperties = this.getProperties().getBuriProperties();
        return buriProperties.isBuriAllRoundStateHistory(this.getName());
    }

    public boolean hasBehaviorFilterBeforeColumn() {
        try {
            return this.hasBehaviorFilterBeforeInsertColumn() || this.hasBehaviorFilterBeforeUpdateColumn();
        }
        catch (RuntimeException e) {
            _log.debug((Object)"Failed to execute 'Table.hasBehaviorFilterBeforeColumn()'!", (Throwable)e);
            throw e;
        }
    }

    public boolean hasBehaviorFilterBeforeInsertColumn() {
        return !this.getBehaviorFilterBeforeInsertColumnList().isEmpty();
    }

    public List<Column> getBehaviorFilterBeforeInsertColumnList() {
        if (this._behaviorFilterBeforeInsertColumnList != null) {
            return this._behaviorFilterBeforeInsertColumnList;
        }
        DfBehaviorFilterProperties prop = this.getProperties().getBehaviorFilterProperties();
        Map<String, Object> map = prop.getBeforeInsertMap();
        Set<String> columnNameSet = map.keySet();
        this._behaviorFilterBeforeInsertColumnList = new ArrayList<Column>();
        HashSet<String> commonColumnNameSet = new HashSet<String>();
        if (this.hasAllCommonColumn()) {
            List<Column> commonColumnList = this.getCommonColumnList();
            for (Column commonColumn : commonColumnList) {
                commonColumnNameSet.add(commonColumn.getName());
            }
        }
        for (String columnName : columnNameSet) {
            Column column = this.getColumn(columnName);
            if (column == null || commonColumnNameSet.contains(columnName)) continue;
            this._behaviorFilterBeforeInsertColumnList.add(column);
            String expression = (String)map.get(columnName);
            if (expression == null || expression.trim().length() == 0) {
                String msg = "The value expression was not found in beforeInsertMap: column=" + column;
                throw new IllegalStateException(msg);
            }
            column.setBehaviorFilterBeforeInsertColumnExpression(expression);
        }
        return this._behaviorFilterBeforeInsertColumnList;
    }

    public String getBehaviorFilterBeforeInsertColumnExpression(String columName) {
        DfBehaviorFilterProperties prop = this.getProperties().getBehaviorFilterProperties();
        Map<String, Object> map = prop.getBeforeInsertMap();
        return (String)map.get(columName);
    }

    public boolean hasBehaviorFilterBeforeUpdateColumn() {
        return !this.getBehaviorFilterBeforeUpdateColumnList().isEmpty();
    }

    public List<Column> getBehaviorFilterBeforeUpdateColumnList() {
        if (this._behaviorFilterBeforeUpdateColumnList != null) {
            return this._behaviorFilterBeforeUpdateColumnList;
        }
        DfBehaviorFilterProperties prop = this.getProperties().getBehaviorFilterProperties();
        Map<String, Object> map = prop.getBeforeUpdateMap();
        Set<String> columnNameSet = map.keySet();
        this._behaviorFilterBeforeUpdateColumnList = new ArrayList<Column>();
        HashSet<String> commonColumnNameSet = new HashSet<String>();
        if (this.hasAllCommonColumn()) {
            List<Column> commonColumnList = this.getCommonColumnList();
            for (Column commonColumn : commonColumnList) {
                commonColumnNameSet.add(commonColumn.getName());
            }
        }
        for (String columnName : columnNameSet) {
            Column column = this.getColumn(columnName);
            if (column == null || commonColumnNameSet.contains(columnName)) continue;
            this._behaviorFilterBeforeUpdateColumnList.add(column);
            String expression = (String)map.get(columnName);
            if (expression == null || expression.trim().length() == 0) {
                String msg = "The value expression was not found in beforeUpdateMap: column=" + column;
                throw new IllegalStateException(msg);
            }
            column.setBehaviorFilterBeforeUpdateColumnExpression(expression);
        }
        return this._behaviorFilterBeforeUpdateColumnList;
    }

    protected Map<String, Map<String, String>> getBehaviorQueryPathMap() {
        Map<String, Map<String, Map<String, String>>> tableBqpMap = this.getDatabase().getTableBqpMap();
        HashMap elementMap = tableBqpMap.get(this.getName());
        return elementMap != null ? elementMap : new HashMap();
    }

    public boolean hasBehaviorQueryPath() {
        return !this.getBehaviorQueryPathList().isEmpty();
    }

    public List<String> getBehaviorQueryPathList() {
        Map<String, Map<String, String>> bqpMap = this.getBehaviorQueryPathMap();
        return new ArrayList<String>(bqpMap.keySet());
    }

    protected Map<String, String> getBehaviorQueryPathElementMap(String behaviorQueryPath) {
        Map<String, Map<String, String>> bqpMap = this.getBehaviorQueryPathMap();
        return bqpMap.get(behaviorQueryPath);
    }

    public String getBehaviorQueryPathDisplayName(String behaviorQueryPath) {
        String subDirectoryPath = this.getBehaviorQueryPathSubDirectoryPath(behaviorQueryPath);
        if (Srl.is_NotNull_and_NotTrimmedEmpty((String)subDirectoryPath)) {
            String connector = "_";
            return Srl.replace((String)subDirectoryPath, (String)"/", (String)"_") + "_" + behaviorQueryPath;
        }
        return behaviorQueryPath;
    }

    public String getBehaviorQueryPathFileName(String behaviorQueryPath) {
        String path = this.getBehaviorQueryPathPath(behaviorQueryPath);
        if (Srl.is_NotNull_and_NotTrimmedEmpty((String)path)) {
            int fileNameIndex = path.lastIndexOf("/");
            if (fileNameIndex >= 0) {
                return path.substring(fileNameIndex + "/".length());
            }
            return path;
        }
        return "";
    }

    public String getBehaviorQueryPathSubDirectoryPath(String behaviorQueryPath) {
        Map<String, String> elementMap = this.getBehaviorQueryPathElementMap(behaviorQueryPath);
        String subDirectoryPath = elementMap.get("subDirectoryPath");
        return Srl.is_NotNull_and_NotTrimmedEmpty((String)subDirectoryPath) ? subDirectoryPath : "";
    }

    public String getBehaviorQueryPathPath(String behaviorQueryPath) {
        Map<String, String> elementMap = this.getBehaviorQueryPathElementMap(behaviorQueryPath);
        String path = elementMap.get("path");
        return Srl.is_NotNull_and_NotTrimmedEmpty((String)path) ? path : "";
    }

    public boolean hasBehaviorQueryPathCustomizeEntity(String behaviorQueryPath) {
        return Srl.is_NotNull_and_NotTrimmedEmpty((String)this.getBehaviorQueryPathCustomizeEntity(behaviorQueryPath));
    }

    public String getBehaviorQueryPathCustomizeEntity(String behaviorQueryPath) {
        Map<String, String> elementMap = this.getBehaviorQueryPathElementMap(behaviorQueryPath);
        String customizeEntity = elementMap.get("customizeEntity");
        return Srl.is_NotNull_and_NotTrimmedEmpty((String)customizeEntity) ? customizeEntity : "";
    }

    public boolean hasBehaviorQueryPathParameterBean(String behaviorQueryPath) {
        return Srl.is_NotNull_and_NotTrimmedEmpty((String)this.getBehaviorQueryPathParameterBean(behaviorQueryPath));
    }

    public String getBehaviorQueryPathParameterBean(String behaviorQueryPath) {
        Map<String, String> elementMap = this.getBehaviorQueryPathElementMap(behaviorQueryPath);
        String parameterBean = elementMap.get("parameterBean");
        return Srl.is_NotNull_and_NotTrimmedEmpty((String)parameterBean) ? parameterBean : "";
    }

    public boolean hasBehaviorQueryPathCursor(String behaviorQueryPath) {
        return Srl.is_NotNull_and_NotTrimmedEmpty((String)this.getBehaviorQueryPathCursor(behaviorQueryPath));
    }

    public String getBehaviorQueryPathCursor(String behaviorQueryPath) {
        Map<String, String> elementMap = this.getBehaviorQueryPathElementMap(behaviorQueryPath);
        String cursor = elementMap.get("cursor");
        return Srl.is_NotNull_and_NotTrimmedEmpty((String)cursor) ? cursor : "";
    }

    public String getBehaviorQueryPathCursorForSchemaHtml(String behaviorQueryPath) {
        String cursor = this.getBehaviorQueryPathCursor(behaviorQueryPath);
        return Srl.is_NotNull_and_NotTrimmedEmpty((String)cursor) ? " *" + cursor : "";
    }

    public String getBehaviorQueryPathTitle(String behaviorQueryPath) {
        Map<String, String> elementMap = this.getBehaviorQueryPathElementMap(behaviorQueryPath);
        String title = elementMap.get("title");
        return Srl.is_NotNull_and_NotTrimmedEmpty((String)title) ? title : "";
    }

    public String getBehaviorQueryPathTitleForSchemaHtml(String behaviorQueryPath) {
        String title = this.getBehaviorQueryPathTitle(behaviorQueryPath);
        if (Srl.is_NotNull_and_NotTrimmedEmpty((String)title)) {
            DfDocumentProperties prop = this.getProperties().getDocumentProperties();
            title = prop.resolveTextForSchemaHtml(title);
            return "(" + title + ")";
        }
        return "&nbsp;";
    }

    public boolean hasBehaviorQueryPathDescription(String behaviorQueryPath) {
        return Srl.is_NotNull_and_NotTrimmedEmpty((String)this.getBehaviorQueryPathDescription(behaviorQueryPath));
    }

    public String getBehaviorQueryPathDescription(String behaviorQueryPath) {
        Map<String, String> elementMap = this.getBehaviorQueryPathElementMap(behaviorQueryPath);
        String description = elementMap.get("description");
        return Srl.is_NotNull_and_NotTrimmedEmpty((String)description) ? description : "";
    }

    public String getBehaviorQueryPathDescriptionForSchemaHtml(String behaviorQueryPath) {
        String description = this.getBehaviorQueryPathDescription(behaviorQueryPath);
        if (Srl.is_NotNull_and_NotTrimmedEmpty((String)description)) {
            DfDocumentProperties prop = this.getProperties().getDocumentProperties();
            description = prop.resolvePreTextForSchemaHtml(description);
            return description;
        }
        return "&nbsp;";
    }

    protected String ln() {
        return "\n";
    }

    public String toString() {
        Iterator<Object> iter;
        StringBuilder result = new StringBuilder();
        result.append("<table name=\"").append(this.getName()).append('\"');
        if (this._javaName != null) {
            result.append(" javaName=\"").append(this._javaName).append('\"');
        }
        result.append(">\n");
        if (this._columnList != null) {
            iter = this._columnList.iterator();
            while (iter.hasNext()) {
                result.append(iter.next());
            }
        }
        if (this._foreignKeys != null) {
            iter = this._foreignKeys.iterator();
            while (iter.hasNext()) {
                result.append(iter.next());
            }
        }
        if (this._idMethodParameters != null) {
            iter = this._idMethodParameters.iterator();
            while (iter.hasNext()) {
                result.append(iter.next());
            }
        }
        result.append("</table>\n");
        return result.toString();
    }

    public void doFinalInitialization() {
        this.doNaming();
    }

    private void doNaming() {
        try {
            String name;
            int i;
            int size = this._foreignKeys.size();
            for (i = 0; i < size; ++i) {
                ForeignKey fk = this._foreignKeys.get(i);
                name = fk.getName();
                if (!Srl.is_Null_or_Empty((String)name)) continue;
                name = this.acquireConstraintName("FK", i + 1);
                fk.setName(name);
            }
            size = this._indices.size();
            for (i = 0; i < size; ++i) {
                Index index = this._indices.get(i);
                name = index.getName();
                if (!Srl.is_Null_or_Empty((String)name)) continue;
                name = this.acquireConstraintName("I", i + 1);
                index.setName(name);
            }
        }
        catch (EngineException nameAlreadyInUse) {
            _log.error((Object)nameAlreadyInUse, (Throwable)((Object)nameAlreadyInUse));
        }
    }

    private final String acquireConstraintName(String nameType, int nbr) throws EngineException {
        ArrayList<Object> inputs = new ArrayList<Object>(4);
        inputs.add(this.getDatabase());
        inputs.add(this.getName());
        inputs.add(nameType);
        inputs.add(new Integer(nbr));
        return NameFactory.generateName(NameFactory.CONSTRAINT_GENERATOR, inputs);
    }

    public IdMethodParameter addIdMethodParameter(Attributes attrib) {
        IdMethodParameter imp = new IdMethodParameter();
        imp.loadFromXML(attrib);
        this.addIdMethodParameter(imp);
        return imp;
    }

    public void addIdMethodParameter(IdMethodParameter imp) {
        imp.setTable(this);
        if (this._idMethodParameters == null) {
            this._idMethodParameters = new ArrayList<IdMethodParameter>(2);
        }
        this._idMethodParameters.add(imp);
    }
}

