/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.sqlcommand;

import java.util.ArrayList;
import java.util.Arrays;
import javax.sql.DataSource;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.jdbc.StatementFactory;
import org.seasar.dbflute.s2dao.identity.TnIdentifierGenerator;
import org.seasar.dbflute.s2dao.metadata.TnBeanMetaData;
import org.seasar.dbflute.s2dao.metadata.TnPropertyType;
import org.seasar.dbflute.s2dao.sqlcommand.TnAbstractStaticCommand;
import org.seasar.dbflute.s2dao.sqlhandler.TnAbstractAutoHandler;

public abstract class TnAbstractAutoStaticCommand
extends TnAbstractStaticCommand {
    protected final DBMeta _targetDBMeta;
    protected TnPropertyType[] _propertyTypes;
    protected boolean _optimisticLockHandling;
    protected boolean _versionNoAutoIncrementOnMemory;

    public TnAbstractAutoStaticCommand(DataSource dataSource, StatementFactory statementFactory, TnBeanMetaData beanMetaData, DBMeta targetDBMeta, String[] propertyNames, boolean optimisticLockHandling, boolean versionNoAutoIncrementOnMemory) {
        super(dataSource, statementFactory, beanMetaData);
        this._targetDBMeta = targetDBMeta;
        this._optimisticLockHandling = optimisticLockHandling;
        this._versionNoAutoIncrementOnMemory = versionNoAutoIncrementOnMemory;
        this.setupPropertyTypes(propertyNames);
        this.setupSql();
    }

    public Object execute(Object[] args) {
        TnAbstractAutoHandler handler = this.createAutoHandler();
        handler.setOptimisticLockHandling(this._optimisticLockHandling);
        handler.setVersionNoAutoIncrementOnMemory(this._versionNoAutoIncrementOnMemory);
        handler.setSql(this.getSql());
        handler.setExceptionMessageSqlArgs(args);
        int rows = handler.execute(args);
        return rows;
    }

    protected TnPropertyType[] getPropertyTypes() {
        return this._propertyTypes;
    }

    protected void setPropertyTypes(TnPropertyType[] propertyTypes) {
        this._propertyTypes = propertyTypes;
    }

    protected abstract TnAbstractAutoHandler createAutoHandler();

    protected abstract void setupPropertyTypes(String[] var1);

    protected void setupInsertPropertyTypes(String[] propertyNames) {
        ArrayList<TnPropertyType> types = new ArrayList<TnPropertyType>();
        for (int i = 0; i < propertyNames.length; ++i) {
            TnPropertyType pt = this.getBeanMetaData().getPropertyType(propertyNames[i]);
            if (!this.isInsertTarget(pt)) continue;
            types.add(pt);
        }
        this._propertyTypes = types.toArray(new TnPropertyType[types.size()]);
    }

    protected boolean isInsertTarget(TnPropertyType propertyType) {
        if (propertyType.isPrimaryKey()) {
            String name = propertyType.getPropertyName();
            TnIdentifierGenerator generator = this.getBeanMetaData().getIdentifierGenerator(name);
            return generator.isSelfGenerate();
        }
        return true;
    }

    protected void setupUpdatePropertyTypes(String[] propertyNames) {
        ArrayList<TnPropertyType> types = new ArrayList<TnPropertyType>();
        for (int i = 0; i < propertyNames.length; ++i) {
            TnPropertyType pt = this.getBeanMetaData().getPropertyType(propertyNames[i]);
            if (pt.isPrimaryKey()) continue;
            types.add(pt);
        }
        if (types.size() == 0) {
            String msg = "The property type that is not primary key was not found:";
            msg = msg + " propertyNames=" + Arrays.asList(propertyNames);
            throw new IllegalStateException(msg);
        }
        this._propertyTypes = types.toArray(new TnPropertyType[types.size()]);
    }

    protected void setupDeletePropertyTypes(String[] propertyNames) {
    }

    protected abstract void setupSql();

    protected void setupInsertSql() {
        TnPropertyType pt;
        int i;
        StringBuilder sb = new StringBuilder(100);
        sb.append("insert into ");
        sb.append(this._targetDBMeta.getTableSqlName());
        sb.append(" (");
        for (i = 0; i < this._propertyTypes.length; ++i) {
            pt = this._propertyTypes[i];
            if (!this.isInsertTarget(pt)) continue;
            sb.append(pt.getColumnSqlName());
            sb.append(", ");
        }
        sb.setLength(sb.length() - 2);
        sb.append(") values (");
        for (i = 0; i < this._propertyTypes.length; ++i) {
            pt = this._propertyTypes[i];
            if (!this.isInsertTarget(pt)) continue;
            sb.append("?, ");
        }
        sb.setLength(sb.length() - 2);
        sb.append(")");
        this.setSql(sb.toString());
    }

    protected void setupUpdateSql() {
        this.checkPrimaryKey();
        StringBuilder sb = new StringBuilder(100);
        sb.append("update ");
        sb.append(this._targetDBMeta.getTableSqlName());
        sb.append(" set ");
        String versionNoPropertyName = this.getBeanMetaData().getVersionNoPropertyName();
        for (int i = 0; i < this._propertyTypes.length; ++i) {
            TnPropertyType pt = this._propertyTypes[i];
            if (pt.getPropertyName().equalsIgnoreCase(versionNoPropertyName) && !this._versionNoAutoIncrementOnMemory) {
                sb.append(pt.getColumnSqlName()).append(" = ").append(pt.getColumnSqlName()).append(" + 1, ");
                continue;
            }
            sb.append(pt.getColumnSqlName()).append(" = ?, ");
        }
        sb.setLength(sb.length() - 2);
        this.setupUpdateWhere(sb);
        this.setSql(sb.toString());
    }

    protected void setupDeleteSql() {
        this.checkPrimaryKey();
        StringBuilder sb = new StringBuilder(100);
        sb.append("delete from ");
        sb.append(this._targetDBMeta.getTableSqlName());
        this.setupUpdateWhere(sb);
        this.setSql(sb.toString());
    }

    protected void checkPrimaryKey() {
        TnBeanMetaData bmd = this.getBeanMetaData();
        if (bmd.getPrimaryKeySize() == 0) {
            String msg = "The primary key was not found:";
            msg = msg + " bean=" + bmd.getBeanClass();
            throw new IllegalStateException(msg);
        }
    }

    protected void setupUpdateWhere(StringBuilder sb) {
        TnBeanMetaData bmd = this.getBeanMetaData();
        sb.append(" where ");
        for (int i = 0; i < bmd.getPrimaryKeySize(); ++i) {
            sb.append(bmd.getPrimaryKeySqlName(i)).append(" = ? and ");
        }
        sb.setLength(sb.length() - 5);
        if (this._optimisticLockHandling && bmd.hasVersionNoPropertyType()) {
            TnPropertyType pt = bmd.getVersionNoPropertyType();
            sb.append(" and ").append(pt.getColumnSqlName()).append(" = ?");
        }
        if (this._optimisticLockHandling && bmd.hasTimestampPropertyType()) {
            TnPropertyType pt = bmd.getTimestampPropertyType();
            sb.append(" and ").append(pt.getColumnSqlName()).append(" = ?");
        }
    }
}

