/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.task;

import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.engine.EngineException;
import org.apache.torque.engine.database.model.AppData;
import org.apache.torque.engine.database.model.Column;
import org.apache.torque.engine.database.model.Database;
import org.apache.torque.engine.database.model.NameFactory;
import org.apache.torque.engine.database.model.Table;
import org.apache.torque.engine.database.model.TypeMap;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.seasar.dbflute.DfBuildProperties;
import org.seasar.dbflute.config.DfSpecifiedSqlFile;
import org.seasar.dbflute.exception.DfCustomizeEntityDuplicateException;
import org.seasar.dbflute.exception.DfParameterBeanDuplicateException;
import org.seasar.dbflute.exception.SQLFailureException;
import org.seasar.dbflute.friends.torque.DfSchemaXmlReader;
import org.seasar.dbflute.friends.velocity.DfVelocityContextFactory;
import org.seasar.dbflute.helper.StringKeyMap;
import org.seasar.dbflute.helper.jdbc.DfRunnerInformation;
import org.seasar.dbflute.helper.jdbc.determiner.DfJdbcDeterminer;
import org.seasar.dbflute.helper.jdbc.sqlfile.DfSqlFileFireMan;
import org.seasar.dbflute.helper.jdbc.sqlfile.DfSqlFileRunner;
import org.seasar.dbflute.helper.jdbc.sqlfile.DfSqlFileRunnerBase;
import org.seasar.dbflute.helper.language.DfLanguageDependencyInfo;
import org.seasar.dbflute.helper.language.grammar.DfGrammarInfo;
import org.seasar.dbflute.logic.bqp.DfBehaviorQueryPathSetupper;
import org.seasar.dbflute.logic.factory.DfJdbcDeterminerFactory;
import org.seasar.dbflute.logic.jdbc.handler.DfColumnHandler;
import org.seasar.dbflute.logic.jdbc.handler.DfProcedureHandler;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfColumnMetaInfo;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfProcedureColumnMetaInfo;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfProcedureMetaInfo;
import org.seasar.dbflute.logic.outsidesql.DfOutsideSqlMarkAnalyzer;
import org.seasar.dbflute.logic.outsidesql.DfSqlFileNameResolver;
import org.seasar.dbflute.logic.pkgresolver.DfStandardApiPackageResolver;
import org.seasar.dbflute.logic.pmb.DfParameterBeanMetaData;
import org.seasar.dbflute.properties.DfBasicProperties;
import org.seasar.dbflute.properties.DfCommonColumnProperties;
import org.seasar.dbflute.properties.DfLittleAdjustmentProperties;
import org.seasar.dbflute.properties.DfOutsideSqlProperties;
import org.seasar.dbflute.task.bs.DfAbstractTexenTask;
import org.seasar.dbflute.util.DfSqlStringUtil;
import org.seasar.dbflute.util.DfStringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfSql2EntityTask
extends DfAbstractTexenTask {
    private static final Log _log = LogFactory.getLog(DfSql2EntityTask.class);
    protected final Map<String, Map<String, DfColumnMetaInfo>> _entityInfoMap = new LinkedHashMap<String, Map<String, DfColumnMetaInfo>>();
    protected final Map<String, Object> _cursorInfoMap = new LinkedHashMap<String, Object>();
    protected final Map<String, DfParameterBeanMetaData> _pmbMetaDataMap = new LinkedHashMap<String, DfParameterBeanMetaData>();
    protected final Map<String, File> _entitySqlFileMap = new LinkedHashMap<String, File>();
    protected final Map<String, String> _exceptionInfoMap = new LinkedHashMap<String, String>();
    protected final Map<String, List<String>> _primaryKeyMap = new LinkedHashMap<String, List<String>>();
    protected DfColumnHandler _columnHandler = new DfColumnHandler();
    protected DfProcedureHandler _procedureHandler = new DfProcedureHandler();
    protected DfOutsideSqlMarkAnalyzer _markAnalyzer = new DfOutsideSqlMarkAnalyzer();
    protected AppData _schemaData;

    @Override
    protected boolean isUseDataSource() {
        return true;
    }

    @Override
    protected void doExecute() {
        this.setupControlTemplate();
        this.setupSchemaInformation();
        DfRunnerInformation runInfo = new DfRunnerInformation();
        runInfo.setDriver(this._driver);
        runInfo.setUrl(this._url);
        runInfo.setUser(this._userId);
        runInfo.setPassword(this._password);
        runInfo.setEncoding(this.getProperties().getOutsideSqlProperties().getSqlFileEncoding());
        DfSqlFileRunner runner = this.createSqlFileRunner(runInfo);
        DfSqlFileFireMan fireMan = new DfSqlFileFireMan();
        List<File> sqlFileList = this.getTargetSqlFileList();
        fireMan.execute(runner, sqlFileList);
        this.setupProcedure();
        this.fireVelocityProcess();
        this.setupBehaviorQueryPath();
        this.showTargetSqlFileInformation(sqlFileList);
        this.showSkippedFileInformation();
        this.handleNotFoundResult(sqlFileList);
        this.handleException();
        this.refreshResources();
    }

    protected void setupSchemaInformation() {
        DfSchemaXmlReader schemaFileReader = this.createSchemaFileReader();
        try {
            schemaFileReader.read();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        this._schemaData = schemaFileReader.getSchemaData();
    }

    protected DfSchemaXmlReader createSchemaFileReader() {
        String filePath = this.getBasicProperties().getProejctSchemaXMLFilePath();
        return new DfSchemaXmlReader(filePath, this.getProject(), this.getTargetDatabase());
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void setupControlTemplate() {
        DfLittleAdjustmentProperties littleProp = DfBuildProperties.getInstance().getLittleAdjustmentProperties();
        if (littleProp.isAlternateSql2EntityControlValid()) {
            _log.info((Object)"");
            _log.info((Object)"* * * * * * * * * * * * * * *");
            _log.info((Object)"* Process Alternate Control *");
            _log.info((Object)"* * * * * * * * * * * * * * *");
            String control = littleProp.getAlternateSql2EntityControl();
            _log.info((Object)("...Using alternate control: " + control));
            this.setControlTemplate(control);
            return;
        }
        if (!this.getBasicProperties().isTargetLanguageMain()) {
            String language = this.getBasicProperties().getTargetLanguage();
            _log.info((Object)"");
            _log.info((Object)"* * * * * * * * * *");
            _log.info((Object)("* Process " + language + "    *"));
            _log.info((Object)"* * * * * * * * * *");
            String control = "om/" + language + "/sql2entity-Control-" + language + ".vm";
            _log.info((Object)("...Using " + language + " control: " + control));
            this.setControlTemplate(control);
            return;
        }
        if (this.getBasicProperties().isTargetLanguageJava()) {
            _log.info((Object)"");
            _log.info((Object)"* * * * * * * * *");
            _log.info((Object)"* Process Java  *");
            _log.info((Object)"* * * * * * * * *");
            String control = "om/ControlSql2EntityJava.vm";
            _log.info((Object)"...Using Java control: om/ControlSql2EntityJava.vm");
            this.setControlTemplate("om/ControlSql2EntityJava.vm");
            return;
        }
        if (this.getBasicProperties().isTargetLanguageCSharp()) {
            _log.info((Object)"");
            _log.info((Object)"* * * * * * * * * *");
            _log.info((Object)"* Process CSharp  *");
            _log.info((Object)"* * * * * * * * * *");
            String control = "om/ControlSql2EntityCSharp.vm";
            _log.info((Object)"...Using CSharp control: om/ControlSql2EntityCSharp.vm");
            this.setControlTemplate("om/ControlSql2EntityCSharp.vm");
            return;
        }
        String msg = "Unknown Main Language: " + this.getBasicProperties().getTargetLanguage();
        throw new IllegalStateException(msg);
    }

    protected List<File> getTargetSqlFileList() {
        List<File> sqlFileList = this.collectSqlFileList();
        String specifiedSqlFile = DfSpecifiedSqlFile.getInstance().getSpecifiedSqlFile();
        if (specifiedSqlFile != null) {
            ArrayList<File> filteredList = new ArrayList<File>();
            for (File sqlFile : sqlFileList) {
                String fileName = sqlFile.getName();
                if (!specifiedSqlFile.equals(fileName)) continue;
                filteredList.add(sqlFile);
            }
            return filteredList;
        }
        return sqlFileList;
    }

    protected DfSqlFileRunner createSqlFileRunner(DfRunnerInformation runInfo) {
        final Log log4inner = _log;
        final DfJdbcDeterminer jdbcDeterminer = this.createJdbcDeterminer();
        final DfStandardApiPackageResolver packageResolver = new DfStandardApiPackageResolver(this.getBasicProperties());
        return new DfSqlFileRunnerBase(runInfo, this.getDataSource()){

            @Override
            protected String filterSql(String sql) {
                if (!jdbcDeterminer.isBlockCommentValid()) {
                    sql = DfSql2EntityTask.this.removeBlockComment(sql);
                }
                return super.filterSql(sql);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            protected void execSQL(String sql) {
                ResultSet rs;
                block20: {
                    DfParameterBeanMetaData parameterBeanMetaData;
                    rs = null;
                    boolean alreadyIncrementGoodSqlCount = false;
                    if (this.isTargetEntityMakingSql(sql)) {
                        String executedActuallySql = !jdbcDeterminer.isLineCommentValid() ? DfSql2EntityTask.this.removeLineComment(sql) : sql;
                        this.checkStatement(sql);
                        rs = this._currentStatement.executeQuery(executedActuallySql);
                        ++this._goodSqlCount;
                        alreadyIncrementGoodSqlCount = true;
                        Map<String, String> columnJavaNativeMap = this.createColumnJavaNativeMap(sql);
                        StringKeyMap columnJdbcTypeMap = StringKeyMap.createAsFlexibleOrdered();
                        ResultSetMetaData md = rs.getMetaData();
                        for (int i = 1; i <= md.getColumnCount(); ++i) {
                            DfColumnMetaInfo metaInfo = new DfColumnMetaInfo();
                            String sql2EntityRelatedTableName = null;
                            try {
                                sql2EntityRelatedTableName = md.getTableName(i);
                            }
                            catch (SQLException ignored) {
                                String msg = "ResultSetMetaData.getTableName(" + i + ") threw the exception:";
                                msg = msg + " " + ignored.getMessage();
                                _log.info((Object)msg);
                            }
                            metaInfo.setSql2EntityRelatedTableName(sql2EntityRelatedTableName);
                            String columnName = md.getColumnLabel(i);
                            String relatedColumnName = md.getColumnName(i);
                            metaInfo.setSql2EntityRelatedColumnName(relatedColumnName);
                            if (columnName == null || columnName.trim().length() == 0) {
                                columnName = relatedColumnName;
                            }
                            if (columnName == null || columnName.trim().length() == 0) {
                                String ln = this.ln();
                                String msg = "The columnName is invalid: columnName=" + columnName + ln;
                                msg = msg + "ResultSetMetaData returned invalid value." + ln;
                                msg = msg + "sql=" + sql;
                                throw new IllegalArgumentException(msg);
                            }
                            metaInfo.setColumnName(columnName);
                            int columnType = md.getColumnType(i);
                            metaInfo.setJdbcDefValue(columnType);
                            String columnTypeName = md.getColumnTypeName(i);
                            metaInfo.setDbTypeName(columnTypeName);
                            int columnSize = md.getPrecision(i);
                            if (!DfColumnHandler.isColumnSizeValid(columnSize)) {
                                columnSize = md.getColumnDisplaySize(i);
                            }
                            metaInfo.setColumnSize(columnSize);
                            int scale = md.getScale(i);
                            metaInfo.setDecimalDigits(scale);
                            String sql2entityForcedJavaNative = columnJavaNativeMap.get(columnName);
                            metaInfo.setSql2EntityForcedJavaNative(sql2entityForcedJavaNative);
                            columnJdbcTypeMap.put(columnName, metaInfo);
                        }
                        String entityName = DfSql2EntityTask.this.getCustomizeEntityName(sql);
                        if (entityName != null) {
                            entityName = DfSql2EntityTask.this.resolveEntityNameIfNeeds(entityName, this._sqlFile);
                            DfSql2EntityTask.this.assertDuplicateEntity(entityName, this._sqlFile);
                            DfSql2EntityTask.this._entityInfoMap.put(entityName, (Map<String, DfColumnMetaInfo>)columnJdbcTypeMap);
                            if (DfSql2EntityTask.this.isCursor(sql)) {
                                DfSql2EntityTask.this._cursorInfoMap.put(entityName, new Object());
                            }
                            DfSql2EntityTask.this._entitySqlFileMap.put(entityName, this._sqlFile);
                            DfSql2EntityTask.this._primaryKeyMap.put(entityName, DfSql2EntityTask.this.getPrimaryKeyColumnNameList(sql));
                        }
                    }
                    if (!this.isTargetParameterBeanMakingSql(sql)) break block20;
                    if (!alreadyIncrementGoodSqlCount) {
                        ++this._goodSqlCount;
                    }
                    if ((parameterBeanMetaData = this.extractParameterBeanMetaData(sql)) == null) break block20;
                    String pmbName = parameterBeanMetaData.getClassName();
                    DfSql2EntityTask.this.assertDuplicateParameterBean(pmbName, this._sqlFile);
                    DfSql2EntityTask.this._pmbMetaDataMap.put(pmbName, parameterBeanMetaData);
                }
                Object var19_24 = null;
                if (rs == null) return;
                try {
                    rs.close();
                    return;
                }
                catch (SQLException ignored) {
                    log4inner.warn((Object)("Ignored exception: " + ignored.getMessage()));
                }
                return;
                {
                    catch (SQLException e) {
                        if (!this._runInfo.isErrorContinue()) {
                            String msg = "Look! Read the message below." + this.ln();
                            msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.ln();
                            msg = msg + "It failed to execute the SQL!" + this.ln();
                            msg = msg + this.ln();
                            msg = msg + "[SQL File]" + this.ln() + this._sqlFile + this.ln();
                            msg = msg + this.ln();
                            msg = msg + "[Executed SQL]" + this.ln() + sql + this.ln();
                            msg = msg + this.ln();
                            msg = msg + "[SQLState]" + this.ln() + e.getSQLState() + this.ln();
                            msg = msg + this.ln();
                            msg = msg + "[ErrorCode]" + this.ln() + e.getErrorCode() + this.ln();
                            msg = msg + this.ln();
                            msg = msg + "[SQLException]" + this.ln() + e.getClass().getName() + this.ln();
                            msg = msg + e.getMessage() + this.ln();
                            SQLException nextException = e.getNextException();
                            if (nextException != null) {
                                msg = msg + this.ln();
                                msg = msg + "[NextException]" + this.ln() + nextException.getClass().getName() + this.ln();
                                msg = msg + nextException.getMessage() + this.ln();
                            }
                            msg = msg + "* * * * * * * * * */";
                            throw new SQLFailureException(msg, e);
                        }
                        _log.warn((Object)("Failed to execute: " + sql), (Throwable)e);
                        DfSql2EntityTask.this._exceptionInfoMap.put(this._sqlFile.getName(), e.getMessage() + this.ln() + sql);
                        Object var19_25 = null;
                        if (rs == null) return;
                        try {
                            rs.close();
                            return;
                        }
                        catch (SQLException ignored) {
                            log4inner.warn((Object)("Ignored exception: " + ignored.getMessage()));
                        }
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var19_26 = null;
                    if (rs == null) throw throwable;
                    try {
                        rs.close();
                        throw throwable;
                    }
                    catch (SQLException ignored) {
                        log4inner.warn((Object)("Ignored exception: " + ignored.getMessage()));
                    }
                    throw throwable;
                }
            }

            protected Map<String, String> createColumnJavaNativeMap(String sql) {
                List<String> entityPropertyTypeList = DfSql2EntityTask.this.getEntityPropertyTypeList(sql);
                StringKeyMap columnJavaNativeMap = StringKeyMap.createAsFlexible();
                for (String element : entityPropertyTypeList) {
                    String nameDelimiter = " ";
                    int nameDelimiterLength = " ".length();
                    int nameIndex = (element = element.trim()).lastIndexOf(" ");
                    if (nameIndex <= 0) {
                        String msg = "The customize entity element should be [typeName columnName].";
                        msg = msg + " But: element=" + element;
                        msg = msg + " srcFile=" + this._sqlFile;
                        throw new IllegalStateException(msg);
                    }
                    String typeName = this.resolvePackageName(element.substring(0, nameIndex).trim());
                    String columnName = element.substring(nameIndex + nameDelimiterLength).trim();
                    columnJavaNativeMap.put(columnName, typeName);
                }
                return columnJavaNativeMap;
            }

            protected boolean isTargetEntityMakingSql(String sql) {
                String entityName = DfSql2EntityTask.this.getCustomizeEntityName(sql);
                if (entityName == null) {
                    return false;
                }
                return !"df:x".equalsIgnoreCase(entityName);
            }

            protected boolean isTargetParameterBeanMakingSql(String sql) {
                String parameterBeanName = DfSql2EntityTask.this.getParameterBeanName(sql);
                return parameterBeanName != null;
            }

            protected DfParameterBeanMetaData extractParameterBeanMetaData(String sql) {
                String parameterBeanName = DfSql2EntityTask.this.getParameterBeanName(sql);
                if (parameterBeanName == null) {
                    return null;
                }
                DfParameterBeanMetaData pmbMetaData = new DfParameterBeanMetaData();
                String delimiter = "extends";
                int idx = parameterBeanName.indexOf("extends");
                String className = idx >= 0 ? parameterBeanName.substring(0, idx) : parameterBeanName;
                className = className.trim();
                className = DfSql2EntityTask.this.resolvePmbNameIfNeeds(className, this._sqlFile);
                pmbMetaData.setClassName(className);
                if (idx >= 0) {
                    String superClassName = parameterBeanName.substring(idx + "extends".length()).trim();
                    pmbMetaData.setSuperClassName(superClassName);
                    this.resolveSuperClassSimplePagingBean(pmbMetaData);
                }
                LinkedHashMap<String, String> propertyNameTypeMap = new LinkedHashMap<String, String>();
                LinkedHashMap<String, String> propertyNameOptionMap = new LinkedHashMap<String, String>();
                pmbMetaData.setPropertyNameTypeMap(propertyNameTypeMap);
                pmbMetaData.setPropertyNameOptionMap(propertyNameOptionMap);
                List<String> parameterBeanElement = DfSql2EntityTask.this.getParameterBeanPropertyTypeList(sql);
                for (String element : parameterBeanElement) {
                    String optionDef;
                    String propertyDef;
                    String nameDelimiter = " ";
                    String optionDelimiter = ":";
                    int optionIndex = (element = element.trim()).indexOf(":");
                    if (optionIndex > 0) {
                        propertyDef = element.substring(0, optionIndex).trim();
                        optionDef = element.substring(optionIndex + ":".length()).trim();
                    } else {
                        propertyDef = element;
                        optionDef = null;
                    }
                    int nameIndex = propertyDef.lastIndexOf(" ");
                    if (nameIndex <= 0) {
                        String msg = "The parameter bean element should be [typeName propertyName].";
                        msg = msg + " But: element=" + element + " srcFile=" + this._sqlFile;
                        throw new IllegalStateException(msg);
                    }
                    String typeName = this.resolvePackageName(propertyDef.substring(0, nameIndex).trim());
                    String propertyName = propertyDef.substring(nameIndex + " ".length()).trim();
                    propertyNameTypeMap.put(propertyName, typeName);
                    if (optionDef == null) continue;
                    propertyNameOptionMap.put(propertyName, optionDef);
                }
                pmbMetaData.setSqlFile(this._sqlFile);
                return pmbMetaData;
            }

            protected void resolveSuperClassSimplePagingBean(DfParameterBeanMetaData pmbMetaData) {
                if (pmbMetaData.getSuperClassName().equalsIgnoreCase("SPB")) {
                    String baseCommonPackage = DfSql2EntityTask.this.getBasicProperties().getBaseCommonPackage();
                    String projectPrefix = DfSql2EntityTask.this.getBasicProperties().getProjectPrefix();
                    DfBasicProperties basicProperties = DfSql2EntityTask.this.getProperties().getBasicProperties();
                    DfLanguageDependencyInfo languageDependencyInfo = basicProperties.getLanguageDependencyInfo();
                    String cbeanPackageName = languageDependencyInfo.getConditionBeanPackageName();
                    String spbName = "SimplePagingBean";
                    pmbMetaData.setSuperClassName(baseCommonPackage + "." + cbeanPackageName + "." + projectPrefix + "SimplePagingBean");
                }
            }

            protected String resolvePackageName(String typeName) {
                if (typeName == null) {
                    return typeName;
                }
                return packageResolver.resolvePackageName(typeName);
            }

            @Override
            protected String replaceCommentQuestionMarkIfNeeds(String line) {
                if (line.indexOf("--!!") >= 0 || line.indexOf("-- !!") >= 0) {
                    return line;
                }
                return super.replaceCommentQuestionMarkIfNeeds(line);
            }

            @Override
            protected boolean isTargetSql(String sql) {
                String entityName = DfSql2EntityTask.this.getCustomizeEntityName(sql);
                String parameterBeanClassDefinition = DfSql2EntityTask.this.getParameterBeanName(sql);
                if (parameterBeanClassDefinition == null && entityName != null && "df:x".equalsIgnoreCase(entityName)) {
                    return false;
                }
                return entityName != null || parameterBeanClassDefinition != null;
            }

            @Override
            protected void traceSql(String sql) {
                log4inner.info((Object)("{SQL}" + this.ln() + sql));
            }

            @Override
            protected void traceResult(int goodSqlCount, int totalSqlCount) {
                if (totalSqlCount > 0) {
                    _log.info((Object)("  --> success=" + goodSqlCount + " failure=" + (totalSqlCount - goodSqlCount)));
                } else {
                    _log.info((Object)"  --> SQL for sql2entity was Not Found in the SQL file!");
                }
            }

            @Override
            protected boolean isSqlTrimAndRemoveLineSeparator() {
                return false;
            }
        };
    }

    protected void assertDuplicateEntity(String entityName, File currentSqlFile) {
        File sqlFile = this._entitySqlFileMap.get(entityName);
        if (sqlFile == null) {
            return;
        }
        String msg = "Look! Read the message below." + this.ln();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.ln();
        msg = msg + "The customize entity was duplicated!" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Customize Entity]" + this.ln() + entityName + this.ln();
        msg = msg + this.ln();
        msg = msg + "[SQL Files]" + this.ln() + sqlFile + this.ln() + currentSqlFile + this.ln();
        msg = msg + "* * * * * * * * * */";
        throw new DfCustomizeEntityDuplicateException(msg);
    }

    protected void assertDuplicateParameterBean(String pmbName, File currentSqlFile) {
        DfParameterBeanMetaData metaData = this._pmbMetaDataMap.get(pmbName);
        if (metaData == null) {
            return;
        }
        String msg = "Look! Read the message below." + this.ln();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.ln();
        msg = msg + "The parameter-bean was duplicated!" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[ParameterBean]" + this.ln() + pmbName + this.ln();
        msg = msg + this.ln();
        msg = msg + "[SQL Files]" + this.ln() + metaData.getSqlFile() + this.ln() + currentSqlFile + this.ln();
        msg = msg + "* * * * * * * * * */";
        throw new DfParameterBeanDuplicateException(msg);
    }

    protected void handleNotFoundResult(List<File> sqlFileList) {
        if (this._entityInfoMap.isEmpty() && this._pmbMetaDataMap.isEmpty()) {
            _log.warn((Object)"/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *");
            _log.warn((Object)"SQL for sql2entity was not found!");
            _log.warn((Object)"");
            _log.warn((Object)("SQL Files: " + sqlFileList.size()));
            int index = 0;
            for (File file : sqlFileList) {
                _log.warn((Object)("  " + ++index + " -- " + file));
            }
            _log.warn((Object)"* * * * * * * * * */");
            _log.warn((Object)" ");
        }
    }

    protected void handleException() {
        if (this._exceptionInfoMap.isEmpty()) {
            return;
        }
        Set<String> nameSet = this._exceptionInfoMap.keySet();
        StringBuilder sb = new StringBuilder();
        String lineSeparator = System.getProperty("line.separator");
        for (String name : nameSet) {
            String exceptionInfo = this._exceptionInfoMap.get(name);
            sb.append(lineSeparator);
            sb.append("[" + name + "]");
            sb.append(exceptionInfo);
        }
        _log.warn((Object)" ");
        _log.warn((Object)"/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *");
        _log.warn((Object)sb.toString());
        _log.warn((Object)"* * * * * * * * * */");
        _log.warn((Object)" ");
    }

    protected String getCustomizeEntityName(String sql) {
        return this._markAnalyzer.getCustomizeEntityName(sql);
    }

    protected boolean isCursor(String sql) {
        return this._markAnalyzer.isCursor(sql);
    }

    protected List<String> getEntityPropertyTypeList(String sql) {
        return this._markAnalyzer.getCustomizeEntityPropertyTypeList(sql);
    }

    protected String getParameterBeanName(String sql) {
        return this._markAnalyzer.getParameterBeanName(sql);
    }

    protected List<String> getParameterBeanPropertyTypeList(String sql) {
        return this._markAnalyzer.getParameterBeanPropertyTypeList(sql);
    }

    protected List<String> getPrimaryKeyColumnNameList(String sql) {
        return this._markAnalyzer.getPrimaryKeyColumnNameList(sql);
    }

    protected String removeBlockComment(String sql) {
        return DfSqlStringUtil.removeBlockComment((String)sql);
    }

    protected String removeLineComment(String sql) {
        return DfSqlStringUtil.removeLineComment((String)sql);
    }

    protected String resolveEntityNameIfNeeds(String className, File file) {
        return new DfSqlFileNameResolver().resolveEntityNameIfNeeds(className, file.getName());
    }

    protected String resolvePmbNameIfNeeds(String className, File file) {
        return new DfSqlFileNameResolver().resolvePmbNameIfNeeds(className, file.getName());
    }

    protected void setupProcedure() {
        try {
            this.doSetupProcedure();
        }
        catch (SQLException ignored) {
            _log.info((Object)"/* * * * * * * * * * * * * * * * * * * * * * * * *");
            _log.info((Object)ignored.getMessage());
            _log.info((Object)"* * * * * * * * * */");
        }
    }

    protected void doSetupProcedure() throws SQLException {
        DfOutsideSqlProperties outsideSqlProperties = this.getProperties().getOutsideSqlProperties();
        if (!outsideSqlProperties.isGenerateProcedureParameterBean()) {
            return;
        }
        _log.info((Object)" ");
        _log.info((Object)"...Setting up procedures for generating parameter-beans");
        Map<String, DfProcedureMetaInfo> procedureMap = this.getAvailableProcedureMap();
        Set<Map.Entry<String, DfProcedureMetaInfo>> entrySet = procedureMap.entrySet();
        _log.info((Object)"/= = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =");
        HashMap<String, DfProcedureMetaInfo> procdureHandlingMap = new HashMap<String, DfProcedureMetaInfo>();
        for (Map.Entry<String, DfProcedureMetaInfo> entry : entrySet) {
            String procedureUniqueName = entry.getKey();
            DfProcedureMetaInfo metaInfo = entry.getValue();
            DfParameterBeanMetaData parameterBeanMetaData = new DfParameterBeanMetaData();
            LinkedHashMap<String, String> propertyNameTypeMap = new LinkedHashMap<String, String>();
            LinkedHashMap<String, String> propertyNameOptionMap = new LinkedHashMap<String, String>();
            LinkedHashMap<String, String> propertyNameColumnNameMap = new LinkedHashMap<String, String>();
            List<DfProcedureColumnMetaInfo> procedureColumnMetaInfoList = metaInfo.getProcedureColumnMetaInfoList();
            int index = 0;
            String pmbName = this.convertProcedureNameToPmbName(procedureUniqueName);
            String procedureSqlName = metaInfo.getProcedureSqlName();
            _log.info((Object)("[" + pmbName + "]: " + procedureSqlName + " // " + (Object)((Object)metaInfo.getProcedureType())));
            if (procedureColumnMetaInfoList.isEmpty()) {
                _log.info((Object)"    *No Parameter");
            }
            for (DfProcedureColumnMetaInfo columnMetaInfo : procedureColumnMetaInfoList) {
                String columnName = columnMetaInfo.getColumnName();
                if (columnName == null || columnName.trim().length() == 0) {
                    columnName = "arg" + (index + 1);
                }
                columnName = this.filterColumnNameAboutVendorDependency(columnName);
                String propertyName = this.convertColumnNameToPropertyName(columnName);
                String propertyType = this.getProcedureColumnPropertyType(columnMetaInfo);
                propertyNameTypeMap.put(propertyName, propertyType);
                DfProcedureColumnMetaInfo.DfProcedureColumnType procedureColumnType = columnMetaInfo.getProcedureColumnType();
                propertyNameOptionMap.put(propertyName, procedureColumnType.toString());
                propertyNameColumnNameMap.put(propertyName, columnName);
                String msg = "    " + propertyType + " " + propertyName + ";";
                msg = msg + " // " + (Object)((Object)columnMetaInfo.getProcedureColumnType());
                msg = msg + "(" + columnMetaInfo.getJdbcType() + ", " + columnMetaInfo.getDbTypeName() + ")";
                _log.info((Object)msg);
                ++index;
            }
            parameterBeanMetaData.setClassName(pmbName);
            parameterBeanMetaData.setPropertyNameTypeMap(propertyNameTypeMap);
            parameterBeanMetaData.setPropertyNameOptionMap(propertyNameOptionMap);
            parameterBeanMetaData.setPropertyNameColumnNameMap(propertyNameColumnNameMap);
            parameterBeanMetaData.setProcedureName(procedureSqlName);
            this._pmbMetaDataMap.put(pmbName, parameterBeanMetaData);
            procdureHandlingMap.put(pmbName, metaInfo);
        }
        _log.info((Object)"= = = = = = = = = =/");
        _log.info((Object)" ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, DfProcedureMetaInfo> getAvailableProcedureMap() throws SQLException {
        Map<String, DfProcedureMetaInfo> map;
        block2: {
            Connection conn = null;
            try {
                conn = this.getDataSource().getConnection();
                DatabaseMetaData metaData = conn.getMetaData();
                this._procedureHandler.includeProcedureSynonym(this.getDataSource());
                map = this._procedureHandler.getAvailableProcedureMap(metaData);
                Object var5_4 = null;
                if (conn == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var5_5 = null;
                    if (conn == null) break block3;
                    conn.close();
                }
                throw throwable;
            }
            conn.close();
        }
        return map;
    }

    protected String getProcedureColumnPropertyType(DfProcedureColumnMetaInfo procedureColumnMetaInfo) {
        String propertyType;
        if (this.isResultSetProperty(procedureColumnMetaInfo)) {
            DfGrammarInfo grammarInfo = this.getBasicProperties().getLanguageDependencyInfo().getGrammarInfo();
            propertyType = grammarInfo.getGenericMapListClassName("String", "Object");
        } else {
            int jdbcType = procedureColumnMetaInfo.getJdbcType();
            String dbTypeName = procedureColumnMetaInfo.getDbTypeName();
            Integer columnSize = procedureColumnMetaInfo.getColumnSize();
            Integer decimalDigits = procedureColumnMetaInfo.getDecimalDigits();
            if (this.getBasicProperties().isDatabaseOracle() && "number".equalsIgnoreCase(dbTypeName)) {
                propertyType = TypeMap.getDefaultDecimalJavaNativeType();
            } else {
                String torqueType = this._columnHandler.getColumnJdbcType(jdbcType, dbTypeName);
                propertyType = TypeMap.findJavaNativeByJdbcType(torqueType, columnSize, decimalDigits);
            }
        }
        return propertyType;
    }

    protected boolean isResultSetProperty(DfProcedureColumnMetaInfo procedureColumnMetaInfo) {
        int jdbcType = procedureColumnMetaInfo.getJdbcType();
        String dbTypeName = procedureColumnMetaInfo.getDbTypeName();
        if (this.getBasicProperties().isDatabaseOracle()) {
            return jdbcType == 1111 && dbTypeName != null && dbTypeName.toLowerCase().contains("cursor");
        }
        if (this.getBasicProperties().isDatabasePostgreSQL()) {
            return jdbcType == 1111 && dbTypeName != null && dbTypeName.toLowerCase().contains("refcursor");
        }
        return false;
    }

    protected String convertProcedureNameToPmbName(String procedureUniqueName) {
        boolean allUpperCase;
        procedureUniqueName = this.replaceString(procedureUniqueName, ".", "_");
        procedureUniqueName = (procedureUniqueName = this.filterProcedureName4PmbNameAboutVendorDependency(procedureUniqueName)).contains("_") ? this.generateCapitalisedJavaName(procedureUniqueName.toUpperCase()) : StringUtils.capitalise((String)((allUpperCase = this.isAllUpperCase(procedureUniqueName)) ? procedureUniqueName.toLowerCase() : procedureUniqueName));
        return procedureUniqueName + "Pmb";
    }

    protected String filterProcedureName4PmbNameAboutVendorDependency(String procedureName) {
        if (this.getBasicProperties().isDatabaseSqlServer() && procedureName.contains(";")) {
            procedureName = procedureName.substring(0, procedureName.indexOf(";"));
        }
        return procedureName;
    }

    protected String filterColumnNameAboutVendorDependency(String columnName) {
        if (this.getBasicProperties().isDatabaseSqlServer() && columnName.startsWith("@")) {
            columnName = columnName.substring("@".length());
        }
        return columnName;
    }

    protected String convertColumnNameToPropertyName(String columnName) {
        boolean allUpperCase;
        columnName = columnName.contains("_") ? this.generateUncapitalisedJavaName(columnName.toUpperCase()) : StringUtils.uncapitalise((String)((allUpperCase = this.isAllUpperCase(columnName)) ? columnName.toLowerCase() : columnName));
        return columnName;
    }

    protected boolean isAllUpperCase(String name) {
        char[] charArray = name.toCharArray();
        boolean allUpperCase = true;
        for (char ch : charArray) {
            if (!Character.isLowerCase(ch)) continue;
            allUpperCase = false;
            break;
        }
        return allUpperCase;
    }

    protected String generateUncapitalisedJavaName(String name) {
        return StringUtils.uncapitalise((String)NameFactory.generateJavaNameByMethodUnderscore(name));
    }

    protected String generateCapitalisedJavaName(String name) {
        return StringUtils.capitalise((String)NameFactory.generateJavaNameByMethodUnderscore(name));
    }

    protected void setupBehaviorQueryPath() {
        List<File> sqlFileList = this.collectSqlFileList();
        DfBehaviorQueryPathSetupper setupper = new DfBehaviorQueryPathSetupper(this.getProperties());
        setupper.setupBehaviorQueryPath(sqlFileList);
    }

    public Context initControlContext() throws Exception {
        Database database = new Database();
        database.setSql2EntitySchemaData(this._schemaData);
        database.setPmbMetaDataMap(this._pmbMetaDataMap);
        database.setSkipDeleteOldClass(DfSpecifiedSqlFile.getInstance().getSpecifiedSqlFile() != null);
        Set<String> entityNameSet = this._entityInfoMap.keySet();
        for (String entityName : entityNameSet) {
            Map<String, DfColumnMetaInfo> columnJdbcTypeMap = this._entityInfoMap.get(entityName);
            Table tbl = new Table();
            tbl.setName(entityName);
            tbl.setupNeedsJavaNameConvertFalse();
            tbl.setSql2EntityTypeSafeCursor(this._cursorInfoMap.get(entityName) != null);
            database.addTable(tbl);
            _log.info((Object)(entityName + " --> " + tbl.getName() + " : " + tbl.getJavaName() + " : " + tbl.getUncapitalisedJavaName()));
            boolean allCommonColumn = this.hasAllCommonColumn(columnJdbcTypeMap);
            Set<String> columnNameSet = columnJdbcTypeMap.keySet();
            for (String columnName : columnNameSet) {
                Column column = new Column();
                this.setupColumnName(columnName, column);
                this.setupPrimaryKey(entityName, columnName, column);
                this.setupTorqueType(columnJdbcTypeMap, columnName, column, allCommonColumn);
                this.setupDbType(columnJdbcTypeMap, columnName, column);
                this.setupColumnSizeContainsDigit(columnJdbcTypeMap, columnName, column);
                this.setupColumnComment(columnJdbcTypeMap, columnName, column);
                this.setupSql2EntityRelatedTableName(columnJdbcTypeMap, columnName, column);
                this.setupSql2EntityRelatedColumnName(columnJdbcTypeMap, columnName, column);
                this.setupSql2EntityForcedJavaNative(columnJdbcTypeMap, columnName, column);
                tbl.addColumn(column);
                _log.info((Object)("   " + (column.isPrimaryKey() ? "*" : " ") + columnName + " --> " + column.getName() + " : " + column.getJavaName() + " : " + column.getUncapitalisedJavaName()));
            }
            _log.info((Object)"");
        }
        String databaseType = this.getBasicProperties().getDatabaseType();
        AppData appData = new AppData(databaseType);
        appData.addDatabase(database);
        VelocityContext context = this.createVelocityContext(appData);
        return context;
    }

    protected boolean hasAllCommonColumn(Map<String, DfColumnMetaInfo> columnJdbcTypeMap) {
        Map<String, String> commonColumnMap = this.getCommonColumnMap();
        if (commonColumnMap.isEmpty()) {
            return false;
        }
        Set<String> commonColumnSet = commonColumnMap.keySet();
        for (String commonColumnName : commonColumnSet) {
            if (columnJdbcTypeMap.containsKey(commonColumnName)) continue;
            return false;
        }
        return true;
    }

    protected void setupColumnName(String columnName, Column col) {
        if (this.needsConvert(columnName)) {
            col.setName(columnName);
        } else {
            col.setupNeedsJavaNameConvertFalse();
            if (columnName.length() > 1) {
                col.setName(columnName.substring(0, 1).toUpperCase() + columnName.substring(1));
            } else {
                col.setName(columnName.toUpperCase());
            }
        }
    }

    protected void setupPrimaryKey(String entityName, String columnName, Column col) {
        List<String> primaryKeyList = this._primaryKeyMap.get(entityName);
        col.setPrimaryKey(primaryKeyList.contains(columnName));
    }

    protected void setupTorqueType(Map<String, DfColumnMetaInfo> columnJdbcTypeMap, String columnName, Column column, boolean allCommonColumn) {
        String commonColumnTorqueType;
        if (allCommonColumn && (commonColumnTorqueType = this.getCommonColumnTorqueType(columnName)) != null) {
            column.setJdbcType(commonColumnTorqueType);
            return;
        }
        DfColumnMetaInfo columnMetaInfo = columnJdbcTypeMap.get(columnName);
        String columnTorqueType = this.getColumnTorqueType(columnMetaInfo);
        column.setJdbcType(columnTorqueType);
    }

    protected void setupDbType(Map<String, DfColumnMetaInfo> columnJdbcTypeMap, String columnName, Column column) {
        DfColumnMetaInfo columnMetaInfo = columnJdbcTypeMap.get(columnName);
        column.setDbType(columnMetaInfo.getDbTypeName());
    }

    protected String getCommonColumnTorqueType(String columnName) {
        return this.getCommonColumnMap().get(columnName);
    }

    protected Map<String, String> getCommonColumnMap() {
        DfCommonColumnProperties prop = this.getProperties().getCommonColumnProperties();
        return prop.getCommonColumnMap();
    }

    protected String getColumnTorqueType(DfColumnMetaInfo columnMetaInfo) {
        return this._columnHandler.getColumnJdbcType(columnMetaInfo);
    }

    protected void setupColumnSizeContainsDigit(Map<String, DfColumnMetaInfo> columnJdbcTypeMap, String columnName, Column column) {
        DfColumnMetaInfo metaInfo = columnJdbcTypeMap.get(columnName);
        int columnSize = metaInfo.getColumnSize();
        int decimalDigits = metaInfo.getDecimalDigits();
        column.setupColumnSize(columnSize, decimalDigits);
    }

    protected void setupColumnComment(Map<String, DfColumnMetaInfo> columnJdbcTypeMap, String columnName, Column column) {
        DfColumnMetaInfo metaInfo = columnJdbcTypeMap.get(columnName);
        String sql2EntityRelatedTableName = metaInfo.getSql2EntityRelatedTableName();
        Table relatedTable = this.getRelatedTable(sql2EntityRelatedTableName);
        if (relatedTable == null) {
            return;
        }
        String relatedColumnName = metaInfo.getSql2EntityRelatedColumnName();
        Column relatedColumn = relatedTable.getColumn(relatedColumnName);
        if (relatedColumn == null) {
            return;
        }
        String plainComment = relatedColumn.getPlainComment();
        column.setPlainComment(plainComment);
    }

    protected void setupSql2EntityRelatedTableName(Map<String, DfColumnMetaInfo> columnJdbcTypeMap, String columnName, Column column) {
        DfColumnMetaInfo metaInfo = columnJdbcTypeMap.get(columnName);
        String sql2EntityRelatedTableName = metaInfo.getSql2EntityRelatedTableName();
        Table relatedTable = this.getRelatedTable(sql2EntityRelatedTableName);
        if (relatedTable == null) {
            return;
        }
        column.setSql2EntityRelatedTableName(sql2EntityRelatedTableName);
    }

    protected void setupSql2EntityRelatedColumnName(Map<String, DfColumnMetaInfo> columnJdbcTypeMap, String columnName, Column column) {
        DfColumnMetaInfo metaInfo = columnJdbcTypeMap.get(columnName);
        String sql2EntityRelatedTableName = metaInfo.getSql2EntityRelatedTableName();
        Table relatedTable = this.getRelatedTable(sql2EntityRelatedTableName);
        if (relatedTable == null) {
            return;
        }
        String sql2EntityRelatedColumnName = metaInfo.getSql2EntityRelatedColumnName();
        Column relatedColumn = relatedTable.getColumn(sql2EntityRelatedColumnName);
        if (relatedColumn == null) {
            return;
        }
        column.setSql2EntityRelatedColumnName(sql2EntityRelatedColumnName);
    }

    protected Table getRelatedTable(String sql2EntityRelatedTableName) {
        Table relatedTable;
        if (this._schemaData == null) {
            return null;
        }
        try {
            relatedTable = this._schemaData.getDatabase().getTable(sql2EntityRelatedTableName);
        }
        catch (EngineException e) {
            String msg = "Failed to get database information: schemaData=" + this._schemaData;
            throw new IllegalStateException(msg);
        }
        return relatedTable;
    }

    protected void setupSql2EntityForcedJavaNative(Map<String, DfColumnMetaInfo> columnJdbcTypeMap, String columnName, Column column) {
        DfColumnMetaInfo metaInfo = columnJdbcTypeMap.get(columnName);
        String sql2EntityForcedJavaNative = metaInfo.getSql2EntityForcedJavaNative();
        column.setSql2EntityForcedJavaNative(sql2EntityForcedJavaNative);
    }

    protected VelocityContext createVelocityContext(AppData appData) {
        DfVelocityContextFactory factory = new DfVelocityContextFactory();
        return factory.create(appData);
    }

    protected boolean needsConvert(String columnName) {
        if (columnName == null || columnName.trim().length() == 0) {
            String msg = "The columnName is invalid: " + columnName;
            throw new IllegalArgumentException(msg);
        }
        if (columnName.indexOf("_") < 0) {
            char[] columnCharArray;
            for (char ch : columnCharArray = columnName.toCharArray()) {
                if (Character.isDigit(ch) || Character.isUpperCase(ch)) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    protected DfJdbcDeterminer createJdbcDeterminer() {
        return new DfJdbcDeterminerFactory(this.getBasicProperties()).createJdbcDeterminer();
    }

    public String replaceString(String text, String fromText, String toText) {
        return DfStringUtil.replace((String)text, (String)fromText, (String)toText);
    }

    public String getSlashPath(File file) {
        return this.replaceString(file.getPath(), this.getFileSeparator(), "/");
    }

    public String getFileSeparator() {
        return File.separator;
    }

    public void setSpecifiedSqlFile(String specifiedSqlFile) {
        DfSpecifiedSqlFile.getInstance().setSpecifiedSqlFile(specifiedSqlFile);
    }
}

