/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.pmb;

import java.util.List;
import org.apache.torque.engine.EngineException;
import org.apache.torque.engine.database.model.AppData;
import org.apache.torque.engine.database.model.Column;
import org.apache.torque.engine.database.model.Database;
import org.apache.torque.engine.database.model.Table;
import org.seasar.dbflute.exception.DfParameterBeanReferenceColumnNotFoundException;
import org.seasar.dbflute.exception.DfParameterBeanReferenceTableNotFoundException;
import org.seasar.dbflute.logic.pmb.PmbMetaDataPropertyOptionFinder;
import org.seasar.dbflute.util.DfSystemUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PmbMetaDataPropertyOptionReference {
    protected static final String OPTION_PREFIX = "ref(";
    protected static final String OPTION_SUFFIX = ")";
    protected String _className;
    protected String _propertyName;
    protected PmbMetaDataPropertyOptionFinder _pmbMetaDataPropertyOptionFinder;

    public PmbMetaDataPropertyOptionReference(String className, String propertyName, PmbMetaDataPropertyOptionFinder pmbMetaDataPropertyOptionFinder) {
        this._className = className;
        this._propertyName = propertyName;
        this._pmbMetaDataPropertyOptionFinder = pmbMetaDataPropertyOptionFinder;
    }

    public Column getPmbMetaDataPropertyOptionReferenceColumn(AppData appData) {
        Column column;
        String columnName;
        String tableName;
        String value;
        Database database;
        if (appData == null) {
            return null;
        }
        try {
            database = appData.getDatabase();
        }
        catch (EngineException e) {
            throw new IllegalStateException((Throwable)((Object)e));
        }
        if (database == null) {
            return null;
        }
        String refPrefix = OPTION_PREFIX;
        String refSuffix = OPTION_SUFFIX;
        String option = this.getPmbMetaDataPropertyOption();
        if (option == null) {
            return null;
        }
        List<String> splitOption = this.splitOption(option);
        String firstOption = null;
        for (String element : splitOption) {
            if (!(element = element.trim()).startsWith(OPTION_PREFIX) || !element.endsWith(OPTION_SUFFIX)) continue;
            firstOption = element;
            break;
        }
        if (firstOption == null) {
            return null;
        }
        option = firstOption;
        int clsIdx = OPTION_PREFIX.length();
        int clsEndIdx = option.length() - OPTION_SUFFIX.length();
        try {
            value = option.substring(OPTION_PREFIX.length(), option.length() - OPTION_SUFFIX.length()).trim();
        }
        catch (StringIndexOutOfBoundsException e) {
            String msg = "Look the message below:" + this.ln();
            msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * " + this.ln();
            msg = msg + "IndexOutOfBounds ocurred:" + this.ln();
            msg = msg + " " + this._className + " " + this._propertyName;
            msg = msg + ":" + option + this.ln();
            msg = msg + "{" + option + "}.substring(" + clsIdx + ", " + clsEndIdx + OPTION_SUFFIX + this.ln();
            msg = msg + "* * * * * * * * * */";
            throw new IllegalStateException(msg, e);
        }
        int delimiterIndex = value.indexOf(".");
        if (delimiterIndex < 0) {
            tableName = value;
            columnName = null;
        } else {
            tableName = value.substring(0, delimiterIndex);
            columnName = value.substring(delimiterIndex + ".".length());
        }
        Table table = database.getTable(tableName);
        if (table == null) {
            this.throwParameterBeanReferenceTableNotFoundException(this._className, this._propertyName, tableName);
        }
        if ((column = columnName != null ? table.getColumn(columnName) : table.getColumn(this._propertyName)) == null) {
            this.throwParameterBeanReferenceColumnNotFoundException(this._className, this._propertyName, tableName, columnName);
        }
        return column;
    }

    protected void throwParameterBeanReferenceTableNotFoundException(String className, String propertyName, String tableName) {
        String msg = "Look! Read the message below." + this.ln();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.ln();
        msg = msg + "The reference table was not found!" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Advice]" + this.ln();
        msg = msg + "Please confirm the table existence." + this.ln();
        msg = msg + this.ln();
        msg = msg + "[ParameterBean]" + this.ln() + className + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Property]" + this.ln() + propertyName + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Not Found Table]" + this.ln() + tableName + this.ln();
        msg = msg + "* * * * * * * * * */";
        throw new DfParameterBeanReferenceTableNotFoundException(msg);
    }

    protected void throwParameterBeanReferenceColumnNotFoundException(String className, String propertyName, String tableName, String columnName) {
        String msg = "Look! Read the message below." + this.ln();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.ln();
        msg = msg + "The reference column was not found!" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Advice]" + this.ln();
        msg = msg + "Please confirm the column existence." + this.ln();
        msg = msg + this.ln();
        msg = msg + "[ParameterBean]" + this.ln() + className + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Property]" + this.ln() + propertyName + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Table]" + this.ln() + tableName + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Column]" + this.ln() + columnName + this.ln();
        msg = msg + "* * * * * * * * * */";
        throw new DfParameterBeanReferenceColumnNotFoundException(msg);
    }

    protected String getPmbMetaDataPropertyOption() {
        return this._pmbMetaDataPropertyOptionFinder.findPmbMetaDataPropertyOption(this._className, this._propertyName);
    }

    protected List<String> splitOption(String option) {
        return PmbMetaDataPropertyOptionFinder.splitOption(option);
    }

    protected String ln() {
        return DfSystemUtil.getLineSeparator();
    }
}

