/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.helper.dataset;

import java.util.ArrayList;
import java.util.List;
import org.seasar.dbflute.helper.dataset.DfDataColumn;
import org.seasar.dbflute.helper.dataset.DfDataTable;
import org.seasar.dbflute.helper.dataset.states.DfDtsRowState;
import org.seasar.dbflute.helper.dataset.states.DfDtsRowStates;
import org.seasar.dbflute.helper.dataset.types.DfDtsColumnType;
import org.seasar.dbflute.helper.dataset.types.DfDtsColumnTypes;

public class DfDataRow {
    private DfDataTable _table;
    private List<Object> _values = new ArrayList<Object>();
    private DfDtsRowState _state = DfDtsRowStates.UNCHANGED;

    public DfDataRow(DfDataTable table) {
        this._table = table;
    }

    public Object getValue(int index) {
        return this._values.get(index);
    }

    public Object getValue(String columnName) {
        DfDataColumn column = this._table.getColumn(columnName);
        return this._values.get(column.getColumnIndex());
    }

    public void addValue(String columnName, Object value) {
        DfDataColumn column = this._table.getColumn(columnName);
        this._values.add(column.convert(value));
        this.modify();
    }

    private void modify() {
        if (this._state.equals(DfDtsRowStates.UNCHANGED)) {
            this._state = DfDtsRowStates.MODIFIED;
        }
    }

    public void remove() {
        this._state = DfDtsRowStates.REMOVED;
    }

    public DfDataTable getTable() {
        return this._table;
    }

    public DfDtsRowState getState() {
        return this._state;
    }

    public void setState(DfDtsRowState state) {
        this._state = state;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(100);
        buf.append("{");
        for (int i = 0; i < this._values.size(); ++i) {
            buf.append(this.getValue(i));
            buf.append(", ");
        }
        buf.setLength(buf.length() - 2);
        buf.append('}');
        return buf.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DfDataRow)) {
            return false;
        }
        DfDataRow other = (DfDataRow)o;
        for (int i = 0; i < this._table.getColumnSize(); ++i) {
            String columnName = this._table.getColumnName(i);
            Object value = this._values.get(i);
            Object otherValue = other.getValue(columnName);
            DfDtsColumnType ct = DfDtsColumnTypes.getColumnType(value);
            if (ct.equals(value, otherValue)) continue;
            return false;
        }
        return true;
    }
}

