/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.friends.torque;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.engine.database.model.Column;
import org.apache.torque.engine.database.model.Database;
import org.apache.torque.engine.database.model.ForeignKey;
import org.apache.torque.engine.database.model.Table;
import org.seasar.dbflute.DfBuildProperties;
import org.seasar.dbflute.properties.DfAdditionalForeignKeyProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfAdditionalForeignKeyInitializer {
    private static final Log _log = LogFactory.getLog(DfAdditionalForeignKeyInitializer.class);
    protected Database _database;

    public DfAdditionalForeignKeyInitializer(Database database) {
        this._database = database;
    }

    public void initializeAdditionalForeignKey() {
        _log.info((Object)"/=======================================");
        _log.info((Object)"...Initializing additional foreign keys.");
        Map<String, Map<String, String>> additionalForeignKeyMap = this.getAdditionalForeignKeyMap();
        Set<String> foreignKeyNameKeySet = additionalForeignKeyMap.keySet();
        for (String foreignKeyName : foreignKeyNameKeySet) {
            String foreignTableName = this.getForeignTableName(foreignKeyName);
            this.assertForeignTable(foreignTableName);
            List<String> foreignColumnNameList = this.getForeignColumnNameList(foreignKeyName, foreignTableName);
            this.assertForeignTableColumn(foreignTableName, foreignColumnNameList);
            String localTableName = this.getLocalTableName(foreignKeyName);
            String fixedCondition = this.getFixedCondition(foreignKeyName);
            String fixedSuffix = this.getFixedSuffix(foreignKeyName);
            _log.info((Object)foreignKeyName);
            if (localTableName.equals("*")) {
                this.processAllTableFK(foreignKeyName, foreignTableName, foreignColumnNameList, fixedCondition, fixedSuffix);
                continue;
            }
            this.assertLocalTable(localTableName);
            Table table = this.getTable(localTableName);
            List<String> localColumnNameList = this.getLocalColumnNameList(foreignKeyName, foreignTableName, foreignColumnNameList, localTableName, true);
            this.assertLocalTableColumn(localTableName, localColumnNameList);
            if (table.isExistForeignKey(foreignTableName, localColumnNameList, foreignColumnNameList)) {
                String msg = "The foreign key has already set up: ";
                _log.info((Object)(msg + foreignTableName + " " + localColumnNameList + " " + foreignColumnNameList));
                continue;
            }
            this.setupForeignKeyToTable(foreignKeyName, foreignTableName, foreignColumnNameList, fixedCondition, table, localColumnNameList, fixedSuffix);
            this.showResult(foreignTableName, foreignColumnNameList, fixedCondition, table, localColumnNameList);
        }
        _log.info((Object)"==========/");
    }

    protected void processAllTableFK(String foreignKeyName, String foreignTableName, List<String> foreignColumnNameList, String fixedCondition, String fixedSuffix) {
        Table[] tableArray;
        for (Table table : tableArray = this.getTables()) {
            List<String> localColumnNameList = this.getLocalColumnNameList(foreignKeyName, foreignTableName, foreignColumnNameList, table.getName(), false);
            if (localColumnNameList == null || !table.containsColumn(localColumnNameList)) continue;
            if (table.isExistForeignKey(foreignTableName, localColumnNameList, foreignColumnNameList)) {
                String msg = "The foreign key has already set up: ";
                msg = msg + " localTable=" + table.getName() + " foreignTable=" + foreignTableName;
                msg = msg + " localColumnNameList=" + localColumnNameList + " foreignColumnNameList=" + foreignColumnNameList;
                _log.info((Object)msg);
                continue;
            }
            String currentForeignKeyName = foreignKeyName + "_" + table.getName();
            this.setupForeignKeyToTable(currentForeignKeyName, foreignTableName, foreignColumnNameList, fixedCondition, table, localColumnNameList, fixedSuffix);
            this.showResult(foreignTableName, foreignColumnNameList, fixedCondition, table, localColumnNameList);
        }
    }

    protected void setupForeignKeyToTable(String foreignKeyname, String foreignTableName, List<String> foreignColumnNameList, String fixedCondition, Table table, List<String> localColumnNameList, String fixedSuffix) {
        ForeignKey fk = new ForeignKey();
        fk.setName(foreignKeyname);
        fk.setForeignTableName(foreignTableName);
        fk.addReference(localColumnNameList, foreignColumnNameList);
        fk.setAdditionalForeignKey(true);
        if (fixedCondition != null && fixedCondition.trim().length() > 0) {
            fk.setFixedCondition(fixedCondition);
        }
        if (fixedSuffix != null && fixedSuffix.trim().length() > 0) {
            fk.setFixedSuffix(fixedSuffix);
        }
        table.addForeignKey(fk);
        boolean canBeReferrer = this.getTable(foreignTableName).addReferrer(fk);
        if (canBeReferrer) {
            for (String foreignColumnName : foreignColumnNameList) {
                Column foreignColumn = this.getTable(foreignTableName).getColumn(foreignColumnName);
                foreignColumn.addReferrer(fk);
            }
        } else {
            String msg = "    *Cannot add referrer!";
            _log.info((Object)msg);
        }
    }

    protected void showResult(String foreignTableName, List<String> foreignColumnNameList, String fixedCondition, Table table, List<String> localColumnNameList) {
        String msg = "    Add foreign key " + table.getName() + "." + localColumnNameList;
        if (fixedCondition != null && fixedCondition.trim().length() > 0) {
            msg = msg + " to " + foreignTableName + "." + foreignColumnNameList;
            _log.info((Object)msg);
            String withFixedCondition = "    with " + fixedCondition;
            _log.info((Object)withFixedCondition);
        } else {
            msg = msg + " to " + foreignTableName + "." + foreignColumnNameList;
            _log.info((Object)msg);
        }
    }

    protected List<String> getForeignColumnNameList(String foreignName, String foreignTableName) {
        List<String> foreignColumnNameList = this.getForeignColumnNameList(foreignName);
        if (foreignColumnNameList == null || foreignColumnNameList.isEmpty()) {
            foreignColumnNameList = new ArrayList<String>();
            List<Column> foreignPrimaryKeyList = this.getTable(foreignTableName).getPrimaryKey();
            if (foreignPrimaryKeyList.isEmpty()) {
                String msg = "The foreignTable[" + foreignTableName + "] should have primary-key!";
                throw new RuntimeException(msg);
            }
            for (Column column : foreignPrimaryKeyList) {
                foreignColumnNameList.add(column.getName());
            }
        }
        return foreignColumnNameList;
    }

    protected DfAdditionalForeignKeyProperties getProperties() {
        return DfBuildProperties.getInstance().getAdditionalForeignKeyProperties();
    }

    protected List<String> getLocalColumnNameList(String foreignName, String foreignTableName, List<String> foreignColumnNameList, String localTableName, boolean isErrorNotFound) {
        List<String> localColumnNameList = this.getLocalColumnNameList(foreignName);
        if (localColumnNameList == null || localColumnNameList.isEmpty()) {
            localColumnNameList = new ArrayList<String>();
            for (String foreignColumnName : foreignColumnNameList) {
                Column column = this.getTable(localTableName).getColumn(foreignColumnName);
                if (column == null) {
                    if (isErrorNotFound) {
                        String msg = "The localTable[" + localTableName + "] should have the columns '";
                        msg = msg + foreignColumnNameList + "' same as primary keys of foreign table[" + foreignTableName + "]";
                        throw new RuntimeException(msg);
                    }
                    return null;
                }
                localColumnNameList.add(column.getName());
            }
        }
        return localColumnNameList;
    }

    protected void assertForeignTable(String foreignTableName) {
        if (this.getTable(foreignTableName) == null) {
            String msg = "Not found table by the foreignTableName: " + foreignTableName;
            msg = msg + " additionalForeignKeyMap=" + this.getAdditionalForeignKeyMap();
            throw new IllegalStateException(msg);
        }
    }

    protected void assertForeignTableColumn(String foreignTableName, List<String> foreignColumnNameList) {
        if (!this.getTable(foreignTableName).containsColumn(foreignColumnNameList)) {
            String msg = "Not found column by the foreignColumnNameList: " + foreignColumnNameList;
            msg = msg + " of the foreign table '" + foreignTableName + "'";
            msg = msg + " additionalForeignKeyMap=" + this.getAdditionalForeignKeyMap();
            throw new IllegalStateException(msg);
        }
    }

    protected void assertLocalTable(String localTableName) {
        if (this.getTable(localTableName) == null) {
            String msg = "Not found table by the localTableName: " + localTableName;
            msg = msg + " additionalForeignKeyMap=" + this.getAdditionalForeignKeyMap();
            throw new IllegalStateException(msg);
        }
    }

    protected void assertLocalTableColumn(String localTableName, List<String> localColumnNameList) {
        if (!this.getTable(localTableName).containsColumn(localColumnNameList)) {
            String msg = "Not found column by the localColumnNameList: " + localColumnNameList;
            msg = msg + " of the local table '" + localTableName + "'";
            msg = msg + " additionalForeignKeyMap=" + this.getAdditionalForeignKeyMap();
            throw new IllegalStateException(msg);
        }
    }

    protected String getLocalTableName(String foreignKeyName) {
        return this.getProperties().findLocalTableName(foreignKeyName);
    }

    protected String getForeignTableName(String foreignKeyName) {
        return this.getProperties().findForeignTableName(foreignKeyName);
    }

    protected List<String> getLocalColumnNameList(String foreignKeyName) {
        return this.getProperties().findLocalColumnNameList(foreignKeyName);
    }

    protected List<String> getForeignColumnNameList(String foreignKeyName) {
        return this.getProperties().findForeignColumnNameList(foreignKeyName);
    }

    protected String getFixedCondition(String foreignKeyName) {
        return this.getProperties().findFixedCondition(foreignKeyName);
    }

    protected String getFixedSuffix(String foreignKeyName) {
        return this.getProperties().findFixedSuffix(foreignKeyName);
    }

    protected Map<String, Map<String, String>> getAdditionalForeignKeyMap() {
        return this.getProperties().getAdditionalForeignKeyMap();
    }

    protected Table getTable(String tableName) {
        return this.getDatabase().getTable(tableName);
    }

    protected Table[] getTables() {
        return this.getDatabase().getTables();
    }

    protected Database getDatabase() {
        return this._database;
    }
}

