/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.twowaysql.node;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.seasar.dbflute.exception.IfCommentDifferentTypeComparisonException;
import org.seasar.dbflute.exception.IfCommentEmptyExpressionException;
import org.seasar.dbflute.exception.IfCommentIllegalParameterBeanSpecificationException;
import org.seasar.dbflute.exception.IfCommentNotBooleanResultException;
import org.seasar.dbflute.exception.IfCommentNotFoundMethodException;
import org.seasar.dbflute.exception.IfCommentNotFoundPropertyException;
import org.seasar.dbflute.exception.IfCommentNullPointerException;
import org.seasar.dbflute.exception.IfCommentUnsupportedExpressionException;
import org.seasar.dbflute.exception.IfCommentUnsupportedTypeComparisonException;
import org.seasar.dbflute.helper.beans.DfBeanDesc;
import org.seasar.dbflute.helper.beans.DfPropertyDesc;
import org.seasar.dbflute.helper.beans.exception.DfBeanMethodNotFoundException;
import org.seasar.dbflute.helper.beans.exception.DfBeanPropertyNotFoundException;
import org.seasar.dbflute.helper.beans.factory.DfBeanDescFactory;
import org.seasar.dbflute.twowaysql.node.NodeUtil;
import org.seasar.dbflute.twowaysql.node.ParameterFinder;
import org.seasar.dbflute.twowaysql.pmbean.ParameterBean;
import org.seasar.dbflute.util.DfReflectionUtil;
import org.seasar.dbflute.util.DfStringUtil;
import org.seasar.dbflute.util.DfSystemUtil;
import org.seasar.dbflute.util.DfTypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IfCommentEvaluator {
    private static final String AND = " && ";
    private static final String OR = " || ";
    private static final String EQUAL = " == ";
    private static final String NOT_EQUAL = " != ";
    private static final String GREATER_THAN = " > ";
    private static final String LESS_THAN = " < ";
    private static final String GREATER_EQUAL = " >= ";
    private static final String LESS_EQUAL = " <= ";
    private static final String BOOLEAN_NOT = "!";
    private static final String METHOD_SUFFIX = "()";
    private ParameterFinder _finder;
    private String _expression;
    private String _specifiedSql;

    public IfCommentEvaluator(ParameterFinder finder, String expression, String specifiedSql) {
        this._finder = finder;
        this._expression = expression;
        this._specifiedSql = specifiedSql;
    }

    public boolean evaluate() {
        this.assertExpression();
        this._expression = this._expression.trim();
        if (this._expression.contains(AND)) {
            List<String> splitList = this.splitList(this._expression, AND);
            for (String booleanClause : splitList) {
                boolean result = this.evaluateBooleanClause(booleanClause);
                if (result) continue;
                return false;
            }
            return true;
        }
        if (this._expression.contains(OR)) {
            List<String> splitList = this.splitList(this._expression, OR);
            for (String booleanClause : splitList) {
                boolean result = this.evaluateBooleanClause(booleanClause);
                if (!result) continue;
                return true;
            }
            return false;
        }
        return this.evaluateBooleanClause(this._expression);
    }

    public void assertExpression() {
        String filtered;
        if (this._expression == null || this._expression.trim().length() == 0) {
            this.throwIfCommentEmptyExpressionException();
        }
        if ((filtered = DfStringUtil.replace(this._expression, METHOD_SUFFIX, "")).contains("(") || filtered.contains(")")) {
            this.throwIfCommentUnsupportedExpressionException();
        }
        if (this._expression.contains(AND) && this._expression.contains(OR)) {
            this.throwIfCommentUnsupportedExpressionException();
        }
        if (this._expression.contains(" = ") || this._expression.contains(" <> ")) {
            this.throwIfCommentUnsupportedExpressionException();
        }
        if (this._expression.contains("\"")) {
            this.throwIfCommentUnsupportedExpressionException();
        }
    }

    protected boolean evaluateBooleanClause(final String booleanClause) {
        if (booleanClause.contains(EQUAL)) {
            return this.evaluateCompareClause(booleanClause, EQUAL, new OperandEvaluator(){

                public boolean evaluate(Object leftResult, Object rightResult) {
                    if (leftResult instanceof Number && rightResult instanceof Number) {
                        leftResult = new BigDecimal(leftResult.toString());
                        rightResult = new BigDecimal(rightResult.toString());
                    }
                    IfCommentEvaluator.this.assertCompareType(leftResult, rightResult, booleanClause);
                    return leftResult != null ? leftResult.equals(rightResult) : rightResult == null;
                }
            });
        }
        if (booleanClause.contains(NOT_EQUAL)) {
            return this.evaluateCompareClause(booleanClause, NOT_EQUAL, new OperandEvaluator(){

                public boolean evaluate(Object leftResult, Object rightResult) {
                    if (leftResult instanceof Number && rightResult instanceof Number) {
                        leftResult = new BigDecimal(leftResult.toString());
                        rightResult = new BigDecimal(rightResult.toString());
                    }
                    IfCommentEvaluator.this.assertCompareType(leftResult, rightResult, booleanClause);
                    return leftResult != null ? !leftResult.equals(rightResult) : rightResult != null;
                }
            });
        }
        if (booleanClause.contains(GREATER_THAN)) {
            return this.evaluateCompareClause(booleanClause, GREATER_THAN, new OperandEvaluator(){

                public boolean evaluate(Object leftResult, Object rightResult) {
                    if (leftResult == null) {
                        return false;
                    }
                    if (rightResult == null) {
                        return true;
                    }
                    return IfCommentEvaluator.this.compareLeftRight(leftResult, rightResult, new ComparaDeterminater(){

                        public boolean compare(int compareResult) {
                            return compareResult > 0;
                        }
                    }, booleanClause);
                }
            });
        }
        if (booleanClause.contains(LESS_THAN)) {
            return this.evaluateCompareClause(booleanClause, LESS_THAN, new OperandEvaluator(){

                public boolean evaluate(Object leftResult, Object rightResult) {
                    if (leftResult == null) {
                        return true;
                    }
                    if (rightResult == null) {
                        return false;
                    }
                    return IfCommentEvaluator.this.compareLeftRight(leftResult, rightResult, new ComparaDeterminater(){

                        public boolean compare(int compareResult) {
                            return compareResult < 0;
                        }
                    }, booleanClause);
                }
            });
        }
        if (booleanClause.contains(GREATER_EQUAL)) {
            return this.evaluateCompareClause(booleanClause, GREATER_EQUAL, new OperandEvaluator(){

                public boolean evaluate(Object leftResult, Object rightResult) {
                    if (leftResult == null) {
                        return rightResult == null;
                    }
                    if (rightResult == null) {
                        return true;
                    }
                    return IfCommentEvaluator.this.compareLeftRight(leftResult, rightResult, new ComparaDeterminater(){

                        public boolean compare(int compareResult) {
                            return compareResult >= 0;
                        }
                    }, booleanClause);
                }
            });
        }
        if (booleanClause.contains(LESS_EQUAL)) {
            return this.evaluateCompareClause(booleanClause, LESS_EQUAL, new OperandEvaluator(){

                public boolean evaluate(Object leftResult, Object rightResult) {
                    if (leftResult == null) {
                        return true;
                    }
                    if (rightResult == null) {
                        return false;
                    }
                    return IfCommentEvaluator.this.compareLeftRight(leftResult, rightResult, new ComparaDeterminater(){

                        public boolean compare(int compareResult) {
                            return compareResult <= 0;
                        }
                    }, booleanClause);
                }
            });
        }
        return this.evaluateStandAloneValue(booleanClause);
    }

    protected boolean compareLeftRight(Object leftResult, Object rightResult, ComparaDeterminater determinater, String booleanClause) {
        this.assertCompareType(leftResult, rightResult, booleanClause);
        if (leftResult instanceof Date) {
            Date leftDate = (Date)leftResult;
            Date rightDate = (Date)rightResult;
            return determinater.compare(leftDate.compareTo(rightDate));
        }
        if (leftResult instanceof Number) {
            Number leftNumber = (Number)leftResult;
            BigDecimal leftDecimal = new BigDecimal(leftNumber.toString());
            Number rightNumber = (Number)rightResult;
            BigDecimal rightDecimal = new BigDecimal(rightNumber.toString());
            return determinater.compare(leftDecimal.compareTo(rightDecimal));
        }
        this.throwIfCommentUnsupportedTypeComparisonException(leftResult, rightResult, booleanClause);
        return false;
    }

    protected void assertCompareType(Object leftResult, Object rightResult, String booleanClause) {
        if (leftResult != null && rightResult != null && leftResult instanceof Date) {
            if (!(rightResult instanceof Date)) {
                this.throwIfCommentDifferentTypeComparisonException(leftResult, rightResult, booleanClause);
            }
        } else if (leftResult != null && rightResult != null && leftResult instanceof Number && !(rightResult instanceof Number)) {
            this.throwIfCommentDifferentTypeComparisonException(leftResult, rightResult, booleanClause);
        }
    }

    protected boolean evaluateCompareClause(String booleanClause, String operand, OperandEvaluator evaluator) {
        String left = booleanClause.substring(0, booleanClause.indexOf(operand)).trim();
        String right = booleanClause.substring(booleanClause.indexOf(operand) + operand.length()).trim();
        Object leftResult = this.evaluateComparePiece(left, null);
        Object rightResult = this.evaluateComparePiece(right, null);
        return evaluator.evaluate(leftResult, rightResult);
    }

    protected Object evaluateComparePiece(String piece, Object leftResult) {
        if (!this.startsWithParameterBean(piece = piece.trim())) {
            String rearValue;
            if ("null".equalsIgnoreCase(piece)) {
                return null;
            }
            if ("true".equalsIgnoreCase(piece)) {
                return true;
            }
            if ("false".equalsIgnoreCase(piece)) {
                return false;
            }
            String quote = "'";
            int qlen = "'".length();
            if (piece.startsWith("'") && piece.endsWith("'")) {
                return piece.substring(qlen, piece.length() - qlen);
            }
            String dateMark = "date ";
            if (piece.toLowerCase().startsWith("date ") && (rearValue = piece.substring("date ".length()).trim()).startsWith("'") && rearValue.endsWith("'")) {
                String literal = rearValue.substring(qlen, rearValue.length() - qlen).trim();
                try {
                    return DfTypeUtil.toTimestamp(literal);
                }
                catch (DfTypeUtil.ParseTimestampException ignored) {
                    // empty catch block
                }
            }
            try {
                return DfTypeUtil.toBigDecimal(piece);
            }
            catch (NumberFormatException ignored) {
                // empty catch block
            }
        }
        ArrayList<String> propertyList = new ArrayList<String>();
        String preProperty = this.setupPropertyList(piece, propertyList);
        Object baseObject = this._finder.find(preProperty);
        for (String property : propertyList) {
            baseObject = this.processOneProperty(baseObject, preProperty, property);
            preProperty = property;
        }
        return baseObject;
    }

    protected boolean evaluateStandAloneValue(String piece) {
        piece = piece.trim();
        boolean not = false;
        if (piece.startsWith(BOOLEAN_NOT)) {
            not = true;
            piece = piece.substring(BOOLEAN_NOT.length());
        }
        if (!this.startsWithParameterBean(piece)) {
            if ("true".equalsIgnoreCase(piece)) {
                return !not;
            }
            if ("false".equalsIgnoreCase(piece)) {
                return not;
            }
        }
        ArrayList<String> propertyList = new ArrayList<String>();
        String preProperty = this.setupPropertyList(piece, propertyList);
        Object baseObject = this._finder.find(preProperty);
        for (String property : propertyList) {
            baseObject = this.processOneProperty(baseObject, preProperty, property);
            preProperty = property;
        }
        if (baseObject == null) {
            this.throwIfCommentNotBooleanResultException();
        }
        boolean result = Boolean.valueOf(baseObject.toString());
        return not ? !result : result;
    }

    protected boolean startsWithParameterBean(String piece) {
        return piece.startsWith("pmb");
    }

    protected String setupPropertyList(String piece, List<String> emptyPropertyList) {
        List<String> splitList = this.splitList(piece, ".");
        String firstName = null;
        for (int i = 0; i < splitList.size(); ++i) {
            if (i == 0) {
                this.assertFirstName(splitList.get(i));
                continue;
            }
            emptyPropertyList.add(splitList.get(i));
        }
        return firstName;
    }

    protected void assertFirstName(String firstName) {
        NodeUtil.assertParameterBeanName(firstName, this._finder, new NodeUtil.IllegalParameterBeanHandler(){

            public void handle(ParameterBean pmb) {
                IfCommentEvaluator.this.throwIfCommentIllegalParameterBeanSpecificationException();
            }
        });
    }

    protected Object processOneProperty(Object baseObject, String preProperty, String property) {
        if (baseObject == null) {
            this.throwIfCommentNullPointerException(preProperty);
        }
        DfBeanDesc beanDesc = DfBeanDescFactory.getBeanDesc(baseObject.getClass());
        if (property.endsWith(METHOD_SUFFIX)) {
            String methodName = property.substring(0, property.length() - METHOD_SUFFIX.length());
            try {
                Method method = beanDesc.getMethod(methodName);
                return DfReflectionUtil.invoke(method, baseObject, null);
            }
            catch (DfBeanMethodNotFoundException e) {
                this.throwIfCommentNotFoundMethodException(baseObject, methodName);
                return null;
            }
        }
        if (Map.class.isInstance(baseObject)) {
            Map map = (Map)baseObject;
            return map.get(property);
        }
        try {
            DfPropertyDesc propertyDesc = beanDesc.getPropertyDesc(property);
            return propertyDesc.getValue(baseObject);
        }
        catch (DfBeanPropertyNotFoundException e) {
            this.throwIfCommentNotFoundPropertyException(baseObject, property);
            return null;
        }
    }

    protected void throwIfCommentEmptyExpressionException() {
        String msg = "Look! Read the message below." + this.ln();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.ln();
        msg = msg + "The IF comment expression was empty!" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Advice]" + this.ln();
        msg = msg + "Please confirm your IF comment." + this.ln();
        msg = msg + "  For example, wrong and correct IF comment is as below:" + this.ln();
        msg = msg + "    /- - - - - - - - - - - - - - - - - - - - - - - - - - " + this.ln();
        msg = msg + "    (x) - /*IF */" + this.ln();
        msg = msg + "    (o) - /*IF pmb.memberId != null*/" + this.ln();
        msg = msg + "    - - - - - - - - - -/" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[IF Comment Expression]" + this.ln() + this._expression + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Specified ParameterBean]" + this.ln() + this.getDisplayParameterBean() + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Specified SQL]" + this.ln() + this._specifiedSql + this.ln();
        msg = msg + "* * * * * * * * * */";
        throw new IfCommentEmptyExpressionException(msg);
    }

    protected void throwIfCommentUnsupportedExpressionException() {
        String msg = "Look! Read the message below." + this.ln();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.ln();
        msg = msg + "The IF comment expression was unsupported!" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Advice]" + this.ln();
        msg = msg + "Please confirm your unsupported IF comment." + this.ln();
        msg = msg + "  For example, unsupported examples:" + this.ln();
        msg = msg + "    (x:andOr) - /*IF (pmb.fooId != null || pmb.barId != null) && pmb.fooName != null*/" + this.ln();
        msg = msg + "    (x:argsMethod) - /*IF pmb.buildFooId(123)*/" + this.ln();
        msg = msg + "    (x:stringLiteral) - /*IF pmb.fooName == 'Pixy' || pmb.fooName == \"Pixy\"*/" + this.ln();
        msg = msg + "    (x:singleEqual) - /*IF pmb.fooId = null*/ --> /*IF pmb.fooId == null*/" + this.ln();
        msg = msg + "    (x:anotherNot) - /*IF pmb.fooId <> null*/ --> /*IF pmb.fooId != null*/" + this.ln();
        msg = msg + "    (x:doubleQuotation) - /*IF pmb.fooName == \"Pixy\"*/ --> /*IF pmb.fooName == 'Pixy'*/" + this.ln();
        msg = msg + "    " + this.ln();
        msg = msg + "If you want to write a complex condition, write an ExParameterBean property." + this.ln();
        msg = msg + "And use the property in IF comment." + this.ln();
        msg = msg + "  For example, ExParameterBean original property:" + this.ln();
        msg = msg + "    ex) ExParameterBean (your original property)" + this.ln();
        msg = msg + "    /- - - - - - - - - - - - - - - - - - - - - - - - - - " + this.ln();
        msg = msg + "    public boolean isOriginalMemberProperty() {" + this.ln();
        msg = msg + "        return (getMemberId() != null || getBirthdate() != null) && getMemberName() != null);" + this.ln();
        msg = msg + "    }" + this.ln();
        msg = msg + "    - - - - - - - - - -/" + this.ln();
        msg = msg + "    " + this.ln();
        msg = msg + "    ex) IF comment" + this.ln();
        msg = msg + "    /- - - - - - - - - - - - - - - - - - - - - - - - - - " + this.ln();
        msg = msg + "    /*IF pmb.originalMemberProperty*/" + this.ln();
        msg = msg + "    - - - - - - - - - -/" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[IF Comment Expression]" + this.ln() + this._expression + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Specified ParameterBean]" + this.ln() + this.getDisplayParameterBean() + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Specified SQL]" + this.ln() + this._specifiedSql + this.ln();
        msg = msg + "* * * * * * * * * */";
        throw new IfCommentUnsupportedExpressionException(msg);
    }

    public void throwIfCommentIllegalParameterBeanSpecificationException() {
        String msg = "Look! Read the message below." + this.ln();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.ln();
        msg = msg + "The IF comment had the illegal parameter-bean specification!" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Advice]" + this.ln();
        msg = msg + "Please confirm your IF comment." + this.ln();
        msg = msg + "  For example, wrong and correct IF comment is as below:" + this.ln();
        msg = msg + "    (x) - /*IF pmb,memberId != null*/" + this.ln();
        msg = msg + "    (x) - /*IF p mb.memberId != null*/" + this.ln();
        msg = msg + "    (x) - /*IF pmb:memberId != null*/" + this.ln();
        msg = msg + "    (x) - /*IF pnb.memberId != null*/" + this.ln();
        msg = msg + "    (o) - /*IF pmb.memberId != null*/" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[IF Comment Expression]" + this.ln() + this._expression + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Specified ParameterBean]" + this.ln() + this.getDisplayParameterBean() + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Specified SQL]" + this.ln() + this._specifiedSql + this.ln();
        msg = msg + "* * * * * * * * * */";
        throw new IfCommentIllegalParameterBeanSpecificationException(msg);
    }

    protected void throwIfCommentNotFoundMethodException(Object baseObject, String notFoundMethod) {
        String msg = "Look! Read the message below." + this.ln();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.ln();
        msg = msg + "The IF comment method was not found!" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Advice]" + this.ln();
        msg = msg + "Please confirm your IF comment properties." + this.ln();
        msg = msg + "  For example, wrong and correct IF comment is as below:" + this.ln();
        msg = msg + "    /- - - - - - - - - - - - - - - - - - - - - - - - - - " + this.ln();
        msg = msg + "    (x) - /*IF pmb.getMemborWame() != null*/" + this.ln();
        msg = msg + "    (o) - /*IF pmb.getMemberName() != null*/" + this.ln();
        msg = msg + "    - - - - - - - - - -/" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[IF Comment Expression]" + this.ln() + this._expression + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Not Found Method]" + this.ln();
        msg = msg + (baseObject != null ? baseObject.getClass().getSimpleName() + "." : "");
        msg = msg + notFoundMethod + METHOD_SUFFIX + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Specified ParameterBean]" + this.ln() + this.getDisplayParameterBean() + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Specified SQL]" + this.ln() + this._specifiedSql + this.ln();
        msg = msg + "* * * * * * * * * */";
        throw new IfCommentNotFoundMethodException(msg);
    }

    protected void throwIfCommentNotFoundPropertyException(Object baseObject, String notFoundProperty) {
        String msg = "Look! Read the message below." + this.ln();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.ln();
        msg = msg + "The IF comment property was not found!" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Advice]" + this.ln();
        msg = msg + "Please confirm your IF comment properties." + this.ln();
        msg = msg + "  For example, wrong and correct IF comment is as below:" + this.ln();
        msg = msg + "    /- - - - - - - - - - - - - - - - - - - - - - - - - - " + this.ln();
        msg = msg + "    (x) - /*IF pmb.memderBame != null*/" + this.ln();
        msg = msg + "    (o) - /*IF pmb.memberName != null*/" + this.ln();
        msg = msg + "    - - - - - - - - - -/" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[IF Comment Expression]" + this.ln() + this._expression + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Not Found Property]" + this.ln();
        msg = msg + (baseObject != null ? baseObject.getClass().getSimpleName() + "." : "");
        msg = msg + notFoundProperty + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Specified ParameterBean]" + this.ln() + this.getDisplayParameterBean() + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Specified SQL]" + this.ln() + this._specifiedSql + this.ln();
        msg = msg + "* * * * * * * * * */";
        throw new IfCommentNotFoundPropertyException(msg);
    }

    protected void throwIfCommentNullPointerException(String nullProperty) {
        String msg = "Look! Read the message below." + this.ln();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.ln();
        msg = msg + "The IF comment had the null pointer!" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Advice]" + this.ln();
        msg = msg + "Please confirm your IF comment and its property values." + this.ln();
        msg = msg + this.ln();
        msg = msg + "[IF Comment Expression]" + this.ln() + this._expression + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Null Property]" + this.ln() + nullProperty + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Specified ParameterBean]" + this.ln() + this.getDisplayParameterBean() + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Specified SQL]" + this.ln() + this._specifiedSql + this.ln();
        msg = msg + "* * * * * * * * * */";
        throw new IfCommentNullPointerException(msg);
    }

    protected void throwIfCommentDifferentTypeComparisonException(Object left, Object right, String booleanClause) {
        String msg = "Look! Read the message below." + this.ln();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.ln();
        msg = msg + "The IF comment had the different type comparison!" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Advice]" + this.ln();
        msg = msg + "Please confirm your IF comment property types." + this.ln();
        msg = msg + "If the left type is Number, the right type should be Number." + this.ln();
        msg = msg + "If the left type is Date, the right type should be Date." + this.ln();
        msg = msg + this.ln();
        msg = msg + "[IF Comment Expression]" + this.ln() + this._expression + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Target Boolean Clause]" + this.ln() + booleanClause + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Left]" + this.ln() + (left != null ? left.getClass() : "null") + this.ln();
        msg = msg + " --> " + left + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Right]" + this.ln() + (right != null ? right.getClass() : "null") + this.ln();
        msg = msg + " --> " + right + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Specified ParameterBean]" + this.ln() + this.getDisplayParameterBean() + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Specified SQL]" + this.ln() + this._specifiedSql + this.ln();
        msg = msg + "* * * * * * * * * */";
        throw new IfCommentDifferentTypeComparisonException(msg);
    }

    protected void throwIfCommentUnsupportedTypeComparisonException(Object left, Object right, String booleanClause) {
        String msg = "Look! Read the message below." + this.ln();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.ln();
        msg = msg + "The IF comment had the different type comparison!" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Advice]" + this.ln();
        msg = msg + "Please confirm your IF comment property types." + this.ln();
        msg = msg + "For example, String type is unsupported at comparison(>, <, >=, <=)." + this.ln();
        msg = msg + "Number and Date are only supported." + this.ln();
        msg = msg + this.ln();
        msg = msg + "[IF Comment Expression]" + this.ln() + this._expression + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Target Boolean Clause]" + this.ln() + booleanClause + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Left]" + this.ln() + (left != null ? left.getClass() : "null") + this.ln();
        msg = msg + " --> " + left + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Right]" + this.ln() + (right != null ? right.getClass() : "null") + this.ln();
        msg = msg + " --> " + right + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Specified ParameterBean]" + this.ln() + this.getDisplayParameterBean() + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Specified SQL]" + this.ln() + this._specifiedSql + this.ln();
        msg = msg + "* * * * * * * * * */";
        throw new IfCommentUnsupportedTypeComparisonException(msg);
    }

    protected void throwIfCommentNotBooleanResultException() {
        String msg = "Look! Read the message below." + this.ln();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.ln();
        msg = msg + "The IF comment was not boolean!" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Advice]" + this.ln();
        msg = msg + "Please confirm your IF comment property." + this.ln();
        msg = msg + this.ln();
        msg = msg + "[IF Comment Expression]" + this.ln() + this._expression + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Specified ParameterBean]" + this.ln() + this.getDisplayParameterBean() + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Specified SQL]" + this.ln() + this._specifiedSql + this.ln();
        msg = msg + "* * * * * * * * * */";
        throw new IfCommentNotBooleanResultException(msg);
    }

    protected Object getDisplayParameterBean() {
        return this._finder.find("pmb");
    }

    protected String ln() {
        return DfSystemUtil.getLineSeparator();
    }

    protected List<String> splitList(String str, String delimiter) {
        return DfStringUtil.splitList(str, delimiter);
    }

    public String getExpression() {
        return this._expression;
    }

    protected static interface OperandEvaluator {
        public boolean evaluate(Object var1, Object var2);
    }

    protected static interface ComparaDeterminater {
        public boolean compare(int var1);
    }
}

