/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.procedure;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.seasar.dbflute.DBDef;
import org.seasar.dbflute.helper.beans.DfBeanDesc;
import org.seasar.dbflute.helper.beans.factory.DfBeanDescFactory;
import org.seasar.dbflute.jdbc.ValueType;
import org.seasar.dbflute.resource.ResourceContext;
import org.seasar.dbflute.s2dao.procedure.TnProcedureMetaData;
import org.seasar.dbflute.s2dao.procedure.TnProcedureParameterType;
import org.seasar.dbflute.s2dao.valuetype.TnValueTypeFactory;
import org.seasar.dbflute.s2dao.valuetype.TnValueTypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TnProcedureMetaDataFactory {
    protected TnValueTypeFactory valueTypeFactory;
    protected InternalFieldProcedureAnnotationReader annotationReader = new InternalFieldProcedureAnnotationReader();

    public TnProcedureMetaData createProcedureMetaData(String procedureName, Class<?> pmbType) {
        Class clazz;
        TnProcedureMetaData metaData = new TnProcedureMetaData(procedureName);
        if (pmbType == null) {
            return metaData;
        }
        if (!this.isDtoType(pmbType)) {
            throw new IllegalStateException("The pmb type was Not DTO type: " + pmbType.getName());
        }
        DfBeanDesc pmbDesc = DfBeanDescFactory.getBeanDesc(pmbType);
        Stack stack = new Stack();
        for (clazz = pmbType; clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
            stack.push(clazz);
        }
        while (!stack.isEmpty()) {
            clazz = (Class)stack.pop();
            this.registerParameterType(metaData, pmbDesc, clazz.getDeclaredFields());
        }
        return metaData;
    }

    protected void registerParameterType(TnProcedureMetaData metaData, DfBeanDesc pmbDesc, Field[] fields) {
        for (Field field : fields) {
            TnProcedureParameterType ppt;
            if (!this.isInstanceField(field) || (ppt = this.getProcedureParameterType(pmbDesc, field)) == null) continue;
            metaData.addParameterType(ppt);
        }
    }

    protected TnProcedureParameterType getProcedureParameterType(DfBeanDesc dtoDesc, Field field) {
        String procedureParameter = this.annotationReader.getProcedureParameter(dtoDesc, field);
        if (procedureParameter == null) {
            return null;
        }
        String type = this.extractParameterType(procedureParameter);
        field.setAccessible(true);
        TnProcedureParameterType ppt = new TnProcedureParameterType(field);
        if (type.equalsIgnoreCase("in")) {
            ppt.setInType(true);
        } else if (type.equalsIgnoreCase("out")) {
            ppt.setOutType(true);
        } else if (type.equalsIgnoreCase("inout")) {
            ppt.setInType(true);
            ppt.setOutType(true);
        } else if (type.equalsIgnoreCase("return")) {
            ppt.setOutType(true);
            ppt.setReturnType(true);
        } else {
            String msg = "The parameter type should be 'in' or 'out' or 'inout' or 'return':";
            msg = msg + " class=" + field.getDeclaringClass().getSimpleName();
            msg = msg + " field=" + field.getName();
            msg = msg + " parameterType=" + type;
            throw new IllegalStateException(msg);
        }
        Integer index = this.extractParameterIndex(procedureParameter, field);
        ppt.setParameterIndex(index);
        ValueType valueType = this.getValueType(dtoDesc, field);
        ppt.setValueType(valueType);
        return ppt;
    }

    protected String extractParameterType(String procedureParameter) {
        if (procedureParameter.contains(",")) {
            return procedureParameter.substring(0, procedureParameter.indexOf(",")).trim();
        }
        return procedureParameter.trim();
    }

    protected Integer extractParameterIndex(String procedureParameter, Field field) {
        if (procedureParameter.contains(",")) {
            String tmp = procedureParameter.substring(procedureParameter.indexOf(",") + ",".length()).trim();
            try {
                return Integer.valueOf(tmp);
            }
            catch (NumberFormatException e) {
                String msg = "The parameter index should be number:";
                msg = msg + " class=" + field.getDeclaringClass().getSimpleName();
                msg = msg + " field=" + field.getName();
                msg = msg + " parameterIndex=" + tmp + " procedureParameter=" + procedureParameter;
                throw new IllegalStateException(msg, e);
            }
        }
        return null;
    }

    protected ValueType getValueType(DfBeanDesc dtoDesc, Field field) {
        String name = this.annotationReader.getValueType(dtoDesc, field);
        if (name != null) {
            return this.valueTypeFactory.getValueTypeByName(name);
        }
        Class<?> type = field.getType();
        if (List.class.isAssignableFrom(type)) {
            if (this.isCurrentDBDef(DBDef.Oracle)) {
                return TnValueTypes.ORACLE_RESULT_SET;
            }
            if (this.isCurrentDBDef(DBDef.PostgreSQL)) {
                return TnValueTypes.POSTGRE_RESULT_SET;
            }
            return TnValueTypes.SERIALIZABLE_BYTE_ARRAY;
        }
        return this.valueTypeFactory.getValueTypeByClass(type);
    }

    protected boolean isCurrentDBDef(DBDef currentDBDef) {
        return ResourceContext.isCurrentDBDef(currentDBDef);
    }

    protected boolean isInstanceField(Field field) {
        int mod = field.getModifiers();
        return !Modifier.isStatic(mod) && !Modifier.isFinal(mod);
    }

    protected boolean isDtoType(Class<?> clazz) {
        return !this.isSimpleType(clazz) && !this.isContainerType(clazz);
    }

    protected boolean isSimpleType(Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz");
        }
        return clazz == String.class || clazz.isPrimitive() || clazz == Boolean.class || clazz == Character.class || Number.class.isAssignableFrom(clazz) || Date.class.isAssignableFrom(clazz) || Calendar.class.isAssignableFrom(clazz) || clazz == byte[].class;
    }

    protected boolean isContainerType(Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz");
        }
        return Collection.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz) || clazz.isArray();
    }

    public void setValueTypeFactory(TnValueTypeFactory valueTypeFactory) {
        this.valueTypeFactory = valueTypeFactory;
    }

    protected static class InternalFieldProcedureAnnotationReader {
        protected String PROCEDURE_PARAMETER_SUFFIX = "_PROCEDURE_PARAMETER";
        protected String VALUE_TYPE_SUFFIX = "_VALUE_TYPE";

        public String getProcedureParameter(DfBeanDesc dtoDesc, Field field) {
            String fieldName = this.removeInstanceVariablePrefix(field.getName());
            String annotationName = fieldName + this.PROCEDURE_PARAMETER_SUFFIX;
            if (dtoDesc.hasField(annotationName)) {
                Field f = dtoDesc.getField(annotationName);
                return (String)this.getValue(f, null);
            }
            return null;
        }

        public String getValueType(DfBeanDesc dtoDesc, Field field) {
            String fieldName = this.removeInstanceVariablePrefix(field.getName());
            String annotationName = fieldName + this.VALUE_TYPE_SUFFIX;
            if (dtoDesc.hasField(annotationName)) {
                Field f = dtoDesc.getField(annotationName);
                return (String)this.getValue(f, null);
            }
            return null;
        }

        protected String removeInstanceVariablePrefix(String fieldName) {
            return fieldName.startsWith("_") ? fieldName.substring("_".length()) : fieldName;
        }

        protected Object getValue(Field field, Object target) {
            try {
                return field.get(target);
            }
            catch (IllegalAccessException e) {
                String msg = "The getting of the field threw the exception:";
                msg = msg + " class=" + field.getDeclaringClass().getSimpleName();
                msg = msg + " field=" + field.getName();
                throw new IllegalStateException(msg, e);
            }
        }
    }
}

