/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.bhv.core.command;

import org.seasar.dbflute.bhv.core.SqlExecution;
import org.seasar.dbflute.bhv.core.SqlExecutionCreator;
import org.seasar.dbflute.bhv.core.command.AbstractBehaviorCommand;
import org.seasar.dbflute.bhv.core.execution.BasicSelectExecution;
import org.seasar.dbflute.bhv.core.supplement.SequenceCache;
import org.seasar.dbflute.bhv.core.supplement.SequenceCacheHandler;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.exception.SequenceCacheIncrementSizeInvalidException;
import org.seasar.dbflute.exception.SequenceSelectIllegalStateException;
import org.seasar.dbflute.outsidesql.OutsideSqlOption;
import org.seasar.dbflute.s2dao.jdbc.TnResultSetHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectNextValCommand<RESULT>
extends AbstractBehaviorCommand<RESULT> {
    protected Class<RESULT> _resultType;
    protected DBMeta _dbmeta;
    protected SequenceCacheHandler _sequenceCacheHandler;

    @Override
    public String getCommandName() {
        return "selectNextVal";
    }

    @Override
    public Class<?> getCommandReturnType() {
        return this._resultType;
    }

    @Override
    public boolean isConditionBean() {
        return false;
    }

    @Override
    public boolean isOutsideSql() {
        return false;
    }

    @Override
    public boolean isProcedure() {
        return false;
    }

    @Override
    public boolean isSelect() {
        return true;
    }

    @Override
    public boolean isSelectCount() {
        return false;
    }

    @Override
    public void beforeGettingSqlExecution() {
    }

    @Override
    public void afterExecuting() {
    }

    @Override
    public String buildSqlExecutionKey() {
        this.assertStatus("buildSqlExecutionKey");
        return this._tableDbName + ":" + this.getCommandName() + "()";
    }

    @Override
    public SqlExecutionCreator createSqlExecutionCreator() {
        this.assertStatus("createSqlExecutionCreator");
        return new SqlExecutionCreator(){

            public SqlExecution createSqlExecution() {
                TnResultSetHandler handler = SelectNextValCommand.this.createDynamicScalarResultSetHandler(SelectNextValCommand.this._resultType);
                return SelectNextValCommand.this.createSelectNextValExecution(handler);
            }
        };
    }

    protected SqlExecution createSelectNextValExecution(TnResultSetHandler handler) {
        Integer incrementSize;
        this.assertStatus("createSelectNextValExecution");
        DBMeta dbmeta = this.findDBMeta();
        this.assertTableHasSequence(dbmeta);
        String sql = dbmeta.getSequenceNextValSql();
        this.assertSequenceReturnsNotNull(sql, dbmeta);
        SequenceCache sequenceCache = this.findSequenceCache(dbmeta);
        if (sequenceCache != null && (incrementSize = dbmeta.getSequenceIncrementSize()) != null) {
            this.assertIncrementSizeNotMinusAndNotZero(incrementSize, dbmeta);
            Integer cacheSize = dbmeta.getSequenceCacheSize();
            sql = this._sequenceCacheHandler.filterNextValSql(cacheSize, incrementSize, sql);
        }
        return this.createBasicSelectExecution(handler, new String[0], new Class[0], sql, sequenceCache);
    }

    protected void assertTableHasSequence(DBMeta dbmeta) {
        if (!dbmeta.hasSequence()) {
            String msg = "If it uses sequence, the table should be related to a sequence:";
            msg = msg + " table=" + dbmeta.getTableDbName() + " sequence=" + dbmeta.getSequenceName();
            throw new SequenceSelectIllegalStateException(msg);
        }
    }

    protected void assertSequenceReturnsNotNull(String nextValSql, DBMeta dbmeta) {
        if (nextValSql == null) {
            String msg = "If it uses sequence, SQL for next value should exist:";
            msg = msg + " table=" + dbmeta.getTableDbName() + " sequence=" + dbmeta.getSequenceName();
            throw new SequenceSelectIllegalStateException(msg);
        }
    }

    protected SequenceCache findSequenceCache(DBMeta dbmeta) {
        String tableName = dbmeta.getTableDbName();
        String sequenceName = dbmeta.getSequenceName();
        Integer cacheSize = dbmeta.getSequenceCacheSize();
        Integer incrementSize = dbmeta.getSequenceIncrementSize();
        return this._sequenceCacheHandler.findSequenceCache(tableName, sequenceName, this._dataSource, this._resultType, cacheSize, incrementSize);
    }

    protected void assertIncrementSizeNotMinusAndNotZero(Integer incrementSize, DBMeta dbmeta) {
        if (incrementSize <= 0) {
            String msg = "The increment size should not be minus or zero if you use sequence cache:";
            msg = msg + " table=" + dbmeta.getTableDbName() + " sequence=" + dbmeta.getSequenceName();
            msg = msg + " cacheSize=" + dbmeta.getSequenceCacheSize();
            msg = msg + " incrementSize=" + dbmeta.getSequenceIncrementSize();
            throw new SequenceCacheIncrementSizeInvalidException(msg);
        }
    }

    protected BasicSelectExecution createBasicSelectExecution(TnResultSetHandler handler, String[] argNames, Class<?>[] argTypes, String sql, final SequenceCache sequenceCache) {
        BasicSelectExecution cmd = sequenceCache != null ? new BasicSelectExecution(this._dataSource, this._statementFactory, handler){

            public Object execute(final Object[] args) {
                return sequenceCache.nextval(new SequenceCache.SequenceRealExecutor(){

                    public Object execute() {
                        return this.executeSuperExecute(args);
                    }
                });
            }

            protected Object executeSuperExecute(Object[] args) {
                return super.execute(args);
            }
        } : new BasicSelectExecution(this._dataSource, this._statementFactory, handler);
        cmd.setArgNames(argNames);
        cmd.setArgTypes(argTypes);
        cmd.setSql(sql);
        return cmd;
    }

    protected DBMeta findDBMeta() {
        return this._dbmeta;
    }

    @Override
    public Object[] getSqlExecutionArgument() {
        this.assertStatus("getSqlExecutionArgument");
        return new Object[0];
    }

    @Override
    public ConditionBean getConditionBean() {
        return null;
    }

    @Override
    public String getOutsideSqlPath() {
        return null;
    }

    @Override
    public OutsideSqlOption getOutsideSqlOption() {
        return null;
    }

    protected void assertStatus(String methodName) {
        this.assertBasicProperty(methodName);
        this.assertComponentProperty(methodName);
        if (this._dbmeta == null) {
            throw new IllegalStateException(this.buildAssertMessage("_dbmeta", methodName));
        }
    }

    public void setResultType(Class<RESULT> resultType) {
        this._resultType = resultType;
    }

    public void setDBMeta(DBMeta dbmeta) {
        this._dbmeta = dbmeta;
    }

    public void setSequenceCacheHandler(SequenceCacheHandler sequenceCacheHandler) {
        this._sequenceCacheHandler = sequenceCacheHandler;
    }
}

