/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.jdbc.metadata.sequence;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.engine.database.model.UnifiedSchema;
import org.seasar.dbflute.helper.StringKeyMap;
import org.seasar.dbflute.helper.jdbc.facade.DfJdbcFacade;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfSequenceMetaInfo;
import org.seasar.dbflute.logic.jdbc.metadata.sequence.DfSequenceExtractorBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfSequenceExtractorPostgreSQL
extends DfSequenceExtractorBase {
    private static final Log _log = LogFactory.getLog(DfSequenceExtractorPostgreSQL.class);

    public DfSequenceExtractorPostgreSQL(DataSource dataSource, List<UnifiedSchema> unifiedSchemaList) {
        super(dataSource, unifiedSchemaList);
    }

    @Override
    protected Map<String, DfSequenceMetaInfo> doGetSequenceMap() {
        _log.info((Object)"...Loading sequence informations");
        StringKeyMap resultMap = StringKeyMap.createAsFlexibleOrdered();
        DfJdbcFacade facade = new DfJdbcFacade(this._dataSource);
        String sql = this.buildMetaSelectSql();
        _log.info((Object)sql);
        ArrayList<String> columnList = new ArrayList<String>();
        columnList.add("sequence_catalog");
        columnList.add("sequence_schema");
        columnList.add("sequence_name");
        columnList.add("minimum_value");
        columnList.add("maximum_value");
        columnList.add("increment");
        List<Map<String, String>> resultList = facade.selectStringList(sql, columnList);
        StringBuilder logSb = new StringBuilder();
        logSb.append(this.ln()).append("[SEQUENCE]");
        for (Map<String, String> recordMap : resultList) {
            DfSequenceMetaInfo info = new DfSequenceMetaInfo();
            String sequenceCatalog = recordMap.get("sequence_catalog");
            info.setSequenceCatalog(sequenceCatalog);
            String sequenceSchema = recordMap.get("sequence_schema");
            info.setSequenceSchema(sequenceSchema);
            String sequenceName = recordMap.get("sequence_name");
            info.setSequenceName(sequenceName);
            UnifiedSchema unifiedSchema = this.createAsDynamicSchema(sequenceCatalog, sequenceSchema);
            String minValue = recordMap.get("minimum_value");
            if (minValue == null || minValue.trim().length() == 0) {
                minValue = this.selectMinimumValue(facade, unifiedSchema, sequenceName);
            }
            info.setMinimumValue(minValue != null ? new BigDecimal(minValue) : null);
            String maxValue = recordMap.get("maximum_value");
            if (maxValue == null || maxValue.trim().length() == 0) {
                maxValue = this.selectMaximumValue(facade, unifiedSchema, sequenceName);
            }
            info.setMaximumValue(maxValue != null ? new BigDecimal(maxValue) : null);
            String incrementSize = recordMap.get("increment");
            if (incrementSize == null || incrementSize.trim().length() == 0) {
                incrementSize = this.selectIncrementSize(facade, unifiedSchema, sequenceName);
            }
            info.setIncrementSize(incrementSize != null ? Integer.valueOf(incrementSize) : null);
            String key = this.buildSequenceMapKey(sequenceCatalog, sequenceSchema, sequenceName);
            resultMap.put(key, info);
            logSb.append(this.ln()).append(" ").append(key).append(" = ").append(info.toString());
        }
        _log.info((Object)logSb.toString());
        return resultMap;
    }

    protected String buildMetaSelectSql() {
        String schemaCondition;
        if (!this._unifiedSchemaList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (UnifiedSchema unifiedSchema : this._unifiedSchemaList) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append("'").append(unifiedSchema.getPureSchema()).append("'");
            }
            schemaCondition = sb.toString();
        } else {
            schemaCondition = "'public'";
        }
        return "select * from information_schema.sequences where sequence_schema in (" + schemaCondition + ")";
    }

    protected String selectMinimumValue(DfJdbcFacade facade, UnifiedSchema unifiedSchema, String sequenceName) {
        return this.selectElementValue(facade, unifiedSchema, sequenceName, "min_value");
    }

    protected String selectMaximumValue(DfJdbcFacade facade, UnifiedSchema unifiedSchema, String sequenceName) {
        return this.selectElementValue(facade, unifiedSchema, sequenceName, "max_value");
    }

    protected String selectIncrementSize(DfJdbcFacade facade, UnifiedSchema unifiedSchema, String sequenceName) {
        return this.selectElementValue(facade, unifiedSchema, sequenceName, "increment_by");
    }

    protected String selectElementValue(DfJdbcFacade facade, UnifiedSchema unifiedSchema, String sequenceName, String elementName) {
        String sql = this.buildElementValueSql(unifiedSchema.buildSqlName(sequenceName), elementName);
        ArrayList<String> columnList = new ArrayList<String>();
        columnList.add(elementName);
        List<Map<String, String>> resultList = facade.selectStringList(sql, columnList);
        if (!resultList.isEmpty()) {
            return resultList.get(0).get(elementName);
        }
        return null;
    }

    protected String buildElementValueSql(String sequenceName, String elementName) {
        return "select " + elementName + " from " + sequenceName;
    }
}

