/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.properties;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.seasar.dbflute.helper.StringSet;
import org.seasar.dbflute.properties.DfAbstractHelperProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DfLittleAdjustmentProperties
extends DfAbstractHelperProperties {
    public static final String KEY_littleAdjustmentMap = "littleAdjustmentMap";
    protected Map<String, Object> _littleAdjustmentMap;
    protected Set<String> _quoteTableNameSet;

    public DfLittleAdjustmentProperties(Properties prop) {
        super(prop);
    }

    public Map<String, Object> getLittleAdjustmentMap() {
        if (this._littleAdjustmentMap == null) {
            this._littleAdjustmentMap = this.mapProp("torque.littleAdjustmentMap", DEFAULT_EMPTY_MAP);
        }
        return this._littleAdjustmentMap;
    }

    public String getProperty(String key, String defaultValue) {
        return this.getPropertyIfNotBuildProp(key, defaultValue, this.getLittleAdjustmentMap());
    }

    public boolean isProperty(String key, boolean defaultValue) {
        return this.isPropertyIfNotBuildProp(key, defaultValue, this.getLittleAdjustmentMap());
    }

    public boolean isAvailableAddingSchemaToTableSqlName() {
        return this.isProperty("isAvailableAddingSchemaToTableSqlName", false);
    }

    public boolean isAvailableDatabaseDependency() {
        return this.isProperty("isAvailableDatabaseDependency", false);
    }

    public boolean isAvailableNonPrimaryKeyWritable() {
        return this.isProperty("isAvailableNonPrimaryKeyWritable", false);
    }

    public boolean isMakeEntityChaseRelation() {
        return this.isProperty("isMakeEntityChaseRelation", false);
    }

    public boolean isMakeDeprecated() {
        return this.isProperty("isMakeDeprecated", false);
    }

    public boolean isMakeRecentlyDeprecated() {
        return this.isProperty("isMakeRecentlyDeprecated", true);
    }

    public boolean isMakeConditionQueryEqualEmptyString() {
        return this.isProperty("isMakeConditionQueryEqualEmptyString", false);
    }

    public boolean hasExtendedImplementedInvokerAssistantClass() {
        String str = this.getExtendedImplementedInvokerAssistantClass();
        return str != null && str.trim().length() > 0 && !str.trim().equals("null");
    }

    public String getExtendedImplementedInvokerAssistantClass() {
        return this.getProperty("extendedImplementedInvokerAssistantClass", null);
    }

    public boolean hasExtendedImplementedCommonColumnAutoSetupperClass() {
        String str = this.getExtendedImplementedCommonColumnAutoSetupperClass();
        return str != null && str.trim().length() > 0 && !str.trim().equals("null");
    }

    public String getExtendedImplementedCommonColumnAutoSetupperClass() {
        return this.getProperty("extendedImplementedCommonColumnAutoSetupperClass", null);
    }

    public boolean hasExtendedS2DaoSettingClassValid() {
        String str = this.getExtendedS2DaoSettingClass();
        return str != null && str.trim().length() > 0 && !str.trim().equals("null");
    }

    public String getExtendedS2DaoSettingClass() {
        return this.getProperty("extendedS2DaoSettingClass", null);
    }

    public boolean isShortCharHandlingValid() {
        return !this.getShortCharHandlingMode().equalsIgnoreCase("NONE");
    }

    public String getShortCharHandlingMode() {
        String property = this.getProperty("shortCharHandlingMode", "NONE");
        return property.toUpperCase();
    }

    public String getShortCharHandlingModeCode() {
        return this.getShortCharHandlingMode().substring(0, 1);
    }

    protected Set<String> getQuoteTableNameSet() {
        if (this._quoteTableNameSet != null) {
            return this._quoteTableNameSet;
        }
        Map<String, Object> littleAdjustmentMap = this.getLittleAdjustmentMap();
        Object obj = littleAdjustmentMap.get("quoteTableNameList");
        if (obj == null) {
            return new HashSet<String>();
        }
        List list = this.castToList(obj, "littleAdjustmentMap.quoteTableNameList");
        this._quoteTableNameSet = StringSet.createAsFlexible();
        this._quoteTableNameSet.addAll(list);
        return this._quoteTableNameSet;
    }

    public boolean isQuoteTable(String tableName) {
        return this.getQuoteTableNameSet().contains(tableName);
    }

    public String quoteTableNameIfNeeds(String tableName) {
        return this.quoteTableNameIfNeeds(tableName, false);
    }

    public String quoteTableNameIfNeeds(String tableName, boolean directUse) {
        String endQuote;
        String beginQuote;
        if (!this.isQuoteTable(tableName)) {
            return tableName;
        }
        if (this.getBasicProperties().isDatabaseSqlServer()) {
            beginQuote = "[";
            endQuote = "]";
        } else {
            endQuote = beginQuote = directUse ? "\"" : "\\\"";
        }
        return beginQuote + tableName + endQuote;
    }

    public boolean isCDefToStringReturnsName() {
        return this.isProperty("isCDefToStringReturnsName", false);
    }

    public boolean isAlternateGenerateControlValid() {
        String str = this.getAlternateGenerateControl();
        return str != null && str.trim().length() > 0 && !str.trim().equals("null");
    }

    public String getAlternateGenerateControl() {
        return this.getProperty("alternateGenerateControl", null);
    }

    public boolean isAlternateSql2EntityControlValid() {
        String str = this.getAlternateSql2EntityControl();
        return str != null && str.trim().length() > 0 && !str.trim().equals("null");
    }

    public String getAlternateSql2EntityControl() {
        return this.getProperty("alternateSql2EntityControl", null);
    }

    public boolean isStopGenerateExtendedBhv() {
        return this.isProperty("isStopGenerateExtendedBhv", false);
    }

    public boolean isStopGenerateExtendedDao() {
        return this.isProperty("isStopGenerateExtendedDao", false);
    }

    public boolean isStopGenerateExtendedEntity() {
        return this.isProperty("isStopGenerateExtendedEntity", false);
    }

    public boolean isDeleteOldTableClass() {
        return this.isProperty("isDeleteOldTableClass", true);
    }

    public boolean isSkipGenerateIfSameFile() {
        return this.isProperty("isSkipGenerateIfSameFile", true);
    }

    public boolean isAvailableToLowerInGeneratorUnderscoreMethod() {
        return this.isProperty("isAvailableToLowerInGeneratorUnderscoreMethod", true);
    }

    public boolean isMakeFlatExpansion() {
        return this.isProperty("isMakeFlatExpansion", false);
    }

    public boolean isMakeDaoInterface() {
        if (this.isTargetLanguageCSharp()) {
            return true;
        }
        boolean makeDaoInterface = this.booleanProp("torque.isMakeDaoInterface", false);
        if (makeDaoInterface) {
            String msg = "Dao interfaces are unsupported since DBFlute-0.8.7!";
            throw new UnsupportedOperationException(msg);
        }
        return false;
    }

    protected boolean isTargetLanguageCSharp() {
        return this.getBasicProperties().isTargetLanguageCSharp();
    }

    public boolean isCompatibleAutoMappingOldStyle() {
        return this.isProperty("isCompatibleAutoMappingOldStyle", false);
    }
}

