/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.helper.io.data.impl;

import java.io.File;
import java.io.FilenameFilter;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.dbflute.exception.DfTableDataRegistrationFailureException;
import org.seasar.dbflute.exception.DfTableNotFoundException;
import org.seasar.dbflute.helper.StringKeyMap;
import org.seasar.dbflute.helper.dataset.DfDataColumn;
import org.seasar.dbflute.helper.dataset.DfDataRow;
import org.seasar.dbflute.helper.dataset.DfDataSet;
import org.seasar.dbflute.helper.dataset.DfDataTable;
import org.seasar.dbflute.helper.dataset.states.DfDtsCreatedState;
import org.seasar.dbflute.helper.dataset.states.DfDtsSqlContext;
import org.seasar.dbflute.helper.dataset.types.DfDtsColumnType;
import org.seasar.dbflute.helper.dataset.types.DfDtsColumnTypes;
import org.seasar.dbflute.helper.io.data.DfXlsDataHandler;
import org.seasar.dbflute.helper.io.data.impl.DfAbsractDataWriter;
import org.seasar.dbflute.helper.io.data.impl.DfSeparatedDataHandlerImpl;
import org.seasar.dbflute.helper.io.xls.DfXlsReader;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfColumnMetaInfo;
import org.seasar.dbflute.properties.filereader.DfMapStringFileReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfXlsDataHandlerImpl
extends DfAbsractDataWriter
implements DfXlsDataHandler {
    private static final Log _log = LogFactory.getLog(DfSeparatedDataHandlerImpl.class);
    protected boolean _loggingInsertSql;
    protected String _schemaName;
    protected Pattern _skipSheetPattern;
    protected boolean _suppressBatchUpdate;
    protected Map<String, Map<String, DfColumnMetaInfo>> _metaInfoCacheMap = StringKeyMap.createAsFlexible();

    @Override
    public List<DfDataSet> readSeveralData(String dataDirectoryName) {
        List<File> xlsList = this.getXlsList(dataDirectoryName);
        ArrayList<DfDataSet> ls = new ArrayList<DfDataSet>();
        for (File file : xlsList) {
            DfXlsReader xlsReader = this.createXlsReader(dataDirectoryName, file);
            ls.add(xlsReader.read());
        }
        return ls;
    }

    /*
     * Loose catch block
     */
    @Override
    public void writeSeveralData(String dataDirectoryName, DataSource dataSource) {
        List<File> xlsList = this.getXlsList(dataDirectoryName);
        boolean useBatchUpdate = !this._suppressBatchUpdate;
        for (File file : xlsList) {
            _log.info((Object)"");
            _log.info((Object)"/= = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = ");
            _log.info((Object)("writeData(" + file + ")"));
            _log.info((Object)"= = = = = = =/");
            DfXlsReader xlsReader = this.createXlsReader(dataDirectoryName, file);
            DfDataSet dataSet = xlsReader.read();
            this.filterValidColumn(dataSet, dataSource);
            this.setupDefaultValue(dataDirectoryName, dataSet, dataSource);
            for (int i = 0; i < dataSet.getTableSize(); ++i) {
                SQLException ignored2222;
                Object var27_32;
                Statement ps;
                String tableName;
                DfDataTable dataTable;
                block31: {
                    block30: {
                        dataTable = dataSet.getTable(i);
                        tableName = dataTable.getTableName();
                        if (dataTable.getRowSize() == 0) {
                            _log.info((Object)("*Not found row at the table: " + tableName));
                            continue;
                        }
                        Map<String, DfColumnMetaInfo> columnMetaInfoMap = this.getColumnMetaInfo(dataSource, tableName);
                        this.beforeHandlingTable(dataSource, dataTable);
                        ArrayList<String> columnNameList = new ArrayList<String>();
                        for (int j = 0; j < dataTable.getColumnSize(); ++j) {
                            DfDataColumn dataColumn = dataTable.getColumn(j);
                            String columnName = dataColumn.getColumnName();
                            columnNameList.add(columnName);
                        }
                        ps = null;
                        for (int j = 0; j < dataTable.getRowSize(); ++j) {
                            ColumnContainer columnContainer;
                            Map<String, Object> columnValueMap;
                            DfDataRow dataRow = dataTable.getRow(j);
                            if (ps == null) {
                                MyCreatedState myCreatedState = new MyCreatedState();
                                String preparedSql = myCreatedState.buildPreparedSql(dataRow);
                                ps = dataSource.getConnection().prepareStatement(preparedSql);
                            }
                            if ((columnValueMap = (columnContainer = this.createColumnContainer(dataTable, dataRow)).getColumnValueMap()).isEmpty()) {
                                String msg = "The table was Not Found in the file:";
                                msg = msg + " tableName=" + tableName + " file=" + file;
                                throw new DfTableNotFoundException(msg);
                            }
                            if (this._loggingInsertSql) {
                                ArrayList<Object> valueList = new ArrayList<Object>(columnValueMap.values());
                                _log.info((Object)this.getSql4Log(tableName, columnNameList, valueList));
                            }
                            int bindCount = 1;
                            Set<Map.Entry<String, Object>> entrySet = columnValueMap.entrySet();
                            for (Map.Entry<String, Object> entry : entrySet) {
                                Object obj;
                                String columnName = entry.getKey();
                                if (this.processNotNullNotString(tableName, columnName, obj = entry.getValue(), (PreparedStatement)ps, bindCount)) {
                                    ++bindCount;
                                    continue;
                                }
                                if (this.processNull(tableName, columnName, obj, (PreparedStatement)ps, bindCount, columnMetaInfoMap)) {
                                    ++bindCount;
                                    continue;
                                }
                                String value = (String)obj;
                                if (value != null && value.length() > 1 && value.startsWith("\"") && value.endsWith("\"")) {
                                    value = this.removeDoubleQuotation(value);
                                }
                                if (this.processTimestamp(tableName, columnName, value, (PreparedStatement)ps, bindCount, columnMetaInfoMap)) {
                                    ++bindCount;
                                    continue;
                                }
                                if (this.processTime(tableName, columnName, value, (PreparedStatement)ps, bindCount, columnMetaInfoMap)) {
                                    ++bindCount;
                                    continue;
                                }
                                if (this.processBoolean(tableName, columnName, value, (PreparedStatement)ps, bindCount, columnMetaInfoMap)) {
                                    ++bindCount;
                                    continue;
                                }
                                if (this.processNumber(tableName, columnName, value, (PreparedStatement)ps, bindCount, columnMetaInfoMap)) {
                                    ++bindCount;
                                    continue;
                                }
                                if (this.processUUID(tableName, columnName, value, (PreparedStatement)ps, bindCount, columnMetaInfoMap)) {
                                    ++bindCount;
                                    continue;
                                }
                                if (this.processArray(tableName, columnName, value, (PreparedStatement)ps, bindCount, columnMetaInfoMap)) {
                                    ++bindCount;
                                    continue;
                                }
                                ps.setString(bindCount, value);
                                ++bindCount;
                            }
                            if (useBatchUpdate) {
                                ps.addBatch();
                                continue;
                            }
                            ps.execute();
                        }
                        if (ps == null) {
                            String msg = "The statement should not be null:";
                            msg = msg + " currentTable=" + dataTable.getTableName();
                            msg = msg + " rowSize=" + dataTable.getRowSize();
                            throw new IllegalStateException(msg);
                        }
                        if (!useBatchUpdate) break block30;
                        ps.executeBatch();
                    }
                    var27_32 = null;
                    if (ps == null) break block31;
                    try {
                        ps.close();
                    }
                    catch (SQLException ignored2222) {
                        _log.info((Object)"statement.close() threw the exception!", (Throwable)ignored2222);
                    }
                }
                this.finallyHandlingTable(dataSource, dataTable);
                {
                    continue;
                    catch (SQLException e) {
                        String msg;
                        SQLException nextEx = e.getNextException();
                        if (nextEx != null && !e.equals(nextEx)) {
                            if (e instanceof BatchUpdateException) {
                                _log.warn((Object)"");
                                _log.warn((Object)"/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * ");
                                _log.warn((Object)"[BatchUpdateException]");
                                _log.warn((Object)e.getMessage());
                                _log.warn((Object)" - - - - - - - -");
                                _log.warn((Object)"Also look at the nextException thrown!");
                                _log.warn((Object)"* * * * * * * * * */");
                                _log.warn((Object)"");
                                msg = "Failed to register the table data: " + tableName;
                                throw new DfTableDataRegistrationFailureException(msg, nextEx);
                            }
                            _log.warn((Object)"");
                            _log.warn((Object)"/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * ");
                            _log.warn((Object)"[NextException]", (Throwable)nextEx);
                            _log.warn((Object)"* * * * * * * * * */");
                            _log.warn((Object)"");
                            msg = "Failed to register the table data: " + tableName;
                            throw new DfTableDataRegistrationFailureException(msg, e);
                        }
                        msg = "Failed to register the table data: " + tableName;
                        throw new DfTableDataRegistrationFailureException(msg, e);
                    }
                }
                catch (Throwable throwable) {
                    var27_32 = null;
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (SQLException ignored2222) {
                            _log.info((Object)"statement.close() threw the exception!", (Throwable)ignored2222);
                        }
                    }
                    this.finallyHandlingTable(dataSource, dataTable);
                    throw throwable;
                }
            }
        }
    }

    protected void beforeHandlingTable(DataSource dataSource, DfDataTable dataTable) {
    }

    protected void finallyHandlingTable(DataSource dataSource, DfDataTable dataTable) {
    }

    protected String removeDoubleQuotation(String value) {
        value = value.substring(1);
        value = value.substring(0, value.length() - 1);
        return value;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Map<String, DfColumnMetaInfo> getColumnMetaInfo(DataSource dataSource, String tableName) {
        StringKeyMap stringKeyMap;
        if (this._metaInfoCacheMap.containsKey(tableName)) {
            return this._metaInfoCacheMap.get(tableName);
        }
        StringKeyMap columnMetaInfoMap = StringKeyMap.createAsFlexible();
        Connection conn = null;
        try {
            try {
                conn = dataSource.getConnection();
                DatabaseMetaData metaData = conn.getMetaData();
                List<DfColumnMetaInfo> columnList = this._columnHandler.getColumnList(metaData, this._schemaName, tableName);
                for (DfColumnMetaInfo columnMetaInfo : columnList) {
                    columnMetaInfoMap.put(columnMetaInfo.getColumnName(), columnMetaInfo);
                }
                this._metaInfoCacheMap.put(tableName, (Map<String, DfColumnMetaInfo>)columnMetaInfoMap);
                stringKeyMap = columnMetaInfoMap;
                Object var10_11 = null;
                if (conn == null) return stringKeyMap;
            }
            catch (SQLException e) {
                String msg = "Failed to get column meta informations: table=" + tableName;
                throw new IllegalStateException(msg, e);
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (conn == null) throw throwable;
            try {
                conn.close();
                throw throwable;
            }
            catch (SQLException ignored) {
                throw throwable;
            }
        }
        try {}
        catch (SQLException ignored) {
            // empty catch block
            return stringKeyMap;
        }
        conn.close();
        return stringKeyMap;
    }

    protected DfXlsReader createXlsReader(String dataDirectoryName, File file) {
        Map<String, String> tableNameMap = this.getTableNameMap(dataDirectoryName);
        Map<String, List<String>> notTrimTableColumnMap = this.getNotTrimTableColumnMap(dataDirectoryName);
        Map<String, List<String>> emptyStringTableColumnMap = this.getEmptyStringTableColumnMap(dataDirectoryName);
        DfXlsReader xlsReader = new DfXlsReader(file, tableNameMap, notTrimTableColumnMap, emptyStringTableColumnMap, this._skipSheetPattern);
        if (tableNameMap != null && !tableNameMap.isEmpty()) {
            _log.info((Object)"/- - - - - - - - - - - - - - - - - - - - - - - - - - - - ");
            _log.info((Object)("tableNameMap = " + tableNameMap));
            _log.info((Object)"- - - - - - - - - -/");
        }
        return xlsReader;
    }

    @Override
    public List<File> getXlsList(String dataDirectoryName) {
        Comparator<File> fileNameAscComparator = new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o1.getName().compareTo(o2.getName());
            }
        };
        TreeSet<File> sortedFileSet = new TreeSet<File>(fileNameAscComparator);
        File dir = new File(dataDirectoryName);
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".xls");
            }
        };
        File[] listFiles = dir.listFiles(filter);
        if (listFiles == null) {
            return new ArrayList<File>();
        }
        for (File file : listFiles) {
            sortedFileSet.add(file);
        }
        return new ArrayList<File>(sortedFileSet);
    }

    protected void filterValidColumn(DfDataSet dataSet, DataSource dataSource) {
        for (int i = 0; i < dataSet.getTableSize(); ++i) {
            DfDataTable table = dataSet.getTable(i);
            String tableName = table.getTableName();
            Map<String, DfColumnMetaInfo> metaInfoMap = this.getColumnMetaInfo(dataSource, tableName);
            for (int j = 0; j < table.getColumnSize(); ++j) {
                DfDataColumn dataColumn = table.getColumn(j);
                if (metaInfoMap.containsKey(dataColumn.getColumnName())) continue;
                dataColumn.setWritable(false);
            }
        }
    }

    protected void setupDefaultValue(String dataDirectoryName, DfDataSet dataSet, DataSource dataSource) {
        Map<String, String> defaultValueMap = this.getDefaultValueMap(dataDirectoryName);
        for (int i = 0; i < dataSet.getTableSize(); ++i) {
            DfDataTable table = dataSet.getTable(i);
            Set<String> defaultValueMapKeySet = defaultValueMap.keySet();
            String tableName = table.getTableName();
            Map<String, DfColumnMetaInfo> metaInfoMap = this.getColumnMetaInfo(dataSource, tableName);
            for (String defaultTargetColumnName : defaultValueMapKeySet) {
                Object value;
                DfDtsColumnType columnType;
                String defaultValue = defaultValueMap.get(defaultTargetColumnName);
                if (!metaInfoMap.containsKey(defaultTargetColumnName) || table.hasColumn(defaultTargetColumnName)) continue;
                if (defaultValue.equalsIgnoreCase("sysdate")) {
                    columnType = DfDtsColumnTypes.TIMESTAMP;
                    value = new Timestamp(System.currentTimeMillis());
                } else {
                    columnType = DfDtsColumnTypes.STRING;
                    value = defaultValue;
                }
                table.addColumn(defaultTargetColumnName, columnType);
                int rowSize = table.getRowSize();
                for (int j = 0; j < table.getRowSize(); ++j) {
                    DfDataRow row = table.getRow(j);
                    row.addValue(defaultTargetColumnName, value);
                    ++rowSize;
                }
            }
        }
    }

    private Map<String, String> getDefaultValueMap(String dataDirectoryName) {
        DfMapStringFileReader reader = new DfMapStringFileReader();
        String path = dataDirectoryName + "/defaultValueMap.dataprop";
        Map<String, String> resultMap = reader.readMapAsStringValue(path);
        if (resultMap != null && !resultMap.isEmpty()) {
            return resultMap;
        }
        path = dataDirectoryName + "/default-value.txt";
        resultMap = reader.readMapAsStringValue(path);
        return resultMap;
    }

    private Map<String, String> getTableNameMap(String dataDirectoryName) {
        DfMapStringFileReader reader = new DfMapStringFileReader();
        String path = dataDirectoryName + "/tableNameMap.dataprop";
        Map<String, String> resultMap = reader.readMapAsStringValue(path);
        if (resultMap == null || resultMap.isEmpty()) {
            path = dataDirectoryName + "/table-name.txt";
            resultMap = reader.readMapAsStringValue(path);
        }
        StringKeyMap flmap = StringKeyMap.createAsFlexible();
        flmap.putAll(resultMap);
        return flmap;
    }

    private Map<String, List<String>> getNotTrimTableColumnMap(String dataDirectoryName) {
        DfMapStringFileReader reader = new DfMapStringFileReader();
        String path = dataDirectoryName + "/notTrimColumnMap.dataprop";
        Map<String, List<String>> resultMap = reader.readMapAsStringListValue(path);
        if (resultMap == null || resultMap.isEmpty()) {
            path = dataDirectoryName + "/not-trim-column.txt";
            resultMap = reader.readMapAsStringListValue(path);
        }
        Set<Map.Entry<String, List<String>>> entrySet = resultMap.entrySet();
        StringKeyMap stringKeyMap = StringKeyMap.createAsFlexible();
        for (Map.Entry<String, List<String>> entry : entrySet) {
            stringKeyMap.put(entry.getKey(), entry.getValue());
        }
        return stringKeyMap;
    }

    private Map<String, List<String>> getEmptyStringTableColumnMap(String dataDirectoryName) {
        DfMapStringFileReader reader = new DfMapStringFileReader();
        String path = dataDirectoryName + "/emptyStringColumnMap.dataprop";
        Map<String, List<String>> resultMap = reader.readMapAsStringListValue(path);
        if (resultMap == null || resultMap.isEmpty()) {
            path = dataDirectoryName + "/empty-string-column.txt";
            resultMap = reader.readMapAsStringListValue(path);
        }
        Set<Map.Entry<String, List<String>>> entrySet = resultMap.entrySet();
        StringKeyMap stringKeyMap = StringKeyMap.createAsFlexible();
        for (Map.Entry<String, List<String>> entry : entrySet) {
            stringKeyMap.put(entry.getKey(), entry.getValue());
        }
        return stringKeyMap;
    }

    protected String getSql4Log(String tableName, List<String> columnNameList, List<? extends Object> bindParameters) {
        String bindParameterString = bindParameters.toString();
        bindParameterString = bindParameterString.substring(1, bindParameterString.length() - 1);
        return tableName + ":{" + bindParameterString + "}";
    }

    protected ColumnContainer createColumnContainer(DfDataTable dataTable, DfDataRow dataRow) {
        ColumnContainer container = new ColumnContainer();
        for (int i = 0; i < dataTable.getColumnSize(); ++i) {
            DfDataColumn dataColumn = dataTable.getColumn(i);
            if (!dataColumn.isWritable()) continue;
            Object value = dataRow.getValue(i);
            String columnName = dataColumn.getColumnName();
            container.addColumnValue(columnName, value);
            container.addColumnObject(columnName, dataColumn);
        }
        return container;
    }

    public boolean isLoggingInsertSql() {
        return this._loggingInsertSql;
    }

    public void setLoggingInsertSql(boolean loggingInsertSql) {
        this._loggingInsertSql = loggingInsertSql;
    }

    public boolean isSuppressBatchUpdate() {
        return this._suppressBatchUpdate;
    }

    public void setSuppressBatchUpdate(boolean suppressBatchUpdate) {
        this._suppressBatchUpdate = suppressBatchUpdate;
    }

    public String getSchemaName() {
        return this._schemaName;
    }

    public void setSchemaName(String schemaName) {
        this._schemaName = schemaName;
    }

    public void setSkipSheet(String skipSheet) {
        if (skipSheet == null || skipSheet.trim().length() == 0) {
            return;
        }
        try {
            this._skipSheetPattern = Pattern.compile(skipSheet);
        }
        catch (PatternSyntaxException e) {
            String msg = "The pattern syntax for skip-sheet was wrong: " + skipSheet;
            throw new IllegalStateException(msg, e);
        }
    }

    protected static class MyCreatedState {
        protected MyCreatedState() {
        }

        public String buildPreparedSql(final DfDataRow row) {
            DfDtsCreatedState createdState = new DfDtsCreatedState(){

                public String toString() {
                    DfDtsSqlContext sqlContext = this.getSqlContext(row);
                    return sqlContext.getSql();
                }
            };
            return createdState.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ColumnContainer {
        protected Map<String, Object> columnValueMap = new LinkedHashMap<String, Object>();
        protected Map<String, DfDataColumn> columnObjectMap = new LinkedHashMap<String, DfDataColumn>();

        protected ColumnContainer() {
        }

        public Map<String, Object> getColumnValueMap() {
            return this.columnValueMap;
        }

        public void addColumnValue(String columnName, Object columnValue) {
            this.columnValueMap.put(columnName, columnValue);
        }

        public Map<String, DfDataColumn> getColumnObjectMap() {
            return this.columnObjectMap;
        }

        public void addColumnObject(String columnName, DfDataColumn columnObject) {
            this.columnObjectMap.put(columnName, columnObject);
        }
    }
}

