/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.engine.database.model;

import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.engine.EngineException;
import org.apache.torque.engine.database.model.AppData;
import org.apache.torque.engine.database.model.Column;
import org.apache.torque.engine.database.model.ForeignKey;
import org.apache.torque.engine.database.model.NameFactory;
import org.apache.torque.engine.database.model.Table;
import org.apache.torque.engine.database.model.TypeMap;
import org.apache.velocity.texen.util.FileUtil;
import org.seasar.dbflute.DfBuildProperties;
import org.seasar.dbflute.config.DfDatabaseNameMapping;
import org.seasar.dbflute.friends.torque.DfAdditionalForeignKeyInitializer;
import org.seasar.dbflute.friends.torque.DfAdditionalPrimaryKeyInitializer;
import org.seasar.dbflute.friends.torque.DfAdditionalUniqueKeyInitializer;
import org.seasar.dbflute.friends.velocity.DfGenerator;
import org.seasar.dbflute.helper.StringKeyMap;
import org.seasar.dbflute.helper.jdbc.context.DfDataSourceContext;
import org.seasar.dbflute.logic.bqp.DfBehaviorQueryPathSetupper;
import org.seasar.dbflute.logic.deletefile.DfOldClassHandler;
import org.seasar.dbflute.logic.initializer.IncludeQueryInitializer;
import org.seasar.dbflute.logic.jdbc.handler.DfProcedureHandler;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfProcedureMetaInfo;
import org.seasar.dbflute.logic.outsidesql.DfSqlFileCollector;
import org.seasar.dbflute.logic.pathhandling.DfPackagePathHandler;
import org.seasar.dbflute.logic.pmb.DfParameterBeanBasicHandler;
import org.seasar.dbflute.logic.pmb.DfParameterBeanMetaData;
import org.seasar.dbflute.properties.DfBasicProperties;
import org.seasar.dbflute.properties.DfBuriProperties;
import org.seasar.dbflute.properties.DfClassificationProperties;
import org.seasar.dbflute.properties.DfDatabaseProperties;
import org.seasar.dbflute.properties.DfSequenceIdentityProperties;
import org.seasar.dbflute.properties.assistant.DfTableFinder;
import org.seasar.dbflute.properties.assistant.commoncolumn.CommonColumnSetupResource;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Database {
    private static final Log _log = LogFactory.getLog(Database.class);
    protected Integer _version;
    protected String _name;
    protected AppData _appData;
    protected AppData _sql2entitySchemaData;
    protected List<Table> _tableList = new ArrayList<Table>(100);
    protected StringKeyMap<Table> _tableMap = StringKeyMap.createAsFlexibleOrdered();
    protected Map<String, DfParameterBeanMetaData> _pmbMetaDataMap;
    protected String _databaseType;
    protected String _defaultJavaNamingMethod;
    protected boolean _skipDeleteOldClass;
    protected DfParameterBeanBasicHandler _pmbBasicHandler;
    protected Map<String, Map<String, Map<String, String>>> _tableBqpMap;
    protected List<DfProcedureMetaInfo> _procedureMetaInfoList;

    public void initializeVersion(Integer version) {
        DfBuildProperties.getInstance().setVersion(version);
    }

    public void loadFromXML(Attributes attrib) {
        this.setName(attrib.getValue("name"));
        this._defaultJavaNamingMethod = attrib.getValue("defaultJavaNamingMethod");
        if (this._defaultJavaNamingMethod == null) {
            this._defaultJavaNamingMethod = "underscore";
        }
    }

    public Table[] getTables() {
        int size = this._tableList.size();
        Table[] tbls = new Table[size];
        for (int i = 0; i < size; ++i) {
            tbls[i] = this._tableList.get(i);
        }
        return tbls;
    }

    public List<Table> getTableList() {
        Table[] tables;
        ArrayList<Table> ls = new ArrayList<Table>();
        for (Table table : tables = this.getTables()) {
            ls.add(table);
        }
        return ls;
    }

    public List<Table> getTableDisplaySortedList() {
        Comparator<Table> tableDisplayOrderBy = this.getProperties().getDocumentProperties().getTableDisplayOrderBy();
        TreeSet<Table> tableSet = new TreeSet<Table>(tableDisplayOrderBy);
        tableSet.addAll(this.getTableList());
        return new ArrayList<Table>(tableSet);
    }

    public Table getTable(String name) {
        return (Table)this._tableMap.get((Object)name);
    }

    public Table addTable(Attributes attrib) {
        Table tbl = new Table();
        tbl.setDatabase(this);
        tbl.loadFromXML(attrib);
        this.addTable(tbl);
        return tbl;
    }

    public void addTable(Table tbl) {
        tbl.setDatabase(this);
        this._tableList.add(tbl);
        this._tableMap.put(tbl.getName(), (Object)tbl);
    }

    public void doFinalInitialization() throws EngineException {
        Table[] tables = this.getTables();
        for (int i = 0; i < tables.length; ++i) {
            Table currTable = tables[i];
            currTable.doFinalInitialization();
            ForeignKey[] fks = currTable.getForeignKeys();
            for (int j = 0; j < fks.length; ++j) {
                ForeignKey currFK = fks[j];
                Table foreignTable = this.getTable(currFK.getForeignTableName());
                if (foreignTable == null) {
                    throw new EngineException("Attempt to set foreign key to nonexistent table, " + currFK.getForeignTableName());
                }
                List<ForeignKey> refererList = foreignTable.getRefererList();
                if (refererList == null || !refererList.contains(currFK)) {
                    foreignTable.addReferrer(currFK);
                }
                Iterator<String> localColumnNames = currFK.getLocalColumns().iterator();
                while (localColumnNames.hasNext()) {
                    Column local = currTable.getColumn(localColumnNames.next());
                    if (local == null) {
                        throw new EngineException("Attempt to define foreign key with nonexistent column in table, " + currTable.getName());
                    }
                    if (!local.isPrimaryKey()) continue;
                    currTable.setContainsForeignPK(true);
                }
                for (String foreignColumnName : currFK.getForeignColumns()) {
                    Column foreign = foreignTable.getColumn(foreignColumnName);
                    if (foreign == null) {
                        throw new EngineException("Attempt to set foreign key to nonexistent column: table=" + currTable.getName() + ", foreign column=" + foreignColumnName);
                    }
                    foreign.addReferrer(currFK);
                }
            }
        }
    }

    protected DfParameterBeanBasicHandler getParameterBeanBasicHandler() {
        if (this._pmbBasicHandler != null) {
            return this._pmbBasicHandler;
        }
        DfBasicProperties basicProp = this.getBasicProperties();
        DfClassificationProperties classificationProp = this.getClassificationProperties();
        this._pmbBasicHandler = new DfParameterBeanBasicHandler(this._pmbMetaDataMap, basicProp, classificationProp);
        return this._pmbBasicHandler;
    }

    public boolean isExistPmbMetaData() {
        return this.getParameterBeanBasicHandler().isExistPmbMetaData();
    }

    public Collection<DfParameterBeanMetaData> getPmbMetaDataList() {
        return this.getParameterBeanBasicHandler().getPmbMetaDataList();
    }

    public String getPmbMetaDataSuperClassDefinition(String className) {
        return this.getParameterBeanBasicHandler().getPmbMetaDataSuperClassDefinition(className);
    }

    public boolean hasPmbMetaDataSafetyResultDefitinion(String className) {
        return this.getParameterBeanBasicHandler().hasPmbMetaDataSafetyResultDefitinion(className);
    }

    public Map<String, String> getPmbMetaDataPropertyNameTypeMap(String className) {
        return this.getParameterBeanBasicHandler().getPmbMetaDataPropertyNameTypeMap(className);
    }

    public Map<String, String> getPmbMetaDataPropertyNameColumnNameMap(String className) {
        return this.getParameterBeanBasicHandler().getPmbMetaDataPropertyNameColumnNameMap(className);
    }

    public Map<String, String> getPmbMetaDataPropertyNameOptionMap(String className) {
        return this.getParameterBeanBasicHandler().getPmbMetaDataPropertyNameOptionMap(className);
    }

    public Set<String> getPmbMetaDataPropertySet(String className) {
        return this.getParameterBeanBasicHandler().getPmbMetaDataPropertySet(className);
    }

    public String getPmbMetaDataPropertyType(String className, String propertyName) {
        return this.getParameterBeanBasicHandler().getPmbMetaDataPropertyType(className, propertyName);
    }

    public String getPmbMetaDataPropertyColumnName(String className, String propertyName) {
        return this.getParameterBeanBasicHandler().getPmbMetaDataPropertyColumnName(className, propertyName);
    }

    public boolean isPmbMetaDataForProcedure(String className) {
        return this.getParameterBeanBasicHandler().isPmbMetaDataForProcedure(className);
    }

    public String getPmbMetaDataProcedureName(String className) {
        return this.getParameterBeanBasicHandler().getPmbMetaDataProcedureName(className);
    }

    public boolean isPmbMetaDataPropertyOptionProcedureParameterIn(String className, String propertyName) {
        return this.getParameterBeanBasicHandler().isPmbMetaDataPropertyOptionProcedureParameterIn(className, propertyName);
    }

    public boolean isPmbMetaDataPropertyOptionProcedureParameterOut(String className, String propertyName) {
        return this.getParameterBeanBasicHandler().isPmbMetaDataPropertyOptionProcedureParameterOut(className, propertyName);
    }

    public boolean isPmbMetaDataPropertyOptionProcedureParameterInOut(String className, String propertyName) {
        return this.getParameterBeanBasicHandler().isPmbMetaDataPropertyOptionProcedureParameterInOut(className, propertyName);
    }

    public boolean isPmbMetaDataPropertyOptionProcedureParameterReturn(String className, String propertyName) {
        return this.getParameterBeanBasicHandler().isPmbMetaDataPropertyOptionProcedureParameterReturn(className, propertyName);
    }

    public boolean hasPmbMetaDataPropertyOptionOriginalOnlyOneSetter(String className, String propertyName) {
        return this.getParameterBeanBasicHandler().hasPmbMetaDataPropertyOptionOriginalOnlyOneSetter(className, propertyName);
    }

    public boolean hasPmbMetaDataPropertyOptionAnyLikeSearch(String className) {
        return this.getParameterBeanBasicHandler().hasPmbMetaDataPropertyOptionAnyLikeSearch(className);
    }

    public boolean hasPmbMetaDataPropertyOptionAnyLikeSearch(String className, String propertyName) {
        return this.getParameterBeanBasicHandler().hasPmbMetaDataPropertyOptionAnyLikeSearch(className, propertyName);
    }

    public boolean isPmbMetaDataPropertyOptionLikeSearch(String className, String propertyName) {
        return this.getParameterBeanBasicHandler().isPmbMetaDataPropertyOptionLikeSearch(className, propertyName);
    }

    public boolean isPmbMetaDataPropertyOptionPrefixSearch(String className, String propertyName) {
        return this.getParameterBeanBasicHandler().isPmbMetaDataPropertyOptionPrefixSearch(className, propertyName);
    }

    public boolean isPmbMetaDataPropertyOptionContainSearch(String className, String propertyName) {
        return this.getParameterBeanBasicHandler().isPmbMetaDataPropertyOptionContainSearch(className, propertyName);
    }

    public boolean isPmbMetaDataPropertyOptionSuffixSearch(String className, String propertyName) {
        return this.getParameterBeanBasicHandler().isPmbMetaDataPropertyOptionSuffixSearch(className, propertyName);
    }

    public boolean hasPmbMetaDataPropertyOptionAnyFromTo(String className) {
        return this.getParameterBeanBasicHandler().hasPmbMetaDataPropertyOptionAnyFromTo(className);
    }

    public boolean hasPmbMetaDataPropertyOptionAnyFromTo(String className, String propertyName) {
        return this.getParameterBeanBasicHandler().hasPmbMetaDataPropertyOptionAnyFromTo(className, propertyName);
    }

    public boolean isPmbMetaDataPropertyOptionFromDate(String className, String propertyName) {
        return this.getParameterBeanBasicHandler().isPmbMetaDataPropertyOptionFromDate(className, propertyName);
    }

    public boolean isPmbMetaDataPropertyOptionToDate(String className, String propertyName) {
        return this.getParameterBeanBasicHandler().isPmbMetaDataPropertyOptionToDate(className, propertyName);
    }

    public boolean isPmbMetaDataPropertyOptionClassification(String className, String propertyName) {
        return this.getParameterBeanBasicHandler().isPmbMetaDataPropertyOptionClassification(className, propertyName);
    }

    public String getPmbMetaDataPropertyOptionClassificationName(String className, String propertyName) {
        return this.getParameterBeanBasicHandler().getPmbMetaDataPropertyOptionClassificationName(className, propertyName);
    }

    public List<Map<String, String>> getPmbMetaDataPropertyOptionClassificationMapList(String className, String propertyName) {
        return this.getParameterBeanBasicHandler().getPmbMetaDataPropertyOptionClassificationMapList(className, propertyName);
    }

    public String getPmbMetaDataPropertyRefColumnInfo(String className, String propertyName) {
        try {
            DfParameterBeanBasicHandler handler = this.getParameterBeanBasicHandler();
            AppData data = this._sql2entitySchemaData;
            String alias = handler.getPmbMetaDataPropertyRefAlias(className, propertyName, data);
            String name = handler.getPmbMetaDataPropertyRefName(className, propertyName, data);
            String lineDisp = handler.getPmbMetaDataPropertyRefLineDisp(className, propertyName, data);
            if (name != null && name.trim().length() > 0) {
                return " :: related to " + alias + name + ": " + lineDisp;
            }
            return "";
        }
        catch (RuntimeException e) {
            String msg = "Failed to execute getPmbMetaDataPropertyRefColumnInfo(): ";
            msg = msg + " " + className + "." + propertyName;
            _log.debug((Object)msg, (Throwable)e);
            throw new IllegalStateException(msg, e);
        }
    }

    public boolean isPmbMetaDataPropertyRefColumnChar(String className, String propertyName) {
        return this.getParameterBeanBasicHandler().isPmbMetaDataPropertyRefColumnChar(className, propertyName, this._sql2entitySchemaData);
    }

    public String getPmbMetaDataPropertyRefSize(String className, String propertyName) {
        return this.getParameterBeanBasicHandler().getPmbMetaDataPropertyRefSize(className, propertyName, this._sql2entitySchemaData);
    }

    public void initializeAdditionalPrimaryKey() {
        DfAdditionalPrimaryKeyInitializer initializer = new DfAdditionalPrimaryKeyInitializer(this);
        initializer.initializeAdditionalPrimaryKey();
    }

    public void initializeAdditionalUniqueKey() {
        DfAdditionalUniqueKeyInitializer initializer = new DfAdditionalUniqueKeyInitializer(this);
        initializer.initializeAdditionalUniqueKey();
    }

    public void initializeAdditionalForeignKey() {
        DfBuriProperties buriProperties = this.getProperties().getBuriProperties();
        buriProperties.setupImplicitAdditionalForeignKey(new DfTableFinder(){

            public Table findTable(String tableName) {
                return Database.this.getTable(tableName);
            }
        });
        DfAdditionalForeignKeyInitializer initializer = new DfAdditionalForeignKeyInitializer(this);
        initializer.initializeAdditionalForeignKey();
    }

    public void initializeClassificationDeployment() {
        DfClassificationProperties clsProp = this.getClassificationProperties();
        clsProp.initializeClassificationDefinition();
        clsProp.initializeClassificationDeployment(this);
        if (this._sql2entitySchemaData != null) {
            try {
                clsProp.initializeClassificationDeployment(this._sql2entitySchemaData.getDatabase());
            }
            catch (EngineException e) {
                throw new IllegalStateException((Throwable)((Object)e));
            }
        }
    }

    public void initializeIncludeQuery() {
        IncludeQueryInitializer initializer = new IncludeQueryInitializer();
        initializer.setIncludeQueryProperties(this.getProperties().getIncludeQueryProperties());
        initializer.setTableFinder(new DfTableFinder(){

            public Table findTable(String name) {
                return Database.this.getTable(name);
            }
        });
        initializer.initializeIncludeQuery();
    }

    public void checkProperties() {
        this.getProperties().getSequenceIdentityProperties().checkSequenceDefinitionMap(new DfSequenceIdentityProperties.SequenceDefinitionMapChecker(){

            public boolean hasTable(String tableName) {
                return Database.this.getTable(tableName) != null;
            }
        });
        this.getProperties().getBasicProperties().checkDirectoryPackage();
    }

    public void deleteOldTableClass() {
        if (this._skipDeleteOldClass) {
            return;
        }
        if (this.getProperties().getLittleAdjustmentProperties().isDeleteOldTableClass()) {
            DfOldClassHandler handler = this.createOldClassHandler();
            handler.deleteOldTableClass();
        }
    }

    public void deleteOldCustomizeClass() {
        if (this._skipDeleteOldClass) {
            return;
        }
        if (this.getProperties().getLittleAdjustmentProperties().isDeleteOldTableClass()) {
            DfOldClassHandler handler = this.createOldClassHandler();
            handler.setPmbMetaDataMap(this._pmbMetaDataMap);
            handler.deleteOldCustomizeClass();
        }
    }

    protected DfOldClassHandler createOldClassHandler() {
        return new DfOldClassHandler(this.getGeneratorInstance(), this.getBasicProperties(), this.getProperties().getLittleAdjustmentProperties(), this.getTableList());
    }

    public void enableGenerateOutputDirectory() {
        String outputDirectory = this.getProperties().getBasicProperties().getGenerateOutputDirectory();
        _log.info((Object)("...Setting up generateOutputDirectory: " + outputDirectory));
        this.getGeneratorInstance().setOutputPath(outputDirectory);
    }

    public void enableSql2EntityOutputDirectory() {
        String outputDirectory = this.getProperties().getOutsideSqlProperties().getSql2EntityOutputDirectory();
        _log.info((Object)("...Setting up sql2EntityOutputDirectory: " + outputDirectory));
        this.getGeneratorInstance().setOutputPath(outputDirectory);
    }

    public void enableDocumentOutputDirectory() {
        String outputDirectory = this.getProperties().getDocumentProperties().getDocumentOutputDirectory();
        _log.info((Object)("...Setting up documentOutputDirectory: " + outputDirectory));
        File dir = new File(outputDirectory);
        if (!dir.exists()) {
            _log.info((Object)("...Making directories for documentOutputDirectory: " + dir));
            dir.mkdirs();
        }
        this.getGeneratorInstance().setOutputPath(outputDirectory);
    }

    public void enableFlexDtoOutputDirectory() {
        String outputDirectory = this.getProperties().getFlexDtoProperties().getOutputDirectory();
        _log.info((Object)("...Setting up flexDtoOutputDirectory: " + outputDirectory));
        this.getGeneratorInstance().setOutputPath(outputDirectory);
    }

    public DfGenerator getGeneratorInstance() {
        return DfGenerator.getInstance();
    }

    public String getDefaultDBDef() {
        return this.getBasicProperties().getCurrentDBDef().code();
    }

    public String getGenerateDbName() {
        return DfDatabaseNameMapping.getInstance().findGenerateName(this.getDatabaseType());
    }

    protected DfBuildProperties getProperties() {
        return DfBuildProperties.getInstance();
    }

    protected DfBasicProperties getBasicProperties() {
        return this.getProperties().getBasicProperties();
    }

    public String getProjectName() {
        return this.getBasicProperties().getProjectName();
    }

    public String getDatabaseName() {
        return this.getBasicProperties().getDatabaseType();
    }

    public boolean isDatabaseMySQL() {
        return this.getBasicProperties().isDatabaseMySQL();
    }

    public boolean isDatabasePostgreSQL() {
        return this.getBasicProperties().isDatabasePostgreSQL();
    }

    public boolean isDatabaseOracle() {
        return this.getBasicProperties().isDatabaseOracle();
    }

    public boolean isDatabaseDB2() {
        return this.getBasicProperties().isDatabaseDB2();
    }

    public boolean isDatabaseSQLServer() {
        return this.getBasicProperties().isDatabaseSqlServer();
    }

    public boolean isDatabaseDerby() {
        return this.getBasicProperties().isDatabaseDerby();
    }

    public boolean isDatabaseH2() {
        return this.getBasicProperties().isDatabaseH2();
    }

    public boolean isDatabaseMSAccess() {
        return this.getBasicProperties().isDatabaseMsAccess();
    }

    public String getTargetLanguage() {
        return this.getBasicProperties().getTargetLanguage();
    }

    public String getResourceDirectory() {
        return this.getBasicProperties().getResourceDirectory();
    }

    public String getTargetLanguageInitCap() {
        String targetLanguage = this.getBasicProperties().getTargetLanguage();
        return targetLanguage.substring(0, 1).toUpperCase() + targetLanguage.substring(1);
    }

    public boolean isTargetLanguageJava() {
        return this.getBasicProperties().isTargetLanguageJava();
    }

    public boolean isTargetLanguageCSharp() {
        return this.getBasicProperties().isTargetLanguageCSharp();
    }

    public boolean isTargetLanguagePhp() {
        return this.getBasicProperties().isTargetLanguagePhp();
    }

    public boolean isJavaVersionGreaterEqualTiger() {
        return this.getBasicProperties().isJavaVersionGreaterEqualTiger();
    }

    public boolean isJavaVersionGreaterEqualMustang() {
        return this.getBasicProperties().isJavaVersionGreaterEqualMustang();
    }

    public String getTargetContainerName() {
        return this.getBasicProperties().getTargetContainerName();
    }

    public boolean isTargetContainerSeasar() {
        return this.getBasicProperties().isTargetContainerSeasar();
    }

    public boolean isTargetContainerSpring() {
        return this.getBasicProperties().isTargetContainerSpring();
    }

    public boolean isTargetContainerLucy() {
        return this.getBasicProperties().isTargetContainerLucy();
    }

    public boolean isTargetContainerGuice() {
        return this.getBasicProperties().isTargetContainerGuice();
    }

    public boolean isTargetContainerSlim3() {
        return this.getBasicProperties().isTargetContainerSlim3();
    }

    public String getTemplateFileExtension() {
        return this.getBasicProperties().getTemplateFileExtension();
    }

    public String getClassFileExtension() {
        return this.getBasicProperties().getClassFileExtension();
    }

    public String getTemplateFileEncoding() {
        return this.getBasicProperties().getTemplateFileEncoding();
    }

    public String getJavaDir() {
        return this.getBasicProperties().getGenerateOutputDirectory();
    }

    public String getClassAuthor() {
        return this.getBasicProperties().getClassAuthor();
    }

    public String getAllClassCopyright() {
        return this.getProperties().getAllClassCopyrightProperties().getAllClassCopyright();
    }

    public void reflectAllExCopyright(String path) {
        String outputPath = DfGenerator.getInstance().getOutputPath();
        String absolutePath = outputPath + "/" + path;
        this.getProperties().getAllClassCopyrightProperties().reflectAllExCopyright(absolutePath);
    }

    public String getProjectPrefix() {
        return this.getBasicProperties().getProjectPrefix();
    }

    public String getBasePrefix() {
        return this.getBasicProperties().getBasePrefix();
    }

    public String getBaseSuffixForEntity() {
        return "";
    }

    public String getPackageBase() {
        return this.getProperties().getBasicProperties().getPackageBase();
    }

    public String getBaseCommonPackage() {
        return this.getProperties().getBasicProperties().getBaseCommonPackage();
    }

    public String getBaseBehaviorPackage() {
        return this.getProperties().getBasicProperties().getBaseBehaviorPackage();
    }

    public String getBaseDaoPackage() {
        return this.getProperties().getBasicProperties().getBaseDaoPackage();
    }

    public String getBaseEntityPackage() {
        return this.getProperties().getBasicProperties().getBaseEntityPackage();
    }

    public String getDBMetaPackage() {
        return this.getProperties().getBasicProperties().getDBMetaPackage();
    }

    public String getConditionBeanPackage() {
        return this.getProperties().getBasicProperties().getConditionBeanPackage();
    }

    public String getExtendedConditionBeanPackage() {
        return this.getProperties().getBasicProperties().getExtendedConditionBeanPackage();
    }

    public String getExtendedBehaviorPackage() {
        return this.getProperties().getBasicProperties().getExtendedBehaviorPackage();
    }

    public String getExtendedDaoPackage() {
        return this.getProperties().getBasicProperties().getExtendedDaoPackage();
    }

    public String getExtendedEntityPackage() {
        return this.getProperties().getBasicProperties().getExtendedEntityPackage();
    }

    public boolean isFlatDirectoryPackageValid() {
        return this.getProperties().getBasicProperties().isFlatDirectoryPackageValid();
    }

    public String getFlatDirectoryPackage() {
        return this.getProperties().getBasicProperties().getFlatDirectoryPackage();
    }

    public boolean isOmitDirectoryPackageValid() {
        return this.getProperties().getBasicProperties().isOmitDirectoryPackageValid();
    }

    public String getOmitDirectoryPackage() {
        return this.getProperties().getBasicProperties().getOmitDirectoryPackage();
    }

    public boolean isAvailableHotDeploy() {
        return this.getBasicProperties().isAvailableHotDeploy();
    }

    public String getBehaviorQueryPathBeginMark() {
        return this.getBasicProperties().getBehaviorQueryPathBeginMark();
    }

    public String getBehaviorQueryPathEndMark() {
        return this.getBasicProperties().getBehaviorQueryPathEndMark();
    }

    protected DfDatabaseProperties getDatabaseProperties() {
        return this.getProperties().getDatabaseProperties();
    }

    public String getDatabaseSchema() {
        return this.getDatabaseProperties().getDatabaseSchema();
    }

    public boolean hasDatabaseSchema() {
        String databaseSchema = this.getDatabaseSchema();
        return databaseSchema != null && databaseSchema.trim().length() > 0;
    }

    public boolean hasAdditionalSchema() {
        return this.getDatabaseProperties().hasAdditionalSchema();
    }

    public String getDBFluteDiconNamespace() {
        return this.getProperties().getDependencyInjectionProperties().getDBFluteDiconNamespace();
    }

    public List<String> getDBFluteDiconPackageNameList() {
        String resourceOutputDirectory = this.getBasicProperties().getResourceOutputDirectory();
        if (resourceOutputDirectory != null) {
            ArrayList<String> resulList = new ArrayList<String>();
            resulList.add(resourceOutputDirectory);
            return resulList;
        }
        List<String> diconPackageNameList = this.getProperties().getDependencyInjectionProperties().getDBFluteDiconPackageNameList();
        if (diconPackageNameList != null && !diconPackageNameList.isEmpty()) {
            return diconPackageNameList;
        }
        ArrayList<String> resulList = new ArrayList<String>();
        resulList.add(this.getBasicProperties().getDefaultResourceOutputDirectory());
        return resulList;
    }

    public String getDBFluteCreatorDiconFileName() {
        return this.getProperties().getDependencyInjectionProperties().getDBFluteCreatorDiconFileName();
    }

    public String getDBFluteCustomizerDiconFileName() {
        return this.getProperties().getDependencyInjectionProperties().getDBFluteCustomizerDiconFileName();
    }

    public String getDBFluteDiconFileName() {
        return this.getProperties().getDependencyInjectionProperties().getDBFluteDiconFileName();
    }

    public String getJ2eeDiconResourceName() {
        return this.getProperties().getDependencyInjectionProperties().getJ2eeDiconResourceName();
    }

    public List<String> getDBFluteDiconBeforeJ2eeIncludePathList() {
        return this.getProperties().getDependencyInjectionProperties().getDBFluteDiconBeforeJ2eeIncludePathList();
    }

    public List<String> getDBFluteDiconOtherIncludePathList() {
        return this.getProperties().getDependencyInjectionProperties().getDBFluteDiconOtherIncludePathList();
    }

    public List<String> getDBFluteBeansPackageNameList() {
        String resourceOutputDirectory = this.getBasicProperties().getResourceOutputDirectory();
        if (resourceOutputDirectory != null) {
            ArrayList<String> resulList = new ArrayList<String>();
            resulList.add(resourceOutputDirectory);
            return resulList;
        }
        List<String> diconPackageNameList = this.getProperties().getDependencyInjectionProperties().getDBFluteBeansPackageNameList();
        if (diconPackageNameList != null && !diconPackageNameList.isEmpty()) {
            return diconPackageNameList;
        }
        ArrayList<String> resulList = new ArrayList<String>();
        resulList.add(this.getBasicProperties().getDefaultResourceOutputDirectory());
        return resulList;
    }

    public String getDBFluteBeansFileName() {
        return this.getProperties().getDependencyInjectionProperties().getDBFluteBeansFileName();
    }

    public String getDBFluteBeansDataSourceName() {
        return this.getProperties().getDependencyInjectionProperties().getDBFluteBeansDataSourceName();
    }

    public boolean isQuillDataSourceNameValid() {
        return this.getProperties().getDependencyInjectionProperties().isQuillDataSourceNameValid();
    }

    public String getQuillDataSourceName() {
        return this.getProperties().getDependencyInjectionProperties().getQuillDataSourceName();
    }

    public String getSequenceReturnType() {
        return this.getProperties().getSequenceIdentityProperties().getSequenceReturnType();
    }

    public Map<String, String> getCommonColumnMap() {
        return this.getProperties().getCommonColumnProperties().getCommonColumnMap();
    }

    public List<String> getCommonColumnNameList() {
        return this.getProperties().getCommonColumnProperties().getCommonColumnNameList();
    }

    public List<String> getCommonColumnNameConversionList() {
        return this.getProperties().getCommonColumnProperties().getCommonColumnNameConversionList();
    }

    public String filterCommonColumn(String commonColumnName) {
        return this.getProperties().getCommonColumnProperties().filterCommonColumn(commonColumnName);
    }

    public boolean hasCommonColumn() {
        return !this.getProperties().getCommonColumnProperties().getCommonColumnNameList().isEmpty();
    }

    public boolean isExistCommonColumnSetupElement() {
        return this.getProperties().getCommonColumnProperties().isExistCommonColumnSetupElement();
    }

    public boolean hasCommonColumnConvertion(String commonColumnName) {
        return this.getProperties().getCommonColumnProperties().isCommonColumnConversion(commonColumnName);
    }

    public Map<String, Object> getCommonColumnSetupBeforeInsertInterceptorLogicMap() {
        return this.getProperties().getCommonColumnProperties().getBeforeInsertMap();
    }

    public boolean containsValidColumnNameKeyCommonColumnSetupBeforeInsertInterceptorLogicMap(String columnName) {
        return this.getProperties().getCommonColumnProperties().containsValidColumnNameKeyCommonColumnSetupBeforeInsertInterceptorLogicMap(columnName);
    }

    public String getCommonColumnSetupBeforeInsertInterceptorLogicByColumnName(String columnName) {
        return this.getProperties().getCommonColumnProperties().getCommonColumnSetupBeforeInsertInterceptorLogicByColumnName(columnName);
    }

    public Map<String, Object> getCommonColumnSetupBeforeUpdateInterceptorLogicMap() {
        return this.getProperties().getCommonColumnProperties().getBeforeUpdateMap();
    }

    public boolean containsValidColumnNameKeyCommonColumnSetupBeforeUpdateInterceptorLogicMap(String columnName) {
        return this.getProperties().getCommonColumnProperties().containsValidColumnNameKeyCommonColumnSetupBeforeUpdateInterceptorLogicMap(columnName);
    }

    public String getCommonColumnSetupBeforeUpdateInterceptorLogicByColumnName(String columnName) {
        return this.getProperties().getCommonColumnProperties().getCommonColumnSetupBeforeUpdateInterceptorLogicByColumnName(columnName);
    }

    public boolean hasCommonColumnSetupResource() {
        return this.getProperties().getCommonColumnProperties().hasCommonColumnSetupResource();
    }

    public List<CommonColumnSetupResource> getCommonColumnSetupResourceList() {
        return this.getProperties().getCommonColumnProperties().getCommonColumnSetupResourceList();
    }

    public boolean isCommonColumnSetupInvokingLogic(String logic) {
        return this.getProperties().getCommonColumnProperties().isCommonColumnSetupInvokingLogic(logic);
    }

    public String removeCommonColumnSetupInvokingMark(String logic) {
        return this.getProperties().getCommonColumnProperties().removeCommonColumnSetupInvokingMark(logic);
    }

    public DfClassificationProperties getClassificationProperties() {
        return this.getProperties().getClassificationProperties();
    }

    public Map<String, Map<String, String>> getClassificationTopDefinitionMap() {
        return this.getClassificationProperties().getClassificationTopDefinitionMap();
    }

    public boolean hasClassificationDefinitionMap() {
        return this.getClassificationProperties().hasClassificationDefinitionMap();
    }

    public Map<String, List<Map<String, String>>> getClassificationDefinitionMap() {
        return this.getClassificationProperties().getClassificationDefinitionMap();
    }

    public List<String> getClassificationNameList() {
        return this.getClassificationProperties().getClassificationNameList();
    }

    public List<String> getClassificationNameListValidNameOnly() {
        return this.getClassificationProperties().getClassificationNameListValidNameOnly();
    }

    public List<String> getClassificationNameListValidAliasOnly() {
        return this.getClassificationProperties().getClassificationNameListValidAliasOnly();
    }

    public String getClassificationDefinitionMapAsStringRemovedLineSeparatorFilteredQuotation() {
        return this.getClassificationProperties().getClassificationDefinitionMapAsStringRemovedLineSeparatorFilteredQuotation();
    }

    public List<Map<String, String>> getClassificationMapList(String classificationName) {
        return this.getClassificationProperties().getClassificationMapList(classificationName);
    }

    public String buildClassificationApplicationComment(Map<String, String> classificationMap) {
        return this.getClassificationProperties().buildClassificationApplicationComment(classificationMap);
    }

    public String buildClassificationCodeAliasVariables(Map<String, String> classificationMap) {
        return this.getClassificationProperties().buildClassificationCodeAliasVariables(classificationMap);
    }

    public String buildClassificationCodeNameAliasVariables(Map<String, String> classificationMap) {
        return this.getClassificationProperties().buildClassificationCodeNameAliasVariables(classificationMap);
    }

    public boolean isTableClassification(String classificationName) {
        return this.getClassificationProperties().isTableClassification(classificationName);
    }

    public Map<String, Map<String, String>> getClassificationDeploymentMap() {
        return this.getClassificationProperties().getClassificationDeploymentMap();
    }

    public String getClassificationDeploymentMapAsStringRemovedLineSeparatorFilteredQuotation() {
        return this.getClassificationProperties().getClassificationDeploymentMapAsStringRemovedLineSeparatorFilteredQuotation();
    }

    public boolean hasClassification(String tableName, String columnName) {
        return this.getClassificationProperties().hasClassification(tableName, columnName);
    }

    public String getClassificationName(String tableName, String columnName) {
        return this.getClassificationProperties().getClassificationName(tableName, columnName);
    }

    public boolean hasClassificationName(String tableName, String columnName) {
        return this.getClassificationProperties().hasClassificationName(tableName, columnName);
    }

    public boolean hasClassificationAlias(String tableName, String columnName) {
        return this.getClassificationProperties().hasClassificationAlias(tableName, columnName);
    }

    public Map<String, String> getAllColumnClassificationMap() {
        return this.getClassificationProperties().getAllColumnClassificationMap();
    }

    public boolean isAllClassificationColumn(String columnName) {
        return this.getClassificationProperties().isAllClassificationColumn(columnName);
    }

    public String getAllClassificationName(String columnName) {
        return this.getClassificationProperties().getAllClassificationName(columnName);
    }

    public boolean isAvailableDatabaseDependency() {
        return this.getProperties().getLittleAdjustmentProperties().isAvailableDatabaseDependency();
    }

    public boolean isAvailableNonPrimaryKeyWritable() {
        return this.getProperties().getLittleAdjustmentProperties().isAvailableNonPrimaryKeyWritable();
    }

    public boolean isAvailableToLowerInGeneratorUnderscoreMethod() {
        return this.getProperties().getLittleAdjustmentProperties().isAvailableToLowerInGeneratorUnderscoreMethod();
    }

    public boolean isMakeDeprecated() {
        return this.getProperties().getLittleAdjustmentProperties().isMakeDeprecated();
    }

    public boolean isMakeRecentlyDeprecated() {
        return this.getProperties().getLittleAdjustmentProperties().isMakeRecentlyDeprecated();
    }

    public boolean isMakeConditionQueryEqualEmptyString() {
        return this.getProperties().getLittleAdjustmentProperties().isMakeConditionQueryEqualEmptyString();
    }

    public boolean isMakeEntityChaseRelation() {
        return this.getProperties().getLittleAdjustmentProperties().isMakeEntityChaseRelation();
    }

    public boolean hasExtendedImplementedInvokerAssistantClass() {
        return this.getProperties().getLittleAdjustmentProperties().hasExtendedImplementedInvokerAssistantClass();
    }

    public String getExtendedImplementedInvokerAssistantClass() {
        return this.getProperties().getLittleAdjustmentProperties().getExtendedImplementedInvokerAssistantClass();
    }

    public boolean hasExtendedImplementedCommonColumnAutoSetupperClass() {
        return this.getProperties().getLittleAdjustmentProperties().hasExtendedImplementedCommonColumnAutoSetupperClass();
    }

    public String getExtendedImplementedCommonColumnAutoSetupperClass() {
        return this.getProperties().getLittleAdjustmentProperties().getExtendedImplementedCommonColumnAutoSetupperClass();
    }

    public boolean hasExtendedS2DaoSettingClassValid() {
        return this.getProperties().getLittleAdjustmentProperties().hasExtendedS2DaoSettingClassValid();
    }

    public String getExtendedS2DaoSettingClass() {
        return this.getProperties().getLittleAdjustmentProperties().getExtendedS2DaoSettingClass();
    }

    public boolean isShortCharHandlingValid() {
        return this.getProperties().getLittleAdjustmentProperties().isShortCharHandlingValid();
    }

    public String getShortCharHandlingMode() {
        return this.getProperties().getLittleAdjustmentProperties().getShortCharHandlingMode();
    }

    public String getShortCharHandlingModeCode() {
        return this.getProperties().getLittleAdjustmentProperties().getShortCharHandlingModeCode();
    }

    public boolean isCDefToStringReturnsName() {
        return this.getProperties().getLittleAdjustmentProperties().isCDefToStringReturnsName();
    }

    public boolean isStopGenerateExtendedBhv() {
        return this.getProperties().getLittleAdjustmentProperties().isStopGenerateExtendedBhv();
    }

    public boolean isStopGenerateExtendedDao() {
        return this.getProperties().getLittleAdjustmentProperties().isStopGenerateExtendedDao();
    }

    public boolean isStopGenerateExtendedEntity() {
        return this.getProperties().getLittleAdjustmentProperties().isStopGenerateExtendedEntity();
    }

    public boolean isMakeFlatExpansion() {
        return this.getProperties().getLittleAdjustmentProperties().isMakeFlatExpansion();
    }

    public boolean isMakeDaoInterface() {
        return this.getProperties().getLittleAdjustmentProperties().isMakeDaoInterface();
    }

    public boolean isUseBuri() {
        return this.getProperties().getBuriProperties().isUseBuri();
    }

    public List<String> getBuriPackageList() {
        return new ArrayList<String>(this.getProperties().getBuriProperties().getActivityDefinitionMap().keySet());
    }

    public List<String> getBuriProcessList(String packageName) {
        return new ArrayList<String>(this.getProperties().getBuriProperties().getProcessMap(packageName).keySet());
    }

    public List<String> getBuriStatusList(String packageName, String processName) {
        return this.getProperties().getBuriProperties().getStatusList(packageName, processName);
    }

    public List<String> getBuriActionList(String packageName, String processName) {
        return this.getProperties().getBuriProperties().getActionList(packageName, processName);
    }

    public boolean hasBuriAllRoundStateHistory() {
        return this.getProperties().getBuriProperties().hasBuriAllRoundStateHistory(new DfTableFinder(){

            public Table findTable(String name) {
                return Database.this.getTable(name);
            }
        });
    }

    public boolean isSqlLogRegistryValid() {
        return this.getProperties().getSqlLogRegistryProperties().isValid();
    }

    public int getSqlLogRegistryLimitSize() {
        return this.getProperties().getSqlLogRegistryProperties().getLimitSize();
    }

    public List<Object> getJavaNativeStringList() {
        return this.getProperties().getTypeMappingProperties().getJavaNativeStringList();
    }

    public List<Object> getJavaNativeBooleanList() {
        return this.getProperties().getTypeMappingProperties().getJavaNativeBooleanList();
    }

    public List<Object> getJavaNativeNumberList() {
        return this.getProperties().getTypeMappingProperties().getJavaNativeNumberList();
    }

    public List<Object> getJavaNativeDateList() {
        return this.getProperties().getTypeMappingProperties().getJavaNativeDateList();
    }

    public List<Object> getJavaNativeBinaryList() {
        return this.getProperties().getTypeMappingProperties().getJavaNativeBinaryList();
    }

    public boolean isGenerateProcedureParameterBean() {
        return this.getProperties().getOutsideSqlProperties().isGenerateProcedureParameterBean();
    }

    public boolean hasSqlFileEncoding() {
        return this.getProperties().getOutsideSqlProperties().hasSqlFileEncoding();
    }

    public String getSqlFileEncoding() {
        return this.getProperties().getOutsideSqlProperties().getSqlFileEncoding();
    }

    public boolean isOutsideSqlPackageValid() {
        return this.getProperties().getOutsideSqlProperties().isSqlPackageValid();
    }

    public String getOutsideSqlPackage() {
        return this.getProperties().getOutsideSqlProperties().getSqlPackage();
    }

    public boolean isDefaultPackageValid() {
        return this.getProperties().getOutsideSqlProperties().isDefaultPackageValid();
    }

    public String getDefaultPackage() {
        return this.getProperties().getOutsideSqlProperties().getDefaultPackage();
    }

    public boolean isOmitResourcePathPackageValid() {
        return this.getProperties().getOutsideSqlProperties().isOmitResourcePathPackageValid();
    }

    public String getOmitResourcePathPackage() {
        return this.getProperties().getOutsideSqlProperties().getOmitResourcePathPackage();
    }

    public boolean isOmitFileSystemPathPackageValid() {
        return this.getProperties().getOutsideSqlProperties().isOmitFileSystemPathPackageValid();
    }

    public String getOmitFileSystemPathPackage() {
        return this.getProperties().getOutsideSqlProperties().getOmitFileSystemPathPackage();
    }

    public String getSql2EntityBaseEntityPackage() {
        return this.getProperties().getOutsideSqlProperties().getBaseEntityPackage();
    }

    public String getSql2EntityDBMetaPackage() {
        return this.getProperties().getOutsideSqlProperties().getDBMetaPackage();
    }

    public String getSql2EntityExtendedEntityPackage() {
        return this.getProperties().getOutsideSqlProperties().getExtendedEntityPackage();
    }

    public String getSql2EntityBaseCursorPackage() {
        return this.getProperties().getOutsideSqlProperties().getBaseCursorPackage();
    }

    public String getSql2EntityExtendedCursorPackage() {
        return this.getProperties().getOutsideSqlProperties().getExtendedCursorPackage();
    }

    public String getSql2EntityBaseParameterBeanPackage() {
        return this.getProperties().getOutsideSqlProperties().getBaseParameterBeanPackage();
    }

    public String getSql2EntityExtendedParameterBeanPackage() {
        return this.getProperties().getOutsideSqlProperties().getExtendedParameterBeanPackage();
    }

    public boolean isAliasDelimiterInDbCommentValid() {
        return this.getProperties().getDocumentProperties().isAliasDelimiterInDbCommentValid();
    }

    public boolean isEntityJavaDocDbCommentValid() {
        return this.getProperties().getDocumentProperties().isEntityJavaDocDbCommentValid();
    }

    public boolean hasSimpleDtoDefinition() {
        return this.getProperties().getSimpleDtoProperties().hasSimpleDtoDefinition();
    }

    public String getSimpleDtoBaseDtoPackage() {
        return this.getProperties().getSimpleDtoProperties().getBaseDtoPackage();
    }

    public String getSimpleDtoExtendedDtoPackage() {
        return this.getProperties().getSimpleDtoProperties().getExtendedDtoPackage();
    }

    public String getSimpleDtoBaseDtoPrefix() {
        return this.getProperties().getSimpleDtoProperties().getBaseDtoPrefix();
    }

    public String getSimpleDtoBaseDtoSuffix() {
        return this.getProperties().getSimpleDtoProperties().getBaseDtoSuffix();
    }

    public String getSimpleDtoExtendedDtoPrefix() {
        return this.getProperties().getSimpleDtoProperties().getExtendedDtoPrefix();
    }

    public String getSimpleDtoExtendedDtoSuffix() {
        return this.getProperties().getSimpleDtoProperties().getExtendedDtoSuffix();
    }

    public String getSimpleDtoDtoMapperPackage() {
        return this.getProperties().getSimpleDtoProperties().getMapperPackage();
    }

    public boolean isSimpleDtoUseDtoMapper() {
        return this.getProperties().getSimpleDtoProperties().isUseDtoMapper();
    }

    public boolean hasFlexDtoDefinition() {
        return this.getProperties().getFlexDtoProperties().hasFlexDtoDefinition();
    }

    public boolean isFlexDtoOverrideExtended() {
        return this.getProperties().getFlexDtoProperties().isOverrideExtended();
    }

    public String getFlexDtoBaseDtoPackage() {
        return this.getProperties().getFlexDtoProperties().getBaseDtoPackage();
    }

    public String getFlexDtoExtendedDtoPackage() {
        return this.getProperties().getFlexDtoProperties().getExtendedDtoPackage();
    }

    public String getFlexDtoBaseDtoPrefix() {
        return this.getProperties().getFlexDtoProperties().getBaseDtoPrefix();
    }

    public String getFlexDtoBaseDtoSuffix() {
        return this.getProperties().getFlexDtoProperties().getBaseDtoSuffix();
    }

    public String getFlexDtoExtendedDtoPrefix() {
        return this.getProperties().getFlexDtoProperties().getExtendedDtoPrefix();
    }

    public String getFlexDtoExtendedDtoSuffix() {
        return this.getProperties().getFlexDtoProperties().getExtendedDtoSuffix();
    }

    public boolean hasHibernateDefinition() {
        return this.getProperties().getHibernateProperties().hasHibernateDefinition();
    }

    public String getHibernateBaseEntityPackage() {
        return this.getBaseEntityPackage();
    }

    public String getHibernateExtendedEntityPackage() {
        return this.getExtendedEntityPackage();
    }

    public String getHibernateBaseEntityPrefix() {
        return this.getBasePrefix();
    }

    public String getHibernateManyToOneFetch() {
        return this.getProperties().getHibernateProperties().getManyToOneFetch();
    }

    public String getHibernateOneToOneFetch() {
        return this.getProperties().getHibernateProperties().getOneToOneFetch();
    }

    public String getHibernateOneToManyFetch() {
        return this.getProperties().getHibernateProperties().getOneToManyFetch();
    }

    public boolean hasS2jdbcDefinition() {
        return this.getProperties().getS2jdbcProperties().hasS2jdbcDefinition();
    }

    public String getS2jdbcBaseEntityPackage() {
        return this.getProperties().getS2jdbcProperties().getBaseEntityPackage();
    }

    public String getS2jdbcExtendedEntityPackage() {
        return this.getProperties().getS2jdbcProperties().getExtendedEntityPackage();
    }

    public String getS2jdbcBaseEntityPrefix() {
        return this.getProperties().getS2jdbcProperties().getBaseEntityPrefix();
    }

    public String getInvokerAssistantComponentName() {
        return this.filterComponentNameWithProjectPrefix("invokerAssistant");
    }

    public String getCommonColumnAutoSetupperComponentName() {
        return this.filterComponentNameWithProjectPrefix("commonColumnAutoSetupper");
    }

    public String getBehaviorSelectorComponentName() {
        return this.filterComponentNameWithProjectPrefix("behaviorSelector");
    }

    public String getBehaviorCommandInvokerComponentName() {
        return this.filterComponentNameWithProjectPrefix("behaviorCommandInvoker");
    }

    public String filterComponentNameWithProjectPrefix(String componentName) {
        String prefix = this.getBasicProperties().getProjectPrefix();
        if (prefix == null || prefix.trim().length() == 0) {
            return componentName;
        }
        String filteredPrefix = prefix.substring(0, 1).toLowerCase() + prefix.substring(1);
        return filteredPrefix + componentName.substring(0, 1).toUpperCase() + componentName.substring(1);
    }

    public String convertJavaNativeByJdbcType(String jdbcType) {
        try {
            return TypeMap.findJavaNativeByJdbcType(jdbcType, null, null);
        }
        catch (RuntimeException e) {
            _log.warn((Object)("TypeMap.findJavaNativeTypeString(jdbcType, null, null) threw the exception: jdbcType=" + jdbcType), (Throwable)e);
            throw e;
        }
    }

    public String convertJavaNameByJdbcNameAsTable(String jdbcName) {
        if (this.getBasicProperties().isTableNameCamelCase()) {
            return jdbcName;
        }
        ArrayList<String> inputs = new ArrayList<String>(2);
        inputs.add(jdbcName);
        inputs.add(this.getDefaultJavaNamingMethod());
        return StringUtils.capitalise((String)this.generateName(NameFactory.JAVA_GENERATOR, inputs));
    }

    public String convertUncapitalisedJavaNameByJdbcNameAsTable(String jdbcName) {
        return StringUtils.uncapitalise((String)this.convertJavaNameByJdbcNameAsTable(jdbcName));
    }

    public String convertJavaNameByJdbcNameAsColumn(String jdbcName) {
        if (this.getBasicProperties().isColumnNameCamelCase()) {
            return jdbcName;
        }
        ArrayList<String> inputs = new ArrayList<String>(2);
        inputs.add(jdbcName);
        inputs.add(this.getDefaultJavaNamingMethod());
        return StringUtils.capitalise((String)this.generateName(NameFactory.JAVA_GENERATOR, inputs));
    }

    public String convertUncapitalisedJavaNameByJdbcNameAsColumn(String jdbcName) {
        return StringUtils.uncapitalise((String)this.convertJavaNameByJdbcNameAsColumn(jdbcName));
    }

    protected String generateName(String algorithmName, List<?> inputs) {
        String javaName = null;
        try {
            javaName = NameFactory.generateName(NameFactory.JAVA_GENERATOR, inputs);
        }
        catch (EngineException e) {
            String msg = "NameFactory.generateName() threw the exception: inputs=" + inputs;
            _log.warn((Object)msg, (Throwable)((Object)e));
            throw new RuntimeException(msg, (Throwable)((Object)e));
        }
        catch (RuntimeException e) {
            String msg = "NameFactory.generateName() threw the exception: inputs=" + inputs;
            _log.warn((Object)msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
        if (javaName == null) {
            String msg = "NameFactory.generateName() returned null: inputs=" + inputs;
            _log.warn((Object)msg);
            throw new IllegalStateException(msg);
        }
        return javaName;
    }

    public String getWildCard() {
        return "%";
    }

    public String getSharp() {
        return "#";
    }

    public String getDollar() {
        return "$";
    }

    public String getOverrideComment() {
        return "{@inheritDoc}";
    }

    public String getImplementComment() {
        return "{@inheritDoc}";
    }

    public void info(String msg) {
        _log.info((Object)msg);
    }

    public void debug(String msg) {
        _log.debug((Object)msg);
    }

    public String getTimestampExpression() {
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        return new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(timestamp);
    }

    public String initCap(String str) {
        if (str == null) {
            String msg = "Argument[str] must not be null.";
            throw new IllegalArgumentException(msg);
        }
        if (str.length() == 0) {
            return "";
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    public boolean isInitNumber(String str) {
        if (str == null) {
            String msg = "Argument[str] must not be null.";
            throw new IllegalArgumentException(msg);
        }
        if (str.length() == 0) {
            return false;
        }
        try {
            Integer.valueOf(str.substring(0, 1));
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public String getMapValue(Map<?, ?> map, String key) {
        Object value = map.get(key);
        return value != null ? (String)value : "";
    }

    public void makeDirectory(String packagePath) {
        FileUtil.mkdir((String)(this.getGeneratorInstance().getOutputPath() + "/" + packagePath));
    }

    public String getPackageAsPath(String pckge) {
        DfPackagePathHandler handler = new DfPackagePathHandler(this.getBasicProperties());
        return handler.getPackageAsPath(pckge);
    }

    public boolean hasTableBqpMap() {
        return !this.getTableBqpMap().isEmpty();
    }

    protected Map<String, Map<String, Map<String, String>>> getTableBqpMap() {
        if (this._tableBqpMap != null) {
            return this._tableBqpMap;
        }
        DfBehaviorQueryPathSetupper setupper = new DfBehaviorQueryPathSetupper(this.getProperties());
        try {
            this._tableBqpMap = setupper.extractTableBqpMap(this.collectSqlFileList());
        }
        catch (RuntimeException e) {
            _log.warn((Object)"Failed to extract the map of table behavior query path!", (Throwable)e);
            this._tableBqpMap = new HashMap<String, Map<String, Map<String, String>>>();
        }
        return this._tableBqpMap;
    }

    protected List<File> collectSqlFileList() {
        String sqlDirectory = this.getProperties().getOutsideSqlProperties().getSqlDirectory();
        DfSqlFileCollector sqlFileCollector = new DfSqlFileCollector(sqlDirectory, this.getBasicProperties());
        sqlFileCollector.suppressDirectoryCheck();
        return sqlFileCollector.collectSqlFileList();
    }

    public List<DfProcedureMetaInfo> getAvailableProcedureList() {
        if (this._procedureMetaInfoList != null) {
            return this._procedureMetaInfoList;
        }
        _log.info((Object)" ");
        _log.info((Object)"...Setting up procedures for documents");
        DfProcedureHandler handler = new DfProcedureHandler();
        handler.includeProcedureSynonym(this.getDataSource());
        String schemaName = this.getDatabaseSchema();
        DataSource dataSource = this.getDataSource();
        try {
            Connection conn = dataSource.getConnection();
            DatabaseMetaData metaData = conn.getMetaData();
            Map<String, DfProcedureMetaInfo> procedureMap = handler.getAvailableProcedureMap(metaData);
            this._procedureMetaInfoList = new ArrayList<DfProcedureMetaInfo>(procedureMap.values());
            return this._procedureMetaInfoList;
        }
        catch (SQLException e) {
            String msg = "Failed to get the list of available procedures:";
            msg = msg + " schemaName=" + schemaName;
            throw new IllegalStateException(msg);
        }
    }

    protected DataSource getDataSource() {
        return DfDataSourceContext.getDataSource();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<database name=\"").append(this.getName()).append('\"').append(">\n");
        Iterator<Table> i = this._tableList.iterator();
        while (i.hasNext()) {
            sb.append(i.next());
        }
        sb.append("</database>");
        return sb.toString();
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name == null ? "default" : name;
    }

    public String getDefaultJavaNamingMethod() {
        return this._defaultJavaNamingMethod;
    }

    public void setDefaultJavaNamingMethod(String v) {
        this._defaultJavaNamingMethod = v;
    }

    public void setAppData(AppData appData) {
        this._appData = appData;
    }

    public void setSql2EntitySchemaData(AppData sql2entitySchemaData) {
        this._sql2entitySchemaData = sql2entitySchemaData;
    }

    public AppData getAppData() {
        return this._appData;
    }

    public String getDatabaseType() {
        return this._databaseType;
    }

    public void setDatabaseType(String databaseType) {
        this._databaseType = databaseType;
    }

    public Map<String, DfParameterBeanMetaData> getPmbMetaDataMap() {
        return this._pmbMetaDataMap;
    }

    public void setPmbMetaDataMap(Map<String, DfParameterBeanMetaData> pmbMetaDataMap) {
        this._pmbMetaDataMap = pmbMetaDataMap;
    }

    public void setSkipDeleteOldClass(boolean skipDeleteOldClass) {
        this._skipDeleteOldClass = skipDeleteOldClass;
    }
}

