/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.replaceschema.loaddata.impl;

import java.sql.Timestamp;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.seasar.dbflute.exception.DfTableDataRegistrationFailureException;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfColumnMetaInfo;
import org.seasar.dbflute.util.Srl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfDelimiterDataWriteSqlBuilder {
    protected String _tableName;
    protected Map<String, DfColumnMetaInfo> _columnMap;
    protected List<String> _columnNameList;
    protected List<String> _valueList;
    protected Map<String, Set<String>> _notFoundColumnMap;
    protected Map<String, Map<String, String>> _convertValueMap;
    protected Map<String, String> _defaultValueMap;
    protected Map<String, String> _basicColumnValueMap;
    protected Map<String, String> _allColumnConvertMap;

    public String buildSql() {
        Map<String, String> columnValueMap = this.createBasicColumnValueMap();
        StringBuilder sb = new StringBuilder();
        StringBuilder sbValues = new StringBuilder();
        for (String columnName : columnValueMap.keySet()) {
            sb.append(", ").append(columnName);
            sbValues.append(", ?");
        }
        sb.delete(0, ", ".length()).insert(0, "insert into " + this._tableName + " (").append(")");
        sbValues.delete(0, ", ".length()).insert(0, " values(").append(")");
        sb.append((CharSequence)sbValues);
        return sb.toString();
    }

    public Map<String, Object> setupParameter() {
        return this.resolveColumnValueMap(this.createBasicColumnValueMap());
    }

    protected Map<String, String> createBasicColumnValueMap() {
        if (this._basicColumnValueMap != null) {
            return this._basicColumnValueMap;
        }
        this._basicColumnValueMap = new LinkedHashMap<String, String>();
        int columnCount = -1;
        for (String columnName : this._columnNameList) {
            String value;
            ++columnCount;
            if (!this._columnMap.isEmpty() && !this._columnMap.containsKey(columnName)) {
                if (this.hasDefaultValue(columnName)) continue;
                Set<String> notFoundColumnSet = this._notFoundColumnMap.get(this._tableName);
                if (notFoundColumnSet == null) {
                    notFoundColumnSet = new LinkedHashSet<String>();
                    this._notFoundColumnMap.put(this._tableName, notFoundColumnSet);
                }
                notFoundColumnSet.add(columnName);
                continue;
            }
            try {
                value = columnCount < this._valueList.size() ? this._valueList.get(columnCount) : null;
            }
            catch (RuntimeException e) {
                String msg = "valueList.get(columnCount) threw the exception:";
                msg = msg + " tableName=" + this._tableName + " columnNameList=" + this._columnNameList;
                msg = msg + " valueList=" + this._valueList + " columnCount=" + columnCount;
                throw new DfTableDataRegistrationFailureException(msg, e);
            }
            if (!this._columnMap.isEmpty() && this._columnMap.containsKey(columnName)) {
                String realDbName = this._columnMap.get(columnName).getColumnName();
                this._basicColumnValueMap.put(realDbName, value);
                continue;
            }
            this._basicColumnValueMap.put(columnName, value);
        }
        return this._basicColumnValueMap;
    }

    protected Map<String, Object> resolveColumnValueMap(Map<String, String> basicColumnValueMap) {
        LinkedHashMap<String, Object> resolvedColumnValueMap = new LinkedHashMap<String, Object>();
        Set<Map.Entry<String, String>> entrySet = basicColumnValueMap.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            String columnName = entry.getKey();
            String plainValue = entry.getValue();
            Object resolvedValue = Srl.is_NotNull_and_NotEmpty((String)plainValue) ? this.resolveConvertValue(columnName, plainValue) : this.resolveDefaultValue(columnName, plainValue);
            resolvedColumnValueMap.put(columnName, resolvedValue);
        }
        return resolvedColumnValueMap;
    }

    protected String resolveConvertValue(String columnName, String plainValue) {
        String resolvedValue = plainValue;
        Map<String, String> valueMapping = this.findConvertValueMapping(columnName);
        if (valueMapping == null || valueMapping.isEmpty()) {
            return resolvedValue;
        }
        for (Map.Entry<String, String> entry : valueMapping.entrySet()) {
            String before = this.resolveControlCharacter(entry.getKey());
            String after = this.resolveControlCharacter(entry.getValue());
            if (Srl.startsWithIgnoreCase((String)before, (String[])new String[]{"contain:"})) {
                String realBefore = Srl.substringFirstRear((String)before, (String[])new String[]{"contain:"});
                resolvedValue = Srl.replace((String)resolvedValue, (String)realBefore, (String)after);
                continue;
            }
            if (!resolvedValue.equals(before)) continue;
            resolvedValue = after;
        }
        return resolvedValue;
    }

    protected String resolveControlCharacter(String after) {
        if (after == null) {
            return null;
        }
        String tmp = "${df:temporaryVariable}";
        after = Srl.replace((String)after, (String)"\\\\", (String)"${df:temporaryVariable}");
        after = Srl.replace((String)after, (String)"\\r", (String)"\r");
        after = Srl.replace((String)after, (String)"\\n", (String)"\n");
        after = Srl.replace((String)after, (String)"\\t", (String)"\t");
        after = Srl.replace((String)after, (String)"${df:temporaryVariable}", (String)"\\");
        return after;
    }

    protected Object resolveDefaultValue(String columnName, Object plainValue) {
        if (!this.hasDefaultValue(columnName)) {
            return plainValue;
        }
        Object resolvedValue = plainValue;
        String defaultValue = this.findDefaultValue(columnName);
        if (Srl.is_Null_or_Empty((String)defaultValue)) {
            return null;
        }
        resolvedValue = defaultValue.equalsIgnoreCase("sysdate") ? new Timestamp(System.currentTimeMillis()) : defaultValue;
        return resolvedValue;
    }

    private Map<String, String> findConvertValueMapping(String columnName) {
        Map<String, String> resultMap;
        if (this._allColumnConvertMap == null) {
            this._allColumnConvertMap = this._convertValueMap.get("$$ALL$$");
            if (this._allColumnConvertMap == null) {
                this._allColumnConvertMap = new HashMap<String, String>();
            }
        }
        if ((resultMap = this._convertValueMap.get(columnName)) != null && !resultMap.isEmpty()) {
            if (!this._allColumnConvertMap.isEmpty()) {
                HashMap<String, String> mergedMap = new HashMap<String, String>();
                mergedMap.putAll(this._allColumnConvertMap);
                mergedMap.putAll(resultMap);
                return mergedMap;
            }
            return resultMap;
        }
        return !this._allColumnConvertMap.isEmpty() ? this._allColumnConvertMap : null;
    }

    private boolean hasDefaultValue(String columnName) {
        return this._defaultValueMap.containsKey(columnName);
    }

    private String findDefaultValue(String columnName) {
        return this._defaultValueMap.get(columnName);
    }

    public Map<String, DfColumnMetaInfo> getColumnMap() {
        return this._columnMap;
    }

    public void setColumnMap(Map<String, DfColumnMetaInfo> columnMap) {
        this._columnMap = columnMap;
    }

    public List<String> getColumnNameList() {
        return this._columnNameList;
    }

    public void setColumnNameList(List<String> columnNameList) {
        this._columnNameList = columnNameList;
    }

    public Map<String, Set<String>> getNotFoundColumnMap() {
        return this._notFoundColumnMap;
    }

    public void setNotFoundColumnMap(Map<String, Set<String>> notFoundColumnMap) {
        this._notFoundColumnMap = notFoundColumnMap;
    }

    public String getTableName() {
        return this._tableName;
    }

    public void setTableName(String tableName) {
        this._tableName = tableName;
    }

    public List<String> getValueList() {
        return this._valueList;
    }

    public void setValueList(List<String> valueList) {
        this._valueList = valueList;
    }

    public Map<String, Map<String, String>> getConvertValueMap() {
        return this._convertValueMap;
    }

    public void setConvertValueMap(Map<String, Map<String, String>> convertValueMap) {
        this._convertValueMap = convertValueMap;
    }

    public Map<String, String> getDefaultValueMap() {
        return this._defaultValueMap;
    }

    public void setDefaultValueMap(Map<String, String> defaultValueMap) {
        this._defaultValueMap = defaultValueMap;
    }
}

