/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.jdbc.urlanalyzer.factory;

import org.seasar.dbflute.logic.jdbc.urlanalyzer.DfUrlAnalyzer;
import org.seasar.dbflute.logic.jdbc.urlanalyzer.DfUrlAnalyzerDerby;
import org.seasar.dbflute.logic.jdbc.urlanalyzer.DfUrlAnalyzerH2;
import org.seasar.dbflute.logic.jdbc.urlanalyzer.DfUrlAnalyzerMySQL;
import org.seasar.dbflute.logic.jdbc.urlanalyzer.DfUrlAnalyzerPostgreSQL;
import org.seasar.dbflute.logic.jdbc.urlanalyzer.DfUrlAnalyzerSQLServer;
import org.seasar.dbflute.logic.jdbc.urlanalyzer.DfUrlAnalyzerSQLite;
import org.seasar.dbflute.logic.jdbc.urlanalyzer.DfUrlAnalyzerSybase;
import org.seasar.dbflute.properties.DfBasicProperties;

public class DfUrlAnalyzerFactory {
    protected DfBasicProperties _basicProperties;
    protected String _url;

    public DfUrlAnalyzerFactory(DfBasicProperties basicProperties, String url) {
        this._basicProperties = basicProperties;
        this._url = url;
    }

    public DfUrlAnalyzer createAnalyzer() {
        if (this._basicProperties.isDatabaseMySQL()) {
            return new DfUrlAnalyzerMySQL(this._url);
        }
        if (this._basicProperties.isDatabasePostgreSQL()) {
            return new DfUrlAnalyzerPostgreSQL(this._url);
        }
        if (this._basicProperties.isDatabaseOracle()) {
            return this.createNullAnalyzer();
        }
        if (this._basicProperties.isDatabaseDB2()) {
            return this.createNullAnalyzer();
        }
        if (this._basicProperties.isDatabaseSQLServer()) {
            return new DfUrlAnalyzerSQLServer(this._url);
        }
        if (this._basicProperties.isDatabaseH2()) {
            return new DfUrlAnalyzerH2(this._url);
        }
        if (this._basicProperties.isDatabaseDerby()) {
            return new DfUrlAnalyzerDerby(this._url);
        }
        if (this._basicProperties.isDatabaseSQLite()) {
            return new DfUrlAnalyzerSQLite(this._url);
        }
        if (this._basicProperties.isDatabaseMSAccess()) {
            return this.createNullAnalyzer();
        }
        if (this._basicProperties.isDatabaseSybase()) {
            return new DfUrlAnalyzerSybase(this._url);
        }
        return this.createNullAnalyzer();
    }

    protected DfUrlAnalyzer createNullAnalyzer() {
        return new DfUrlAnalyzer(){

            public String extractCatalog() {
                return null;
            }
        };
    }
}

