/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.jdbc.schemadiff;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.seasar.dbflute.DfBuildProperties;
import org.seasar.dbflute.logic.jdbc.schemadiff.DfColumnDiff;
import org.seasar.dbflute.logic.jdbc.schemadiff.DfForeignKeyDiff;
import org.seasar.dbflute.logic.jdbc.schemadiff.DfIndexDiff;
import org.seasar.dbflute.logic.jdbc.schemadiff.DfNestDiff;
import org.seasar.dbflute.logic.jdbc.schemadiff.DfNextPreviousDiff;
import org.seasar.dbflute.logic.jdbc.schemadiff.DfPrimaryKeyDiff;
import org.seasar.dbflute.logic.jdbc.schemadiff.DfTableDiff;
import org.seasar.dbflute.logic.jdbc.schemadiff.DfUniqueKeyDiff;
import org.seasar.dbflute.properties.DfBasicProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DfAbstractDiff {
    protected DfTableDiff createTableDiff(Map<String, Object> tableDiffMap) {
        return DfTableDiff.createFromDiffMap(tableDiffMap);
    }

    protected DfColumnDiff createColumnDiff(Map<String, Object> columnDiffMap) {
        return DfColumnDiff.createFromDiffMap(columnDiffMap);
    }

    protected DfPrimaryKeyDiff createPrimaryKeyDiff(Map<String, Object> primaryKeyDiffMap) {
        return DfPrimaryKeyDiff.createFromDiffMap(primaryKeyDiffMap);
    }

    protected DfForeignKeyDiff createForeignKeyDiff(Map<String, Object> foreignKeyDiffMap) {
        return DfForeignKeyDiff.createFromDiffMap(foreignKeyDiffMap);
    }

    protected DfUniqueKeyDiff createUniqueKeyDiff(Map<String, Object> uniqueKeyDiffMap) {
        return DfUniqueKeyDiff.createFromDiffMap(uniqueKeyDiffMap);
    }

    protected DfIndexDiff createIndexDiff(Map<String, Object> indexDiffMap) {
        return DfIndexDiff.createFromDiffMap(indexDiffMap);
    }

    protected DfNextPreviousDiff createNextPreviousDiff(String next, String previous) {
        return DfNextPreviousDiff.create(next, previous);
    }

    protected DfNextPreviousDiff createNextPreviousDiff(Integer next, Integer previous) {
        return DfNextPreviousDiff.create(next.toString(), previous.toString());
    }

    protected DfNextPreviousDiff createNextPreviousDiff(Boolean next, Boolean previous) {
        return DfNextPreviousDiff.create(next.toString(), previous.toString());
    }

    protected DfNextPreviousDiff restoreNextPreviousDiff(Map<String, Object> diffMap, String key) {
        Object value = diffMap.get(key);
        if (value == null) {
            return null;
        }
        this.assertElementValueMap(key, value, diffMap);
        Map nextPreviousDiffMap = (Map)value;
        return DfNextPreviousDiff.create(nextPreviousDiffMap);
    }

    protected void restoreNestDiff(Map<String, Object> parentDiffMap, NestDiffSetupper setupper) {
        String key = setupper.propertyName();
        Object value = parentDiffMap.get(key);
        if (value == null) {
            return;
        }
        this.assertElementValueMap(key, value, parentDiffMap);
        Map diffAllMap = (Map)value;
        Set entrySet = diffAllMap.entrySet();
        for (Map.Entry entry : entrySet) {
            String name = (String)entry.getKey();
            Object diffObj = entry.getValue();
            this.assertElementValueMap(name, diffObj, diffAllMap);
            Map nestDiffMap = (Map)diffObj;
            setupper.setup(nestDiffMap);
        }
    }

    protected DfBasicProperties getBasicProperties() {
        return DfBuildProperties.getInstance().getBasicProperties();
    }

    protected boolean isDatabaseMySQL() {
        return this.getBasicProperties().isDatabaseMySQL();
    }

    protected boolean isDatabasePostgreSQL() {
        return this.getBasicProperties().isDatabasePostgreSQL();
    }

    protected boolean isDatabaseOracle() {
        return this.getBasicProperties().isDatabaseOracle();
    }

    protected boolean isDatabaseDB2() {
        return this.getBasicProperties().isDatabaseDB2();
    }

    protected boolean isDatabaseSQLServer() {
        return this.getBasicProperties().isDatabaseSQLServer();
    }

    protected boolean isDatabaseH2() {
        return this.getBasicProperties().isDatabaseH2();
    }

    protected boolean isDatabaseDerby() {
        return this.getBasicProperties().isDatabaseDerby();
    }

    protected boolean isSame(Object next, Object previous) {
        if (next == null && previous == null) {
            return true;
        }
        if (next == null || previous == null) {
            return false;
        }
        return next.equals(previous);
    }

    protected void assertElementValueMap(String key, Object value, Map<String, Object> diffMap) {
        if (!(value instanceof Map)) {
            String msg = "The element in diff-map should be Map:";
            msg = msg + " key=" + key + " value=" + value + " diffMap=" + diffMap;
            throw new IllegalStateException(msg);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface NestDiffSetupper {
        public String propertyName();

        public List<? extends DfNestDiff> provide();

        public void setup(Map<String, Object> var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface NextPreviousHandler {
        public String titleName();

        public String propertyName();

        public DfNextPreviousDiff provide();

        public void restore(Map<String, Object> var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class BooleanNextPreviousDiffer<OBJECT, DIFF>
    implements NextPreviousDiffer<OBJECT, DIFF, Boolean> {
        protected BooleanNextPreviousDiffer() {
        }

        @Override
        public boolean isMatch(Boolean next, Boolean previous) {
            return DfAbstractDiff.this.isSame(next, previous);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class StringNextPreviousDiffer<OBJECT, DIFF>
    implements NextPreviousDiffer<OBJECT, DIFF, String> {
        protected StringNextPreviousDiffer() {
        }

        @Override
        public boolean isMatch(String next, String previous) {
            return DfAbstractDiff.this.isSame(next, previous);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface NextPreviousDiffer<OBJECT, DIFF, TYPE> {
        public TYPE provide(OBJECT var1);

        public boolean isMatch(TYPE var1, TYPE var2);

        public void diff(DIFF var1, DfNextPreviousDiff var2);
    }
}

