/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.cbean.coption.parts;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.seasar.dbflute.util.Srl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplitOptionParts
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String _delimiter;
    protected List<String> _subDelimiterList;
    protected int _splitLimitCount;

    public void splitByBlank() {
        this._delimiter = " ";
        this.addSubDelimiter("\u3000");
        this.addSubDelimiter("\t");
        this.addSubDelimiter("\r");
        this.addSubDelimiter("\n");
    }

    public void splitByBlank(int splitLimitCount) {
        this.splitByBlank();
        this._splitLimitCount = splitLimitCount;
    }

    public void splitBySpace() {
        this._delimiter = " ";
    }

    public void splitBySpace(int splitLimitCount) {
        this.splitBySpace();
        this._splitLimitCount = splitLimitCount;
    }

    public void splitBySpaceContainsDoubleByte() {
        this.splitBySpace();
        this.addSubDelimiter("\u3000");
    }

    public void splitBySpaceContainsDoubleByte(int splitLimitCount) {
        this.splitBySpaceContainsDoubleByte();
        this._splitLimitCount = splitLimitCount;
    }

    public void splitByPipeLine() {
        this._delimiter = "|";
    }

    public void splitByPipeLine(int splitLimitCount) {
        this.splitByPipeLine();
        this._splitLimitCount = splitLimitCount;
    }

    public void splitByVarious(List<String> delimiterList) {
        if (delimiterList == null || delimiterList.isEmpty()) {
            String msg = "The delimiterList should not be null or empty:";
            msg = msg + " delimiterList=" + delimiterList;
            throw new IllegalArgumentException(msg);
        }
        ArrayList<String> acceptList = new ArrayList<String>(delimiterList);
        this._delimiter = delimiterList.remove(0);
        this.addSubDelimiter(acceptList);
    }

    public void splitByVarious(List<String> delimiterList, int splitLimitCount) {
        this.splitByVarious(delimiterList);
        this._splitLimitCount = splitLimitCount;
    }

    protected void addSubDelimiter(String delimiter) {
        if (this._subDelimiterList == null) {
            this._subDelimiterList = new ArrayList<String>();
        }
        this._subDelimiterList.add(delimiter);
    }

    protected void addSubDelimiter(List<String> delimiterList) {
        if (this._subDelimiterList == null) {
            this._subDelimiterList = new ArrayList<String>();
        }
        this._subDelimiterList.addAll(delimiterList);
    }

    public boolean isSplit() {
        return this._delimiter != null;
    }

    public String[] generateSplitValueArray(String value) {
        if (value == null) {
            String msg = "The argument[value] should not be null!";
            throw new IllegalArgumentException(msg);
        }
        value = this.resolveSubSplit(value);
        StringTokenizer st = new StringTokenizer(value, this._delimiter);
        String[] tokenizedValues = new String[st.countTokens()];
        int count = 0;
        while (st.hasMoreTokens()) {
            tokenizedValues[count] = st.nextToken();
            ++count;
        }
        String[] values = this.removeInvalidValue(tokenizedValues);
        if (this._splitLimitCount > 0 && values.length > this._splitLimitCount) {
            String[] realValues = new String[this._splitLimitCount];
            for (int i = 0; i < values.length && i != this._splitLimitCount; ++i) {
                realValues[i] = values[i];
            }
            return realValues;
        }
        return values;
    }

    protected String resolveSubSplit(String value) {
        if (value == null || this._delimiter == null || this._subDelimiterList == null) {
            return value;
        }
        for (String subSplit : this._subDelimiterList) {
            value = this.replace(value, subSplit, this._delimiter);
        }
        return value;
    }

    protected String[] removeInvalidValue(String[] values) {
        ArrayList<String> ls = new ArrayList<String>();
        for (int i = 0; i < values.length; ++i) {
            String value = values[i];
            if (value == null || value.equals("")) continue;
            ls.add(value);
        }
        String[] resultArray = new String[ls.size()];
        for (int i = 0; i < ls.size(); ++i) {
            resultArray[i] = (String)ls.get(i);
        }
        return resultArray;
    }

    protected final String replace(String str, String fromStr, String toStr) {
        return Srl.replace(str, fromStr, toStr);
    }

    public Object createDeepCopy() {
        SplitOptionParts deepCopy = new SplitOptionParts();
        deepCopy._delimiter = this._delimiter;
        deepCopy._subDelimiterList = this._subDelimiterList;
        deepCopy._splitLimitCount = this._splitLimitCount;
        return deepCopy;
    }
}

