/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.properties.initializer;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.engine.database.model.Column;
import org.apache.torque.engine.database.model.Database;
import org.apache.torque.engine.database.model.Table;
import org.seasar.dbflute.DfBuildProperties;
import org.seasar.dbflute.exception.DfPropertySettingColumnNotFoundException;
import org.seasar.dbflute.exception.DfPropertySettingTableNotFoundException;
import org.seasar.dbflute.exception.factory.ExceptionMessageBuilder;
import org.seasar.dbflute.properties.DfAdditionalPrimaryKeyProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfAdditionalPrimaryKeyInitializer {
    private static final Log _log = LogFactory.getLog(DfAdditionalPrimaryKeyInitializer.class);
    protected Database _database;

    public DfAdditionalPrimaryKeyInitializer(Database database) {
        this._database = database;
    }

    public void initializeAdditionalPrimaryKey() {
        _log.info((Object)"/=======================================");
        _log.info((Object)"...Initializing additional primary keys.");
        Map<String, Map<String, String>> additionalPrimaryKeyMap = this.getAdditionalPrimaryKeyMap();
        Set<String> primaryNameKeySet = additionalPrimaryKeyMap.keySet();
        for (String primaryKeyName : primaryNameKeySet) {
            String tableName = this.getTableName(primaryKeyName);
            this.assertTable(primaryKeyName, tableName);
            List<String> columnNameList = this.getLocalColumnNameList(primaryKeyName);
            this.assertColumnList(primaryKeyName, tableName, columnNameList);
            Table table = this.getTable(tableName);
            if (table.hasPrimaryKey()) {
                String pkDisp = table.getPrimaryKeyDispValueString();
                String msg = "The primary key of the table has already set up:";
                msg = msg + " tableName=" + tableName + " existing primaryKey=" + pkDisp;
                msg = msg + " your specified primaryKey=" + columnNameList;
                _log.info((Object)msg);
                continue;
            }
            for (String columnName : columnNameList) {
                Column column = table.getColumn(columnName);
                column.setPrimaryKey(true);
                column.setAdditionalPrimaryKey(true);
            }
            this.showResult(primaryKeyName, table, columnNameList);
        }
        _log.info((Object)"==========/");
    }

    protected void showResult(String primaryKeyName, Table table, List<String> columnNameList) {
        _log.info((Object)("  " + primaryKeyName));
        if (columnNameList.size() == 1) {
            _log.info((Object)("    Add primary key " + table.getName() + "." + columnNameList.get(0)));
        } else {
            _log.info((Object)("    Add primary key " + table.getName() + "." + columnNameList));
        }
    }

    protected DfAdditionalPrimaryKeyProperties getProperties() {
        return DfBuildProperties.getInstance().getAdditionalPrimaryKeyProperties();
    }

    protected void assertTable(String primaryKeyName, String tableName) {
        if (this.getTable(tableName) != null) {
            return;
        }
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Not found table by the tableName of additionalPrimaryKey.");
        br.addItem("Additional PK");
        br.addElement((Object)primaryKeyName);
        br.addItem("NotFound Table");
        br.addElement((Object)tableName);
        String msg = br.buildExceptionMessage();
        throw new DfPropertySettingTableNotFoundException(msg);
    }

    protected void assertColumnList(String primaryKeyName, String tableName, List<String> columnNameList) {
        if (this.getTable(tableName).containsColumn(columnNameList)) {
            return;
        }
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Not found table by the tableName of additionalPrimaryKey.");
        br.addItem("Additional PK");
        br.addElement((Object)primaryKeyName);
        br.addItem("Table");
        br.addElement((Object)tableName);
        br.addItem("NotFound Column");
        br.addElement(columnNameList);
        String msg = br.buildExceptionMessage();
        throw new DfPropertySettingColumnNotFoundException(msg);
    }

    protected String getTableName(String primaryKeyName) {
        return this.getProperties().findTableName(primaryKeyName);
    }

    protected List<String> getLocalColumnNameList(String primaryKeyName) {
        return this.getProperties().findColumnNameList(primaryKeyName);
    }

    protected Map<String, Map<String, String>> getAdditionalPrimaryKeyMap() {
        return this.getProperties().getAdditionalPrimaryKeyMap();
    }

    protected Table getTable(String tableName) {
        return this.getDatabase().getTable(tableName);
    }

    protected Table[] getTables() {
        return this.getDatabase().getTables();
    }

    protected Database getDatabase() {
        return this._database;
    }
}

