/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.extension.creator;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.seasar.ymir.extension.creator.ClassCreationHintBag;
import org.seasar.ymir.extension.creator.ClassDesc;
import org.seasar.ymir.extension.creator.MethodDesc;
import org.seasar.ymir.extension.creator.ParameterDesc;
import org.seasar.ymir.extension.creator.PropertyDesc;
import org.seasar.ymir.extension.creator.SourceCreator;
import org.seasar.ymir.extension.creator.TypeDesc;
import org.seasar.ymir.extension.creator.impl.MethodDescImpl;
import org.seasar.ymir.extension.creator.impl.ParameterDescImpl;
import org.seasar.ymir.extension.creator.impl.PropertyDescImpl;
import org.seasar.ymir.extension.creator.impl.TypeDescImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescPool
implements Iterable<ClassDesc> {
    private static ThreadLocal<DescPool> pools_ = new ThreadLocal();
    private Map<ClassDescKey, ClassDesc> classDescMap_ = new HashMap<ClassDescKey, ClassDesc>();
    private SourceCreator sourceCreator_;
    private ClassCreationHintBag hintBag_;
    private String bornOf_;

    private DescPool(SourceCreator sourceCreator, ClassCreationHintBag hintBag) {
        this.sourceCreator_ = sourceCreator;
        this.hintBag_ = hintBag;
    }

    public static DescPool getDefault() {
        return pools_.get();
    }

    public static void setDefault(DescPool pool) {
        pools_.set(pool);
    }

    public static DescPool newInstance(SourceCreator sourceCreator, ClassCreationHintBag hintBag) {
        return new DescPool(sourceCreator, hintBag);
    }

    public ClassDesc getClassDesc(Class<?> clazz) {
        return this.getClassDesc(clazz, null);
    }

    public ClassDesc getClassDesc(Class<?> clazz, String qualifier) {
        if (clazz == null) {
            return null;
        }
        return this.getClassDesc(new ClassDescKey(clazz, qualifier));
    }

    public ClassDesc getClassDesc(String className) {
        return this.getClassDesc(className, null);
    }

    public ClassDesc getClassDesc(String className, String qualifier) {
        if (className == null) {
            return null;
        }
        return this.getClassDesc(new ClassDescKey(className, qualifier));
    }

    public ClassDesc getClassDesc(ClassDescKey classDescKey) {
        if (classDescKey == null) {
            return null;
        }
        ClassDesc classDesc = this.classDescMap_.get(classDescKey);
        if (classDesc == null) {
            classDesc = this.sourceCreator_.newClassDesc(this, classDescKey.getClassName(), classDescKey.getQualifier(), this.hintBag_);
            classDesc.setBornOf(this.bornOf_);
            this.classDescMap_.put(classDescKey, classDesc);
        }
        return classDesc;
    }

    public TypeDesc newTypeDesc(String typeName) {
        return this.newTypeDesc(typeName, null);
    }

    public TypeDesc newTypeDesc(String typeName, String componentClassQualifier) {
        return new TypeDescImpl(this, typeName, componentClassQualifier);
    }

    public TypeDesc newTypeDesc(Type type) {
        return this.newTypeDesc(type, null);
    }

    public TypeDesc newTypeDesc(Type type, String qualifier) {
        return new TypeDescImpl(this, type, qualifier);
    }

    public TypeDesc newTypeDesc(ClassDesc componentClassDesc) {
        return this.newTypeDesc(componentClassDesc, false, null);
    }

    public TypeDesc newTypeDesc(TypeDesc typeDesc) {
        return new TypeDescImpl(this, typeDesc.getName(), typeDesc.getComponentClassDesc().getQualifier());
    }

    public TypeDesc newTypeDesc(ClassDesc componentClassDesc, boolean collection, String collectionClassName) {
        return new TypeDescImpl(this, componentClassDesc, collection, collectionClassName);
    }

    public void clear() {
        this.classDescMap_.clear();
    }

    @Override
    public Iterator<ClassDesc> iterator() {
        return this.classDescMap_.values().iterator();
    }

    public List<ClassDesc> getGeneratedClassDescs() {
        ArrayList<ClassDesc> list = new ArrayList<ClassDesc>();
        for (ClassDesc classDesc : this.classDescMap_.values()) {
            if (!this.getSourceCreator().isGeneratedClass(classDesc.getName())) continue;
            list.add(classDesc);
        }
        return list;
    }

    public boolean contains(String className) {
        return this.contains(className, null);
    }

    public boolean contains(String className, String qualifier) {
        if (className == null) {
            return false;
        }
        return this.classDescMap_.containsKey(new ClassDescKey(className, qualifier));
    }

    public boolean contains(ClassDesc classDesc) {
        if (classDesc == null) {
            return false;
        }
        if (classDesc.getDescPool() != this) {
            throw new IllegalArgumentException("Can't process ClassDesc born from another DescPool");
        }
        for (ClassDesc cd : this.classDescMap_.values()) {
            if (cd != classDesc) continue;
            return true;
        }
        return false;
    }

    public ClassCreationHintBag getHintBag() {
        return this.hintBag_;
    }

    public SourceCreator getSourceCreator() {
        return this.sourceCreator_;
    }

    public String getBornOf() {
        return this.bornOf_;
    }

    public void setBornOf(String bornOf) {
        this.bornOf_ = bornOf;
    }

    public ClassDesc registerClassDesc(ClassDesc classDesc) {
        if (classDesc.getDescPool() != this) {
            throw new IllegalArgumentException("Can't register ClassDesc born from another DescPool");
        }
        return this.classDescMap_.put(new ClassDescKey(classDesc), classDesc);
    }

    public boolean unregisterClassDesc(String className) {
        return this.unregisterClassDesc(className, null);
    }

    public boolean unregisterClassDesc(String className, String qualifier) {
        if (className == null) {
            return false;
        }
        return this.unregisterClassDesc(new ClassDescKey(className, qualifier));
    }

    public boolean unregisterClassDesc(ClassDesc classDesc) {
        if (classDesc == null) {
            return false;
        }
        if (classDesc.getDescPool() != this) {
            throw new IllegalArgumentException("Can't unregister ClassDesc born from another DescPool");
        }
        Iterator<Map.Entry<ClassDescKey, ClassDesc>> itr = this.classDescMap_.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<ClassDescKey, ClassDesc> entry = itr.next();
            if (entry.getValue() != classDesc) continue;
            itr.remove();
            return true;
        }
        return false;
    }

    public boolean unregisterClassDesc(ClassDescKey classDescKey) {
        if (classDescKey == null) {
            return false;
        }
        return this.classDescMap_.remove(classDescKey) != null;
    }

    public PropertyDesc newPropertyDesc(String name) {
        return new PropertyDescImpl(this, name);
    }

    public MethodDesc newMethodDesc(String name) {
        return new MethodDescImpl(this, name);
    }

    public ParameterDesc newParameterDesc() {
        return new ParameterDescImpl(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClassDescKey {
        private String className_;
        private String qualifier_;

        public ClassDescKey(String className) {
            this(className, null);
        }

        public ClassDescKey(String className, String qualifier) {
            this.className_ = className;
            this.qualifier_ = qualifier;
        }

        public ClassDescKey(Class<?> clazz) {
            this(clazz, null);
        }

        public ClassDescKey(Class<?> clazz, String qualifier) {
            this.className_ = clazz.getName();
            this.qualifier_ = qualifier;
        }

        public ClassDescKey(ClassDesc classDesc) {
            this.className_ = classDesc.getName();
            this.qualifier_ = classDesc.getQualifier();
        }

        public String getClassName() {
            return this.className_;
        }

        public String getQualifier() {
            return this.qualifier_;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.className_ == null ? 0 : this.className_.hashCode());
            result = 31 * result + (this.qualifier_ == null ? 0 : this.qualifier_.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ClassDescKey other = (ClassDescKey)obj;
            if (this.className_ == null ? other.className_ != null : !this.className_.equals(other.className_)) {
                return false;
            }
            return !(this.qualifier_ == null ? other.qualifier_ != null : !this.qualifier_.equals(other.qualifier_));
        }
    }
}

