/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.task;

import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.engine.EngineException;
import org.apache.torque.engine.database.model.AppData;
import org.apache.torque.engine.database.model.Column;
import org.apache.torque.engine.database.model.Database;
import org.apache.torque.engine.database.model.Table;
import org.apache.torque.engine.database.model.UnifiedSchema;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.seasar.dbflute.DBDef;
import org.seasar.dbflute.DfBuildProperties;
import org.seasar.dbflute.config.DfSpecifiedSqlFile;
import org.seasar.dbflute.exception.DfCustomizeEntityDuplicateException;
import org.seasar.dbflute.exception.DfJDBCException;
import org.seasar.dbflute.exception.DfParameterBeanDuplicateException;
import org.seasar.dbflute.exception.DfProcedureSetupFailureException;
import org.seasar.dbflute.exception.IllegalOutsideSqlOperationException;
import org.seasar.dbflute.exception.factory.ExceptionMessageBuilder;
import org.seasar.dbflute.friends.velocity.DfVelocityContextFactory;
import org.seasar.dbflute.helper.StringKeyMap;
import org.seasar.dbflute.helper.jdbc.DfRunnerInformation;
import org.seasar.dbflute.helper.jdbc.sqlfile.DfSqlFileFireMan;
import org.seasar.dbflute.helper.jdbc.sqlfile.DfSqlFileRunner;
import org.seasar.dbflute.helper.jdbc.sqlfile.DfSqlFileRunnerBase;
import org.seasar.dbflute.helper.language.DfLanguageDependencyInfo;
import org.seasar.dbflute.logic.jdbc.handler.DfColumnHandler;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfColumnMetaInfo;
import org.seasar.dbflute.logic.jdbc.schemaxml.DfSchemaXmlReader;
import org.seasar.dbflute.logic.sql2entity.bqp.DfBehaviorQueryPathSetupper;
import org.seasar.dbflute.logic.sql2entity.cmentity.DfCustomizeEntityInfo;
import org.seasar.dbflute.logic.sql2entity.cmentity.DfCustomizeEntityMetaExtractor;
import org.seasar.dbflute.logic.sql2entity.outsidesql.DfOutsideSqlMarkAnalyzer;
import org.seasar.dbflute.logic.sql2entity.outsidesql.DfSqlFileNameResolver;
import org.seasar.dbflute.logic.sql2entity.pmbean.DfPmbMetaData;
import org.seasar.dbflute.logic.sql2entity.pmbean.DfProcedurePmbSetupper;
import org.seasar.dbflute.logic.sql2entity.pmbean.DfPropertyTypePackageResolver;
import org.seasar.dbflute.properties.DfBasicProperties;
import org.seasar.dbflute.properties.DfCommonColumnProperties;
import org.seasar.dbflute.properties.DfLittleAdjustmentProperties;
import org.seasar.dbflute.properties.DfOutsideSqlProperties;
import org.seasar.dbflute.task.bs.DfAbstractTexenTask;
import org.seasar.dbflute.util.DfCollectionUtil;
import org.seasar.dbflute.util.Srl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfSql2EntityTask
extends DfAbstractTexenTask {
    private static final Log _log = LogFactory.getLog(DfSql2EntityTask.class);
    protected final Map<String, DfCustomizeEntityInfo> _entityInfoMap = DfCollectionUtil.newLinkedHashMap();
    protected final Map<String, Object> _cursorInfoMap = DfCollectionUtil.newLinkedHashMap();
    protected final Map<String, DfPmbMetaData> _pmbMetaDataMap = DfCollectionUtil.newLinkedHashMap();
    protected final Map<String, File> _entitySqlFileMap = DfCollectionUtil.newLinkedHashMap();
    protected final Map<String, String> _exceptionInfoMap = DfCollectionUtil.newLinkedHashMap();
    protected final Map<String, List<String>> _primaryKeyMap = DfCollectionUtil.newLinkedHashMap();
    protected final DfColumnHandler _columnHandler = new DfColumnHandler();
    protected final DfOutsideSqlMarkAnalyzer _markAnalyzer = new DfOutsideSqlMarkAnalyzer();
    protected AppData _schemaData;
    protected final Database _database = new Database();

    @Override
    protected boolean isUseDataSource() {
        return true;
    }

    @Override
    protected void doExecute() {
        this.setupControlTemplate();
        this.setupSchemaInformation();
        DfRunnerInformation runInfo = new DfRunnerInformation();
        runInfo.setDriver(this._driver);
        runInfo.setUrl(this._url);
        runInfo.setUser(this._userId);
        runInfo.setPassword(this._password);
        runInfo.setAutoCommit(false);
        runInfo.setErrorContinue(false);
        runInfo.setRollbackOnly(true);
        runInfo.setEncoding(this.getOutsideSqlProperties().getSqlFileEncoding());
        DfSqlFileRunner runner = this.createSqlFileRunner(runInfo);
        DfSqlFileFireMan fireMan = new DfSqlFileFireMan();
        List<File> sqlFileList = this.getTargetSqlFileList();
        fireMan.execute(runner, sqlFileList);
        this.setupProcedure();
        this.fireVelocityProcess();
        this.setupBehaviorQueryPath();
        this.showTargetSqlFileInformation(sqlFileList);
        this.showSkippedFileInformation();
        this.handleNotFoundResult(sqlFileList);
        this.handleException();
        this.refreshResources();
    }

    protected void setupSchemaInformation() {
        DfSchemaXmlReader schemaFileReader = this.createSchemaFileReader();
        try {
            schemaFileReader.read();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        this._schemaData = schemaFileReader.getSchemaData();
    }

    protected DfSchemaXmlReader createSchemaFileReader() {
        String filePath = this.getBasicProperties().getProejctSchemaXMLFilePath();
        return new DfSchemaXmlReader(filePath, this.getTargetDatabase());
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void setupControlTemplate() {
        DfLittleAdjustmentProperties littleProp = DfBuildProperties.getInstance().getLittleAdjustmentProperties();
        if (littleProp.isAlternateSql2EntityControlValid()) {
            _log.info((Object)"");
            _log.info((Object)"* * * * * * * * * * * * * * *");
            _log.info((Object)"* Process Alternate Control *");
            _log.info((Object)"* * * * * * * * * * * * * * *");
            String control = littleProp.getAlternateSql2EntityControl();
            _log.info((Object)("...Using alternate control: " + control));
            this.setControlTemplate(control);
            return;
        }
        if (!this.getBasicProperties().isTargetLanguageMain()) {
            String language = this.getBasicProperties().getTargetLanguage();
            _log.info((Object)"");
            _log.info((Object)"* * * * * * * * * *");
            _log.info((Object)("* Process " + language + "    *"));
            _log.info((Object)"* * * * * * * * * *");
            String control = "om/" + language + "/sql2entity-Control-" + language + ".vm";
            _log.info((Object)("...Using " + language + " control: " + control));
            this.setControlTemplate(control);
            return;
        }
        if (this.getBasicProperties().isTargetLanguageJava()) {
            _log.info((Object)"");
            _log.info((Object)"* * * * * * * * *");
            _log.info((Object)"* Process Java  *");
            _log.info((Object)"* * * * * * * * *");
            String control = "om/ControlSql2EntityJava.vm";
            _log.info((Object)"...Using Java control: om/ControlSql2EntityJava.vm");
            this.setControlTemplate("om/ControlSql2EntityJava.vm");
            return;
        }
        if (this.getBasicProperties().isTargetLanguageCSharp()) {
            _log.info((Object)"");
            _log.info((Object)"* * * * * * * * * *");
            _log.info((Object)"* Process CSharp  *");
            _log.info((Object)"* * * * * * * * * *");
            String control = "om/ControlSql2EntityCSharp.vm";
            _log.info((Object)"...Using CSharp control: om/ControlSql2EntityCSharp.vm");
            this.setControlTemplate("om/ControlSql2EntityCSharp.vm");
            return;
        }
        String msg = "Unknown Main Language: " + this.getBasicProperties().getTargetLanguage();
        throw new IllegalStateException(msg);
    }

    protected List<File> getTargetSqlFileList() {
        List<File> sqlFileList = this.collectSqlFileList();
        String specifiedSqlFile = DfSpecifiedSqlFile.getInstance().getSpecifiedSqlFile();
        if (specifiedSqlFile != null) {
            ArrayList<File> filteredList = new ArrayList<File>();
            for (File sqlFile : sqlFileList) {
                String fileName = sqlFile.getName();
                if (!specifiedSqlFile.equals(fileName)) continue;
                filteredList.add(sqlFile);
            }
            return filteredList;
        }
        return sqlFileList;
    }

    protected DfSqlFileRunner createSqlFileRunner(DfRunnerInformation runInfo) {
        final Log log4inner = _log;
        final DfPropertyTypePackageResolver packageResolver = new DfPropertyTypePackageResolver();
        final DBDef currentDBDef = this.getBasicProperties().getCurrentDBDef();
        return new DfSqlFileRunnerBase(runInfo, this.getDataSource()){

            @Override
            protected String filterSql(String sql) {
                return super.filterSql(sql);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            protected void execSQL(String sql) {
                ResultSet rs;
                block16: {
                    DfPmbMetaData parameterBeanMetaData;
                    rs = null;
                    boolean alreadyIncrementGoodSqlCount = false;
                    if (this.isTargetEntityMakingSql(sql)) {
                        String filtered = sql;
                        if (!currentDBDef.dbway().isBlockCommentSupported()) {
                            filtered = DfSql2EntityTask.this.removeBlockComment(filtered);
                        }
                        if (!currentDBDef.dbway().isLineCommentSupported()) {
                            filtered = DfSql2EntityTask.this.removeLineComment(filtered);
                        }
                        String executedActuallySql = filtered;
                        this.checkStatement(executedActuallySql);
                        rs = this._currentStatement.executeQuery(executedActuallySql);
                        ++this._goodSqlCount;
                        alreadyIncrementGoodSqlCount = true;
                        final Map<String, String> columnForcedJavaNativeMap = this.createColumnForcedJavaNativeMap(sql);
                        DfCustomizeEntityMetaExtractor customizeEntityMetaExtractor = new DfCustomizeEntityMetaExtractor();
                        Map<String, DfColumnMetaInfo> columnMetaInfoMap = customizeEntityMetaExtractor.extractColumnMetaInfoMap(rs, sql, new DfCustomizeEntityMetaExtractor.DfForcedJavaNativeProvider(){

                            public String provide(String columnName) {
                                return (String)columnForcedJavaNativeMap.get(columnName);
                            }
                        });
                        String entityName = DfSql2EntityTask.this.getCustomizeEntityName(sql);
                        if (entityName != null) {
                            entityName = DfSql2EntityTask.this.resolveEntityNameIfNeeds(entityName, this._sqlFile);
                            DfSql2EntityTask.this.assertDuplicateEntity(entityName, this._sqlFile);
                            DfSql2EntityTask.this._entityInfoMap.put(entityName, new DfCustomizeEntityInfo(entityName, columnMetaInfoMap));
                            if (DfSql2EntityTask.this.isCursor(sql)) {
                                DfSql2EntityTask.this._cursorInfoMap.put(entityName, new Object());
                            }
                            DfSql2EntityTask.this._entitySqlFileMap.put(entityName, this._sqlFile);
                            DfSql2EntityTask.this._primaryKeyMap.put(entityName, DfSql2EntityTask.this.getPrimaryKeyColumnNameList(sql));
                        }
                    }
                    if (!this.isTargetParameterBeanMakingSql(sql)) break block16;
                    if (!alreadyIncrementGoodSqlCount) {
                        ++this._goodSqlCount;
                    }
                    if ((parameterBeanMetaData = this.extractParameterBeanMetaData(sql)) == null) break block16;
                    String pmbName = parameterBeanMetaData.getClassName();
                    DfSql2EntityTask.this.assertDuplicateParameterBean(pmbName, this._sqlFile);
                    DfSql2EntityTask.this._pmbMetaDataMap.put(pmbName, parameterBeanMetaData);
                }
                Object var10_10 = null;
                if (rs == null) return;
                try {
                    rs.close();
                    return;
                }
                catch (SQLException ignored) {
                    log4inner.warn((Object)("Ignored exception: " + ignored.getMessage()));
                }
                return;
                {
                    catch (SQLException e) {
                        if (this._runInfo.isErrorContinue()) {
                            _log.warn((Object)("Failed to execute: " + sql), (Throwable)e);
                            DfSql2EntityTask.this._exceptionInfoMap.put(this._sqlFile.getName(), e.getMessage() + this.ln() + sql);
                            Object var10_11 = null;
                            if (rs == null) return;
                            try {
                                rs.close();
                                return;
                            }
                            catch (SQLException ignored) {
                                log4inner.warn((Object)("Ignored exception: " + ignored.getMessage()));
                            }
                            return;
                        }
                        this.throwSQLFailureException(sql, e);
                        Object var10_12 = null;
                        if (rs == null) return;
                        try {
                            rs.close();
                            return;
                        }
                        catch (SQLException ignored) {
                            log4inner.warn((Object)("Ignored exception: " + ignored.getMessage()));
                        }
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var10_13 = null;
                    if (rs == null) throw throwable;
                    try {
                        rs.close();
                        throw throwable;
                    }
                    catch (SQLException ignored) {
                        log4inner.warn((Object)("Ignored exception: " + ignored.getMessage()));
                    }
                    throw throwable;
                }
            }

            protected Map<String, String> createColumnForcedJavaNativeMap(String sql) {
                List<String> entityPropertyTypeList = DfSql2EntityTask.this.getEntityPropertyTypeList(sql);
                StringKeyMap columnJavaNativeMap = StringKeyMap.createAsFlexible();
                for (String element : entityPropertyTypeList) {
                    String nameDelimiter = " ";
                    int nameDelimiterLength = " ".length();
                    int nameIndex = (element = element.trim()).lastIndexOf(" ");
                    if (nameIndex <= 0) {
                        String msg = "The customize entity element should be [typeName columnName].";
                        msg = msg + " But: element=" + element;
                        msg = msg + " srcFile=" + this._sqlFile;
                        throw new IllegalStateException(msg);
                    }
                    String typeName = this.resolvePackageName(element.substring(0, nameIndex).trim());
                    String columnName = element.substring(nameIndex + nameDelimiterLength).trim();
                    columnJavaNativeMap.put(columnName, typeName);
                }
                return columnJavaNativeMap;
            }

            protected boolean isTargetEntityMakingSql(String sql) {
                String entityName = DfSql2EntityTask.this.getCustomizeEntityName(sql);
                if (entityName == null) {
                    return false;
                }
                return !"df:x".equalsIgnoreCase(entityName);
            }

            protected boolean isTargetParameterBeanMakingSql(String sql) {
                String parameterBeanName = DfSql2EntityTask.this.getParameterBeanName(sql);
                return parameterBeanName != null;
            }

            protected DfPmbMetaData extractParameterBeanMetaData(String sql) {
                String parameterBeanName = DfSql2EntityTask.this.getParameterBeanName(sql);
                if (parameterBeanName == null) {
                    return null;
                }
                DfPmbMetaData pmbMetaData = new DfPmbMetaData();
                String delimiter = "extends";
                int idx = parameterBeanName.indexOf("extends");
                String className = idx >= 0 ? parameterBeanName.substring(0, idx) : parameterBeanName;
                className = className.trim();
                className = DfSql2EntityTask.this.resolvePmbNameIfNeeds(className, this._sqlFile);
                pmbMetaData.setClassName(className);
                if (idx >= 0) {
                    String superClassName = parameterBeanName.substring(idx + "extends".length()).trim();
                    pmbMetaData.setSuperClassName(superClassName);
                    this.resolveSuperClassSimplePagingBean(pmbMetaData);
                }
                LinkedHashMap<String, String> propertyNameTypeMap = new LinkedHashMap<String, String>();
                LinkedHashMap<String, String> propertyNameOptionMap = new LinkedHashMap<String, String>();
                pmbMetaData.setPropertyNameTypeMap(propertyNameTypeMap);
                pmbMetaData.setPropertyNameOptionMap(propertyNameOptionMap);
                List<String> parameterBeanElement = DfSql2EntityTask.this.getParameterBeanPropertyTypeList(sql);
                for (String element : parameterBeanElement) {
                    String optionDef;
                    String propertyDef;
                    String nameDelimiter = " ";
                    String optionDelimiter = ":";
                    int optionIndex = (element = element.trim()).indexOf(":");
                    if (optionIndex > 0) {
                        propertyDef = element.substring(0, optionIndex).trim();
                        optionDef = element.substring(optionIndex + ":".length()).trim();
                    } else {
                        propertyDef = element;
                        optionDef = null;
                    }
                    int nameIndex = propertyDef.lastIndexOf(" ");
                    if (nameIndex <= 0) {
                        String msg = "The parameter bean element should be [typeName propertyName].";
                        msg = msg + " But: element=" + element + " srcFile=" + this._sqlFile;
                        throw new IllegalStateException(msg);
                    }
                    String typeName = this.resolvePackageNameExceptUtil(propertyDef.substring(0, nameIndex).trim());
                    String propertyName = propertyDef.substring(nameIndex + " ".length()).trim();
                    propertyNameTypeMap.put(propertyName, typeName);
                    if (optionDef == null) continue;
                    propertyNameOptionMap.put(propertyName, optionDef);
                }
                pmbMetaData.setSqlFile(this._sqlFile);
                return pmbMetaData;
            }

            protected void resolveSuperClassSimplePagingBean(DfPmbMetaData pmbMetaData) {
                String superClassName = pmbMetaData.getSuperClassName();
                if (superClassName.equalsIgnoreCase("Paging") || superClassName.equalsIgnoreCase("SPB")) {
                    String baseCommonPackage = DfSql2EntityTask.this.getBasicProperties().getBaseCommonPackage();
                    String projectPrefix = DfSql2EntityTask.this.getBasicProperties().getProjectPrefix();
                    DfBasicProperties basicProperties = DfSql2EntityTask.this.getProperties().getBasicProperties();
                    DfLanguageDependencyInfo languageDependencyInfo = basicProperties.getLanguageDependencyInfo();
                    String cbeanPackageName = languageDependencyInfo.getConditionBeanPackageName();
                    String spbName = "SimplePagingBean";
                    pmbMetaData.setSuperClassName(baseCommonPackage + "." + cbeanPackageName + "." + projectPrefix + "SimplePagingBean");
                }
            }

            protected String resolvePackageName(String typeName) {
                return packageResolver.resolvePackageName(typeName);
            }

            protected String resolvePackageNameExceptUtil(String typeName) {
                return packageResolver.resolvePackageNameExceptUtil(typeName);
            }

            @Override
            protected String replaceCommentQuestionMarkIfNeeds(String line) {
                if (line.indexOf("--!!") >= 0 || line.indexOf("-- !!") >= 0) {
                    return line;
                }
                return super.replaceCommentQuestionMarkIfNeeds(line);
            }

            @Override
            protected boolean isTargetSql(String sql) {
                String entityName = DfSql2EntityTask.this.getCustomizeEntityName(sql);
                String parameterBeanClassDefinition = DfSql2EntityTask.this.getParameterBeanName(sql);
                if (parameterBeanClassDefinition == null && entityName != null && "df:x".equalsIgnoreCase(entityName)) {
                    return false;
                }
                return entityName != null || parameterBeanClassDefinition != null;
            }

            @Override
            protected void traceSql(String sql) {
                log4inner.info((Object)("{SQL}" + this.ln() + sql));
            }

            @Override
            protected void traceResult(int goodSqlCount, int totalSqlCount) {
                if (totalSqlCount > 0) {
                    _log.info((Object)("  --> success=" + goodSqlCount + " failure=" + (totalSqlCount - goodSqlCount)));
                } else {
                    _log.info((Object)"  --> SQL for sql2entity was not found in the SQL file!");
                }
            }

            @Override
            protected boolean isSqlTrimAndRemoveLineSeparator() {
                return false;
            }
        };
    }

    protected void assertDuplicateEntity(String entityName, File currentSqlFile) {
        File sqlFile = this._entitySqlFileMap.get(entityName);
        if (sqlFile == null) {
            return;
        }
        String msg = "Look! Read the message below." + this.ln();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.ln();
        msg = msg + "The customize entity was duplicated!" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Customize Entity]" + this.ln() + entityName + this.ln();
        msg = msg + this.ln();
        msg = msg + "[SQL Files]" + this.ln() + sqlFile + this.ln() + currentSqlFile + this.ln();
        msg = msg + "* * * * * * * * * */";
        throw new DfCustomizeEntityDuplicateException(msg);
    }

    protected void assertDuplicateParameterBean(String pmbName, File currentSqlFile) {
        DfPmbMetaData metaData = this._pmbMetaDataMap.get(pmbName);
        if (metaData == null) {
            return;
        }
        String msg = "Look! Read the message below." + this.ln();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.ln();
        msg = msg + "The parameter-bean was duplicated!" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[ParameterBean]" + this.ln() + pmbName + this.ln();
        msg = msg + this.ln();
        msg = msg + "[SQL Files]" + this.ln() + metaData.getSqlFile() + this.ln() + currentSqlFile + this.ln();
        msg = msg + "* * * * * * * * * */";
        throw new DfParameterBeanDuplicateException(msg);
    }

    protected void handleNotFoundResult(List<File> sqlFileList) {
        if (this._entityInfoMap.isEmpty() && this._pmbMetaDataMap.isEmpty()) {
            _log.warn((Object)"/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *");
            _log.warn((Object)"SQL for sql2entity was not found!");
            _log.warn((Object)"");
            _log.warn((Object)("SQL Files: " + sqlFileList.size()));
            int index = 0;
            for (File file : sqlFileList) {
                _log.warn((Object)("  " + ++index + " -- " + file));
            }
            _log.warn((Object)"* * * * * * * * * */");
            _log.warn((Object)" ");
        }
    }

    protected void handleException() {
        if (this._exceptionInfoMap.isEmpty()) {
            return;
        }
        Set<String> nameSet = this._exceptionInfoMap.keySet();
        StringBuilder sb = new StringBuilder();
        for (String name : nameSet) {
            String exceptionInfo = this._exceptionInfoMap.get(name);
            sb.append("[" + name + "]");
            boolean containsLn = Srl.contains((String)exceptionInfo, (String)this.ln());
            sb.append(containsLn ? this.ln() : " ");
            sb.append(exceptionInfo);
            sb.append(containsLn ? this.ln() : "").append(this.ln());
        }
        _log.warn((Object)"/* * * * * * * * * * * * * * * * * {Warning Exception}");
        _log.warn((Object)(this.ln() + sb.toString().trim()));
        _log.warn((Object)"* * * * * * * * * */");
        _log.warn((Object)" ");
    }

    protected String getCustomizeEntityName(String sql) {
        return this._markAnalyzer.getCustomizeEntityName(sql);
    }

    protected boolean isCursor(String sql) {
        return this._markAnalyzer.isCursor(sql);
    }

    protected List<String> getEntityPropertyTypeList(String sql) {
        return this._markAnalyzer.getCustomizeEntityPropertyTypeList(sql);
    }

    protected String getParameterBeanName(String sql) {
        return this._markAnalyzer.getParameterBeanName(sql);
    }

    protected List<String> getParameterBeanPropertyTypeList(String sql) {
        return this._markAnalyzer.getParameterBeanPropertyTypeList(sql);
    }

    protected List<String> getPrimaryKeyColumnNameList(String sql) {
        return this._markAnalyzer.getPrimaryKeyColumnNameList(sql);
    }

    protected String removeBlockComment(String sql) {
        return Srl.removeBlockComment((String)sql);
    }

    protected String removeLineComment(String sql) {
        return Srl.removeLineComment((String)sql);
    }

    protected String resolveEntityNameIfNeeds(String className, File file) {
        return new DfSqlFileNameResolver().resolveEntityNameIfNeeds(className, file.getName());
    }

    protected String resolvePmbNameIfNeeds(String className, File file) {
        return new DfSqlFileNameResolver().resolvePmbNameIfNeeds(className, file.getName());
    }

    protected void setupProcedure() {
        try {
            DfProcedurePmbSetupper setupper = this.createProcedurePmbSetupper();
            setupper.setupProcedure();
            this._exceptionInfoMap.putAll(setupper.getContinuedFailureMessageMap());
        }
        catch (SQLException e) {
            this.throwProcedureSetupFailureException(e);
        }
    }

    protected DfProcedurePmbSetupper createProcedurePmbSetupper() {
        return new DfProcedurePmbSetupper(this.getDataSource(), this._entityInfoMap, this._pmbMetaDataMap, this._database);
    }

    protected void throwProcedureSetupFailureException(SQLException e) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Failed to set up procedures.");
        br.addItem("SQL Exception");
        br.addElement((Object)DfJDBCException.extractMessage(e));
        SQLException nextEx = e.getNextException();
        if (nextEx != null) {
            br.addElement((Object)DfJDBCException.extractMessage(nextEx));
        }
        String msg = br.buildExceptionMessage();
        throw new DfProcedureSetupFailureException(msg, e);
    }

    protected void setupBehaviorQueryPath() {
        List<File> sqlFileList = this.collectSqlFileList();
        DfBehaviorQueryPathSetupper setupper = new DfBehaviorQueryPathSetupper(this.getProperties());
        setupper.setupBehaviorQueryPath(sqlFileList);
    }

    public Context initControlContext() throws Exception {
        Database database = this._database;
        database.setSql2EntitySchemaData(this._schemaData);
        database.setPmbMetaDataMap(this._pmbMetaDataMap);
        database.setSkipDeleteOldClass(DfSpecifiedSqlFile.getInstance().getSpecifiedSqlFile() != null);
        Set<String> entityNameSet = this._entityInfoMap.keySet();
        for (String entityName : entityNameSet) {
            DfCustomizeEntityInfo entityInfo = this._entityInfoMap.get(entityName);
            Map<String, DfColumnMetaInfo> metaMap = entityInfo.getColumnMap();
            Table tbl = new Table();
            tbl.setSql2EntityCustomize(true);
            tbl.setName(entityInfo.getTableDbName());
            if (!entityInfo.needsJavaNameConvert()) {
                tbl.suppressJavaNameConvert();
            }
            if (entityInfo.hasNestedCustomizeEntity()) {
                tbl.setSql2EntityCustomizeHasNested(true);
            }
            if (entityInfo.isAdditionalSchema()) {
                tbl.setUnifiedSchema(entityInfo.getAdditionalSchema());
            }
            tbl.setSql2EntityTypeSafeCursor(this._cursorInfoMap.get(entityName) != null);
            database.addTable(tbl);
            _log.info((Object)entityName);
            StringKeyMap<String> pkMap = this.getPrimaryKeyMap(entityName);
            boolean allCommonColumn = this.hasAllCommonColumn(metaMap);
            Set<String> columnNameSet = metaMap.keySet();
            for (String columnName : columnNameSet) {
                Column column = new Column();
                this.setupColumnName(columnName, column);
                String pkRelatedTableName = this.setupPrimaryKey(pkMap, entityName, columnName, column);
                this.setupTorqueType(metaMap, columnName, column, allCommonColumn);
                this.setupDbType(metaMap, columnName, column);
                this.setupColumnSizeContainsDigit(metaMap, columnName, column);
                this.setupColumnComment(metaMap, columnName, column);
                this.setupSql2EntityElement(entityName, metaMap, columnName, column, pkRelatedTableName);
                tbl.addColumn(column);
            }
            if (!pkMap.isEmpty()) {
                this.throwPrimaryKeyNotFoundException(entityName, pkMap, columnNameSet);
            }
            _log.info((Object)"");
        }
        String databaseType = this.getBasicProperties().getDatabaseType();
        AppData appData = new AppData(databaseType);
        appData.addDatabase(database);
        VelocityContext context = this.createVelocityContext(appData);
        return context;
    }

    protected StringKeyMap<String> getPrimaryKeyMap(String entityName) {
        StringKeyMap pkMap = StringKeyMap.createAsFlexibleOrdered();
        List<String> pkList = this._primaryKeyMap.get(entityName);
        if (pkList != null) {
            for (String pk : pkList) {
                if (Srl.contains((String)pk, (String)".")) {
                    Srl.IndexOfInfo info = Srl.indexOfFirst((String)pk, (String[])new String[]{"."});
                    String tableName = info.substringFrontTrimmed();
                    String pkName = info.substringRearTrimmed();
                    pkMap.put(pkName, (Object)tableName);
                    continue;
                }
                pkMap.put(pk, null);
            }
        }
        return pkMap;
    }

    protected boolean hasAllCommonColumn(Map<String, DfColumnMetaInfo> columnJdbcTypeMap) {
        Map<String, String> commonColumnMap = this.getCommonColumnMap();
        if (commonColumnMap.isEmpty()) {
            return false;
        }
        Set<String> commonColumnSet = commonColumnMap.keySet();
        for (String commonColumnName : commonColumnSet) {
            if (columnJdbcTypeMap.containsKey(commonColumnName)) continue;
            return false;
        }
        return true;
    }

    protected void setupColumnName(String columnName, Column col) {
        if (this.needsConvertToJavaName(columnName)) {
            col.setName(columnName);
        } else {
            col.setupNeedsJavaNameConvertFalse();
            col.setName(Srl.initCap((String)columnName));
        }
    }

    protected String setupPrimaryKey(StringKeyMap<String> pkMap, String entityName, String columnName, Column col) {
        if (pkMap.containsKey((Object)columnName)) {
            col.setPrimaryKey(true);
            return (String)pkMap.remove((Object)columnName);
        }
        return null;
    }

    protected void setupTorqueType(Map<String, DfColumnMetaInfo> metaMap, String columnName, Column column, boolean allCommonColumn) {
        String commonColumnTorqueType;
        if (allCommonColumn && (commonColumnTorqueType = this.getCommonColumnTorqueType(columnName)) != null) {
            column.setJdbcType(commonColumnTorqueType);
            return;
        }
        DfColumnMetaInfo columnMetaInfo = metaMap.get(columnName);
        String columnTorqueType = this.getColumnTorqueType(columnMetaInfo);
        column.setJdbcType(columnTorqueType);
    }

    protected void setupDbType(Map<String, DfColumnMetaInfo> metaMap, String columnName, Column column) {
        String catalogSchema;
        UnifiedSchema unifiedSchema;
        DfColumnMetaInfo columnMetaInfo = metaMap.get(columnName);
        String plainName = columnMetaInfo.getDbTypeName();
        String dbTypeName = Srl.contains((String)plainName, (String)".") ? ((unifiedSchema = UnifiedSchema.createAsDynamicSchema(catalogSchema = Srl.substringLastFront((String)plainName, (String[])new String[]{"."}))).isMainSchema() ? Srl.substringLastRear((String)plainName, (String[])new String[]{"."}) : plainName) : plainName;
        column.setDbType(dbTypeName);
    }

    protected String getCommonColumnTorqueType(String columnName) {
        return this.getCommonColumnMap().get(columnName);
    }

    protected Map<String, String> getCommonColumnMap() {
        DfCommonColumnProperties prop = this.getProperties().getCommonColumnProperties();
        return prop.getCommonColumnMap();
    }

    protected String getColumnTorqueType(DfColumnMetaInfo columnMetaInfo) {
        if (columnMetaInfo.isProcedureParameter() && !this._columnHandler.hasMappingJdbcType(columnMetaInfo)) {
            return "OTHER";
        }
        return this._columnHandler.getColumnJdbcType(columnMetaInfo);
    }

    protected void setupColumnSizeContainsDigit(Map<String, DfColumnMetaInfo> metaMap, String columnName, Column column) {
        DfColumnMetaInfo metaInfo = metaMap.get(columnName);
        int columnSize = metaInfo.getColumnSize();
        int decimalDigits = metaInfo.getDecimalDigits();
        column.setupColumnSize(columnSize, decimalDigits);
    }

    protected void setupColumnComment(Map<String, DfColumnMetaInfo> metaMap, String columnName, Column column) {
        DfColumnMetaInfo metaInfo = metaMap.get(columnName);
        String sql2EntityRelatedTableName = metaInfo.getSql2EntityRelatedTableName();
        Table relatedTable = this.getRelatedTable(sql2EntityRelatedTableName);
        if (relatedTable == null) {
            return;
        }
        String relatedColumnName = metaInfo.getSql2EntityRelatedColumnName();
        Column relatedColumn = relatedTable.getColumn(relatedColumnName);
        if (relatedColumn == null) {
            return;
        }
        String plainComment = relatedColumn.getPlainComment();
        column.setPlainComment(plainComment);
    }

    protected void setupSql2EntityElement(String entityName, Map<String, DfColumnMetaInfo> metaMap, String columnName, Column column, String pkRelatedTableName) {
        Table relatedTable = this.setupSql2EntityRelatedTable(entityName, metaMap, columnName, column, pkRelatedTableName);
        Column relatedColumn = this.setupSql2EntityRelatedColumn(relatedTable, metaMap, columnName, column);
        String forcedJavaNative = this.setupSql2EntityForcedJavaNative(metaMap, columnName, column);
        this.showColumnInfo(columnName, column, relatedTable, relatedColumn, forcedJavaNative);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Table setupSql2EntityRelatedTable(String entityName, Map<String, DfColumnMetaInfo> metaMap, String columnName, Column column, String pkRelatedTableName) {
        DfColumnMetaInfo metaInfo = metaMap.get(columnName);
        String sql2EntityRelatedTableName = metaInfo.getSql2EntityRelatedTableName();
        Table relatedTable = this.getRelatedTable(sql2EntityRelatedTableName);
        if (relatedTable == null) {
            if (pkRelatedTableName == null) return null;
            relatedTable = this.getRelatedTable(pkRelatedTableName);
            if (relatedTable == null) {
                this.throwTableRelatedPrimaryKeyNotFoundException(entityName, pkRelatedTableName, columnName);
            }
        } else if (pkRelatedTableName != null && !Srl.equalsFlexible((String)sql2EntityRelatedTableName, (String[])new String[]{pkRelatedTableName})) {
            this.throwTableRelatedPrimaryKeyDifferentException(entityName, sql2EntityRelatedTableName, pkRelatedTableName, columnName);
        }
        column.setSql2EntityRelatedTable(relatedTable);
        return relatedTable;
    }

    protected void throwTableRelatedPrimaryKeyNotFoundException(String entityName, String tableName, String columnName) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("The table name related to the primary key is not found.");
        br.addItem("Entity");
        br.addElement((Object)entityName);
        br.addItem("Table Name");
        br.addElement((Object)tableName);
        br.addItem("Primary Key");
        br.addElement((Object)columnName);
        String msg = br.buildExceptionMessage();
        throw new IllegalOutsideSqlOperationException(msg);
    }

    protected void throwTableRelatedPrimaryKeyDifferentException(String entityName, String realTable, String differentTable, String columnName) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("The table name related to the primary key is different.");
        br.addItem("Entity");
        br.addElement((Object)entityName);
        br.addItem("Real Table");
        br.addElement((Object)realTable);
        br.addItem("Different Table");
        br.addElement((Object)differentTable);
        br.addItem("Primary Key");
        br.addElement((Object)columnName);
        String msg = br.buildExceptionMessage();
        throw new IllegalOutsideSqlOperationException(msg);
    }

    protected Column setupSql2EntityRelatedColumn(Table relatedTable, Map<String, DfColumnMetaInfo> metaMap, String columnName, Column column) {
        if (relatedTable == null) {
            return null;
        }
        DfColumnMetaInfo metaInfo = metaMap.get(columnName);
        String sql2EntityRelatedColumnName = metaInfo.getSql2EntityRelatedColumnName();
        Column relatedColumn = relatedTable.getColumn(sql2EntityRelatedColumnName);
        if (relatedColumn == null) {
            return null;
        }
        column.setSql2EntityRelatedColumn(relatedColumn);
        return column;
    }

    protected Table getRelatedTable(String sql2EntityRelatedTableName) {
        Table relatedTable;
        if (this._schemaData == null) {
            return null;
        }
        try {
            relatedTable = this._schemaData.getDatabase().getTable(sql2EntityRelatedTableName);
        }
        catch (EngineException e) {
            String msg = "Failed to get database information: schemaData=" + this._schemaData;
            throw new IllegalStateException(msg);
        }
        return relatedTable;
    }

    protected String setupSql2EntityForcedJavaNative(Map<String, DfColumnMetaInfo> metaMap, String columnName, Column column) {
        DfColumnMetaInfo metaInfo = metaMap.get(columnName);
        String sql2EntityForcedJavaNative = metaInfo.getSql2EntityForcedJavaNative();
        column.setSql2EntityForcedJavaNative(sql2EntityForcedJavaNative);
        return sql2EntityForcedJavaNative;
    }

    protected void throwPrimaryKeyNotFoundException(String entityName, StringKeyMap<String> pkMap, Set<String> columnNameSet) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("The primary keys are not found in selected columns.");
        br.addItem("Entity");
        br.addElement((Object)entityName);
        br.addItem("Selected Column");
        br.addElement(columnNameSet);
        br.addItem("Specified PK");
        br.addElement((Object)pkMap.keySet());
        String msg = br.buildExceptionMessage();
        throw new IllegalOutsideSqlOperationException(msg);
    }

    protected void showColumnInfo(String columnName, Column column, Table relatedTable, Column relatedColumn, String forcedJavaNatice) {
        StringBuilder sb = new StringBuilder();
        sb.append(" ").append(column.isPrimaryKey() ? "*" : " ");
        sb.append(columnName);
        sb.append(" ");
        sb.append(column.getDbTypeExpression());
        String columnSize = column.getColumnSize();
        if (Srl.is_NotNull_and_NotTrimmedEmpty((String)columnSize)) {
            sb.append("(").append(columnSize).append(")");
        }
        if (relatedColumn != null) {
            sb.append(" related:").append(relatedTable.getName());
            sb.append(".").append(relatedColumn.getName());
        }
        if (Srl.is_NotNull_and_NotTrimmedEmpty((String)forcedJavaNatice)) {
            sb.append(" forced:").append(forcedJavaNatice);
        }
        _log.info((Object)sb.toString());
    }

    protected VelocityContext createVelocityContext(AppData appData) {
        DfVelocityContextFactory factory = new DfVelocityContextFactory();
        return factory.create(appData);
    }

    protected boolean needsConvertToJavaName(String columnName) {
        if (columnName == null || columnName.trim().length() == 0) {
            String msg = "The columnName is invalid: " + columnName;
            throw new IllegalArgumentException(msg);
        }
        if (columnName.contains("_")) {
            return true;
        }
        char[] columnCharArray = columnName.toCharArray();
        boolean existsUpper = false;
        boolean existsLower = false;
        for (char ch : columnCharArray) {
            if (Character.isDigit(ch)) continue;
            if (Character.isUpperCase(ch)) {
                existsUpper = true;
                continue;
            }
            if (!Character.isLowerCase(ch)) continue;
            existsLower = true;
        }
        boolean camelCase = existsUpper && existsLower;
        return !camelCase;
    }

    protected DfOutsideSqlProperties getOutsideSqlProperties() {
        return this.getProperties().getOutsideSqlProperties();
    }

    public String replaceString(String text, String fromText, String toText) {
        return Srl.replace((String)text, (String)fromText, (String)toText);
    }

    public String getSlashPath(File file) {
        return this.replaceString(file.getPath(), this.getFileSeparator(), "/");
    }

    public String getFileSeparator() {
        return File.separator;
    }

    public void setSpecifiedSqlFile(String specifiedSqlFile) {
        DfSpecifiedSqlFile.getInstance().setSpecifiedSqlFile(specifiedSqlFile);
    }
}

