/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.properties;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.seasar.dbflute.properties.DfAbstractHelperProperties;
import org.seasar.dbflute.util.DfStringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DfRefreshProperties
extends DfAbstractHelperProperties {
    protected Map<String, Object> refreshDefinitionMap;

    public DfRefreshProperties(Properties prop) {
        super(prop);
    }

    protected Map<String, Object> getRefreshDefinitionMap() {
        if (this.refreshDefinitionMap == null) {
            this.refreshDefinitionMap = this.mapProp("torque.refreshDefinitionMap", DEFAULT_EMPTY_MAP);
        }
        return this.refreshDefinitionMap;
    }

    public boolean hasRefreshDefinition() {
        return !this.getRefreshDefinitionMap().isEmpty();
    }

    public List<String> getProjectNameList() {
        String prop = this.getRefreshPropertyRequired("projectName");
        return DfStringUtil.splitListTrimmed((String)prop, (String)"/");
    }

    public String getRequestUrl() {
        return this.getRefreshPropertyRequired("requestUrl");
    }

    protected String getRefreshPropertyRequired(String key) {
        String value = this.getRefreshProperty(key);
        if (value == null || value.trim().length() == 0) {
            String msg = "The property '" + key + "' should not be null or empty:";
            msg = msg + " refreshDefinitionMap=" + this.getRefreshDefinitionMap();
            throw new IllegalStateException(msg);
        }
        return value;
    }

    protected String getRefreshPropertyIfNullEmpty(String key) {
        String value = this.getRefreshProperty(key);
        if (value == null) {
            return "";
        }
        return value;
    }

    protected String getRefreshProperty(String key) {
        String value = (String)this.getRefreshDefinitionMap().get(key);
        return value;
    }
}

