/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.sql2entity.outsidesql;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.dbflute.helper.jdbc.sqlfile.DfSqlFileGetter;
import org.seasar.dbflute.helper.language.DfLanguageDependencyInfo;
import org.seasar.dbflute.helper.language.DfLanguageDependencyInfoJava;
import org.seasar.dbflute.properties.DfBasicProperties;
import org.seasar.dbflute.task.DfSql2EntityTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfSqlFileCollector {
    private static final Log _log = LogFactory.getLog(DfSql2EntityTask.class);
    protected String _sqlDirectory;
    protected DfBasicProperties _basicProperties;
    protected boolean _suppressDirectoryCheck;

    public DfSqlFileCollector(String sqlDirectory, DfBasicProperties basicProperties) {
        this._sqlDirectory = sqlDirectory;
        this._basicProperties = basicProperties;
    }

    public List<File> collectSqlFileList() {
        List<File> sqlFileList;
        String sqlDirectory = this._sqlDirectory;
        File dir = new File(sqlDirectory);
        if (dir.exists()) {
            sqlFileList = this.collectSqlFile(sqlDirectory);
            String srcMainResources = this.replaceSrcMainJavaToSrcMainResources(sqlDirectory);
            if (!sqlDirectory.equals(srcMainResources)) {
                try {
                    sqlFileList.addAll(this.collectSqlFile(srcMainResources));
                }
                catch (Exception e) {
                    _log.info((Object)("Not found sql directory on resources: " + srcMainResources));
                }
            }
        } else if (this.containsSrcMainJava(sqlDirectory)) {
            sqlFileList = new ArrayList<File>();
            String srcMainResources = this.replaceSrcMainJavaToSrcMainResources(sqlDirectory);
            if (!sqlDirectory.equals(srcMainResources)) {
                sqlFileList.addAll(this.collectSqlFile(srcMainResources));
            }
        } else {
            if (this._suppressDirectoryCheck) {
                return new ArrayList<File>();
            }
            String msg = "The sqlDirectory does not exist: " + dir;
            throw new IllegalStateException(msg);
        }
        return sqlFileList;
    }

    protected List<File> collectSqlFile(String sqlDirectory) {
        return this.createSqlFileGetter().getSqlFileList(sqlDirectory);
    }

    protected DfSqlFileGetter createSqlFileGetter() {
        final DfLanguageDependencyInfo dependencyInfo = this._basicProperties.getLanguageDependencyInfo();
        return new DfSqlFileGetter(){

            protected boolean acceptSqlFile(File file) {
                if (!dependencyInfo.isCompileTargetFile(file)) {
                    return false;
                }
                return super.acceptSqlFile(file);
            }
        };
    }

    protected boolean containsSrcMainJava(String sqlDirectory) {
        return DfLanguageDependencyInfoJava.containsSrcMainJava(sqlDirectory);
    }

    protected String replaceSrcMainJavaToSrcMainResources(String sqlDirectory) {
        return DfLanguageDependencyInfoJava.replaceSrcMainJavaToSrcMainResources(sqlDirectory);
    }

    public void suppressDirectoryCheck() {
        this._suppressDirectoryCheck = true;
    }
}

