/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.jdbc.download;

import java.io.File;
import java.io.FileFilter;
import org.seasar.dbflute.properties.DfBasicProperties;

public class DfJDBCDriverDownloadHandler {
    protected static final String urlBase = "http://dbflute.sandbox.seasar.org/meta/jdbc";
    private DfBasicProperties basicProperties;

    public DfJDBCDriverDownloadHandler(DfBasicProperties basicProperties) {
        this.basicProperties = basicProperties;
    }

    public void downloadJDBCDriverIfNeeds(String jdbcDriverFileName, String downloadDir) {
        throw new UnsupportedOperationException("Now making");
    }

    protected boolean needsDownload(String jdbcDriverFileName, String downloadDir) {
        String outputFileName;
        String dbMark;
        if (this.basicProperties.isDatabaseMySQL()) {
            dbMark = "mysql";
        } else if (this.basicProperties.isDatabasePostgreSQL()) {
            dbMark = "postgresql";
        } else if (this.basicProperties.isDatabaseOracle()) {
            dbMark = "ojdbc";
        } else if (this.basicProperties.isDatabaseDB2()) {
            dbMark = "db2jcc";
        } else if (this.basicProperties.isDatabaseSQLServer()) {
            dbMark = "sqljdbc";
        } else if (this.basicProperties.isDatabaseH2()) {
            dbMark = "h2";
        } else if (this.basicProperties.isDatabaseDerby()) {
            dbMark = "derby";
        } else {
            return false;
        }
        File[] listFiles = new File(downloadDir).listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.getName().endsWith(".jar");
            }
        });
        if (listFiles != null) {
            for (File jarfile : listFiles) {
                if (!jarfile.getName().contains(dbMark)) continue;
                return false;
            }
        }
        return !new File(outputFileName = downloadDir + "/" + jdbcDriverFileName).exists();
    }
}

