/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.doc.historyhtml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.seasar.dbflute.DfBuildProperties;
import org.seasar.dbflute.exception.factory.ExceptionMessageBuilder;
import org.seasar.dbflute.infra.diffmap.DiffMapFile;
import org.seasar.dbflute.logic.jdbc.schemadiff.DfSchemaDiff;
import org.seasar.dbflute.properties.DfBasicProperties;
import org.seasar.dbflute.util.DfCollectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfSchemaHistory {
    protected final List<DfSchemaDiff> _schemaDiffList = DfCollectionUtil.newArrayList();
    protected boolean _existsSchemaDiff;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serializeSchemaDiff(DfSchemaDiff schemaDiff) throws IOException {
        String path = this.getSchemaHistoryFilePath();
        DiffMapFile diffMapFile = this.createDiffMapFile();
        File file = new File(path);
        Map serializedMap = DfCollectionUtil.newLinkedHashMap();
        Map<String, Object> schemaDiffMap = schemaDiff.createSchemaDiffMap();
        serializedMap.put((String)schemaDiffMap.get("diffDate"), schemaDiffMap);
        if (file.exists()) {
            FileInputStream ins = null;
            try {
                ins = new FileInputStream(file);
                Map existingMap = diffMapFile.readMap((InputStream)ins);
                Set entrySet = existingMap.entrySet();
                int count = 0;
                int historyLimit = this.getHistoryLimit();
                boolean historyLimitValid = historyLimit >= 0;
                for (Map.Entry entry : entrySet) {
                    if (historyLimitValid && count >= historyLimit) {
                    }
                    serializedMap.put(entry.getKey(), entry.getValue());
                    ++count;
                }
            }
            finally {
                if (ins != null) {
                    ins.close();
                }
            }
        } else {
            file.createNewFile();
        }
        FileOutputStream ous = null;
        try {
            ous = new FileOutputStream(path);
            diffMapFile.writeMap((OutputStream)ous, serializedMap);
        }
        finally {
            if (ous != null) {
                ous.close();
            }
        }
    }

    protected int getHistoryLimit() {
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadHistory() {
        Map diffMap;
        String filePath = this.getSchemaHistoryFilePath();
        File file = new File(this.getSchemaHistoryFilePath());
        if (!file.exists()) {
            this._existsSchemaDiff = false;
            return;
        }
        DiffMapFile diffMapFile = this.createDiffMapFile();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            diffMap = diffMapFile.readMap((InputStream)fis);
        }
        catch (FileNotFoundException ignored) {
            this._existsSchemaDiff = false;
            return;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ignored) {}
            }
        }
        try {
            this.acceptDiffMap(diffMap);
        }
        catch (RuntimeException e) {
            ExceptionMessageBuilder br = new ExceptionMessageBuilder();
            br.addNotice("Failed to accept diff-map.");
            br.addItem("File Path");
            br.addElement((Object)filePath);
            br.addItem("Exception");
            br.addElement((Object)e.getClass().getName());
            br.addElement((Object)e.getMessage());
            String msg = br.buildExceptionMessage();
            throw new IllegalStateException(msg, e);
        }
        this._existsSchemaDiff = true;
    }

    protected void acceptDiffMap(Map<String, Object> diffMap) {
        Set<Map.Entry<String, Object>> entrySet = diffMap.entrySet();
        int index = 0;
        for (Map.Entry<String, Object> entry : entrySet) {
            String key = entry.getKey();
            Object value = entry.getValue();
            this.assertDiffElementMap(key, value);
            Map schemaDiffMap = (Map)value;
            DfSchemaDiff schemaDiff = new DfSchemaDiff();
            schemaDiff.acceptSchemaDiffMap(schemaDiffMap);
            if (index == 0) {
                schemaDiff.setLatest(true);
            }
            this._schemaDiffList.add(schemaDiff);
            ++index;
        }
    }

    protected void assertDiffElementMap(String key, Object value) {
        if (!(value instanceof Map)) {
            String msg = "The elements of diff should be Map:";
            msg = msg + " date=" + key + " value=" + value;
            throw new IllegalStateException(msg);
        }
    }

    public boolean existsHistory() {
        return this._existsSchemaDiff && !this._schemaDiffList.isEmpty();
    }

    protected DiffMapFile createDiffMapFile() {
        return new DiffMapFile();
    }

    public String getSchemaHistoryFilePath() {
        return this.getBasicProperties().getProjectSchemaHistoryFilePath();
    }

    protected DfBasicProperties getBasicProperties() {
        return DfBuildProperties.getInstance().getBasicProperties();
    }

    public List<DfSchemaDiff> getSchemaDiffList() {
        return this._schemaDiffList;
    }
}

