/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.zpt.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.skirnir.freyja.ExpressionEvaluator;
import net.skirnir.freyja.IllegalSyntaxException;
import net.skirnir.freyja.TemplateContext;
import net.skirnir.freyja.VariableResolver;
import net.skirnir.freyja.zpt.tales.TalesUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parameters
implements Iterable<Parameter> {
    private static final char DELIMITER = '!';
    private List<Parameter> parameterList_;

    public Parameters(String statement) throws IllegalSyntaxException {
        this.parameterList_ = Collections.unmodifiableList(this.tokenize(statement));
    }

    List<Parameter> tokenize(String statement) throws IllegalSyntaxException {
        ArrayList<Parameter> list = new ArrayList<Parameter>();
        int len = statement.length();
        if (len == 0) {
            return list;
        }
        StringBuilder sb = new StringBuilder(len);
        int i = 0;
        while (i < len) {
            char ch = statement.charAt(i);
            if (ch == '$') {
                int start;
                if (i + 1 == len) {
                    throw (IllegalSyntaxException)new IllegalSyntaxException("Unexpected '$' operator").setColumnNumber(i + 1);
                }
                sb.append(ch);
                ch = statement.charAt(++i);
                if (ch == '{') {
                    start = i;
                    if ((i = Parameters.balancedIndexOf(statement, '}', start + 1)) < 0) {
                        throw (IllegalSyntaxException)new IllegalSyntaxException("'}' not found").setColumnNumber(len);
                    }
                    sb.append(statement.substring(start, ++i));
                    continue;
                }
                if (ch == '_' || ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z') {
                    char ch2;
                    start = i;
                    for (i = start + 1; i < len && ((ch2 = statement.charAt(i)) >= '0' && ch2 <= '9' || ch2 == '_' || ch2 >= 'a' && ch2 <= 'z' || ch2 >= 'A' && ch2 <= 'Z'); ++i) {
                    }
                    sb.append(statement.substring(start, i));
                    continue;
                }
                throw (IllegalSyntaxException)new IllegalSyntaxException("Unexpected character '" + ch + "' after '$'").setColumnNumber(i + 1);
            }
            if (ch == '!') {
                if (i + 1 < len && statement.charAt(i + 1) == '!') {
                    sb.append('!');
                    i += 2;
                    continue;
                }
                list.add(new Parameter(sb.toString()));
                sb.delete(0, sb.length());
                ++i;
                continue;
            }
            sb.append(ch);
            ++i;
        }
        list.add(new Parameter(sb.toString()));
        return list;
    }

    private static int balancedIndexOf(String str, char ch, int idx) {
        int n = str.length();
        int depth = 0;
        for (int i = idx; i < n; ++i) {
            char c = str.charAt(i);
            if (depth == 0 && c == ch) {
                return i;
            }
            if (c == '{') {
                ++depth;
                continue;
            }
            if (c != '}') continue;
            --depth;
        }
        return -1;
    }

    @Override
    public Iterator<Parameter> iterator() {
        return this.parameterList_.iterator();
    }

    public Parameter[] getParameters() {
        return this.parameterList_.toArray(new Parameter[0]);
    }

    public List<Object> getEvaluatedParameterList(TemplateContext context) {
        ArrayList<Object> list = new ArrayList<Object>(this.parameterList_.size());
        for (Parameter parameter : this.parameterList_) {
            list.add(parameter.evaluate(context));
        }
        return list;
    }

    public List<Parameter> getParameterList() {
        return this.parameterList_;
    }

    public Object[] getEvaluatedParameters(TemplateContext context) {
        return this.getEvaluatedParameterList(context).toArray();
    }

    public static class Parameter {
        private String expression_;

        public Parameter(String expression) {
            this.expression_ = expression;
        }

        public Object evaluate(TemplateContext context) {
            return TalesUtils.resolve((TemplateContext)context, (String)this.expression_, (VariableResolver)context.getVariableResolver(), (ExpressionEvaluator)context.getExpressionEvaluator());
        }

        public String getExpression() {
            return this.expression_;
        }
    }
}

