/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.zpt;

import net.skirnir.freyja.TagElement;
import net.skirnir.freyja.TemplateContext;
import net.skirnir.freyja.VariableResolver;
import net.skirnir.freyja.zpt.ZptTemplateContext;
import net.skirnir.freyja.zpt.tales.TalesExpressionEvaluator;
import net.skirnir.freyja.zpt.tales.TypePrefixHandler;
import org.seasar.ymir.message.Notes;
import org.seasar.ymir.zpt.util.DecorateUtils;

public class DecorateByNotesTypePrefixHandler
implements TypePrefixHandler {
    private static final String TOKEN_WITH = "with";
    private static final String ERROR_MESSAGE = "'[NOTE_CATEGORY] with [!]VALUE' is expected, but: ";
    private static final String ATTR_CLASS = "class";
    private static final String ATTRIBUTES_TAG = "tal:attributes";

    public void setTalesExpressionEvaluator(TalesExpressionEvaluator evaluator) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object handle(TemplateContext context, VariableResolver varResolver, String expr) {
        ZptTemplateContext talContext = (ZptTemplateContext)context;
        if (!ATTR_CLASS.equals(talContext.getTargetName()) || !ATTRIBUTES_TAG.equals(talContext.getProcessingAttributeName())) {
            throw new IllegalArgumentException("This expression type should be used only in tal:attributes for 'class' attribute: " + expr);
        }
        String defaultValue = DecorateUtils.getDefaultValue((TagElement)talContext.getElement(), ATTR_CLASS);
        Notes notes = (Notes)varResolver.getVariable(context, "notes");
        if (notes == null) return defaultValue;
        String[] tkns = expr.trim().split("\\s+");
        if (tkns.length == 2) {
            if (!TOKEN_WITH.equals(tkns[0])) throw new IllegalArgumentException(ERROR_MESSAGE + expr);
            if (notes.isEmpty()) return defaultValue;
            return DecorateUtils.decorate(defaultValue, tkns[1]);
        }
        if (tkns.length != 3) throw new IllegalArgumentException(ERROR_MESSAGE + expr);
        if (!TOKEN_WITH.equals(tkns[1])) throw new IllegalArgumentException(ERROR_MESSAGE + expr);
        if (!notes.contains(tkns[0])) return defaultValue;
        return DecorateUtils.decorate(defaultValue, tkns[2]);
    }
}

