/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.extension.freemarker;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.kvasir.util.io.IORuntimeException;
import org.seasar.ymir.extension.creator.BodyDesc;
import org.seasar.ymir.extension.creator.ClassDesc;
import org.seasar.ymir.extension.creator.EntityMetaData;
import org.seasar.ymir.extension.creator.MethodDesc;
import org.seasar.ymir.extension.creator.ParameterDesc;
import org.seasar.ymir.extension.creator.SourceCreator;
import org.seasar.ymir.extension.creator.SourceGenerator;
import org.seasar.ymir.extension.creator.impl.MetaAnnotationDescImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FreemarkerSourceGenerator
implements SourceGenerator {
    private SourceCreator sourceCreator_;

    @Binding(bindingType=BindingType.MUST)
    public void setSourceCreator(SourceCreator sourceCreator) {
        this.sourceCreator_ = sourceCreator;
    }

    @Override
    public String generateGapSource(ClassDesc classDesc) {
        if (classDesc == null) {
            return null;
        }
        return this.generateClassSource(classDesc.getType().getSuffix() + ".java", classDesc);
    }

    @Override
    public String generateBaseSource(ClassDesc classDesc) {
        if (classDesc == null) {
            return null;
        }
        return this.generateClassSource(classDesc.getType().getSuffix() + "Base.java", classDesc);
    }

    @Override
    public String generateClassSource(String templateName, ClassDesc classDesc) {
        MethodDesc[] mds = classDesc.getMethodDescs();
        for (int i = 0; i < mds.length; ++i) {
            String evaluatedBody = this.generateBodySource(mds[i].getBodyDesc());
            mds[i].setEvaluatedBody(evaluatedBody);
            boolean shouldRemainSourceMeta = false;
            if (evaluatedBody != null && evaluatedBody.length() > 0) {
                shouldRemainSourceMeta = true;
            } else {
                for (ParameterDesc pd : mds[i].getParameterDescs()) {
                    if (pd.getNameAsIs() == null) continue;
                    shouldRemainSourceMeta = true;
                    break;
                }
            }
            if (!shouldRemainSourceMeta) continue;
            ArrayList<String> list = new ArrayList<String>();
            list.add(evaluatedBody != null ? evaluatedBody : "");
            for (ParameterDesc pd : mds[i].getParameterDescs()) {
                list.add(pd.getName());
            }
            mds[i].setAnnotationDesc(new MetaAnnotationDescImpl("source", list.toArray(new String[0]), new Class[0]));
        }
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.put("preamble", this.sourceCreator_.getJavaPreamble());
        root.put("classDesc", classDesc);
        root.put("entityMetaData", new EntityMetaData(classDesc.getDescPool(), classDesc.getName()));
        Map<String, Object> map = classDesc.getOptionalSourceGeneratorParameter();
        if (map != null) {
            root.putAll(map);
        }
        return this.generateSource(templateName, root);
    }

    @Override
    public String generateTemplateSource(String suffix, Map<String, Object> root) {
        return this.generateSource("Template" + suffix, root);
    }

    @Override
    public String generateBodySource(BodyDesc bodyDesc) {
        if (bodyDesc == null) {
            return null;
        }
        return this.generateSource("Body." + bodyDesc.getKey(), bodyDesc.getRoot());
    }

    String generateSource(String templateName, Map<String, Object> root) {
        Configuration cfg = new Configuration();
        cfg.setEncoding(Locale.getDefault(), "UTF-8");
        cfg.setTemplateLoader((TemplateLoader)new ClassTemplateLoader(this.getClass(), "template"));
        cfg.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
        root = new HashMap<String, Object>(root);
        root.put("application", this.sourceCreator_.getApplication());
        root.put("fieldSpecialPrefix", this.sourceCreator_.getSourceCreatorSetting().getFieldSpecialPrefix());
        root.put("fieldPrefix", this.sourceCreator_.getSourceCreatorSetting().getFieldPrefix());
        root.put("fieldSuffix", this.sourceCreator_.getSourceCreatorSetting().getFieldSuffix());
        StringWriter sw = new StringWriter();
        try {
            cfg.getTemplate(templateName + ".ftl").process(root, (Writer)sw);
        }
        catch (TemplateException ex) {
            throw new RuntimeException(ex);
        }
        catch (FileNotFoundException ex) {
            throw new IORuntimeException((Throwable)ex);
        }
        catch (IOException ex) {
            throw new IORuntimeException((Throwable)ex);
        }
        return sw.toString();
    }
}

