/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.extension.creator.action.impl;

import java.io.IOException;
import java.util.Map;
import org.seasar.kvasir.util.collection.I18NProperties;
import org.seasar.kvasir.util.io.IORuntimeException;
import org.seasar.kvasir.util.io.Resource;
import org.seasar.kvasir.util.io.impl.FileResource;
import org.seasar.ymir.Request;
import org.seasar.ymir.Response;
import org.seasar.ymir.extension.creator.PathMetaData;
import org.seasar.ymir.extension.creator.SourceCreator;
import org.seasar.ymir.extension.creator.action.UpdateByExceptionAction;
import org.seasar.ymir.extension.creator.action.impl.AbstractAction;
import org.seasar.ymir.message.MessageNotFoundRuntimeException;

public class CreateMessageAction
extends AbstractAction
implements UpdateByExceptionAction {
    protected static final String PARAM_VALUE = "__ymir__value";
    private static final String SUFFIX_XPROPERTIES = ".xproperties";

    public CreateMessageAction(SourceCreator sourceCreator) {
        super(sourceCreator);
    }

    public Response act(Request request, PathMetaData pathMetaData, Throwable t) {
        if (!this.getSourceCreatorSetting().isMessageCreatingFeatureEnabled()) {
            return null;
        }
        if (this.isSkipButtonPushed(request)) {
            return null;
        }
        String subTask = request.getParameter("__ymir__subTask");
        if ("create".equals(subTask)) {
            return this.actCreate(request, pathMetaData, t);
        }
        return this.actDefault(request, pathMetaData, t);
    }

    Response actDefault(Request request, PathMetaData pathMetaData, Throwable t) {
        MessageNotFoundRuntimeException mnfre = (MessageNotFoundRuntimeException)t;
        Map<String, Object> variableMap = this.newVariableMap();
        variableMap.put("request", request);
        variableMap.put("parameters", this.getParameters(request));
        variableMap.put("messageKey", mnfre.getMessageKey());
        variableMap.put("messagesName", mnfre.getMessagesName());
        return this.getSourceCreator().getResponseCreator().createResponse("createMessage", variableMap);
    }

    Response actCreate(Request request, PathMetaData pathMetaData, Throwable t) {
        MessageNotFoundRuntimeException mnfre = (MessageNotFoundRuntimeException)t;
        String method = request.getParameter("__ymir__method");
        if (method == null) {
            return null;
        }
        String value = request.getParameter(PARAM_VALUE);
        if (value == null) {
            value = "";
        }
        this.createMessage(mnfre.getMessagesName(), mnfre.getMessageKey(), value);
        boolean successfullySynchronized = this.synchronizeResources(new String[]{this.getResourcesPath()});
        Map<String, Object> variableMap = this.newVariableMap();
        variableMap.put("request", request);
        variableMap.put("parameters", this.getParameters(request));
        variableMap.put("method", method);
        variableMap.put("messageKey", mnfre.getMessageKey());
        variableMap.put("messagesName", mnfre.getMessagesName());
        variableMap.put("successfullySynchronized", successfullySynchronized);
        return this.getSourceCreator().getResponseCreator().createResponse("createMessage_create", variableMap);
    }

    void createMessage(String messagesName, String messageKey, String value) {
        I18NProperties properties = new I18NProperties((Resource)new FileResource(this.getSourceCreator().getResourcesDirectory()), messagesName, SUFFIX_XPROPERTIES);
        properties.setProperty(messageKey, value);
        try {
            properties.store();
        }
        catch (IOException ex) {
            throw new IORuntimeException((Throwable)ex);
        }
    }
}

