/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.extension.creator.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.TreeSet;
import org.seasar.ymir.extension.creator.AnnotationDesc;
import org.seasar.ymir.extension.creator.impl.AnnotationsMetaData;
import org.seasar.ymir.util.MethodUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationDescImpl
implements AnnotationDesc {
    private String name_;
    private String body_;

    public AnnotationDescImpl(Annotation annotation) {
        this.analyze(annotation);
    }

    public AnnotationDescImpl(String name) {
        this(name, "");
    }

    public AnnotationDescImpl(String name, String body) {
        this.name_ = name;
        this.body_ = body;
    }

    void analyze(Annotation annotation) {
        Class<? extends Annotation> type = annotation.annotationType();
        this.name_ = type.getName();
        Method[] methods = type.getDeclaredMethods();
        TreeSet<Method> methodSet = new TreeSet<Method>(new Comparator<Method>(){

            @Override
            public int compare(Method o1, Method o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (int i = 0; i < methods.length; ++i) {
            String attribute = methods[i].getName();
            if (AnnotationsMetaData.INSTANCE.isDefaultValue(annotation, attribute, MethodUtils.invoke((Method)methods[i], (Object)annotation, (Object[])new Object[0]))) continue;
            methodSet.add(methods[i]);
        }
        StringBuilder sb = new StringBuilder();
        if (!methodSet.isEmpty()) {
            boolean simple = methodSet.size() == 1 && "value".equals(((Method)methodSet.iterator().next()).getName());
            sb.append("(");
            String delim = "";
            for (Method method : methodSet) {
                sb.append(delim);
                delim = ", ";
                this.append(sb, method.getName(), method.getReturnType(), MethodUtils.invoke((Method)method, (Object)annotation, (Object[])new Object[0]), simple);
            }
            sb.append(")");
        }
        this.body_ = sb.toString();
    }

    void append(StringBuilder sb, String attributeName, Class<?> type, Object value, boolean omitAttributeName) {
        if (!omitAttributeName) {
            sb.append(attributeName).append(" = ");
        }
        if (type.isArray()) {
            Class<?> componentType = type.getComponentType();
            int length = Array.getLength(value);
            if (length == 1) {
                this.append(sb, componentType, Array.get(value, 0));
            } else {
                sb.append("{");
                String delim = "";
                for (int i = 0; i < length; ++i) {
                    sb.append(delim);
                    delim = ", ";
                    this.append(sb, componentType, Array.get(value, i));
                }
                sb.append("}");
            }
        } else {
            this.append(sb, type, value);
        }
    }

    void append(StringBuilder sb, Class<?> type, Object value) {
        if (type == Class.class) {
            sb.append(((Class)value).getName()).append(".class");
        } else if (Annotation.class.isAssignableFrom(type)) {
            sb.append(new AnnotationDescImpl((Annotation)value).getString());
        } else if (type == String.class) {
            this.append(sb, (String)value);
        } else if (type == Character.TYPE) {
            this.append(sb, ((Character)value).charValue());
        } else if (Enum.class.isAssignableFrom(type)) {
            sb.append(type.getName()).append(".").append(value);
        } else {
            sb.append(value);
        }
    }

    StringBuilder append(StringBuilder sb, char ch) {
        this.appendQuoted(sb.append('\''), ch).append('\'');
        return sb;
    }

    StringBuilder appendQuoted(StringBuilder sb, char ch) {
        if (ch == '\"' || ch == '\'' || ch == '\\') {
            sb.append("\\").append(ch);
        } else if (ch == '\b') {
            sb.append("\\b");
        } else if (ch == '\t') {
            sb.append("\\t");
        } else if (ch == '\n') {
            sb.append("\\n");
        } else if (ch == '\f') {
            sb.append("\\f");
        } else if (ch == '\r') {
            sb.append("\\r");
        } else if (ch == '\u0000') {
            sb.append("\\0");
        } else if (ch < ' ') {
            this.addPadding(sb.append("\\u"), Integer.toString(ch, 16), 4);
        } else {
            sb.append(ch);
        }
        return sb;
    }

    StringBuilder append(StringBuilder sb, String string) {
        sb.append('\"');
        for (int i = 0; i < string.length(); ++i) {
            this.appendQuoted(sb, string.charAt(i));
        }
        sb.append('\"');
        return sb;
    }

    StringBuilder addPadding(StringBuilder sb, String string, int length) {
        int n = length - string.length();
        for (int i = 0; i < n; ++i) {
            sb.append('0');
        }
        sb.append(string);
        return sb;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String toString() {
        return this.getString();
    }

    @Override
    public String getString() {
        return "@" + this.name_ + this.body_;
    }

    @Override
    public String getName() {
        return this.name_;
    }

    @Override
    public String getBody() {
        return this.body_;
    }

    @Override
    public void setBody(String body) {
        this.body_ = body;
    }
}

