/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.extension.creator;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.seasar.ymir.extension.creator.ClassDesc;
import org.seasar.ymir.extension.creator.ClassDescSet;
import org.seasar.ymir.extension.creator.ClassType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassDescBag {
    private Map<ClassType, Map<String, ClassDesc>> map_ = new HashMap<ClassType, Map<String, ClassDesc>>();
    private Map<ClassType, Map<String, ClassDesc>> createdMap_ = new HashMap<ClassType, Map<String, ClassDesc>>();
    private Map<ClassType, Map<String, ClassDesc>> updatedMap_ = new HashMap<ClassType, Map<String, ClassDesc>>();
    private Map<ClassType, Map<String, ClassDesc>> failedMap_ = new HashMap<ClassType, Map<String, ClassDesc>>();
    private ClassDescSet set_ = new ClassDescSet();
    private Map<String, String[]> failedClassDescLackingClassNamesMap_ = new HashMap<String, String[]>();

    public Map<String, ClassDesc> getClassDescMap() {
        return this.getClassDescMap(this.map_, null);
    }

    public ClassDesc[] getClassDescs() {
        return this.getClassDescs(this.map_, null);
    }

    public Map<String, ClassDesc> getClassDescMap(ClassType type) {
        return this.getClassDescMap(this.map_, type);
    }

    public ClassDesc[] getClassDescs(ClassType type) {
        return this.getClassDescMap(type).values().toArray(new ClassDesc[0]);
    }

    public Iterator<ClassType> getClassDescTypeIterator() {
        return this.map_.keySet().iterator();
    }

    public Map<String, ClassDesc> getCreatedClassDescMap() {
        return this.getClassDescMap(this.createdMap_, null);
    }

    public ClassDesc[] getCreatedClassDescs() {
        return this.getCreatedClassDescMap().values().toArray(new ClassDesc[0]);
    }

    public Map<String, ClassDesc> getCreatedClassDescMap(ClassType type) {
        return this.getClassDescMap(this.createdMap_, type);
    }

    public ClassDesc[] getCreatedClassDescs(ClassType type) {
        return this.getCreatedClassDescMap(type).values().toArray(new ClassDesc[0]);
    }

    public Map<String, ClassDesc> getUpdatedClassDescMap() {
        return this.getClassDescMap(this.updatedMap_, null);
    }

    public ClassDesc[] getUpdatedClassDescs() {
        return this.getUpdatedClassDescMap().values().toArray(new ClassDesc[0]);
    }

    public Map<String, ClassDesc> getUpdatedClassDescMap(ClassType type) {
        return this.getClassDescMap(this.updatedMap_, type);
    }

    public ClassDesc[] getUpdatedClassDescs(ClassType type) {
        return this.getUpdatedClassDescMap(type).values().toArray(new ClassDesc[0]);
    }

    public Map<String, ClassDesc> getFailedClassDescMap() {
        return this.getClassDescMap(this.failedMap_, null);
    }

    public ClassDesc[] getFailedClassDescs() {
        return this.getFailedClassDescMap().values().toArray(new ClassDesc[0]);
    }

    public Map<String, ClassDesc> getFailedClassDescMap(ClassType type) {
        return this.getClassDescMap(this.failedMap_, type);
    }

    public ClassDesc[] getFailedClassDescs(ClassType type) {
        return this.getFailedClassDescMap(type).values().toArray(new ClassDesc[0]);
    }

    public Map<String, String[]> getFailedClassDescLackingClassNamesMap() {
        return this.failedClassDescLackingClassNamesMap_;
    }

    public String[] getFailedClassDescLackingClassNames(String className) {
        String[] classNames = this.failedClassDescLackingClassNamesMap_.get(className);
        if (classNames != null) {
            return classNames;
        }
        return new String[0];
    }

    Map<String, ClassDesc> getClassDescMap(Map<ClassType, Map<String, ClassDesc>> map, ClassType type) {
        Map<String, ClassDesc> got = map.get((Object)type);
        if (got == null) {
            got = new LinkedHashMap<String, ClassDesc>();
            map.put(type, got);
        }
        return got;
    }

    ClassDesc[] getClassDescs(Map<ClassType, Map<String, ClassDesc>> map, ClassType type) {
        return this.getClassDescMap(map, type).values().toArray(new ClassDesc[0]);
    }

    public ClassDescSet getClassDescSet() {
        return this.set_;
    }

    public void addAsCreated(ClassDesc classDesc) {
        this.addAsCreated(classDesc, false);
    }

    public void addAsCreated(ClassDesc classDesc, boolean done) {
        if (!done) {
            this.getClassDescMap().put(classDesc.getName(), classDesc);
            this.getClassDescMap(classDesc.getType()).put(classDesc.getName(), classDesc);
            this.set_.add(classDesc);
        }
        this.getCreatedClassDescMap().put(classDesc.getName(), classDesc);
        this.getCreatedClassDescMap(classDesc.getType()).put(classDesc.getName(), classDesc);
    }

    public void addAsUpdated(ClassDesc classDesc) {
        this.addAsUpdated(classDesc, false);
    }

    public void addAsUpdated(ClassDesc classDesc, boolean done) {
        if (!done) {
            this.getClassDescMap().put(classDesc.getName(), classDesc);
            this.getClassDescMap(classDesc.getType()).put(classDesc.getName(), classDesc);
            this.set_.add(classDesc);
        }
        this.getUpdatedClassDescMap().put(classDesc.getName(), classDesc);
        this.getUpdatedClassDescMap(classDesc.getType()).put(classDesc.getName(), classDesc);
    }

    public void addAsFailed(ClassDesc classDesc, String[] lackingClassNames) {
        this.addAsFailed(classDesc, lackingClassNames, false);
    }

    public void addAsFailed(ClassDesc classDesc, String[] lackingClassNames, boolean done) {
        if (!done) {
            this.getClassDescMap().put(classDesc.getName(), classDesc);
            this.getClassDescMap(classDesc.getType()).put(classDesc.getName(), classDesc);
        }
        this.getFailedClassDescMap().put(classDesc.getName(), classDesc);
        this.getFailedClassDescMap(classDesc.getType()).put(classDesc.getName(), classDesc);
        this.getFailedClassDescLackingClassNamesMap().put(classDesc.getName(), lackingClassNames);
    }

    public void remove(String className) {
        this.remove(this.map_, className);
        this.remove(this.createdMap_, className);
        this.remove(this.updatedMap_, className);
        this.set_.remove(className);
    }

    void remove(Map<ClassType, Map<String, ClassDesc>> map, String className) {
        for (Map<String, ClassDesc> typeMap : map.values()) {
            typeMap.remove(className);
        }
    }

    public boolean isEmpty() {
        return this.map_.isEmpty();
    }
}

