/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.scope.handler.impl;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.ymir.ActionManager;
import org.seasar.ymir.annotation.handler.AnnotationHandler;
import org.seasar.ymir.converter.PropertyHandler;
import org.seasar.ymir.converter.TypeConversionManager;
import org.seasar.ymir.converter.annotation.TypeConversionHint;
import org.seasar.ymir.converter.impl.SetterPropertyHandler;
import org.seasar.ymir.scope.Scope;
import org.seasar.ymir.scope.ScopeManager;
import org.seasar.ymir.scope.handler.ScopeAttributePopulator;
import org.seasar.ymir.util.BeanUtils;
import org.seasar.ymir.util.ClassUtils;

public class ScopeAttributePopulatorImpl
implements ScopeAttributePopulator {
    private Scope scope_;
    private ActionManager actionManager_;
    private AnnotationHandler annotationHandler_;
    private ScopeManager scopeManager_;
    private TypeConversionManager typeConversionManager_;
    private Map<Method, Entry> entryByMethodMap_ = new HashMap<Method, Entry>();
    private Map<String, Entry> entryByNameMap_ = new HashMap<String, Entry>();
    private static final Log log_ = LogFactory.getLog(ScopeAttributePopulatorImpl.class);

    public ScopeAttributePopulatorImpl(Scope scope, ActionManager actionManager, AnnotationHandler annotationHandler, ScopeManager scopeManager, TypeConversionManager typeConversionManager) {
        this.scope_ = scope;
        this.actionManager_ = actionManager;
        this.annotationHandler_ = annotationHandler;
        this.scopeManager_ = scopeManager;
        this.typeConversionManager_ = typeConversionManager;
    }

    public void addEntry(Method method, boolean populateWhereNull, String[] enabledActionNames) {
        this.entryByMethodMap_.put(method, new Entry(method, populateWhereNull, enabledActionNames, this.actionManager_, true));
    }

    public void addEntry(String name, Method method, boolean populateWhereNull, String[] enabledActionNames) {
        this.entryByNameMap_.put(name, new Entry(method, populateWhereNull, enabledActionNames, this.actionManager_, false));
    }

    public void populateTo(Object component, String actionName) {
        Iterator<String> itr = this.scope_.getAttributeNames();
        while (itr.hasNext()) {
            String name = itr.next();
            Entry entry = this.getEntry(component, name);
            if (entry == null || !entry.isEnabled(actionName)) continue;
            entry.populateTo(component, name);
        }
    }

    Entry getEntry(Object component, String name) {
        Entry entry = this.entryByNameMap_.get(name);
        if (entry != null) {
            return entry;
        }
        String segment = BeanUtils.getFirstSegment(name);
        PropertyHandler handler = this.typeConversionManager_.getPropertyHandler(component, segment);
        if (handler == null) {
            return null;
        }
        Method method = name.length() > segment.length() ? handler.getReadMethod() : handler.getWriteMethod();
        if (method == null) {
            return null;
        }
        return this.entryByMethodMap_.get(method);
    }

    protected class Entry {
        private Method method_;
        private boolean invokeWhereNull_;
        private String[] enabledActionNames_;
        private ActionManager actionManager_;
        private boolean passive_;

        public Entry(Method method, boolean invokeWhereNull, String[] enabledActionNames, ActionManager actionManager, boolean passive) {
            this.method_ = method;
            this.invokeWhereNull_ = invokeWhereNull;
            this.enabledActionNames_ = enabledActionNames;
            this.actionManager_ = actionManager;
            this.passive_ = passive;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void populateTo(Object component, String name) {
            PropertyHandler handler;
            block13: {
                if (log_.isDebugEnabled()) {
                    log_.debug((Object)("Try to populate: " + ClassUtils.getPrettyName(ScopeAttributePopulatorImpl.this.scope_) + " -> " + ClassUtils.getPrettyName(component) + ": property=" + name));
                }
                handler = null;
                try {
                    handler = this.passive_ ? ScopeAttributePopulatorImpl.this.typeConversionManager_.getPropertyHandler(component, name) : new SetterPropertyHandler(component, this.method_);
                }
                catch (Throwable t) {
                    if (!log_.isDebugEnabled()) break block13;
                    log_.debug((Object)("Can't get PropertyHandler for scope attribute: scope=" + ScopeAttributePopulatorImpl.this.scope_ + ", attribute name=" + name), t);
                }
            }
            if (handler == null) {
                return;
            }
            Object value = ScopeAttributePopulatorImpl.this.scopeManager_.getAttribute(ScopeAttributePopulatorImpl.this.scope_, name, handler.getPropertyType(), ScopeAttributePopulatorImpl.this.annotationHandler_.getMarkedAnnotations(handler.getWriteMethod(), TypeConversionHint.class), false, true);
            if (value != null || this.invokeWhereNull_) {
                if (log_.isDebugEnabled()) {
                    log_.debug((Object)(ClassUtils.getPrettyName(ScopeAttributePopulatorImpl.this.scope_) + " -> " + ClassUtils.getPrettyName(component) + ": property=" + name + ", value=" + value));
                }
                boolean removeValue = false;
                try {
                    handler.setProperty(value);
                }
                catch (Throwable t) {
                    removeValue = true;
                    if (log_.isDebugEnabled()) {
                        log_.debug((Object)("Can't populate scope attribute: scope=" + ScopeAttributePopulatorImpl.this.scope_ + ", attribute name=" + name + ", value=" + value + ", write method=" + this.method_), t);
                    }
                }
                finally {
                    if (removeValue) {
                        ScopeAttributePopulatorImpl.this.scope_.setAttribute(name, null);
                    }
                }
            }
        }

        public boolean isEnabled(String actionName) {
            return this.actionManager_.isMatched(actionName, this.enabledActionNames_);
        }
    }
}

